/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Caption Rectangle
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionRectangle implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionRectangle.Builder, CaptionRectangle> {
    private static final SdkField<Double> HEIGHT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Height")
            .getter(getter(CaptionRectangle::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<Double> LEFT_OFFSET_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LeftOffset").getter(getter(CaptionRectangle::leftOffset)).setter(setter(Builder::leftOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("leftOffset").build()).build();

    private static final SdkField<Double> TOP_OFFSET_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TopOffset").getter(getter(CaptionRectangle::topOffset)).setter(setter(Builder::topOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topOffset").build()).build();

    private static final SdkField<Double> WIDTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Width")
            .getter(getter(CaptionRectangle::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD,
            LEFT_OFFSET_FIELD, TOP_OFFSET_FIELD, WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double height;

    private final Double leftOffset;

    private final Double topOffset;

    private final Double width;

    private CaptionRectangle(BuilderImpl builder) {
        this.height = builder.height;
        this.leftOffset = builder.leftOffset;
        this.topOffset = builder.topOffset;
        this.width = builder.width;
    }

    /**
     * See the description in leftOffset. For height, specify the entire height of the rectangle as a percentage of the
     * underlying frame height. For example, \"80\" means the rectangle height is 80% of the underlying frame height.
     * The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to tts:extent - Y in the
     * TTML standard.
     * 
     * @return See the description in leftOffset. For height, specify the entire height of the rectangle as a percentage
     *         of the underlying frame height. For example, \"80\" means the rectangle height is 80% of the underlying
     *         frame height. The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to
     *         tts:extent - Y in the TTML standard.
     */
    public final Double height() {
        return height;
    }

    /**
     * Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure to leave
     * the default if you don't have either of these formats in the output.) You can define a display rectangle for the
     * captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of
     * the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The
     * units for the measurements are percentages. If you specify a value for one of these fields, you must specify a
     * value for all of them. For leftOffset, specify the position of the left edge of the rectangle, as a percentage of
     * the underlying frame width, and relative to the left edge of the frame. For example, \"10\" means the measurement
     * is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the
     * frame. This field corresponds to tts:origin - X in the TTML standard.
     * 
     * @return Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure to
     *         leave the default if you don't have either of these formats in the output.) You can define a display
     *         rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by
     *         specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all
     *         within the underlying video frame. The units for the measurements are percentages. If you specify a value
     *         for one of these fields, you must specify a value for all of them. For leftOffset, specify the position
     *         of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the
     *         left edge of the frame. For example, \"10\" means the measurement is 10% of the underlying frame width.
     *         The rectangle left edge starts at that position from the left edge of the frame. This field corresponds
     *         to tts:origin - X in the TTML standard.
     */
    public final Double leftOffset() {
        return leftOffset;
    }

    /**
     * See the description in leftOffset. For topOffset, specify the position of the top edge of the rectangle, as a
     * percentage of the underlying frame height, and relative to the top edge of the frame. For example, \"10\" means
     * the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the
     * top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.
     * 
     * @return See the description in leftOffset. For topOffset, specify the position of the top edge of the rectangle,
     *         as a percentage of the underlying frame height, and relative to the top edge of the frame. For example,
     *         \"10\" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that
     *         position from the top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.
     */
    public final Double topOffset() {
        return topOffset;
    }

    /**
     * See the description in leftOffset. For width, specify the entire width of the rectangle as a percentage of the
     * underlying frame width. For example, \"80\" means the rectangle width is 80% of the underlying frame width. The
     * leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to tts:extent - X in the TTML
     * standard.
     * 
     * @return See the description in leftOffset. For width, specify the entire width of the rectangle as a percentage
     *         of the underlying frame width. For example, \"80\" means the rectangle width is 80% of the underlying
     *         frame width. The leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to
     *         tts:extent - X in the TTML standard.
     */
    public final Double width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(leftOffset());
        hashCode = 31 * hashCode + Objects.hashCode(topOffset());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionRectangle)) {
            return false;
        }
        CaptionRectangle other = (CaptionRectangle) obj;
        return Objects.equals(height(), other.height()) && Objects.equals(leftOffset(), other.leftOffset())
                && Objects.equals(topOffset(), other.topOffset()) && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionRectangle").add("Height", height()).add("LeftOffset", leftOffset())
                .add("TopOffset", topOffset()).add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "LeftOffset":
            return Optional.ofNullable(clazz.cast(leftOffset()));
        case "TopOffset":
            return Optional.ofNullable(clazz.cast(topOffset()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionRectangle, T> g) {
        return obj -> g.apply((CaptionRectangle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionRectangle> {
        /**
         * See the description in leftOffset. For height, specify the entire height of the rectangle as a percentage of
         * the underlying frame height. For example, \"80\" means the rectangle height is 80% of the underlying frame
         * height. The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to tts:extent -
         * Y in the TTML standard.
         * 
         * @param height
         *        See the description in leftOffset. For height, specify the entire height of the rectangle as a
         *        percentage of the underlying frame height. For example, \"80\" means the rectangle height is 80% of
         *        the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less. This field
         *        corresponds to tts:extent - Y in the TTML standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Double height);

        /**
         * Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure to
         * leave the default if you don't have either of these formats in the output.) You can define a display
         * rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by
         * specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within
         * the underlying video frame. The units for the measurements are percentages. If you specify a value for one of
         * these fields, you must specify a value for all of them. For leftOffset, specify the position of the left edge
         * of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame.
         * For example, \"10\" means the measurement is 10% of the underlying frame width. The rectangle left edge
         * starts at that position from the left edge of the frame. This field corresponds to tts:origin - X in the TTML
         * standard.
         * 
         * @param leftOffset
         *        Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure
         *        to leave the default if you don't have either of these formats in the output.) You can define a
         *        display rectangle for the captions that is smaller than the underlying video frame. You define the
         *        rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the
         *        rectangle, all within the underlying video frame. The units for the measurements are percentages. If
         *        you specify a value for one of these fields, you must specify a value for all of them. For leftOffset,
         *        specify the position of the left edge of the rectangle, as a percentage of the underlying frame width,
         *        and relative to the left edge of the frame. For example, \"10\" means the measurement is 10% of the
         *        underlying frame width. The rectangle left edge starts at that position from the left edge of the
         *        frame. This field corresponds to tts:origin - X in the TTML standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leftOffset(Double leftOffset);

        /**
         * See the description in leftOffset. For topOffset, specify the position of the top edge of the rectangle, as a
         * percentage of the underlying frame height, and relative to the top edge of the frame. For example, \"10\"
         * means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position
         * from the top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.
         * 
         * @param topOffset
         *        See the description in leftOffset. For topOffset, specify the position of the top edge of the
         *        rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame.
         *        For example, \"10\" means the measurement is 10% of the underlying frame height. The rectangle top
         *        edge starts at that position from the top edge of the frame. This field corresponds to tts:origin - Y
         *        in the TTML standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topOffset(Double topOffset);

        /**
         * See the description in leftOffset. For width, specify the entire width of the rectangle as a percentage of
         * the underlying frame width. For example, \"80\" means the rectangle width is 80% of the underlying frame
         * width. The leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to tts:extent -
         * X in the TTML standard.
         * 
         * @param width
         *        See the description in leftOffset. For width, specify the entire width of the rectangle as a
         *        percentage of the underlying frame width. For example, \"80\" means the rectangle width is 80% of the
         *        underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less. This field
         *        corresponds to tts:extent - X in the TTML standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Double width);
    }

    static final class BuilderImpl implements Builder {
        private Double height;

        private Double leftOffset;

        private Double topOffset;

        private Double width;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionRectangle model) {
            height(model.height);
            leftOffset(model.leftOffset);
            topOffset(model.topOffset);
            width(model.width);
        }

        public final Double getHeight() {
            return height;
        }

        @Override
        public final Builder height(Double height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Double height) {
            this.height = height;
        }

        public final Double getLeftOffset() {
            return leftOffset;
        }

        @Override
        public final Builder leftOffset(Double leftOffset) {
            this.leftOffset = leftOffset;
            return this;
        }

        public final void setLeftOffset(Double leftOffset) {
            this.leftOffset = leftOffset;
        }

        public final Double getTopOffset() {
            return topOffset;
        }

        @Override
        public final Builder topOffset(Double topOffset) {
            this.topOffset = topOffset;
            return this;
        }

        public final void setTopOffset(Double topOffset) {
            this.topOffset = topOffset;
        }

        public final Double getWidth() {
            return width;
        }

        @Override
        public final Builder width(Double width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Double width) {
            this.width = width;
        }

        @Override
        public CaptionRectangle build() {
            return new CaptionRectangle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
