/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to create a channel
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateChannelRequest.Builder, CreateChannelRequest> {
    private static final SdkField<CdiInputSpecification> CDI_INPUT_SPECIFICATION_FIELD = SdkField
            .<CdiInputSpecification> builder(MarshallingType.SDK_POJO).memberName("CdiInputSpecification")
            .getter(getter(CreateChannelRequest::cdiInputSpecification)).setter(setter(Builder::cdiInputSpecification))
            .constructor(CdiInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdiInputSpecification").build())
            .build();

    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelClass").getter(getter(CreateChannelRequest::channelClassAsString))
            .setter(setter(Builder::channelClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()).build();

    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField
            .<List<OutputDestination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(CreateChannelRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EncoderSettings> ENCODER_SETTINGS_FIELD = SdkField
            .<EncoderSettings> builder(MarshallingType.SDK_POJO).memberName("EncoderSettings")
            .getter(getter(CreateChannelRequest::encoderSettings)).setter(setter(Builder::encoderSettings))
            .constructor(EncoderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderSettings").build()).build();

    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField
            .<List<InputAttachment>> builder(MarshallingType.LIST)
            .memberName("InputAttachments")
            .getter(getter(CreateChannelRequest::inputAttachments))
            .setter(setter(Builder::inputAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField
            .<InputSpecification> builder(MarshallingType.SDK_POJO).memberName("InputSpecification")
            .getter(getter(CreateChannelRequest::inputSpecification)).setter(setter(Builder::inputSpecification))
            .constructor(InputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build())
            .build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(CreateChannelRequest::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(CreateChannelRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RESERVED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Reserved").getter(getter(CreateChannelRequest::reserved)).setter(setter(Builder::reserved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reserved").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateChannelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateChannelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<VpcOutputSettings> VPC_FIELD = SdkField.<VpcOutputSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Vpc").getter(getter(CreateChannelRequest::vpc)).setter(setter(Builder::vpc))
            .constructor(VpcOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDI_INPUT_SPECIFICATION_FIELD,
            CHANNEL_CLASS_FIELD, DESTINATIONS_FIELD, ENCODER_SETTINGS_FIELD, INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD,
            LOG_LEVEL_FIELD, NAME_FIELD, REQUEST_ID_FIELD, RESERVED_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, VPC_FIELD));

    private final CdiInputSpecification cdiInputSpecification;

    private final String channelClass;

    private final List<OutputDestination> destinations;

    private final EncoderSettings encoderSettings;

    private final List<InputAttachment> inputAttachments;

    private final InputSpecification inputSpecification;

    private final String logLevel;

    private final String name;

    private final String requestId;

    private final String reserved;

    private final String roleArn;

    private final Map<String, String> tags;

    private final VpcOutputSettings vpc;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.cdiInputSpecification = builder.cdiInputSpecification;
        this.channelClass = builder.channelClass;
        this.destinations = builder.destinations;
        this.encoderSettings = builder.encoderSettings;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.name = builder.name;
        this.requestId = builder.requestId;
        this.reserved = builder.reserved;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.vpc = builder.vpc;
    }

    /**
     * Specification of CDI inputs for this channel
     * 
     * @return Specification of CDI inputs for this channel
     */
    public final CdiInputSpecification cdiInputSpecification() {
        return cdiInputSpecification;
    }

    /**
     * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one
     * pipeline.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelClass} will
     * return {@link ChannelClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelClassAsString}.
     * </p>
     * 
     * @return The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
     *         with one pipeline.
     * @see ChannelClass
     */
    public final ChannelClass channelClass() {
        return ChannelClass.fromValue(channelClass);
    }

    /**
     * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one
     * pipeline.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelClass} will
     * return {@link ChannelClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelClassAsString}.
     * </p>
     * 
     * @return The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
     *         with one pipeline.
     * @see ChannelClass
     */
    public final String channelClassAsString() {
        return channelClass;
    }

    /**
     * Returns true if the Destinations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Destinations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Destinations property for this object.
     */
    public final List<OutputDestination> destinations() {
        return destinations;
    }

    /**
     * Returns the value of the EncoderSettings property for this object.
     * 
     * @return The value of the EncoderSettings property for this object.
     */
    public final EncoderSettings encoderSettings() {
        return encoderSettings;
    }

    /**
     * Returns true if the InputAttachments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInputAttachments() {
        return inputAttachments != null && !(inputAttachments instanceof SdkAutoConstructList);
    }

    /**
     * List of input attachments for channel.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of input attachments for channel.
     */
    public final List<InputAttachment> inputAttachments() {
        return inputAttachments;
    }

    /**
     * Specification of network and file inputs for this channel
     * 
     * @return Specification of network and file inputs for this channel
     */
    public final InputSpecification inputSpecification() {
        return inputSpecification;
    }

    /**
     * The log level to write to CloudWatch Logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The log level to write to CloudWatch Logs.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * The log level to write to CloudWatch Logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The log level to write to CloudWatch Logs.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * Name of channel.
     * 
     * @return Name of channel.
     */
    public final String name() {
        return name;
    }

    /**
     * Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
     *
     * @return Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * Deprecated field that's only usable by whitelisted customers.
     * 
     * @return Deprecated field that's only usable by whitelisted customers.
     */
    public final String reserved() {
        return reserved;
    }

    /**
     * An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
     * 
     * @return An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * Settings for VPC output
     * 
     * @return Settings for VPC output
     */
    public final VpcOutputSettings vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cdiInputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputAttachments() ? inputAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(reserved());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest) obj;
        return Objects.equals(cdiInputSpecification(), other.cdiInputSpecification())
                && Objects.equals(channelClassAsString(), other.channelClassAsString())
                && hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && Objects.equals(encoderSettings(), other.encoderSettings())
                && hasInputAttachments() == other.hasInputAttachments()
                && Objects.equals(inputAttachments(), other.inputAttachments())
                && Objects.equals(inputSpecification(), other.inputSpecification())
                && Objects.equals(logLevelAsString(), other.logLevelAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(reserved(), other.reserved())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelRequest").add("CdiInputSpecification", cdiInputSpecification())
                .add("ChannelClass", channelClassAsString()).add("Destinations", hasDestinations() ? destinations() : null)
                .add("EncoderSettings", encoderSettings())
                .add("InputAttachments", hasInputAttachments() ? inputAttachments() : null)
                .add("InputSpecification", inputSpecification()).add("LogLevel", logLevelAsString()).add("Name", name())
                .add("RequestId", requestId()).add("Reserved", reserved()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("Vpc", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CdiInputSpecification":
            return Optional.ofNullable(clazz.cast(cdiInputSpecification()));
        case "ChannelClass":
            return Optional.ofNullable(clazz.cast(channelClassAsString()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "EncoderSettings":
            return Optional.ofNullable(clazz.cast(encoderSettings()));
        case "InputAttachments":
            return Optional.ofNullable(clazz.cast(inputAttachments()));
        case "InputSpecification":
            return Optional.ofNullable(clazz.cast(inputSpecification()));
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Reserved":
            return Optional.ofNullable(clazz.cast(reserved()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelRequest> {
        /**
         * Specification of CDI inputs for this channel
         * 
         * @param cdiInputSpecification
         *        Specification of CDI inputs for this channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification);

        /**
         * Specification of CDI inputs for this channel This is a convenience that creates an instance of the
         * {@link CdiInputSpecification.Builder} avoiding the need to create one manually via
         * {@link CdiInputSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CdiInputSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #cdiInputSpecification(CdiInputSpecification)}.
         * 
         * @param cdiInputSpecification
         *        a consumer that will call methods on {@link CdiInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdiInputSpecification(CdiInputSpecification)
         */
        default Builder cdiInputSpecification(Consumer<CdiInputSpecification.Builder> cdiInputSpecification) {
            return cdiInputSpecification(CdiInputSpecification.builder().applyMutation(cdiInputSpecification).build());
        }

        /**
         * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with
         * one pipeline.
         * 
         * @param channelClass
         *        The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
         *        with one pipeline.
         * @see ChannelClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelClass
         */
        Builder channelClass(String channelClass);

        /**
         * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with
         * one pipeline.
         * 
         * @param channelClass
         *        The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
         *        with one pipeline.
         * @see ChannelClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelClass
         */
        Builder channelClass(ChannelClass channelClass);

        /**
         * Sets the value of the Destinations property for this object.
         *
         * @param destinations
         *        The new value for the Destinations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<OutputDestination> destinations);

        /**
         * Sets the value of the Destinations property for this object.
         *
         * @param destinations
         *        The new value for the Destinations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(OutputDestination... destinations);

        /**
         * Sets the value of the Destinations property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<OutputDestination>.Builder} avoiding the
         * need to create one manually via {@link List<OutputDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputDestination>.Builder#build()} is called immediately
         * and its result is passed to {@link #destinations(List<OutputDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<OutputDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<OutputDestination>)
         */
        Builder destinations(Consumer<OutputDestination.Builder>... destinations);

        /**
         * Sets the value of the EncoderSettings property for this object.
         *
         * @param encoderSettings
         *        The new value for the EncoderSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoderSettings(EncoderSettings encoderSettings);

        /**
         * Sets the value of the EncoderSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link EncoderSettings.Builder} avoiding the need to
         * create one manually via {@link EncoderSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncoderSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #encoderSettings(EncoderSettings)}.
         * 
         * @param encoderSettings
         *        a consumer that will call methods on {@link EncoderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encoderSettings(EncoderSettings)
         */
        default Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return encoderSettings(EncoderSettings.builder().applyMutation(encoderSettings).build());
        }

        /**
         * List of input attachments for channel.
         * 
         * @param inputAttachments
         *        List of input attachments for channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachments(Collection<InputAttachment> inputAttachments);

        /**
         * List of input attachments for channel.
         * 
         * @param inputAttachments
         *        List of input attachments for channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachments(InputAttachment... inputAttachments);

        /**
         * List of input attachments for channel. This is a convenience that creates an instance of the {@link List
         * <InputAttachment>.Builder} avoiding the need to create one manually via {@link List
         * <InputAttachment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputAttachment>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputAttachments(List<InputAttachment>)}.
         * 
         * @param inputAttachments
         *        a consumer that will call methods on {@link List<InputAttachment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputAttachments(List<InputAttachment>)
         */
        Builder inputAttachments(Consumer<InputAttachment.Builder>... inputAttachments);

        /**
         * Specification of network and file inputs for this channel
         * 
         * @param inputSpecification
         *        Specification of network and file inputs for this channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSpecification(InputSpecification inputSpecification);

        /**
         * Specification of network and file inputs for this channel This is a convenience that creates an instance of
         * the {@link InputSpecification.Builder} avoiding the need to create one manually via
         * {@link InputSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSpecification(InputSpecification)}.
         * 
         * @param inputSpecification
         *        a consumer that will call methods on {@link InputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSpecification(InputSpecification)
         */
        default Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return inputSpecification(InputSpecification.builder().applyMutation(inputSpecification).build());
        }

        /**
         * The log level to write to CloudWatch Logs.
         * 
         * @param logLevel
         *        The log level to write to CloudWatch Logs.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * The log level to write to CloudWatch Logs.
         * 
         * @param logLevel
         *        The log level to write to CloudWatch Logs.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * Name of channel.
         * 
         * @param name
         *        Name of channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
         *
         * @param requestId
         *        Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * Deprecated field that's only usable by whitelisted customers.
         * 
         * @param reserved
         *        Deprecated field that's only usable by whitelisted customers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reserved(String reserved);

        /**
         * An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
         * 
         * @param roleArn
         *        An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Settings for VPC output
         * 
         * @param vpc
         *        Settings for VPC output
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VpcOutputSettings vpc);

        /**
         * Settings for VPC output This is a convenience that creates an instance of the
         * {@link VpcOutputSettings.Builder} avoiding the need to create one manually via
         * {@link VpcOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #vpc(VpcOutputSettings)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VpcOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VpcOutputSettings)
         */
        default Builder vpc(Consumer<VpcOutputSettings.Builder> vpc) {
            return vpc(VpcOutputSettings.builder().applyMutation(vpc).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private CdiInputSpecification cdiInputSpecification;

        private String channelClass;

        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private EncoderSettings encoderSettings;

        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();

        private InputSpecification inputSpecification;

        private String logLevel;

        private String name;

        private String requestId;

        private String reserved;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private VpcOutputSettings vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            cdiInputSpecification(model.cdiInputSpecification);
            channelClass(model.channelClass);
            destinations(model.destinations);
            encoderSettings(model.encoderSettings);
            inputAttachments(model.inputAttachments);
            inputSpecification(model.inputSpecification);
            logLevel(model.logLevel);
            name(model.name);
            requestId(model.requestId);
            reserved(model.reserved);
            roleArn(model.roleArn);
            tags(model.tags);
            vpc(model.vpc);
        }

        public final CdiInputSpecification.Builder getCdiInputSpecification() {
            return cdiInputSpecification != null ? cdiInputSpecification.toBuilder() : null;
        }

        @Override
        public final Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        public final void setCdiInputSpecification(CdiInputSpecification.BuilderImpl cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification != null ? cdiInputSpecification.build() : null;
        }

        public final String getChannelClass() {
            return channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass == null ? null : channelClass.toString());
            return this;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        public final List<OutputDestination.Builder> getDestinations() {
            List<OutputDestination.Builder> result = ___listOfOutputDestinationCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> OutputDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return encoderSettings != null ? encoderSettings.toBuilder() : null;
        }

        @Override
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        public final List<InputAttachment.Builder> getInputAttachments() {
            List<InputAttachment.Builder> result = ___listOfInputAttachmentCopier.copyToBuilder(this.inputAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment... inputAttachments) {
            inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder>... inputAttachments) {
            inputAttachments(Stream.of(inputAttachments).map(c -> InputAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        public final InputSpecification.Builder getInputSpecification() {
            return inputSpecification != null ? inputSpecification.toBuilder() : null;
        }

        @Override
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getReserved() {
            return reserved;
        }

        @Override
        public final Builder reserved(String reserved) {
            this.reserved = reserved;
            return this;
        }

        public final void setReserved(String reserved) {
            this.reserved = reserved;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final VpcOutputSettings.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VpcOutputSettings vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(VpcOutputSettings.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
