/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeInputSecurityGroupRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInputSecurityGroupRequest extends MediaLiveRequest implements
        ToCopyableBuilder<DescribeInputSecurityGroupRequest.Builder, DescribeInputSecurityGroupRequest> {
    private static final SdkField<String> INPUT_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputSecurityGroupId").getter(getter(DescribeInputSecurityGroupRequest::inputSecurityGroupId))
            .setter(setter(Builder::inputSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputSecurityGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(INPUT_SECURITY_GROUP_ID_FIELD));

    private final String inputSecurityGroupId;

    private DescribeInputSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.inputSecurityGroupId = builder.inputSecurityGroupId;
    }

    /**
     * The id of the Input Security Group to describe
     * 
     * @return The id of the Input Security Group to describe
     */
    public final String inputSecurityGroupId() {
        return inputSecurityGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputSecurityGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputSecurityGroupRequest)) {
            return false;
        }
        DescribeInputSecurityGroupRequest other = (DescribeInputSecurityGroupRequest) obj;
        return Objects.equals(inputSecurityGroupId(), other.inputSecurityGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInputSecurityGroupRequest").add("InputSecurityGroupId", inputSecurityGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputSecurityGroupId":
            return Optional.ofNullable(clazz.cast(inputSecurityGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputSecurityGroupRequest, T> g) {
        return obj -> g.apply((DescribeInputSecurityGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInputSecurityGroupRequest> {
        /**
         * The id of the Input Security Group to describe
         * 
         * @param inputSecurityGroupId
         *        The id of the Input Security Group to describe
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroupId(String inputSecurityGroupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String inputSecurityGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputSecurityGroupRequest model) {
            super(model);
            inputSecurityGroupId(model.inputSecurityGroupId);
        }

        public final String getInputSecurityGroupId() {
            return inputSecurityGroupId;
        }

        @Override
        public final Builder inputSecurityGroupId(String inputSecurityGroupId) {
            this.inputSecurityGroupId = inputSecurityGroupId;
            return this;
        }

        public final void setInputSecurityGroupId(String inputSecurityGroupId) {
            this.inputSecurityGroupId = inputSecurityGroupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInputSecurityGroupRequest build() {
            return new DescribeInputSecurityGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
