/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Frame Capture Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameCaptureGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameCaptureGroupSettings.Builder, FrameCaptureGroupSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField
            .<OutputLocationRef> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(FrameCaptureGroupSettings::destination)).setter(setter(Builder::destination))
            .constructor(OutputLocationRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<FrameCaptureCdnSettings> FRAME_CAPTURE_CDN_SETTINGS_FIELD = SdkField
            .<FrameCaptureCdnSettings> builder(MarshallingType.SDK_POJO).memberName("FrameCaptureCdnSettings")
            .getter(getter(FrameCaptureGroupSettings::frameCaptureCdnSettings)).setter(setter(Builder::frameCaptureCdnSettings))
            .constructor(FrameCaptureCdnSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureCdnSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            FRAME_CAPTURE_CDN_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final OutputLocationRef destination;

    private final FrameCaptureCdnSettings frameCaptureCdnSettings;

    private FrameCaptureGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.frameCaptureCdnSettings = builder.frameCaptureCdnSettings;
    }

    /**
     * The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a file name
     * prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling-) or the URI for a MediaStore container,
     * plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling-). The final file names
     * consist of the prefix from the destination field (for example, "curling-") + name modifier + the counter (5
     * digits, starting from 00001) + extension (which is always .jpg). For example, curling-low.00001.jpg
     * 
     * @return The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a
     *         file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling-) or the URI for a
     *         MediaStore container, plus a file name prefix (for example,
     *         mediastoressl://sportsDelivery/20180820/curling-). The final file names consist of the prefix from the
     *         destination field (for example, "curling-") + name modifier + the counter (5 digits, starting from 00001)
     *         + extension (which is always .jpg). For example, curling-low.00001.jpg
     */
    public final OutputLocationRef destination() {
        return destination;
    }

    /**
     * Parameters that control interactions with the CDN.
     * 
     * @return Parameters that control interactions with the CDN.
     */
    public final FrameCaptureCdnSettings frameCaptureCdnSettings() {
        return frameCaptureCdnSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureCdnSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureGroupSettings)) {
            return false;
        }
        FrameCaptureGroupSettings other = (FrameCaptureGroupSettings) obj;
        return Objects.equals(destination(), other.destination())
                && Objects.equals(frameCaptureCdnSettings(), other.frameCaptureCdnSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrameCaptureGroupSettings").add("Destination", destination())
                .add("FrameCaptureCdnSettings", frameCaptureCdnSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "FrameCaptureCdnSettings":
            return Optional.ofNullable(clazz.cast(frameCaptureCdnSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureGroupSettings, T> g) {
        return obj -> g.apply((FrameCaptureGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameCaptureGroupSettings> {
        /**
         * The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a file
         * name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling-) or the URI for a MediaStore
         * container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling-). The final
         * file names consist of the prefix from the destination field (for example, "curling-") + name modifier + the
         * counter (5 digits, starting from 00001) + extension (which is always .jpg). For example,
         * curling-low.00001.jpg
         * 
         * @param destination
         *        The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a
         *        file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling-) or the URI for a
         *        MediaStore container, plus a file name prefix (for example,
         *        mediastoressl://sportsDelivery/20180820/curling-). The final file names consist of the prefix from the
         *        destination field (for example, "curling-") + name modifier + the counter (5 digits, starting from
         *        00001) + extension (which is always .jpg). For example, curling-low.00001.jpg
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(OutputLocationRef destination);

        /**
         * The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a file
         * name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling-) or the URI for a MediaStore
         * container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling-). The final
         * file names consist of the prefix from the destination field (for example, "curling-") + name modifier + the
         * counter (5 digits, starting from 00001) + extension (which is always .jpg). For example,
         * curling-low.00001.jpg This is a convenience that creates an instance of the {@link OutputLocationRef.Builder}
         * avoiding the need to create one manually via {@link OutputLocationRef#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocationRef.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(OutputLocationRef)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link OutputLocationRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(OutputLocationRef)
         */
        default Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return destination(OutputLocationRef.builder().applyMutation(destination).build());
        }

        /**
         * Parameters that control interactions with the CDN.
         * 
         * @param frameCaptureCdnSettings
         *        Parameters that control interactions with the CDN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureCdnSettings(FrameCaptureCdnSettings frameCaptureCdnSettings);

        /**
         * Parameters that control interactions with the CDN. This is a convenience that creates an instance of the
         * {@link FrameCaptureCdnSettings.Builder} avoiding the need to create one manually via
         * {@link FrameCaptureCdnSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FrameCaptureCdnSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #frameCaptureCdnSettings(FrameCaptureCdnSettings)}.
         * 
         * @param frameCaptureCdnSettings
         *        a consumer that will call methods on {@link FrameCaptureCdnSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureCdnSettings(FrameCaptureCdnSettings)
         */
        default Builder frameCaptureCdnSettings(Consumer<FrameCaptureCdnSettings.Builder> frameCaptureCdnSettings) {
            return frameCaptureCdnSettings(FrameCaptureCdnSettings.builder().applyMutation(frameCaptureCdnSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OutputLocationRef destination;

        private FrameCaptureCdnSettings frameCaptureCdnSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureGroupSettings model) {
            destination(model.destination);
            frameCaptureCdnSettings(model.frameCaptureCdnSettings);
        }

        public final OutputLocationRef.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final FrameCaptureCdnSettings.Builder getFrameCaptureCdnSettings() {
            return frameCaptureCdnSettings != null ? frameCaptureCdnSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureCdnSettings(FrameCaptureCdnSettings frameCaptureCdnSettings) {
            this.frameCaptureCdnSettings = frameCaptureCdnSettings;
            return this;
        }

        public final void setFrameCaptureCdnSettings(FrameCaptureCdnSettings.BuilderImpl frameCaptureCdnSettings) {
            this.frameCaptureCdnSettings = frameCaptureCdnSettings != null ? frameCaptureCdnSettings.build() : null;
        }

        @Override
        public FrameCaptureGroupSettings build() {
            return new FrameCaptureGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
