/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Hls Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsGroupSettings.Builder, HlsGroupSettings> {
    private static final SdkField<List<String>> AD_MARKERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdMarkers")
            .getter(getter(HlsGroupSettings::adMarkersAsStrings))
            .setter(setter(Builder::adMarkersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BASE_URL_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrlContent").getter(getter(HlsGroupSettings::baseUrlContent))
            .setter(setter(Builder::baseUrlContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrlContent").build()).build();

    private static final SdkField<String> BASE_URL_CONTENT1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrlContent1").getter(getter(HlsGroupSettings::baseUrlContent1))
            .setter(setter(Builder::baseUrlContent1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrlContent1").build()).build();

    private static final SdkField<String> BASE_URL_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrlManifest").getter(getter(HlsGroupSettings::baseUrlManifest))
            .setter(setter(Builder::baseUrlManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrlManifest").build()).build();

    private static final SdkField<String> BASE_URL_MANIFEST1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrlManifest1").getter(getter(HlsGroupSettings::baseUrlManifest1))
            .setter(setter(Builder::baseUrlManifest1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrlManifest1").build()).build();

    private static final SdkField<List<CaptionLanguageMapping>> CAPTION_LANGUAGE_MAPPINGS_FIELD = SdkField
            .<List<CaptionLanguageMapping>> builder(MarshallingType.LIST)
            .memberName("CaptionLanguageMappings")
            .getter(getter(HlsGroupSettings::captionLanguageMappings))
            .setter(setter(Builder::captionLanguageMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaptionLanguageMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaptionLanguageMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CAPTION_LANGUAGE_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptionLanguageSetting").getter(getter(HlsGroupSettings::captionLanguageSettingAsString))
            .setter(setter(Builder::captionLanguageSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageSetting").build())
            .build();

    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCache").getter(getter(HlsGroupSettings::clientCacheAsString)).setter(setter(Builder::clientCache))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()).build();

    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecSpecification").getter(getter(HlsGroupSettings::codecSpecificationAsString))
            .setter(setter(Builder::codecSpecification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build())
            .build();

    private static final SdkField<String> CONSTANT_IV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConstantIv").getter(getter(HlsGroupSettings::constantIv)).setter(setter(Builder::constantIv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantIv").build()).build();

    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField
            .<OutputLocationRef> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(HlsGroupSettings::destination)).setter(setter(Builder::destination))
            .constructor(OutputLocationRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> DIRECTORY_STRUCTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryStructure").getter(getter(HlsGroupSettings::directoryStructureAsString))
            .setter(setter(Builder::directoryStructure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryStructure").build())
            .build();

    private static final SdkField<String> DISCONTINUITY_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscontinuityTags").getter(getter(HlsGroupSettings::discontinuityTagsAsString))
            .setter(setter(Builder::discontinuityTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discontinuityTags").build()).build();

    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionType").getter(getter(HlsGroupSettings::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()).build();

    private static final SdkField<HlsCdnSettings> HLS_CDN_SETTINGS_FIELD = SdkField
            .<HlsCdnSettings> builder(MarshallingType.SDK_POJO).memberName("HlsCdnSettings")
            .getter(getter(HlsGroupSettings::hlsCdnSettings)).setter(setter(Builder::hlsCdnSettings))
            .constructor(HlsCdnSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsCdnSettings").build()).build();

    private static final SdkField<String> HLS_ID3_SEGMENT_TAGGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HlsId3SegmentTagging").getter(getter(HlsGroupSettings::hlsId3SegmentTaggingAsString))
            .setter(setter(Builder::hlsId3SegmentTagging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsId3SegmentTagging").build())
            .build();

    private static final SdkField<String> I_FRAME_ONLY_PLAYLISTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IFrameOnlyPlaylists").getter(getter(HlsGroupSettings::iFrameOnlyPlaylistsAsString))
            .setter(setter(Builder::iFrameOnlyPlaylists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iFrameOnlyPlaylists").build())
            .build();

    private static final SdkField<String> INCOMPLETE_SEGMENT_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncompleteSegmentBehavior").getter(getter(HlsGroupSettings::incompleteSegmentBehaviorAsString))
            .setter(setter(Builder::incompleteSegmentBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incompleteSegmentBehavior").build())
            .build();

    private static final SdkField<Integer> INDEX_N_SEGMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IndexNSegments").getter(getter(HlsGroupSettings::indexNSegments))
            .setter(setter(Builder::indexNSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexNSegments").build()).build();

    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputLossAction").getter(getter(HlsGroupSettings::inputLossActionAsString))
            .setter(setter(Builder::inputLossAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()).build();

    private static final SdkField<String> IV_IN_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IvInManifest").getter(getter(HlsGroupSettings::ivInManifestAsString))
            .setter(setter(Builder::ivInManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ivInManifest").build()).build();

    private static final SdkField<String> IV_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IvSource").getter(getter(HlsGroupSettings::ivSourceAsString)).setter(setter(Builder::ivSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ivSource").build()).build();

    private static final SdkField<Integer> KEEP_SEGMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("KeepSegments").getter(getter(HlsGroupSettings::keepSegments)).setter(setter(Builder::keepSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepSegments").build()).build();

    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyFormat").getter(getter(HlsGroupSettings::keyFormat)).setter(setter(Builder::keyFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyFormat").build()).build();

    private static final SdkField<String> KEY_FORMAT_VERSIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyFormatVersions").getter(getter(HlsGroupSettings::keyFormatVersions))
            .setter(setter(Builder::keyFormatVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyFormatVersions").build()).build();

    private static final SdkField<KeyProviderSettings> KEY_PROVIDER_SETTINGS_FIELD = SdkField
            .<KeyProviderSettings> builder(MarshallingType.SDK_POJO).memberName("KeyProviderSettings")
            .getter(getter(HlsGroupSettings::keyProviderSettings)).setter(setter(Builder::keyProviderSettings))
            .constructor(KeyProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyProviderSettings").build())
            .build();

    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestCompression").getter(getter(HlsGroupSettings::manifestCompressionAsString))
            .setter(setter(Builder::manifestCompression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build())
            .build();

    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestDurationFormat").getter(getter(HlsGroupSettings::manifestDurationFormatAsString))
            .setter(setter(Builder::manifestDurationFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build())
            .build();

    private static final SdkField<Integer> MIN_SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSegmentLength").getter(getter(HlsGroupSettings::minSegmentLength))
            .setter(setter(Builder::minSegmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSegmentLength").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(HlsGroupSettings::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<String> OUTPUT_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputSelection").getter(getter(HlsGroupSettings::outputSelectionAsString))
            .setter(setter(Builder::outputSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSelection").build()).build();

    private static final SdkField<String> PROGRAM_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramDateTime").getter(getter(HlsGroupSettings::programDateTimeAsString))
            .setter(setter(Builder::programDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTime").build()).build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramDateTimePeriod").getter(getter(HlsGroupSettings::programDateTimePeriod))
            .setter(setter(Builder::programDateTimePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimePeriod").build())
            .build();

    private static final SdkField<String> REDUNDANT_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedundantManifest").getter(getter(HlsGroupSettings::redundantManifestAsString))
            .setter(setter(Builder::redundantManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redundantManifest").build()).build();

    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentLength").getter(getter(HlsGroupSettings::segmentLength)).setter(setter(Builder::segmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()).build();

    private static final SdkField<String> SEGMENTATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentationMode").getter(getter(HlsGroupSettings::segmentationModeAsString))
            .setter(setter(Builder::segmentationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationMode").build()).build();

    private static final SdkField<Integer> SEGMENTS_PER_SUBDIRECTORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentsPerSubdirectory").getter(getter(HlsGroupSettings::segmentsPerSubdirectory))
            .setter(setter(Builder::segmentsPerSubdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentsPerSubdirectory").build())
            .build();

    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamInfResolution").getter(getter(HlsGroupSettings::streamInfResolutionAsString))
            .setter(setter(Builder::streamInfResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build())
            .build();

    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimedMetadataId3Frame").getter(getter(HlsGroupSettings::timedMetadataId3FrameAsString))
            .setter(setter(Builder::timedMetadataId3Frame))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build())
            .build();

    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimedMetadataId3Period").getter(getter(HlsGroupSettings::timedMetadataId3Period))
            .setter(setter(Builder::timedMetadataId3Period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build())
            .build();

    private static final SdkField<Integer> TIMESTAMP_DELTA_MILLISECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimestampDeltaMilliseconds")
            .getter(getter(HlsGroupSettings::timestampDeltaMilliseconds))
            .setter(setter(Builder::timestampDeltaMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampDeltaMilliseconds").build())
            .build();

    private static final SdkField<String> TS_FILE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TsFileMode").getter(getter(HlsGroupSettings::tsFileModeAsString)).setter(setter(Builder::tsFileMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tsFileMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD,
            BASE_URL_CONTENT_FIELD, BASE_URL_CONTENT1_FIELD, BASE_URL_MANIFEST_FIELD, BASE_URL_MANIFEST1_FIELD,
            CAPTION_LANGUAGE_MAPPINGS_FIELD, CAPTION_LANGUAGE_SETTING_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD,
            CONSTANT_IV_FIELD, DESTINATION_FIELD, DIRECTORY_STRUCTURE_FIELD, DISCONTINUITY_TAGS_FIELD, ENCRYPTION_TYPE_FIELD,
            HLS_CDN_SETTINGS_FIELD, HLS_ID3_SEGMENT_TAGGING_FIELD, I_FRAME_ONLY_PLAYLISTS_FIELD,
            INCOMPLETE_SEGMENT_BEHAVIOR_FIELD, INDEX_N_SEGMENTS_FIELD, INPUT_LOSS_ACTION_FIELD, IV_IN_MANIFEST_FIELD,
            IV_SOURCE_FIELD, KEEP_SEGMENTS_FIELD, KEY_FORMAT_FIELD, KEY_FORMAT_VERSIONS_FIELD, KEY_PROVIDER_SETTINGS_FIELD,
            MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD, MIN_SEGMENT_LENGTH_FIELD, MODE_FIELD,
            OUTPUT_SELECTION_FIELD, PROGRAM_DATE_TIME_FIELD, PROGRAM_DATE_TIME_PERIOD_FIELD, REDUNDANT_MANIFEST_FIELD,
            SEGMENT_LENGTH_FIELD, SEGMENTATION_MODE_FIELD, SEGMENTS_PER_SUBDIRECTORY_FIELD, STREAM_INF_RESOLUTION_FIELD,
            TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD, TIMESTAMP_DELTA_MILLISECONDS_FIELD,
            TS_FILE_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> adMarkers;

    private final String baseUrlContent;

    private final String baseUrlContent1;

    private final String baseUrlManifest;

    private final String baseUrlManifest1;

    private final List<CaptionLanguageMapping> captionLanguageMappings;

    private final String captionLanguageSetting;

    private final String clientCache;

    private final String codecSpecification;

    private final String constantIv;

    private final OutputLocationRef destination;

    private final String directoryStructure;

    private final String discontinuityTags;

    private final String encryptionType;

    private final HlsCdnSettings hlsCdnSettings;

    private final String hlsId3SegmentTagging;

    private final String iFrameOnlyPlaylists;

    private final String incompleteSegmentBehavior;

    private final Integer indexNSegments;

    private final String inputLossAction;

    private final String ivInManifest;

    private final String ivSource;

    private final Integer keepSegments;

    private final String keyFormat;

    private final String keyFormatVersions;

    private final KeyProviderSettings keyProviderSettings;

    private final String manifestCompression;

    private final String manifestDurationFormat;

    private final Integer minSegmentLength;

    private final String mode;

    private final String outputSelection;

    private final String programDateTime;

    private final Integer programDateTimePeriod;

    private final String redundantManifest;

    private final Integer segmentLength;

    private final String segmentationMode;

    private final Integer segmentsPerSubdirectory;

    private final String streamInfResolution;

    private final String timedMetadataId3Frame;

    private final Integer timedMetadataId3Period;

    private final Integer timestampDeltaMilliseconds;

    private final String tsFileMode;

    private HlsGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.baseUrlContent = builder.baseUrlContent;
        this.baseUrlContent1 = builder.baseUrlContent1;
        this.baseUrlManifest = builder.baseUrlManifest;
        this.baseUrlManifest1 = builder.baseUrlManifest1;
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.captionLanguageSetting = builder.captionLanguageSetting;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.constantIv = builder.constantIv;
        this.destination = builder.destination;
        this.directoryStructure = builder.directoryStructure;
        this.discontinuityTags = builder.discontinuityTags;
        this.encryptionType = builder.encryptionType;
        this.hlsCdnSettings = builder.hlsCdnSettings;
        this.hlsId3SegmentTagging = builder.hlsId3SegmentTagging;
        this.iFrameOnlyPlaylists = builder.iFrameOnlyPlaylists;
        this.incompleteSegmentBehavior = builder.incompleteSegmentBehavior;
        this.indexNSegments = builder.indexNSegments;
        this.inputLossAction = builder.inputLossAction;
        this.ivInManifest = builder.ivInManifest;
        this.ivSource = builder.ivSource;
        this.keepSegments = builder.keepSegments;
        this.keyFormat = builder.keyFormat;
        this.keyFormatVersions = builder.keyFormatVersions;
        this.keyProviderSettings = builder.keyProviderSettings;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minSegmentLength = builder.minSegmentLength;
        this.mode = builder.mode;
        this.outputSelection = builder.outputSelection;
        this.programDateTime = builder.programDateTime;
        this.programDateTimePeriod = builder.programDateTimePeriod;
        this.redundantManifest = builder.redundantManifest;
        this.segmentLength = builder.segmentLength;
        this.segmentationMode = builder.segmentationMode;
        this.segmentsPerSubdirectory = builder.segmentsPerSubdirectory;
        this.streamInfResolution = builder.streamInfResolution;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timestampDeltaMilliseconds = builder.timestampDeltaMilliseconds;
        this.tsFileMode = builder.tsFileMode;
    }

    /**
     * Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdMarkers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
     */
    public final List<HlsAdMarkers> adMarkers() {
        return ___listOfHlsAdMarkersCopier.copyStringToEnum(adMarkers);
    }

    /**
     * Returns true if the AdMarkers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAdMarkers() {
        return adMarkers != null && !(adMarkers instanceof SdkAutoConstructList);
    }

    /**
     * Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdMarkers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
     */
    public final List<String> adMarkersAsStrings() {
        return adMarkers;
    }

    /**
     * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest
     * is delivered from a different URL than the main .m3u8 file.
     * 
     * @return A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base
     *         manifest is delivered from a different URL than the main .m3u8 file.
     */
    public final String baseUrlContent() {
        return baseUrlContent;
    }

    /**
     * Optional. One value per output group.
     *
     * This field is required only if you are completing Base URL content A, and the downstream system has notified you
     * that the media files for pipeline 1 of all outputs are in a location different from the media files for pipeline
     * 0.
     * 
     * @return Optional. One value per output group.
     *
     *         This field is required only if you are completing Base URL content A, and the downstream system has
     *         notified you that the media files for pipeline 1 of all outputs are in a location different from the
     *         media files for pipeline 0.
     */
    public final String baseUrlContent1() {
        return baseUrlContent1;
    }

    /**
     * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest
     * is delivered from a different URL than the main .m3u8 file.
     * 
     * @return A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base
     *         manifest is delivered from a different URL than the main .m3u8 file.
     */
    public final String baseUrlManifest() {
        return baseUrlManifest;
    }

    /**
     * Optional. One value per output group.
     *
     * Complete this field only if you are completing Base URL manifest A, and the downstream system has notified you
     * that the child manifest files for pipeline 1 of all outputs are in a location different from the child manifest
     * files for pipeline 0.
     * 
     * @return Optional. One value per output group.
     *
     *         Complete this field only if you are completing Base URL manifest A, and the downstream system has
     *         notified you that the child manifest files for pipeline 1 of all outputs are in a location different from
     *         the child manifest files for pipeline 0.
     */
    public final String baseUrlManifest1() {
        return baseUrlManifest1;
    }

    /**
     * Returns true if the CaptionLanguageMappings property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCaptionLanguageMappings() {
        return captionLanguageMappings != null && !(captionLanguageMappings instanceof SdkAutoConstructList);
    }

    /**
     * Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting is set to
     * "insert".
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCaptionLanguageMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting is
     *         set to "insert".
     */
    public final List<CaptionLanguageMapping> captionLanguageMappings() {
        return captionLanguageMappings;
    }

    /**
     * Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at
     * least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you
     * specify. Make sure to specify the languages in the order in which they appear in the original source (if the
     * source is embedded format) or the order of the caption selectors (if the source is other than embedded).
     * Otherwise, languages in the manifest will not match up properly with the output captions. none: Include
     * CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line from the manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionLanguageSetting} will return {@link HlsCaptionLanguageSetting#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #captionLanguageSettingAsString}.
     * </p>
     * 
     * @return Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest.
     *         Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each
     *         Language Code you specify. Make sure to specify the languages in the order in which they appear in the
     *         original source (if the source is embedded format) or the order of the caption selectors (if the source
     *         is other than embedded). Otherwise, languages in the manifest will not match up properly with the output
     *         captions. none: Include CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line
     *         from the manifest.
     * @see HlsCaptionLanguageSetting
     */
    public final HlsCaptionLanguageSetting captionLanguageSetting() {
        return HlsCaptionLanguageSetting.fromValue(captionLanguageSetting);
    }

    /**
     * Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at
     * least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you
     * specify. Make sure to specify the languages in the order in which they appear in the original source (if the
     * source is embedded format) or the order of the caption selectors (if the source is other than embedded).
     * Otherwise, languages in the manifest will not match up properly with the output captions. none: Include
     * CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line from the manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionLanguageSetting} will return {@link HlsCaptionLanguageSetting#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #captionLanguageSettingAsString}.
     * </p>
     * 
     * @return Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest.
     *         Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each
     *         Language Code you specify. Make sure to specify the languages in the order in which they appear in the
     *         original source (if the source is embedded format) or the order of the caption selectors (if the source
     *         is other than embedded). Otherwise, languages in the manifest will not match up properly with the output
     *         captions. none: Include CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line
     *         from the manifest.
     * @see HlsCaptionLanguageSetting
     */
    public final String captionLanguageSettingAsString() {
        return captionLanguageSetting;
    }

    /**
     * When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from saving
     * media segments for later replay.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link HlsClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from
     *         saving media segments for later replay.
     * @see HlsClientCache
     */
    public final HlsClientCache clientCache() {
        return HlsClientCache.fromValue(clientCache);
    }

    /**
     * When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from saving
     * media segments for later replay.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link HlsClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from
     *         saving media segments for later replay.
     * @see HlsClientCache
     */
    public final String clientCacheAsString() {
        return clientCache;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link HlsCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see HlsCodecSpecification
     */
    public final HlsCodecSpecification codecSpecification() {
        return HlsCodecSpecification.fromValue(codecSpecification);
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link HlsCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see HlsCodecSpecification
     */
    public final String codecSpecificationAsString() {
        return codecSpecification;
    }

    /**
     * For use with encryptionType. This is a 128-bit, 16-byte hex value represented by a 32-character text string. If
     * ivSource is set to "explicit" then this parameter is required and is used as the IV for encryption.
     * 
     * @return For use with encryptionType. This is a 128-bit, 16-byte hex value represented by a 32-character text
     *         string. If ivSource is set to "explicit" then this parameter is required and is used as the IV for
     *         encryption.
     */
    public final String constantIv() {
        return constantIv;
    }

    /**
     * A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled).
     * 
     * @return A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled).
     */
    public final OutputLocationRef destination() {
        return destination;
    }

    /**
     * Place segments in subdirectories.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directoryStructure} will return {@link HlsDirectoryStructure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directoryStructureAsString}.
     * </p>
     * 
     * @return Place segments in subdirectories.
     * @see HlsDirectoryStructure
     */
    public final HlsDirectoryStructure directoryStructure() {
        return HlsDirectoryStructure.fromValue(directoryStructure);
    }

    /**
     * Place segments in subdirectories.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directoryStructure} will return {@link HlsDirectoryStructure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directoryStructureAsString}.
     * </p>
     * 
     * @return Place segments in subdirectories.
     * @see HlsDirectoryStructure
     */
    public final String directoryStructureAsString() {
        return directoryStructure;
    }

    /**
     * Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group. Typically,
     * choose Insert because these tags are required in the manifest (according to the HLS specification) and serve an
     * important purpose. Choose Never Insert only if the downstream system is doing real-time failover (without using
     * the MediaLive automatic failover feature) and only if that downstream system has advised you to exclude the tags.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discontinuityTags}
     * will return {@link HlsDiscontinuityTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #discontinuityTagsAsString}.
     * </p>
     * 
     * @return Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group.
     *         Typically, choose Insert because these tags are required in the manifest (according to the HLS
     *         specification) and serve an important purpose. Choose Never Insert only if the downstream system is doing
     *         real-time failover (without using the MediaLive automatic failover feature) and only if that downstream
     *         system has advised you to exclude the tags.
     * @see HlsDiscontinuityTags
     */
    public final HlsDiscontinuityTags discontinuityTags() {
        return HlsDiscontinuityTags.fromValue(discontinuityTags);
    }

    /**
     * Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group. Typically,
     * choose Insert because these tags are required in the manifest (according to the HLS specification) and serve an
     * important purpose. Choose Never Insert only if the downstream system is doing real-time failover (without using
     * the MediaLive automatic failover feature) and only if that downstream system has advised you to exclude the tags.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discontinuityTags}
     * will return {@link HlsDiscontinuityTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #discontinuityTagsAsString}.
     * </p>
     * 
     * @return Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group.
     *         Typically, choose Insert because these tags are required in the manifest (according to the HLS
     *         specification) and serve an important purpose. Choose Never Insert only if the downstream system is doing
     *         real-time failover (without using the MediaLive automatic failover feature) and only if that downstream
     *         system has advised you to exclude the tags.
     * @see HlsDiscontinuityTags
     */
    public final String discontinuityTagsAsString() {
        return discontinuityTags;
    }

    /**
     * Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is desired.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link HlsEncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is
     *         desired.
     * @see HlsEncryptionType
     */
    public final HlsEncryptionType encryptionType() {
        return HlsEncryptionType.fromValue(encryptionType);
    }

    /**
     * Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is desired.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link HlsEncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is
     *         desired.
     * @see HlsEncryptionType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    /**
     * Parameters that control interactions with the CDN.
     * 
     * @return Parameters that control interactions with the CDN.
     */
    public final HlsCdnSettings hlsCdnSettings() {
        return hlsCdnSettings;
    }

    /**
     * State of HLS ID3 Segment Tagging
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hlsId3SegmentTagging} will return {@link HlsId3SegmentTaggingState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hlsId3SegmentTaggingAsString}.
     * </p>
     * 
     * @return State of HLS ID3 Segment Tagging
     * @see HlsId3SegmentTaggingState
     */
    public final HlsId3SegmentTaggingState hlsId3SegmentTagging() {
        return HlsId3SegmentTaggingState.fromValue(hlsId3SegmentTagging);
    }

    /**
     * State of HLS ID3 Segment Tagging
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hlsId3SegmentTagging} will return {@link HlsId3SegmentTaggingState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hlsId3SegmentTaggingAsString}.
     * </p>
     * 
     * @return State of HLS ID3 Segment Tagging
     * @see HlsId3SegmentTaggingState
     */
    public final String hlsId3SegmentTaggingAsString() {
        return hlsId3SegmentTagging;
    }

    /**
     * DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according to the
     * Output Selection field).
     *
     * STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests
     * (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate
     * it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For example,
     * #EXT-X-BYTERANGE:160364@1461888"
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #iFrameOnlyPlaylists} will return {@link IFrameOnlyPlaylistType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #iFrameOnlyPlaylistsAsString}.
     * </p>
     * 
     * @return DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according
     *         to the Output Selection field).
     *
     *         STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other
     *         manifests (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY
     *         tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame
     *         position. For example, #EXT-X-BYTERANGE:160364@1461888"
     * @see IFrameOnlyPlaylistType
     */
    public final IFrameOnlyPlaylistType iFrameOnlyPlaylists() {
        return IFrameOnlyPlaylistType.fromValue(iFrameOnlyPlaylists);
    }

    /**
     * DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according to the
     * Output Selection field).
     *
     * STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests
     * (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate
     * it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For example,
     * #EXT-X-BYTERANGE:160364@1461888"
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #iFrameOnlyPlaylists} will return {@link IFrameOnlyPlaylistType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #iFrameOnlyPlaylistsAsString}.
     * </p>
     * 
     * @return DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according
     *         to the Output Selection field).
     *
     *         STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other
     *         manifests (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY
     *         tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame
     *         position. For example, #EXT-X-BYTERANGE:160364@1461888"
     * @see IFrameOnlyPlaylistType
     */
    public final String iFrameOnlyPlaylistsAsString() {
        return iFrameOnlyPlaylists;
    }

    /**
     * Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops producing
     * output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto means that MediaLive
     * decides whether to include the final segment, depending on the channel class and the types of output groups.
     * Suppress means to never include the incomplete segment. We recommend you choose Auto and let MediaLive control
     * the behavior.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #incompleteSegmentBehavior} will return {@link HlsIncompleteSegmentBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #incompleteSegmentBehaviorAsString}.
     * </p>
     * 
     * @return Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops
     *         producing output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto
     *         means that MediaLive decides whether to include the final segment, depending on the channel class and the
     *         types of output groups. Suppress means to never include the incomplete segment. We recommend you choose
     *         Auto and let MediaLive control the behavior.
     * @see HlsIncompleteSegmentBehavior
     */
    public final HlsIncompleteSegmentBehavior incompleteSegmentBehavior() {
        return HlsIncompleteSegmentBehavior.fromValue(incompleteSegmentBehavior);
    }

    /**
     * Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops producing
     * output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto means that MediaLive
     * decides whether to include the final segment, depending on the channel class and the types of output groups.
     * Suppress means to never include the incomplete segment. We recommend you choose Auto and let MediaLive control
     * the behavior.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #incompleteSegmentBehavior} will return {@link HlsIncompleteSegmentBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #incompleteSegmentBehaviorAsString}.
     * </p>
     * 
     * @return Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops
     *         producing output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto
     *         means that MediaLive decides whether to include the final segment, depending on the channel class and the
     *         types of output groups. Suppress means to never include the incomplete segment. We recommend you choose
     *         Auto and let MediaLive control the behavior.
     * @see HlsIncompleteSegmentBehavior
     */
    public final String incompleteSegmentBehaviorAsString() {
        return incompleteSegmentBehavior;
    }

    /**
     * Applies only if Mode field is LIVE.
     *
     * Specifies the maximum number of segments in the media manifest file. After this maximum, older segments are
     * removed from the media manifest. This number must be smaller than the number in the Keep Segments field.
     * 
     * @return Applies only if Mode field is LIVE.
     *
     *         Specifies the maximum number of segments in the media manifest file. After this maximum, older segments
     *         are removed from the media manifest. This number must be smaller than the number in the Keep Segments
     *         field.
     */
    public final Integer indexNSegments() {
        return indexNSegments;
    }

    /**
     * Parameter that control output group behavior on input loss.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForHlsOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Parameter that control output group behavior on input loss.
     * @see InputLossActionForHlsOut
     */
    public final InputLossActionForHlsOut inputLossAction() {
        return InputLossActionForHlsOut.fromValue(inputLossAction);
    }

    /**
     * Parameter that control output group behavior on input loss.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForHlsOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Parameter that control output group behavior on input loss.
     * @see InputLossActionForHlsOut
     */
    public final String inputLossActionAsString() {
        return inputLossAction;
    }

    /**
     * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key
     * for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not in the
     * manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ivInManifest} will
     * return {@link HlsIvInManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ivInManifestAsString}.
     * </p>
     * 
     * @return For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with
     *         the key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not
     *         in the manifest.
     * @see HlsIvInManifest
     */
    public final HlsIvInManifest ivInManifest() {
        return HlsIvInManifest.fromValue(ivInManifest);
    }

    /**
     * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key
     * for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not in the
     * manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ivInManifest} will
     * return {@link HlsIvInManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ivInManifestAsString}.
     * </p>
     * 
     * @return For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with
     *         the key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not
     *         in the manifest.
     * @see HlsIvInManifest
     */
    public final String ivInManifestAsString() {
        return ivInManifest;
    }

    /**
     * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key
     * for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change every segment
     * (to match the segment number). If this is set to "explicit", you must enter a constantIv value.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ivSource} will
     * return {@link HlsIvSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ivSourceAsString}.
     * </p>
     * 
     * @return For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with
     *         the key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change
     *         every segment (to match the segment number). If this is set to "explicit", you must enter a constantIv
     *         value.
     * @see HlsIvSource
     */
    public final HlsIvSource ivSource() {
        return HlsIvSource.fromValue(ivSource);
    }

    /**
     * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key
     * for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change every segment
     * (to match the segment number). If this is set to "explicit", you must enter a constantIv value.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ivSource} will
     * return {@link HlsIvSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ivSourceAsString}.
     * </p>
     * 
     * @return For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with
     *         the key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change
     *         every segment (to match the segment number). If this is set to "explicit", you must enter a constantIv
     *         value.
     * @see HlsIvSource
     */
    public final String ivSourceAsString() {
        return ivSource;
    }

    /**
     * Applies only if Mode field is LIVE.
     *
     * Specifies the number of media segments to retain in the destination directory. This number should be bigger than
     * indexNSegments (Num segments). We recommend (value = (2 x indexNsegments) + 1).
     *
     * If this "keep segments" number is too low, the following might happen: the player is still reading a media
     * manifest file that lists this segment, but that segment has been removed from the destination directory (as
     * directed by indexNSegments). This situation would result in a 404 HTTP error on the player.
     * 
     * @return Applies only if Mode field is LIVE.
     *
     *         Specifies the number of media segments to retain in the destination directory. This number should be
     *         bigger than indexNSegments (Num segments). We recommend (value = (2 x indexNsegments) + 1).
     *
     *         If this "keep segments" number is too low, the following might happen: the player is still reading a
     *         media manifest file that lists this segment, but that segment has been removed from the destination
     *         directory (as directed by indexNSegments). This situation would result in a 404 HTTP error on the player.
     */
    public final Integer keepSegments() {
        return keepSegments;
    }

    /**
     * The value specifies how the key is represented in the resource identified by the URI. If parameter is absent, an
     * implicit value of "identity" is used. A reverse DNS string can also be given.
     * 
     * @return The value specifies how the key is represented in the resource identified by the URI. If parameter is
     *         absent, an implicit value of "identity" is used. A reverse DNS string can also be given.
     */
    public final String keyFormat() {
        return keyFormat;
    }

    /**
     * Either a single positive integer version value or a slash delimited list of version values (1/2/3).
     * 
     * @return Either a single positive integer version value or a slash delimited list of version values (1/2/3).
     */
    public final String keyFormatVersions() {
        return keyFormatVersions;
    }

    /**
     * The key provider settings.
     * 
     * @return The key provider settings.
     */
    public final KeyProviderSettings keyProviderSettings() {
        return keyProviderSettings;
    }

    /**
     * When set to gzip, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link HlsManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to gzip, compresses HLS playlist.
     * @see HlsManifestCompression
     */
    public final HlsManifestCompression manifestCompression() {
        return HlsManifestCompression.fromValue(manifestCompression);
    }

    /**
     * When set to gzip, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link HlsManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to gzip, compresses HLS playlist.
     * @see HlsManifestCompression
     */
    public final String manifestCompressionAsString() {
        return manifestCompression;
    }

    /**
     * Indicates whether the output manifest should use floating point or integer values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link HlsManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point or integer values for segment duration.
     * @see HlsManifestDurationFormat
     */
    public final HlsManifestDurationFormat manifestDurationFormat() {
        return HlsManifestDurationFormat.fromValue(manifestDurationFormat);
    }

    /**
     * Indicates whether the output manifest should use floating point or integer values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link HlsManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point or integer values for segment duration.
     * @see HlsManifestDurationFormat
     */
    public final String manifestDurationFormatAsString() {
        return manifestDurationFormat;
    }

    /**
     * When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a nearby
     * avail and extending the segment size if needed.
     * 
     * @return When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a
     *         nearby avail and extending the segment size if needed.
     */
    public final Integer minSegmentLength() {
        return minSegmentLength;
    }

    /**
     * If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only the
     * number segments specified in keepSegments and indexNSegments are kept; newer segments replace older segments,
     * which may prevent players from rewinding all the way to the beginning of the event.
     *
     * VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type
     * manifest on completion of the stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link HlsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only
     *         the number segments specified in keepSegments and indexNSegments are kept; newer segments replace older
     *         segments, which may prevent players from rewinding all the way to the beginning of the event.
     *
     *         VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD"
     *         type manifest on completion of the stream.
     * @see HlsMode
     */
    public final HlsMode mode() {
        return HlsMode.fromValue(mode);
    }

    /**
     * If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only the
     * number segments specified in keepSegments and indexNSegments are kept; newer segments replace older segments,
     * which may prevent players from rewinding all the way to the beginning of the event.
     *
     * VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type
     * manifest on completion of the stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link HlsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only
     *         the number segments specified in keepSegments and indexNSegments are kept; newer segments replace older
     *         segments, which may prevent players from rewinding all the way to the beginning of the event.
     *
     *         VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD"
     *         type manifest on completion of the stream.
     * @see HlsMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for this output
     * group.
     *
     * VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master manifest.
     *
     * SEGMENTS_ONLY: Does not generate any manifests for this output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSelection}
     * will return {@link HlsOutputSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputSelectionAsString}.
     * </p>
     * 
     * @return MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for
     *         this output group.
     *
     *         VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master
     *         manifest.
     *
     *         SEGMENTS_ONLY: Does not generate any manifests for this output group.
     * @see HlsOutputSelection
     */
    public final HlsOutputSelection outputSelection() {
        return HlsOutputSelection.fromValue(outputSelection);
    }

    /**
     * MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for this output
     * group.
     *
     * VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master manifest.
     *
     * SEGMENTS_ONLY: Does not generate any manifests for this output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSelection}
     * will return {@link HlsOutputSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputSelectionAsString}.
     * </p>
     * 
     * @return MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for
     *         this output group.
     *
     *         VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master
     *         manifest.
     *
     *         SEGMENTS_ONLY: Does not generate any manifests for this output group.
     * @see HlsOutputSelection
     */
    public final String outputSelectionAsString() {
        return outputSelection;
    }

    /**
     * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
     * either the program date and time are initialized using the input timecode source, or the time is initialized
     * using the input timecode source and the date is initialized using the timestampOffset.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #programDateTime}
     * will return {@link HlsProgramDateTime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #programDateTimeAsString}.
     * </p>
     * 
     * @return Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
     *         follows: either the program date and time are initialized using the input timecode source, or the time is
     *         initialized using the input timecode source and the date is initialized using the timestampOffset.
     * @see HlsProgramDateTime
     */
    public final HlsProgramDateTime programDateTime() {
        return HlsProgramDateTime.fromValue(programDateTime);
    }

    /**
     * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
     * either the program date and time are initialized using the input timecode source, or the time is initialized
     * using the input timecode source and the date is initialized using the timestampOffset.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #programDateTime}
     * will return {@link HlsProgramDateTime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #programDateTimeAsString}.
     * </p>
     * 
     * @return Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
     *         follows: either the program date and time are initialized using the input timecode source, or the time is
     *         initialized using the input timecode source and the date is initialized using the timestampOffset.
     * @see HlsProgramDateTime
     */
    public final String programDateTimeAsString() {
        return programDateTime;
    }

    /**
     * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
     * 
     * @return Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
     */
    public final Integer programDateTimePeriod() {
        return programDateTimePeriod;
    }

    /**
     * ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first its
     * own media files, then the media files of the other pipeline. This feature allows playout device that support
     * stale manifest detection to switch from one manifest to the other, when the current manifest seems to be stale.
     * There are still two destinations and two master manifests, but both master manifests reference the media files
     * from both pipelines.
     *
     * DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline only.
     *
     * For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed.
     * MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is irrelevant.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #redundantManifest}
     * will return {@link HlsRedundantManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #redundantManifestAsString}.
     * </p>
     * 
     * @return ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines:
     *         first its own media files, then the media files of the other pipeline. This feature allows playout device
     *         that support stale manifest detection to switch from one manifest to the other, when the current manifest
     *         seems to be stale. There are still two destinations and two master manifests, but both master manifests
     *         reference the media files from both pipelines.
     *
     *         DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline
     *         only.
     *
     *         For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed.
     *         MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is
     *         irrelevant.
     * @see HlsRedundantManifest
     */
    public final HlsRedundantManifest redundantManifest() {
        return HlsRedundantManifest.fromValue(redundantManifest);
    }

    /**
     * ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first its
     * own media files, then the media files of the other pipeline. This feature allows playout device that support
     * stale manifest detection to switch from one manifest to the other, when the current manifest seems to be stale.
     * There are still two destinations and two master manifests, but both master manifests reference the media files
     * from both pipelines.
     *
     * DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline only.
     *
     * For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed.
     * MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is irrelevant.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #redundantManifest}
     * will return {@link HlsRedundantManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #redundantManifestAsString}.
     * </p>
     * 
     * @return ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines:
     *         first its own media files, then the media files of the other pipeline. This feature allows playout device
     *         that support stale manifest detection to switch from one manifest to the other, when the current manifest
     *         seems to be stale. There are still two destinations and two master manifests, but both master manifests
     *         reference the media files from both pipelines.
     *
     *         DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline
     *         only.
     *
     *         For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed.
     *         MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is
     *         irrelevant.
     * @see HlsRedundantManifest
     */
    public final String redundantManifestAsString() {
        return redundantManifest;
    }

    /**
     * Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the next
     * keyframe after this number of seconds, so actual segment length may be longer.
     * 
     * @return Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the
     *         next keyframe after this number of seconds, so actual segment length may be longer.
     */
    public final Integer segmentLength() {
        return segmentLength;
    }

    /**
     * useInputSegmentation has been deprecated. The configured segment size is always used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentationMode}
     * will return {@link HlsSegmentationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #segmentationModeAsString}.
     * </p>
     * 
     * @return useInputSegmentation has been deprecated. The configured segment size is always used.
     * @see HlsSegmentationMode
     */
    public final HlsSegmentationMode segmentationMode() {
        return HlsSegmentationMode.fromValue(segmentationMode);
    }

    /**
     * useInputSegmentation has been deprecated. The configured segment size is always used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentationMode}
     * will return {@link HlsSegmentationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #segmentationModeAsString}.
     * </p>
     * 
     * @return useInputSegmentation has been deprecated. The configured segment size is always used.
     * @see HlsSegmentationMode
     */
    public final String segmentationModeAsString() {
        return segmentationMode;
    }

    /**
     * Number of segments to write to a subdirectory before starting a new one. directoryStructure must be
     * subdirectoryPerStream for this setting to have an effect.
     * 
     * @return Number of segments to write to a subdirectory before starting a new one. directoryStructure must be
     *         subdirectoryPerStream for this setting to have an effect.
     */
    public final Integer segmentsPerSubdirectory() {
        return segmentsPerSubdirectory;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link HlsStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see HlsStreamInfResolution
     */
    public final HlsStreamInfResolution streamInfResolution() {
        return HlsStreamInfResolution.fromValue(streamInfResolution);
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link HlsStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see HlsStreamInfResolution
     */
    public final String streamInfResolutionAsString() {
        return streamInfResolution;
    }

    /**
     * Indicates ID3 frame that has the timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataId3Frame} will return {@link HlsTimedMetadataId3Frame#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timedMetadataId3FrameAsString}.
     * </p>
     * 
     * @return Indicates ID3 frame that has the timecode.
     * @see HlsTimedMetadataId3Frame
     */
    public final HlsTimedMetadataId3Frame timedMetadataId3Frame() {
        return HlsTimedMetadataId3Frame.fromValue(timedMetadataId3Frame);
    }

    /**
     * Indicates ID3 frame that has the timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataId3Frame} will return {@link HlsTimedMetadataId3Frame#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timedMetadataId3FrameAsString}.
     * </p>
     * 
     * @return Indicates ID3 frame that has the timecode.
     * @see HlsTimedMetadataId3Frame
     */
    public final String timedMetadataId3FrameAsString() {
        return timedMetadataId3Frame;
    }

    /**
     * Timed Metadata interval in seconds.
     * 
     * @return Timed Metadata interval in seconds.
     */
    public final Integer timedMetadataId3Period() {
        return timedMetadataId3Period;
    }

    /**
     * Provides an extra millisecond delta offset to fine tune the timestamps.
     * 
     * @return Provides an extra millisecond delta offset to fine tune the timestamps.
     */
    public final Integer timestampDeltaMilliseconds() {
        return timestampDeltaMilliseconds;
    }

    /**
     * SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
     *
     * SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media manifest
     * includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when sending the
     * output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while the channel is
     * running is not guaranteed due to HTTP server caching.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tsFileMode} will
     * return {@link HlsTsFileMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tsFileModeAsString}.
     * </p>
     * 
     * @return SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
     *
     *         SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media
     *         manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is
     *         when sending the output to AWS Elemental MediaConvert, which can accept only a single media file.
     *         Playback while the channel is running is not guaranteed due to HTTP server caching.
     * @see HlsTsFileMode
     */
    public final HlsTsFileMode tsFileMode() {
        return HlsTsFileMode.fromValue(tsFileMode);
    }

    /**
     * SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
     *
     * SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media manifest
     * includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when sending the
     * output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while the channel is
     * running is not guaranteed due to HTTP server caching.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tsFileMode} will
     * return {@link HlsTsFileMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tsFileModeAsString}.
     * </p>
     * 
     * @return SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
     *
     *         SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media
     *         manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is
     *         when sending the output to AWS Elemental MediaConvert, which can accept only a single media file.
     *         Playback while the channel is running is not guaranteed due to HTTP server caching.
     * @see HlsTsFileMode
     */
    public final String tsFileModeAsString() {
        return tsFileMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdMarkers() ? adMarkersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(baseUrlContent());
        hashCode = 31 * hashCode + Objects.hashCode(baseUrlContent1());
        hashCode = 31 * hashCode + Objects.hashCode(baseUrlManifest());
        hashCode = 31 * hashCode + Objects.hashCode(baseUrlManifest1());
        hashCode = 31 * hashCode + Objects.hashCode(hasCaptionLanguageMappings() ? captionLanguageMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(captionLanguageSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(constantIv());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(directoryStructureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(discontinuityTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hlsCdnSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsId3SegmentTaggingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iFrameOnlyPlaylistsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(incompleteSegmentBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indexNSegments());
        hashCode = 31 * hashCode + Objects.hashCode(inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ivInManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ivSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keepSegments());
        hashCode = 31 * hashCode + Objects.hashCode(keyFormat());
        hashCode = 31 * hashCode + Objects.hashCode(keyFormatVersions());
        hashCode = 31 * hashCode + Objects.hashCode(keyProviderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(redundantManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsPerSubdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(timestampDeltaMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(tsFileModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings) obj;
        return hasAdMarkers() == other.hasAdMarkers() && Objects.equals(adMarkersAsStrings(), other.adMarkersAsStrings())
                && Objects.equals(baseUrlContent(), other.baseUrlContent())
                && Objects.equals(baseUrlContent1(), other.baseUrlContent1())
                && Objects.equals(baseUrlManifest(), other.baseUrlManifest())
                && Objects.equals(baseUrlManifest1(), other.baseUrlManifest1())
                && hasCaptionLanguageMappings() == other.hasCaptionLanguageMappings()
                && Objects.equals(captionLanguageMappings(), other.captionLanguageMappings())
                && Objects.equals(captionLanguageSettingAsString(), other.captionLanguageSettingAsString())
                && Objects.equals(clientCacheAsString(), other.clientCacheAsString())
                && Objects.equals(codecSpecificationAsString(), other.codecSpecificationAsString())
                && Objects.equals(constantIv(), other.constantIv()) && Objects.equals(destination(), other.destination())
                && Objects.equals(directoryStructureAsString(), other.directoryStructureAsString())
                && Objects.equals(discontinuityTagsAsString(), other.discontinuityTagsAsString())
                && Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString())
                && Objects.equals(hlsCdnSettings(), other.hlsCdnSettings())
                && Objects.equals(hlsId3SegmentTaggingAsString(), other.hlsId3SegmentTaggingAsString())
                && Objects.equals(iFrameOnlyPlaylistsAsString(), other.iFrameOnlyPlaylistsAsString())
                && Objects.equals(incompleteSegmentBehaviorAsString(), other.incompleteSegmentBehaviorAsString())
                && Objects.equals(indexNSegments(), other.indexNSegments())
                && Objects.equals(inputLossActionAsString(), other.inputLossActionAsString())
                && Objects.equals(ivInManifestAsString(), other.ivInManifestAsString())
                && Objects.equals(ivSourceAsString(), other.ivSourceAsString())
                && Objects.equals(keepSegments(), other.keepSegments()) && Objects.equals(keyFormat(), other.keyFormat())
                && Objects.equals(keyFormatVersions(), other.keyFormatVersions())
                && Objects.equals(keyProviderSettings(), other.keyProviderSettings())
                && Objects.equals(manifestCompressionAsString(), other.manifestCompressionAsString())
                && Objects.equals(manifestDurationFormatAsString(), other.manifestDurationFormatAsString())
                && Objects.equals(minSegmentLength(), other.minSegmentLength())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(outputSelectionAsString(), other.outputSelectionAsString())
                && Objects.equals(programDateTimeAsString(), other.programDateTimeAsString())
                && Objects.equals(programDateTimePeriod(), other.programDateTimePeriod())
                && Objects.equals(redundantManifestAsString(), other.redundantManifestAsString())
                && Objects.equals(segmentLength(), other.segmentLength())
                && Objects.equals(segmentationModeAsString(), other.segmentationModeAsString())
                && Objects.equals(segmentsPerSubdirectory(), other.segmentsPerSubdirectory())
                && Objects.equals(streamInfResolutionAsString(), other.streamInfResolutionAsString())
                && Objects.equals(timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString())
                && Objects.equals(timedMetadataId3Period(), other.timedMetadataId3Period())
                && Objects.equals(timestampDeltaMilliseconds(), other.timestampDeltaMilliseconds())
                && Objects.equals(tsFileModeAsString(), other.tsFileModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsGroupSettings").add("AdMarkers", hasAdMarkers() ? adMarkersAsStrings() : null)
                .add("BaseUrlContent", baseUrlContent()).add("BaseUrlContent1", baseUrlContent1())
                .add("BaseUrlManifest", baseUrlManifest()).add("BaseUrlManifest1", baseUrlManifest1())
                .add("CaptionLanguageMappings", hasCaptionLanguageMappings() ? captionLanguageMappings() : null)
                .add("CaptionLanguageSetting", captionLanguageSettingAsString()).add("ClientCache", clientCacheAsString())
                .add("CodecSpecification", codecSpecificationAsString()).add("ConstantIv", constantIv())
                .add("Destination", destination()).add("DirectoryStructure", directoryStructureAsString())
                .add("DiscontinuityTags", discontinuityTagsAsString()).add("EncryptionType", encryptionTypeAsString())
                .add("HlsCdnSettings", hlsCdnSettings()).add("HlsId3SegmentTagging", hlsId3SegmentTaggingAsString())
                .add("IFrameOnlyPlaylists", iFrameOnlyPlaylistsAsString())
                .add("IncompleteSegmentBehavior", incompleteSegmentBehaviorAsString()).add("IndexNSegments", indexNSegments())
                .add("InputLossAction", inputLossActionAsString()).add("IvInManifest", ivInManifestAsString())
                .add("IvSource", ivSourceAsString()).add("KeepSegments", keepSegments()).add("KeyFormat", keyFormat())
                .add("KeyFormatVersions", keyFormatVersions()).add("KeyProviderSettings", keyProviderSettings())
                .add("ManifestCompression", manifestCompressionAsString())
                .add("ManifestDurationFormat", manifestDurationFormatAsString()).add("MinSegmentLength", minSegmentLength())
                .add("Mode", modeAsString()).add("OutputSelection", outputSelectionAsString())
                .add("ProgramDateTime", programDateTimeAsString()).add("ProgramDateTimePeriod", programDateTimePeriod())
                .add("RedundantManifest", redundantManifestAsString()).add("SegmentLength", segmentLength())
                .add("SegmentationMode", segmentationModeAsString()).add("SegmentsPerSubdirectory", segmentsPerSubdirectory())
                .add("StreamInfResolution", streamInfResolutionAsString())
                .add("TimedMetadataId3Frame", timedMetadataId3FrameAsString())
                .add("TimedMetadataId3Period", timedMetadataId3Period())
                .add("TimestampDeltaMilliseconds", timestampDeltaMilliseconds()).add("TsFileMode", tsFileModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkers":
            return Optional.ofNullable(clazz.cast(adMarkersAsStrings()));
        case "BaseUrlContent":
            return Optional.ofNullable(clazz.cast(baseUrlContent()));
        case "BaseUrlContent1":
            return Optional.ofNullable(clazz.cast(baseUrlContent1()));
        case "BaseUrlManifest":
            return Optional.ofNullable(clazz.cast(baseUrlManifest()));
        case "BaseUrlManifest1":
            return Optional.ofNullable(clazz.cast(baseUrlManifest1()));
        case "CaptionLanguageMappings":
            return Optional.ofNullable(clazz.cast(captionLanguageMappings()));
        case "CaptionLanguageSetting":
            return Optional.ofNullable(clazz.cast(captionLanguageSettingAsString()));
        case "ClientCache":
            return Optional.ofNullable(clazz.cast(clientCacheAsString()));
        case "CodecSpecification":
            return Optional.ofNullable(clazz.cast(codecSpecificationAsString()));
        case "ConstantIv":
            return Optional.ofNullable(clazz.cast(constantIv()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DirectoryStructure":
            return Optional.ofNullable(clazz.cast(directoryStructureAsString()));
        case "DiscontinuityTags":
            return Optional.ofNullable(clazz.cast(discontinuityTagsAsString()));
        case "EncryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        case "HlsCdnSettings":
            return Optional.ofNullable(clazz.cast(hlsCdnSettings()));
        case "HlsId3SegmentTagging":
            return Optional.ofNullable(clazz.cast(hlsId3SegmentTaggingAsString()));
        case "IFrameOnlyPlaylists":
            return Optional.ofNullable(clazz.cast(iFrameOnlyPlaylistsAsString()));
        case "IncompleteSegmentBehavior":
            return Optional.ofNullable(clazz.cast(incompleteSegmentBehaviorAsString()));
        case "IndexNSegments":
            return Optional.ofNullable(clazz.cast(indexNSegments()));
        case "InputLossAction":
            return Optional.ofNullable(clazz.cast(inputLossActionAsString()));
        case "IvInManifest":
            return Optional.ofNullable(clazz.cast(ivInManifestAsString()));
        case "IvSource":
            return Optional.ofNullable(clazz.cast(ivSourceAsString()));
        case "KeepSegments":
            return Optional.ofNullable(clazz.cast(keepSegments()));
        case "KeyFormat":
            return Optional.ofNullable(clazz.cast(keyFormat()));
        case "KeyFormatVersions":
            return Optional.ofNullable(clazz.cast(keyFormatVersions()));
        case "KeyProviderSettings":
            return Optional.ofNullable(clazz.cast(keyProviderSettings()));
        case "ManifestCompression":
            return Optional.ofNullable(clazz.cast(manifestCompressionAsString()));
        case "ManifestDurationFormat":
            return Optional.ofNullable(clazz.cast(manifestDurationFormatAsString()));
        case "MinSegmentLength":
            return Optional.ofNullable(clazz.cast(minSegmentLength()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "OutputSelection":
            return Optional.ofNullable(clazz.cast(outputSelectionAsString()));
        case "ProgramDateTime":
            return Optional.ofNullable(clazz.cast(programDateTimeAsString()));
        case "ProgramDateTimePeriod":
            return Optional.ofNullable(clazz.cast(programDateTimePeriod()));
        case "RedundantManifest":
            return Optional.ofNullable(clazz.cast(redundantManifestAsString()));
        case "SegmentLength":
            return Optional.ofNullable(clazz.cast(segmentLength()));
        case "SegmentationMode":
            return Optional.ofNullable(clazz.cast(segmentationModeAsString()));
        case "SegmentsPerSubdirectory":
            return Optional.ofNullable(clazz.cast(segmentsPerSubdirectory()));
        case "StreamInfResolution":
            return Optional.ofNullable(clazz.cast(streamInfResolutionAsString()));
        case "TimedMetadataId3Frame":
            return Optional.ofNullable(clazz.cast(timedMetadataId3FrameAsString()));
        case "TimedMetadataId3Period":
            return Optional.ofNullable(clazz.cast(timedMetadataId3Period()));
        case "TimestampDeltaMilliseconds":
            return Optional.ofNullable(clazz.cast(timestampDeltaMilliseconds()));
        case "TsFileMode":
            return Optional.ofNullable(clazz.cast(tsFileModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsGroupSettings, T> g) {
        return obj -> g.apply((HlsGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsGroupSettings> {
        /**
         * Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkersWithStrings(Collection<String> adMarkers);

        /**
         * Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkersWithStrings(String... adMarkers);

        /**
         * Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkers(Collection<HlsAdMarkers> adMarkers);

        /**
         * Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkers(HlsAdMarkers... adMarkers);

        /**
         * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base
         * manifest is delivered from a different URL than the main .m3u8 file.
         * 
         * @param baseUrlContent
         *        A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if
         *        base manifest is delivered from a different URL than the main .m3u8 file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrlContent(String baseUrlContent);

        /**
         * Optional. One value per output group.
         *
         * This field is required only if you are completing Base URL content A, and the downstream system has notified
         * you that the media files for pipeline 1 of all outputs are in a location different from the media files for
         * pipeline 0.
         * 
         * @param baseUrlContent1
         *        Optional. One value per output group.
         *
         *        This field is required only if you are completing Base URL content A, and the downstream system has
         *        notified you that the media files for pipeline 1 of all outputs are in a location different from the
         *        media files for pipeline 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrlContent1(String baseUrlContent1);

        /**
         * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base
         * manifest is delivered from a different URL than the main .m3u8 file.
         * 
         * @param baseUrlManifest
         *        A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if
         *        base manifest is delivered from a different URL than the main .m3u8 file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrlManifest(String baseUrlManifest);

        /**
         * Optional. One value per output group.
         *
         * Complete this field only if you are completing Base URL manifest A, and the downstream system has notified
         * you that the child manifest files for pipeline 1 of all outputs are in a location different from the child
         * manifest files for pipeline 0.
         * 
         * @param baseUrlManifest1
         *        Optional. One value per output group.
         *
         *        Complete this field only if you are completing Base URL manifest A, and the downstream system has
         *        notified you that the child manifest files for pipeline 1 of all outputs are in a location different
         *        from the child manifest files for pipeline 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrlManifest1(String baseUrlManifest1);

        /**
         * Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting is set
         * to "insert".
         * 
         * @param captionLanguageMappings
         *        Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting
         *        is set to "insert".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionLanguageMappings(Collection<CaptionLanguageMapping> captionLanguageMappings);

        /**
         * Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting is set
         * to "insert".
         * 
         * @param captionLanguageMappings
         *        Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting
         *        is set to "insert".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionLanguageMappings(CaptionLanguageMapping... captionLanguageMappings);

        /**
         * Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting is set
         * to "insert". This is a convenience that creates an instance of the {@link List
         * <CaptionLanguageMapping>.Builder} avoiding the need to create one manually via {@link List
         * <CaptionLanguageMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CaptionLanguageMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #captionLanguageMappings(List<CaptionLanguageMapping>)}.
         * 
         * @param captionLanguageMappings
         *        a consumer that will call methods on {@link List<CaptionLanguageMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captionLanguageMappings(List<CaptionLanguageMapping>)
         */
        Builder captionLanguageMappings(Consumer<CaptionLanguageMapping.Builder>... captionLanguageMappings);

        /**
         * Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest. Specify
         * at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code
         * you specify. Make sure to specify the languages in the order in which they appear in the original source (if
         * the source is embedded format) or the order of the caption selectors (if the source is other than embedded).
         * Otherwise, languages in the manifest will not match up properly with the output captions. none: Include
         * CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line from the manifest.
         * 
         * @param captionLanguageSetting
         *        Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest.
         *        Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for
         *        each Language Code you specify. Make sure to specify the languages in the order in which they appear
         *        in the original source (if the source is embedded format) or the order of the caption selectors (if
         *        the source is other than embedded). Otherwise, languages in the manifest will not match up properly
         *        with the output captions. none: Include CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any
         *        CLOSED-CAPTIONS line from the manifest.
         * @see HlsCaptionLanguageSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCaptionLanguageSetting
         */
        Builder captionLanguageSetting(String captionLanguageSetting);

        /**
         * Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest. Specify
         * at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code
         * you specify. Make sure to specify the languages in the order in which they appear in the original source (if
         * the source is embedded format) or the order of the caption selectors (if the source is other than embedded).
         * Otherwise, languages in the manifest will not match up properly with the output captions. none: Include
         * CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line from the manifest.
         * 
         * @param captionLanguageSetting
         *        Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS lines in the manifest.
         *        Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for
         *        each Language Code you specify. Make sure to specify the languages in the order in which they appear
         *        in the original source (if the source is embedded format) or the order of the caption selectors (if
         *        the source is other than embedded). Otherwise, languages in the manifest will not match up properly
         *        with the output captions. none: Include CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any
         *        CLOSED-CAPTIONS line from the manifest.
         * @see HlsCaptionLanguageSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCaptionLanguageSetting
         */
        Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting);

        /**
         * When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from
         * saving media segments for later replay.
         * 
         * @param clientCache
         *        When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients
         *        from saving media segments for later replay.
         * @see HlsClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsClientCache
         */
        Builder clientCache(String clientCache);

        /**
         * When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from
         * saving media segments for later replay.
         * 
         * @param clientCache
         *        When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients
         *        from saving media segments for later replay.
         * @see HlsClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsClientCache
         */
        Builder clientCache(HlsClientCache clientCache);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see HlsCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCodecSpecification
         */
        Builder codecSpecification(String codecSpecification);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see HlsCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCodecSpecification
         */
        Builder codecSpecification(HlsCodecSpecification codecSpecification);

        /**
         * For use with encryptionType. This is a 128-bit, 16-byte hex value represented by a 32-character text string.
         * If ivSource is set to "explicit" then this parameter is required and is used as the IV for encryption.
         * 
         * @param constantIv
         *        For use with encryptionType. This is a 128-bit, 16-byte hex value represented by a 32-character text
         *        string. If ivSource is set to "explicit" then this parameter is required and is used as the IV for
         *        encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constantIv(String constantIv);

        /**
         * A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled).
         * 
         * @param destination
         *        A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if
         *        enabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(OutputLocationRef destination);

        /**
         * A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled). This
         * is a convenience that creates an instance of the {@link OutputLocationRef.Builder} avoiding the need to
         * create one manually via {@link OutputLocationRef#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocationRef.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(OutputLocationRef)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link OutputLocationRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(OutputLocationRef)
         */
        default Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return destination(OutputLocationRef.builder().applyMutation(destination).build());
        }

        /**
         * Place segments in subdirectories.
         * 
         * @param directoryStructure
         *        Place segments in subdirectories.
         * @see HlsDirectoryStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDirectoryStructure
         */
        Builder directoryStructure(String directoryStructure);

        /**
         * Place segments in subdirectories.
         * 
         * @param directoryStructure
         *        Place segments in subdirectories.
         * @see HlsDirectoryStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDirectoryStructure
         */
        Builder directoryStructure(HlsDirectoryStructure directoryStructure);

        /**
         * Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group.
         * Typically, choose Insert because these tags are required in the manifest (according to the HLS specification)
         * and serve an important purpose. Choose Never Insert only if the downstream system is doing real-time failover
         * (without using the MediaLive automatic failover feature) and only if that downstream system has advised you
         * to exclude the tags.
         * 
         * @param discontinuityTags
         *        Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group.
         *        Typically, choose Insert because these tags are required in the manifest (according to the HLS
         *        specification) and serve an important purpose. Choose Never Insert only if the downstream system is
         *        doing real-time failover (without using the MediaLive automatic failover feature) and only if that
         *        downstream system has advised you to exclude the tags.
         * @see HlsDiscontinuityTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDiscontinuityTags
         */
        Builder discontinuityTags(String discontinuityTags);

        /**
         * Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group.
         * Typically, choose Insert because these tags are required in the manifest (according to the HLS specification)
         * and serve an important purpose. Choose Never Insert only if the downstream system is doing real-time failover
         * (without using the MediaLive automatic failover feature) and only if that downstream system has advised you
         * to exclude the tags.
         * 
         * @param discontinuityTags
         *        Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group.
         *        Typically, choose Insert because these tags are required in the manifest (according to the HLS
         *        specification) and serve an important purpose. Choose Never Insert only if the downstream system is
         *        doing real-time failover (without using the MediaLive automatic failover feature) and only if that
         *        downstream system has advised you to exclude the tags.
         * @see HlsDiscontinuityTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDiscontinuityTags
         */
        Builder discontinuityTags(HlsDiscontinuityTags discontinuityTags);

        /**
         * Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is desired.
         * 
         * @param encryptionType
         *        Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is
         *        desired.
         * @see HlsEncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsEncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is desired.
         * 
         * @param encryptionType
         *        Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is
         *        desired.
         * @see HlsEncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsEncryptionType
         */
        Builder encryptionType(HlsEncryptionType encryptionType);

        /**
         * Parameters that control interactions with the CDN.
         * 
         * @param hlsCdnSettings
         *        Parameters that control interactions with the CDN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsCdnSettings(HlsCdnSettings hlsCdnSettings);

        /**
         * Parameters that control interactions with the CDN. This is a convenience that creates an instance of the
         * {@link HlsCdnSettings.Builder} avoiding the need to create one manually via {@link HlsCdnSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsCdnSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsCdnSettings(HlsCdnSettings)}.
         * 
         * @param hlsCdnSettings
         *        a consumer that will call methods on {@link HlsCdnSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsCdnSettings(HlsCdnSettings)
         */
        default Builder hlsCdnSettings(Consumer<HlsCdnSettings.Builder> hlsCdnSettings) {
            return hlsCdnSettings(HlsCdnSettings.builder().applyMutation(hlsCdnSettings).build());
        }

        /**
         * State of HLS ID3 Segment Tagging
         * 
         * @param hlsId3SegmentTagging
         *        State of HLS ID3 Segment Tagging
         * @see HlsId3SegmentTaggingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsId3SegmentTaggingState
         */
        Builder hlsId3SegmentTagging(String hlsId3SegmentTagging);

        /**
         * State of HLS ID3 Segment Tagging
         * 
         * @param hlsId3SegmentTagging
         *        State of HLS ID3 Segment Tagging
         * @see HlsId3SegmentTaggingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsId3SegmentTaggingState
         */
        Builder hlsId3SegmentTagging(HlsId3SegmentTaggingState hlsId3SegmentTagging);

        /**
         * DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according to
         * the Output Selection field).
         *
         * STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests
         * (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to
         * indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For
         * example, #EXT-X-BYTERANGE:160364@1461888"
         * 
         * @param iFrameOnlyPlaylists
         *        DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests
         *        (according to the Output Selection field).
         *
         *        STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other
         *        manifests (according to the Output Selection field). The I-frame manifest contains a
         *        #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries
         *        identifying the I-frame position. For example, #EXT-X-BYTERANGE:160364@1461888"
         * @see IFrameOnlyPlaylistType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IFrameOnlyPlaylistType
         */
        Builder iFrameOnlyPlaylists(String iFrameOnlyPlaylists);

        /**
         * DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according to
         * the Output Selection field).
         *
         * STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests
         * (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to
         * indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For
         * example, #EXT-X-BYTERANGE:160364@1461888"
         * 
         * @param iFrameOnlyPlaylists
         *        DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests
         *        (according to the Output Selection field).
         *
         *        STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other
         *        manifests (according to the Output Selection field). The I-frame manifest contains a
         *        #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries
         *        identifying the I-frame position. For example, #EXT-X-BYTERANGE:160364@1461888"
         * @see IFrameOnlyPlaylistType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IFrameOnlyPlaylistType
         */
        Builder iFrameOnlyPlaylists(IFrameOnlyPlaylistType iFrameOnlyPlaylists);

        /**
         * Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops
         * producing output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto means
         * that MediaLive decides whether to include the final segment, depending on the channel class and the types of
         * output groups. Suppress means to never include the incomplete segment. We recommend you choose Auto and let
         * MediaLive control the behavior.
         * 
         * @param incompleteSegmentBehavior
         *        Specifies whether to include the final (incomplete) segment in the media output when the pipeline
         *        stops producing output because of a channel stop, a channel pause or a loss of input to the pipeline.
         *        Auto means that MediaLive decides whether to include the final segment, depending on the channel class
         *        and the types of output groups. Suppress means to never include the incomplete segment. We recommend
         *        you choose Auto and let MediaLive control the behavior.
         * @see HlsIncompleteSegmentBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsIncompleteSegmentBehavior
         */
        Builder incompleteSegmentBehavior(String incompleteSegmentBehavior);

        /**
         * Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops
         * producing output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto means
         * that MediaLive decides whether to include the final segment, depending on the channel class and the types of
         * output groups. Suppress means to never include the incomplete segment. We recommend you choose Auto and let
         * MediaLive control the behavior.
         * 
         * @param incompleteSegmentBehavior
         *        Specifies whether to include the final (incomplete) segment in the media output when the pipeline
         *        stops producing output because of a channel stop, a channel pause or a loss of input to the pipeline.
         *        Auto means that MediaLive decides whether to include the final segment, depending on the channel class
         *        and the types of output groups. Suppress means to never include the incomplete segment. We recommend
         *        you choose Auto and let MediaLive control the behavior.
         * @see HlsIncompleteSegmentBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsIncompleteSegmentBehavior
         */
        Builder incompleteSegmentBehavior(HlsIncompleteSegmentBehavior incompleteSegmentBehavior);

        /**
         * Applies only if Mode field is LIVE.
         *
         * Specifies the maximum number of segments in the media manifest file. After this maximum, older segments are
         * removed from the media manifest. This number must be smaller than the number in the Keep Segments field.
         * 
         * @param indexNSegments
         *        Applies only if Mode field is LIVE.
         *
         *        Specifies the maximum number of segments in the media manifest file. After this maximum, older
         *        segments are removed from the media manifest. This number must be smaller than the number in the Keep
         *        Segments field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexNSegments(Integer indexNSegments);

        /**
         * Parameter that control output group behavior on input loss.
         * 
         * @param inputLossAction
         *        Parameter that control output group behavior on input loss.
         * @see InputLossActionForHlsOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForHlsOut
         */
        Builder inputLossAction(String inputLossAction);

        /**
         * Parameter that control output group behavior on input loss.
         * 
         * @param inputLossAction
         *        Parameter that control output group behavior on input loss.
         * @see InputLossActionForHlsOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForHlsOut
         */
        Builder inputLossAction(InputLossActionForHlsOut inputLossAction);

        /**
         * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the
         * key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not in the
         * manifest.
         * 
         * @param ivInManifest
         *        For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction
         *        with the key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the
         *        IV is not in the manifest.
         * @see HlsIvInManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsIvInManifest
         */
        Builder ivInManifest(String ivInManifest);

        /**
         * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the
         * key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not in the
         * manifest.
         * 
         * @param ivInManifest
         *        For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction
         *        with the key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the
         *        IV is not in the manifest.
         * @see HlsIvInManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsIvInManifest
         */
        Builder ivInManifest(HlsIvInManifest ivInManifest);

        /**
         * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the
         * key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change every
         * segment (to match the segment number). If this is set to "explicit", you must enter a constantIv value.
         * 
         * @param ivSource
         *        For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction
         *        with the key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to
         *        change every segment (to match the segment number). If this is set to "explicit", you must enter a
         *        constantIv value.
         * @see HlsIvSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsIvSource
         */
        Builder ivSource(String ivSource);

        /**
         * For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the
         * key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change every
         * segment (to match the segment number). If this is set to "explicit", you must enter a constantIv value.
         * 
         * @param ivSource
         *        For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction
         *        with the key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to
         *        change every segment (to match the segment number). If this is set to "explicit", you must enter a
         *        constantIv value.
         * @see HlsIvSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsIvSource
         */
        Builder ivSource(HlsIvSource ivSource);

        /**
         * Applies only if Mode field is LIVE.
         *
         * Specifies the number of media segments to retain in the destination directory. This number should be bigger
         * than indexNSegments (Num segments). We recommend (value = (2 x indexNsegments) + 1).
         *
         * If this "keep segments" number is too low, the following might happen: the player is still reading a media
         * manifest file that lists this segment, but that segment has been removed from the destination directory (as
         * directed by indexNSegments). This situation would result in a 404 HTTP error on the player.
         * 
         * @param keepSegments
         *        Applies only if Mode field is LIVE.
         *
         *        Specifies the number of media segments to retain in the destination directory. This number should be
         *        bigger than indexNSegments (Num segments). We recommend (value = (2 x indexNsegments) + 1).
         *
         *        If this "keep segments" number is too low, the following might happen: the player is still reading a
         *        media manifest file that lists this segment, but that segment has been removed from the destination
         *        directory (as directed by indexNSegments). This situation would result in a 404 HTTP error on the
         *        player.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keepSegments(Integer keepSegments);

        /**
         * The value specifies how the key is represented in the resource identified by the URI. If parameter is absent,
         * an implicit value of "identity" is used. A reverse DNS string can also be given.
         * 
         * @param keyFormat
         *        The value specifies how the key is represented in the resource identified by the URI. If parameter is
         *        absent, an implicit value of "identity" is used. A reverse DNS string can also be given.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFormat(String keyFormat);

        /**
         * Either a single positive integer version value or a slash delimited list of version values (1/2/3).
         * 
         * @param keyFormatVersions
         *        Either a single positive integer version value or a slash delimited list of version values (1/2/3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFormatVersions(String keyFormatVersions);

        /**
         * The key provider settings.
         * 
         * @param keyProviderSettings
         *        The key provider settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyProviderSettings(KeyProviderSettings keyProviderSettings);

        /**
         * The key provider settings. This is a convenience that creates an instance of the
         * {@link KeyProviderSettings.Builder} avoiding the need to create one manually via
         * {@link KeyProviderSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyProviderSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #keyProviderSettings(KeyProviderSettings)}.
         * 
         * @param keyProviderSettings
         *        a consumer that will call methods on {@link KeyProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyProviderSettings(KeyProviderSettings)
         */
        default Builder keyProviderSettings(Consumer<KeyProviderSettings.Builder> keyProviderSettings) {
            return keyProviderSettings(KeyProviderSettings.builder().applyMutation(keyProviderSettings).build());
        }

        /**
         * When set to gzip, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to gzip, compresses HLS playlist.
         * @see HlsManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestCompression
         */
        Builder manifestCompression(String manifestCompression);

        /**
         * When set to gzip, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to gzip, compresses HLS playlist.
         * @see HlsManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestCompression
         */
        Builder manifestCompression(HlsManifestCompression manifestCompression);

        /**
         * Indicates whether the output manifest should use floating point or integer values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point or integer values for segment
         *        duration.
         * @see HlsManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestDurationFormat
         */
        Builder manifestDurationFormat(String manifestDurationFormat);

        /**
         * Indicates whether the output manifest should use floating point or integer values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point or integer values for segment
         *        duration.
         * @see HlsManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestDurationFormat
         */
        Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat);

        /**
         * When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a nearby
         * avail and extending the segment size if needed.
         * 
         * @param minSegmentLength
         *        When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a
         *        nearby avail and extending the segment size if needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSegmentLength(Integer minSegmentLength);

        /**
         * If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only the
         * number segments specified in keepSegments and indexNSegments are kept; newer segments replace older segments,
         * which may prevent players from rewinding all the way to the beginning of the event.
         *
         * VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type
         * manifest on completion of the stream.
         * 
         * @param mode
         *        If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live",
         *        only the number segments specified in keepSegments and indexNSegments are kept; newer segments replace
         *        older segments, which may prevent players from rewinding all the way to the beginning of the event.
         *
         *        VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD"
         *        type manifest on completion of the stream.
         * @see HlsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsMode
         */
        Builder mode(String mode);

        /**
         * If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only the
         * number segments specified in keepSegments and indexNSegments are kept; newer segments replace older segments,
         * which may prevent players from rewinding all the way to the beginning of the event.
         *
         * VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type
         * manifest on completion of the stream.
         * 
         * @param mode
         *        If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live",
         *        only the number segments specified in keepSegments and indexNSegments are kept; newer segments replace
         *        older segments, which may prevent players from rewinding all the way to the beginning of the event.
         *
         *        VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD"
         *        type manifest on completion of the stream.
         * @see HlsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsMode
         */
        Builder mode(HlsMode mode);

        /**
         * MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for this
         * output group.
         *
         * VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master manifest.
         *
         * SEGMENTS_ONLY: Does not generate any manifests for this output group.
         * 
         * @param outputSelection
         *        MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for
         *        this output group.
         *
         *        VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master
         *        manifest.
         *
         *        SEGMENTS_ONLY: Does not generate any manifests for this output group.
         * @see HlsOutputSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsOutputSelection
         */
        Builder outputSelection(String outputSelection);

        /**
         * MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for this
         * output group.
         *
         * VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master manifest.
         *
         * SEGMENTS_ONLY: Does not generate any manifests for this output group.
         * 
         * @param outputSelection
         *        MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for
         *        this output group.
         *
         *        VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master
         *        manifest.
         *
         *        SEGMENTS_ONLY: Does not generate any manifests for this output group.
         * @see HlsOutputSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsOutputSelection
         */
        Builder outputSelection(HlsOutputSelection outputSelection);

        /**
         * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
         * either the program date and time are initialized using the input timecode source, or the time is initialized
         * using the input timecode source and the date is initialized using the timestampOffset.
         * 
         * @param programDateTime
         *        Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
         *        follows: either the program date and time are initialized using the input timecode source, or the time
         *        is initialized using the input timecode source and the date is initialized using the timestampOffset.
         * @see HlsProgramDateTime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsProgramDateTime
         */
        Builder programDateTime(String programDateTime);

        /**
         * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
         * either the program date and time are initialized using the input timecode source, or the time is initialized
         * using the input timecode source and the date is initialized using the timestampOffset.
         * 
         * @param programDateTime
         *        Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
         *        follows: either the program date and time are initialized using the input timecode source, or the time
         *        is initialized using the input timecode source and the date is initialized using the timestampOffset.
         * @see HlsProgramDateTime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsProgramDateTime
         */
        Builder programDateTime(HlsProgramDateTime programDateTime);

        /**
         * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
         * 
         * @param programDateTimePeriod
         *        Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimePeriod(Integer programDateTimePeriod);

        /**
         * ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first
         * its own media files, then the media files of the other pipeline. This feature allows playout device that
         * support stale manifest detection to switch from one manifest to the other, when the current manifest seems to
         * be stale. There are still two destinations and two master manifests, but both master manifests reference the
         * media files from both pipelines.
         *
         * DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline
         * only.
         *
         * For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed.
         * MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is
         * irrelevant.
         * 
         * @param redundantManifest
         *        ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines:
         *        first its own media files, then the media files of the other pipeline. This feature allows playout
         *        device that support stale manifest detection to switch from one manifest to the other, when the
         *        current manifest seems to be stale. There are still two destinations and two master manifests, but
         *        both master manifests reference the media files from both pipelines.
         *
         *        DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own
         *        pipeline only.
         *
         *        For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always
         *        followed. MediaPackage regenerates the manifests it serves to players so a redundant manifest from
         *        MediaLive is irrelevant.
         * @see HlsRedundantManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsRedundantManifest
         */
        Builder redundantManifest(String redundantManifest);

        /**
         * ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first
         * its own media files, then the media files of the other pipeline. This feature allows playout device that
         * support stale manifest detection to switch from one manifest to the other, when the current manifest seems to
         * be stale. There are still two destinations and two master manifests, but both master manifests reference the
         * media files from both pipelines.
         *
         * DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline
         * only.
         *
         * For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed.
         * MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is
         * irrelevant.
         * 
         * @param redundantManifest
         *        ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines:
         *        first its own media files, then the media files of the other pipeline. This feature allows playout
         *        device that support stale manifest detection to switch from one manifest to the other, when the
         *        current manifest seems to be stale. There are still two destinations and two master manifests, but
         *        both master manifests reference the media files from both pipelines.
         *
         *        DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own
         *        pipeline only.
         *
         *        For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always
         *        followed. MediaPackage regenerates the manifests it serves to players so a redundant manifest from
         *        MediaLive is irrelevant.
         * @see HlsRedundantManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsRedundantManifest
         */
        Builder redundantManifest(HlsRedundantManifest redundantManifest);

        /**
         * Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the next
         * keyframe after this number of seconds, so actual segment length may be longer.
         * 
         * @param segmentLength
         *        Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the
         *        next keyframe after this number of seconds, so actual segment length may be longer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentLength(Integer segmentLength);

        /**
         * useInputSegmentation has been deprecated. The configured segment size is always used.
         * 
         * @param segmentationMode
         *        useInputSegmentation has been deprecated. The configured segment size is always used.
         * @see HlsSegmentationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsSegmentationMode
         */
        Builder segmentationMode(String segmentationMode);

        /**
         * useInputSegmentation has been deprecated. The configured segment size is always used.
         * 
         * @param segmentationMode
         *        useInputSegmentation has been deprecated. The configured segment size is always used.
         * @see HlsSegmentationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsSegmentationMode
         */
        Builder segmentationMode(HlsSegmentationMode segmentationMode);

        /**
         * Number of segments to write to a subdirectory before starting a new one. directoryStructure must be
         * subdirectoryPerStream for this setting to have an effect.
         * 
         * @param segmentsPerSubdirectory
         *        Number of segments to write to a subdirectory before starting a new one. directoryStructure must be
         *        subdirectoryPerStream for this setting to have an effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see HlsStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsStreamInfResolution
         */
        Builder streamInfResolution(String streamInfResolution);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see HlsStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsStreamInfResolution
         */
        Builder streamInfResolution(HlsStreamInfResolution streamInfResolution);

        /**
         * Indicates ID3 frame that has the timecode.
         * 
         * @param timedMetadataId3Frame
         *        Indicates ID3 frame that has the timecode.
         * @see HlsTimedMetadataId3Frame
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTimedMetadataId3Frame
         */
        Builder timedMetadataId3Frame(String timedMetadataId3Frame);

        /**
         * Indicates ID3 frame that has the timecode.
         * 
         * @param timedMetadataId3Frame
         *        Indicates ID3 frame that has the timecode.
         * @see HlsTimedMetadataId3Frame
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTimedMetadataId3Frame
         */
        Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame);

        /**
         * Timed Metadata interval in seconds.
         * 
         * @param timedMetadataId3Period
         *        Timed Metadata interval in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataId3Period(Integer timedMetadataId3Period);

        /**
         * Provides an extra millisecond delta offset to fine tune the timestamps.
         * 
         * @param timestampDeltaMilliseconds
         *        Provides an extra millisecond delta offset to fine tune the timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds);

        /**
         * SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
         *
         * SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media
         * manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when
         * sending the output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while
         * the channel is running is not guaranteed due to HTTP server caching.
         * 
         * @param tsFileMode
         *        SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
         *
         *        SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media
         *        manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value
         *        is when sending the output to AWS Elemental MediaConvert, which can accept only a single media file.
         *        Playback while the channel is running is not guaranteed due to HTTP server caching.
         * @see HlsTsFileMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTsFileMode
         */
        Builder tsFileMode(String tsFileMode);

        /**
         * SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
         *
         * SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media
         * manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when
         * sending the output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while
         * the channel is running is not guaranteed due to HTTP server caching.
         * 
         * @param tsFileMode
         *        SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
         *
         *        SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media
         *        manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value
         *        is when sending the output to AWS Elemental MediaConvert, which can accept only a single media file.
         *        Playback while the channel is running is not guaranteed due to HTTP server caching.
         * @see HlsTsFileMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTsFileMode
         */
        Builder tsFileMode(HlsTsFileMode tsFileMode);
    }

    static final class BuilderImpl implements Builder {
        private List<String> adMarkers = DefaultSdkAutoConstructList.getInstance();

        private String baseUrlContent;

        private String baseUrlContent1;

        private String baseUrlManifest;

        private String baseUrlManifest1;

        private List<CaptionLanguageMapping> captionLanguageMappings = DefaultSdkAutoConstructList.getInstance();

        private String captionLanguageSetting;

        private String clientCache;

        private String codecSpecification;

        private String constantIv;

        private OutputLocationRef destination;

        private String directoryStructure;

        private String discontinuityTags;

        private String encryptionType;

        private HlsCdnSettings hlsCdnSettings;

        private String hlsId3SegmentTagging;

        private String iFrameOnlyPlaylists;

        private String incompleteSegmentBehavior;

        private Integer indexNSegments;

        private String inputLossAction;

        private String ivInManifest;

        private String ivSource;

        private Integer keepSegments;

        private String keyFormat;

        private String keyFormatVersions;

        private KeyProviderSettings keyProviderSettings;

        private String manifestCompression;

        private String manifestDurationFormat;

        private Integer minSegmentLength;

        private String mode;

        private String outputSelection;

        private String programDateTime;

        private Integer programDateTimePeriod;

        private String redundantManifest;

        private Integer segmentLength;

        private String segmentationMode;

        private Integer segmentsPerSubdirectory;

        private String streamInfResolution;

        private String timedMetadataId3Frame;

        private Integer timedMetadataId3Period;

        private Integer timestampDeltaMilliseconds;

        private String tsFileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsGroupSettings model) {
            adMarkersWithStrings(model.adMarkers);
            baseUrlContent(model.baseUrlContent);
            baseUrlContent1(model.baseUrlContent1);
            baseUrlManifest(model.baseUrlManifest);
            baseUrlManifest1(model.baseUrlManifest1);
            captionLanguageMappings(model.captionLanguageMappings);
            captionLanguageSetting(model.captionLanguageSetting);
            clientCache(model.clientCache);
            codecSpecification(model.codecSpecification);
            constantIv(model.constantIv);
            destination(model.destination);
            directoryStructure(model.directoryStructure);
            discontinuityTags(model.discontinuityTags);
            encryptionType(model.encryptionType);
            hlsCdnSettings(model.hlsCdnSettings);
            hlsId3SegmentTagging(model.hlsId3SegmentTagging);
            iFrameOnlyPlaylists(model.iFrameOnlyPlaylists);
            incompleteSegmentBehavior(model.incompleteSegmentBehavior);
            indexNSegments(model.indexNSegments);
            inputLossAction(model.inputLossAction);
            ivInManifest(model.ivInManifest);
            ivSource(model.ivSource);
            keepSegments(model.keepSegments);
            keyFormat(model.keyFormat);
            keyFormatVersions(model.keyFormatVersions);
            keyProviderSettings(model.keyProviderSettings);
            manifestCompression(model.manifestCompression);
            manifestDurationFormat(model.manifestDurationFormat);
            minSegmentLength(model.minSegmentLength);
            mode(model.mode);
            outputSelection(model.outputSelection);
            programDateTime(model.programDateTime);
            programDateTimePeriod(model.programDateTimePeriod);
            redundantManifest(model.redundantManifest);
            segmentLength(model.segmentLength);
            segmentationMode(model.segmentationMode);
            segmentsPerSubdirectory(model.segmentsPerSubdirectory);
            streamInfResolution(model.streamInfResolution);
            timedMetadataId3Frame(model.timedMetadataId3Frame);
            timedMetadataId3Period(model.timedMetadataId3Period);
            timestampDeltaMilliseconds(model.timestampDeltaMilliseconds);
            tsFileMode(model.tsFileMode);
        }

        public final Collection<String> getAdMarkers() {
            if (adMarkers instanceof SdkAutoConstructList) {
                return null;
            }
            return adMarkers;
        }

        @Override
        public final Builder adMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkersWithStrings(String... adMarkers) {
            adMarkersWithStrings(Arrays.asList(adMarkers));
            return this;
        }

        @Override
        public final Builder adMarkers(Collection<HlsAdMarkers> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copyEnumToString(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkers(HlsAdMarkers... adMarkers) {
            adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
        }

        public final String getBaseUrlContent() {
            return baseUrlContent;
        }

        @Override
        public final Builder baseUrlContent(String baseUrlContent) {
            this.baseUrlContent = baseUrlContent;
            return this;
        }

        public final void setBaseUrlContent(String baseUrlContent) {
            this.baseUrlContent = baseUrlContent;
        }

        public final String getBaseUrlContent1() {
            return baseUrlContent1;
        }

        @Override
        public final Builder baseUrlContent1(String baseUrlContent1) {
            this.baseUrlContent1 = baseUrlContent1;
            return this;
        }

        public final void setBaseUrlContent1(String baseUrlContent1) {
            this.baseUrlContent1 = baseUrlContent1;
        }

        public final String getBaseUrlManifest() {
            return baseUrlManifest;
        }

        @Override
        public final Builder baseUrlManifest(String baseUrlManifest) {
            this.baseUrlManifest = baseUrlManifest;
            return this;
        }

        public final void setBaseUrlManifest(String baseUrlManifest) {
            this.baseUrlManifest = baseUrlManifest;
        }

        public final String getBaseUrlManifest1() {
            return baseUrlManifest1;
        }

        @Override
        public final Builder baseUrlManifest1(String baseUrlManifest1) {
            this.baseUrlManifest1 = baseUrlManifest1;
            return this;
        }

        public final void setBaseUrlManifest1(String baseUrlManifest1) {
            this.baseUrlManifest1 = baseUrlManifest1;
        }

        public final List<CaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            List<CaptionLanguageMapping.Builder> result = ___listOfCaptionLanguageMappingCopier
                    .copyToBuilder(this.captionLanguageMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder captionLanguageMappings(Collection<CaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(CaptionLanguageMapping... captionLanguageMappings) {
            captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(Consumer<CaptionLanguageMapping.Builder>... captionLanguageMappings) {
            captionLanguageMappings(Stream.of(captionLanguageMappings)
                    .map(c -> CaptionLanguageMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionLanguageMappings(Collection<CaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        public final String getCaptionLanguageSetting() {
            return captionLanguageSetting;
        }

        @Override
        public final Builder captionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
            return this;
        }

        @Override
        public final Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
            this.captionLanguageSetting(captionLanguageSetting == null ? null : captionLanguageSetting.toString());
            return this;
        }

        public final void setCaptionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
        }

        public final String getClientCache() {
            return clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(HlsClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecification() {
            return codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(HlsCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getConstantIv() {
            return constantIv;
        }

        @Override
        public final Builder constantIv(String constantIv) {
            this.constantIv = constantIv;
            return this;
        }

        public final void setConstantIv(String constantIv) {
            this.constantIv = constantIv;
        }

        public final OutputLocationRef.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getDirectoryStructure() {
            return directoryStructure;
        }

        @Override
        public final Builder directoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
            return this;
        }

        @Override
        public final Builder directoryStructure(HlsDirectoryStructure directoryStructure) {
            this.directoryStructure(directoryStructure == null ? null : directoryStructure.toString());
            return this;
        }

        public final void setDirectoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
        }

        public final String getDiscontinuityTags() {
            return discontinuityTags;
        }

        @Override
        public final Builder discontinuityTags(String discontinuityTags) {
            this.discontinuityTags = discontinuityTags;
            return this;
        }

        @Override
        public final Builder discontinuityTags(HlsDiscontinuityTags discontinuityTags) {
            this.discontinuityTags(discontinuityTags == null ? null : discontinuityTags.toString());
            return this;
        }

        public final void setDiscontinuityTags(String discontinuityTags) {
            this.discontinuityTags = discontinuityTags;
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(HlsEncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final HlsCdnSettings.Builder getHlsCdnSettings() {
            return hlsCdnSettings != null ? hlsCdnSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsCdnSettings(HlsCdnSettings hlsCdnSettings) {
            this.hlsCdnSettings = hlsCdnSettings;
            return this;
        }

        public final void setHlsCdnSettings(HlsCdnSettings.BuilderImpl hlsCdnSettings) {
            this.hlsCdnSettings = hlsCdnSettings != null ? hlsCdnSettings.build() : null;
        }

        public final String getHlsId3SegmentTagging() {
            return hlsId3SegmentTagging;
        }

        @Override
        public final Builder hlsId3SegmentTagging(String hlsId3SegmentTagging) {
            this.hlsId3SegmentTagging = hlsId3SegmentTagging;
            return this;
        }

        @Override
        public final Builder hlsId3SegmentTagging(HlsId3SegmentTaggingState hlsId3SegmentTagging) {
            this.hlsId3SegmentTagging(hlsId3SegmentTagging == null ? null : hlsId3SegmentTagging.toString());
            return this;
        }

        public final void setHlsId3SegmentTagging(String hlsId3SegmentTagging) {
            this.hlsId3SegmentTagging = hlsId3SegmentTagging;
        }

        public final String getIFrameOnlyPlaylists() {
            return iFrameOnlyPlaylists;
        }

        @Override
        public final Builder iFrameOnlyPlaylists(String iFrameOnlyPlaylists) {
            this.iFrameOnlyPlaylists = iFrameOnlyPlaylists;
            return this;
        }

        @Override
        public final Builder iFrameOnlyPlaylists(IFrameOnlyPlaylistType iFrameOnlyPlaylists) {
            this.iFrameOnlyPlaylists(iFrameOnlyPlaylists == null ? null : iFrameOnlyPlaylists.toString());
            return this;
        }

        public final void setIFrameOnlyPlaylists(String iFrameOnlyPlaylists) {
            this.iFrameOnlyPlaylists = iFrameOnlyPlaylists;
        }

        public final String getIncompleteSegmentBehavior() {
            return incompleteSegmentBehavior;
        }

        @Override
        public final Builder incompleteSegmentBehavior(String incompleteSegmentBehavior) {
            this.incompleteSegmentBehavior = incompleteSegmentBehavior;
            return this;
        }

        @Override
        public final Builder incompleteSegmentBehavior(HlsIncompleteSegmentBehavior incompleteSegmentBehavior) {
            this.incompleteSegmentBehavior(incompleteSegmentBehavior == null ? null : incompleteSegmentBehavior.toString());
            return this;
        }

        public final void setIncompleteSegmentBehavior(String incompleteSegmentBehavior) {
            this.incompleteSegmentBehavior = incompleteSegmentBehavior;
        }

        public final Integer getIndexNSegments() {
            return indexNSegments;
        }

        @Override
        public final Builder indexNSegments(Integer indexNSegments) {
            this.indexNSegments = indexNSegments;
            return this;
        }

        public final void setIndexNSegments(Integer indexNSegments) {
            this.indexNSegments = indexNSegments;
        }

        public final String getInputLossAction() {
            return inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForHlsOut inputLossAction) {
            this.inputLossAction(inputLossAction == null ? null : inputLossAction.toString());
            return this;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        public final String getIvInManifest() {
            return ivInManifest;
        }

        @Override
        public final Builder ivInManifest(String ivInManifest) {
            this.ivInManifest = ivInManifest;
            return this;
        }

        @Override
        public final Builder ivInManifest(HlsIvInManifest ivInManifest) {
            this.ivInManifest(ivInManifest == null ? null : ivInManifest.toString());
            return this;
        }

        public final void setIvInManifest(String ivInManifest) {
            this.ivInManifest = ivInManifest;
        }

        public final String getIvSource() {
            return ivSource;
        }

        @Override
        public final Builder ivSource(String ivSource) {
            this.ivSource = ivSource;
            return this;
        }

        @Override
        public final Builder ivSource(HlsIvSource ivSource) {
            this.ivSource(ivSource == null ? null : ivSource.toString());
            return this;
        }

        public final void setIvSource(String ivSource) {
            this.ivSource = ivSource;
        }

        public final Integer getKeepSegments() {
            return keepSegments;
        }

        @Override
        public final Builder keepSegments(Integer keepSegments) {
            this.keepSegments = keepSegments;
            return this;
        }

        public final void setKeepSegments(Integer keepSegments) {
            this.keepSegments = keepSegments;
        }

        public final String getKeyFormat() {
            return keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        public final String getKeyFormatVersions() {
            return keyFormatVersions;
        }

        @Override
        public final Builder keyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
            return this;
        }

        public final void setKeyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
        }

        public final KeyProviderSettings.Builder getKeyProviderSettings() {
            return keyProviderSettings != null ? keyProviderSettings.toBuilder() : null;
        }

        @Override
        public final Builder keyProviderSettings(KeyProviderSettings keyProviderSettings) {
            this.keyProviderSettings = keyProviderSettings;
            return this;
        }

        public final void setKeyProviderSettings(KeyProviderSettings.BuilderImpl keyProviderSettings) {
            this.keyProviderSettings = keyProviderSettings != null ? keyProviderSettings.build() : null;
        }

        public final String getManifestCompression() {
            return manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(HlsManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormat() {
            return manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Integer getMinSegmentLength() {
            return minSegmentLength;
        }

        @Override
        public final Builder minSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
            return this;
        }

        public final void setMinSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(HlsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getOutputSelection() {
            return outputSelection;
        }

        @Override
        public final Builder outputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
            return this;
        }

        @Override
        public final Builder outputSelection(HlsOutputSelection outputSelection) {
            this.outputSelection(outputSelection == null ? null : outputSelection.toString());
            return this;
        }

        public final void setOutputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
        }

        public final String getProgramDateTime() {
            return programDateTime;
        }

        @Override
        public final Builder programDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
            return this;
        }

        @Override
        public final Builder programDateTime(HlsProgramDateTime programDateTime) {
            this.programDateTime(programDateTime == null ? null : programDateTime.toString());
            return this;
        }

        public final void setProgramDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
        }

        public final Integer getProgramDateTimePeriod() {
            return programDateTimePeriod;
        }

        @Override
        public final Builder programDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
            return this;
        }

        public final void setProgramDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
        }

        public final String getRedundantManifest() {
            return redundantManifest;
        }

        @Override
        public final Builder redundantManifest(String redundantManifest) {
            this.redundantManifest = redundantManifest;
            return this;
        }

        @Override
        public final Builder redundantManifest(HlsRedundantManifest redundantManifest) {
            this.redundantManifest(redundantManifest == null ? null : redundantManifest.toString());
            return this;
        }

        public final void setRedundantManifest(String redundantManifest) {
            this.redundantManifest = redundantManifest;
        }

        public final Integer getSegmentLength() {
            return segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final String getSegmentationMode() {
            return segmentationMode;
        }

        @Override
        public final Builder segmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
            return this;
        }

        @Override
        public final Builder segmentationMode(HlsSegmentationMode segmentationMode) {
            this.segmentationMode(segmentationMode == null ? null : segmentationMode.toString());
            return this;
        }

        public final void setSegmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
        }

        public final Integer getSegmentsPerSubdirectory() {
            return segmentsPerSubdirectory;
        }

        @Override
        public final Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
            return this;
        }

        public final void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
        }

        public final String getStreamInfResolution() {
            return streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(HlsStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getTimedMetadataId3Frame() {
            return timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame == null ? null : timedMetadataId3Frame.toString());
            return this;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        public final Integer getTimedMetadataId3Period() {
            return timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        public final Integer getTimestampDeltaMilliseconds() {
            return timestampDeltaMilliseconds;
        }

        @Override
        public final Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
            return this;
        }

        public final void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
        }

        public final String getTsFileMode() {
            return tsFileMode;
        }

        @Override
        public final Builder tsFileMode(String tsFileMode) {
            this.tsFileMode = tsFileMode;
            return this;
        }

        @Override
        public final Builder tsFileMode(HlsTsFileMode tsFileMode) {
            this.tsFileMode(tsFileMode == null ? null : tsFileMode.toString());
            return this;
        }

        public final void setTsFileMode(String tsFileMode) {
            this.tsFileMode = tsFileMode;
        }

        @Override
        public HlsGroupSettings build() {
            return new HlsGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
