/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The network settings for the input device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceNetworkSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceNetworkSettings.Builder, InputDeviceNetworkSettings> {
    private static final SdkField<List<String>> DNS_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsAddresses")
            .getter(getter(InputDeviceNetworkSettings::dnsAddresses))
            .setter(setter(Builder::dnsAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GATEWAY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Gateway")
            .getter(getter(InputDeviceNetworkSettings::gateway)).setter(setter(Builder::gateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gateway").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(InputDeviceNetworkSettings::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> IP_SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpScheme").getter(getter(InputDeviceNetworkSettings::ipSchemeAsString))
            .setter(setter(Builder::ipScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipScheme").build()).build();

    private static final SdkField<String> SUBNET_MASK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetMask").getter(getter(InputDeviceNetworkSettings::subnetMask)).setter(setter(Builder::subnetMask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetMask").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_ADDRESSES_FIELD,
            GATEWAY_FIELD, IP_ADDRESS_FIELD, IP_SCHEME_FIELD, SUBNET_MASK_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> dnsAddresses;

    private final String gateway;

    private final String ipAddress;

    private final String ipScheme;

    private final String subnetMask;

    private InputDeviceNetworkSettings(BuilderImpl builder) {
        this.dnsAddresses = builder.dnsAddresses;
        this.gateway = builder.gateway;
        this.ipAddress = builder.ipAddress;
        this.ipScheme = builder.ipScheme;
        this.subnetMask = builder.subnetMask;
    }

    /**
     * Returns true if the DnsAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDnsAddresses() {
        return dnsAddresses != null && !(dnsAddresses instanceof SdkAutoConstructList);
    }

    /**
     * The DNS addresses of the input device.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDnsAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The DNS addresses of the input device.
     */
    public final List<String> dnsAddresses() {
        return dnsAddresses;
    }

    /**
     * The network gateway IP address.
     * 
     * @return The network gateway IP address.
     */
    public final String gateway() {
        return gateway;
    }

    /**
     * The IP address of the input device.
     * 
     * @return The IP address of the input device.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address
     * assignment (DHCP) or a static IP address.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipScheme} will
     * return {@link InputDeviceIpScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipSchemeAsString}.
     * </p>
     * 
     * @return Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address
     *         assignment (DHCP) or a static IP address.
     * @see InputDeviceIpScheme
     */
    public final InputDeviceIpScheme ipScheme() {
        return InputDeviceIpScheme.fromValue(ipScheme);
    }

    /**
     * Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address
     * assignment (DHCP) or a static IP address.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipScheme} will
     * return {@link InputDeviceIpScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipSchemeAsString}.
     * </p>
     * 
     * @return Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address
     *         assignment (DHCP) or a static IP address.
     * @see InputDeviceIpScheme
     */
    public final String ipSchemeAsString() {
        return ipScheme;
    }

    /**
     * The subnet mask of the input device.
     * 
     * @return The subnet mask of the input device.
     */
    public final String subnetMask() {
        return subnetMask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsAddresses() ? dnsAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gateway());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ipSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetMask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceNetworkSettings)) {
            return false;
        }
        InputDeviceNetworkSettings other = (InputDeviceNetworkSettings) obj;
        return hasDnsAddresses() == other.hasDnsAddresses() && Objects.equals(dnsAddresses(), other.dnsAddresses())
                && Objects.equals(gateway(), other.gateway()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(ipSchemeAsString(), other.ipSchemeAsString())
                && Objects.equals(subnetMask(), other.subnetMask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceNetworkSettings").add("DnsAddresses", hasDnsAddresses() ? dnsAddresses() : null)
                .add("Gateway", gateway()).add("IpAddress", ipAddress()).add("IpScheme", ipSchemeAsString())
                .add("SubnetMask", subnetMask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsAddresses":
            return Optional.ofNullable(clazz.cast(dnsAddresses()));
        case "Gateway":
            return Optional.ofNullable(clazz.cast(gateway()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "IpScheme":
            return Optional.ofNullable(clazz.cast(ipSchemeAsString()));
        case "SubnetMask":
            return Optional.ofNullable(clazz.cast(subnetMask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceNetworkSettings, T> g) {
        return obj -> g.apply((InputDeviceNetworkSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceNetworkSettings> {
        /**
         * The DNS addresses of the input device.
         * 
         * @param dnsAddresses
         *        The DNS addresses of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsAddresses(Collection<String> dnsAddresses);

        /**
         * The DNS addresses of the input device.
         * 
         * @param dnsAddresses
         *        The DNS addresses of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsAddresses(String... dnsAddresses);

        /**
         * The network gateway IP address.
         * 
         * @param gateway
         *        The network gateway IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateway(String gateway);

        /**
         * The IP address of the input device.
         * 
         * @param ipAddress
         *        The IP address of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address
         * assignment (DHCP) or a static IP address.
         * 
         * @param ipScheme
         *        Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP
         *        address assignment (DHCP) or a static IP address.
         * @see InputDeviceIpScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceIpScheme
         */
        Builder ipScheme(String ipScheme);

        /**
         * Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address
         * assignment (DHCP) or a static IP address.
         * 
         * @param ipScheme
         *        Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP
         *        address assignment (DHCP) or a static IP address.
         * @see InputDeviceIpScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceIpScheme
         */
        Builder ipScheme(InputDeviceIpScheme ipScheme);

        /**
         * The subnet mask of the input device.
         * 
         * @param subnetMask
         *        The subnet mask of the input device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMask(String subnetMask);
    }

    static final class BuilderImpl implements Builder {
        private List<String> dnsAddresses = DefaultSdkAutoConstructList.getInstance();

        private String gateway;

        private String ipAddress;

        private String ipScheme;

        private String subnetMask;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceNetworkSettings model) {
            dnsAddresses(model.dnsAddresses);
            gateway(model.gateway);
            ipAddress(model.ipAddress);
            ipScheme(model.ipScheme);
            subnetMask(model.subnetMask);
        }

        public final Collection<String> getDnsAddresses() {
            if (dnsAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsAddresses;
        }

        @Override
        public final Builder dnsAddresses(Collection<String> dnsAddresses) {
            this.dnsAddresses = ___listOf__stringCopier.copy(dnsAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsAddresses(String... dnsAddresses) {
            dnsAddresses(Arrays.asList(dnsAddresses));
            return this;
        }

        public final void setDnsAddresses(Collection<String> dnsAddresses) {
            this.dnsAddresses = ___listOf__stringCopier.copy(dnsAddresses);
        }

        public final String getGateway() {
            return gateway;
        }

        @Override
        public final Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public final void setGateway(String gateway) {
            this.gateway = gateway;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getIpScheme() {
            return ipScheme;
        }

        @Override
        public final Builder ipScheme(String ipScheme) {
            this.ipScheme = ipScheme;
            return this;
        }

        @Override
        public final Builder ipScheme(InputDeviceIpScheme ipScheme) {
            this.ipScheme(ipScheme == null ? null : ipScheme.toString());
            return this;
        }

        public final void setIpScheme(String ipScheme) {
            this.ipScheme = ipScheme;
        }

        public final String getSubnetMask() {
            return subnetMask;
        }

        @Override
        public final Builder subnetMask(String subnetMask) {
            this.subnetMask = subnetMask;
            return this;
        }

        public final void setSubnetMask(String subnetMask) {
            this.subnetMask = subnetMask;
        }

        @Override
        public InputDeviceNetworkSettings build() {
            return new InputDeviceNetworkSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
