/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for InputSpecification
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<InputSpecification.Builder, InputSpecification> {
    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Codec")
            .getter(getter(InputSpecification::codecAsString)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<String> MAXIMUM_BITRATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaximumBitrate").getter(getter(InputSpecification::maximumBitrateAsString))
            .setter(setter(Builder::maximumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resolution").getter(getter(InputSpecification::resolutionAsString)).setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD,
            MAXIMUM_BITRATE_FIELD, RESOLUTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codec;

    private final String maximumBitrate;

    private final String resolution;

    private InputSpecification(BuilderImpl builder) {
        this.codec = builder.codec;
        this.maximumBitrate = builder.maximumBitrate;
        this.resolution = builder.resolution;
    }

    /**
     * Input codec
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link InputCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Input codec
     * @see InputCodec
     */
    public final InputCodec codec() {
        return InputCodec.fromValue(codec);
    }

    /**
     * Input codec
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link InputCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Input codec
     * @see InputCodec
     */
    public final String codecAsString() {
        return codec;
    }

    /**
     * Maximum input bitrate, categorized coarsely
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maximumBitrate}
     * will return {@link InputMaximumBitrate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maximumBitrateAsString}.
     * </p>
     * 
     * @return Maximum input bitrate, categorized coarsely
     * @see InputMaximumBitrate
     */
    public final InputMaximumBitrate maximumBitrate() {
        return InputMaximumBitrate.fromValue(maximumBitrate);
    }

    /**
     * Maximum input bitrate, categorized coarsely
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maximumBitrate}
     * will return {@link InputMaximumBitrate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maximumBitrateAsString}.
     * </p>
     * 
     * @return Maximum input bitrate, categorized coarsely
     * @see InputMaximumBitrate
     */
    public final String maximumBitrateAsString() {
        return maximumBitrate;
    }

    /**
     * Input resolution, categorized coarsely
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link InputResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolutionAsString}.
     * </p>
     * 
     * @return Input resolution, categorized coarsely
     * @see InputResolution
     */
    public final InputResolution resolution() {
        return InputResolution.fromValue(resolution);
    }

    /**
     * Input resolution, categorized coarsely
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link InputResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolutionAsString}.
     * </p>
     * 
     * @return Input resolution, categorized coarsely
     * @see InputResolution
     */
    public final String resolutionAsString() {
        return resolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBitrateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSpecification)) {
            return false;
        }
        InputSpecification other = (InputSpecification) obj;
        return Objects.equals(codecAsString(), other.codecAsString())
                && Objects.equals(maximumBitrateAsString(), other.maximumBitrateAsString())
                && Objects.equals(resolutionAsString(), other.resolutionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputSpecification").add("Codec", codecAsString())
                .add("MaximumBitrate", maximumBitrateAsString()).add("Resolution", resolutionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Codec":
            return Optional.ofNullable(clazz.cast(codecAsString()));
        case "MaximumBitrate":
            return Optional.ofNullable(clazz.cast(maximumBitrateAsString()));
        case "Resolution":
            return Optional.ofNullable(clazz.cast(resolutionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputSpecification, T> g) {
        return obj -> g.apply((InputSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputSpecification> {
        /**
         * Input codec
         * 
         * @param codec
         *        Input codec
         * @see InputCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputCodec
         */
        Builder codec(String codec);

        /**
         * Input codec
         * 
         * @param codec
         *        Input codec
         * @see InputCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputCodec
         */
        Builder codec(InputCodec codec);

        /**
         * Maximum input bitrate, categorized coarsely
         * 
         * @param maximumBitrate
         *        Maximum input bitrate, categorized coarsely
         * @see InputMaximumBitrate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputMaximumBitrate
         */
        Builder maximumBitrate(String maximumBitrate);

        /**
         * Maximum input bitrate, categorized coarsely
         * 
         * @param maximumBitrate
         *        Maximum input bitrate, categorized coarsely
         * @see InputMaximumBitrate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputMaximumBitrate
         */
        Builder maximumBitrate(InputMaximumBitrate maximumBitrate);

        /**
         * Input resolution, categorized coarsely
         * 
         * @param resolution
         *        Input resolution, categorized coarsely
         * @see InputResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputResolution
         */
        Builder resolution(String resolution);

        /**
         * Input resolution, categorized coarsely
         * 
         * @param resolution
         *        Input resolution, categorized coarsely
         * @see InputResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputResolution
         */
        Builder resolution(InputResolution resolution);
    }

    static final class BuilderImpl implements Builder {
        private String codec;

        private String maximumBitrate;

        private String resolution;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSpecification model) {
            codec(model.codec);
            maximumBitrate(model.maximumBitrate);
            resolution(model.resolution);
        }

        public final String getCodec() {
            return codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(InputCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final String getMaximumBitrate() {
            return maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        @Override
        public final Builder maximumBitrate(InputMaximumBitrate maximumBitrate) {
            this.maximumBitrate(maximumBitrate == null ? null : maximumBitrate.toString());
            return this;
        }

        public final void setMaximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        public final String getResolution() {
            return resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(InputResolution resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public InputSpecification build() {
            return new InputSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
