/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Ms Smooth Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MsSmoothGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MsSmoothGroupSettings.Builder, MsSmoothGroupSettings> {
    private static final SdkField<String> ACQUISITION_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcquisitionPointId").getter(getter(MsSmoothGroupSettings::acquisitionPointId))
            .setter(setter(Builder::acquisitionPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acquisitionPointId").build())
            .build();

    private static final SdkField<String> AUDIO_ONLY_TIMECODE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioOnlyTimecodeControl").getter(getter(MsSmoothGroupSettings::audioOnlyTimecodeControlAsString))
            .setter(setter(Builder::audioOnlyTimecodeControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyTimecodeControl").build())
            .build();

    private static final SdkField<String> CERTIFICATE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateMode").getter(getter(MsSmoothGroupSettings::certificateModeAsString))
            .setter(setter(Builder::certificateMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateMode").build()).build();

    private static final SdkField<Integer> CONNECTION_RETRY_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConnectionRetryInterval").getter(getter(MsSmoothGroupSettings::connectionRetryInterval))
            .setter(setter(Builder::connectionRetryInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionRetryInterval").build())
            .build();

    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField
            .<OutputLocationRef> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(MsSmoothGroupSettings::destination)).setter(setter(Builder::destination))
            .constructor(OutputLocationRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventId").getter(getter(MsSmoothGroupSettings::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_ID_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventIdMode").getter(getter(MsSmoothGroupSettings::eventIdModeAsString))
            .setter(setter(Builder::eventIdMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventIdMode").build()).build();

    private static final SdkField<String> EVENT_STOP_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventStopBehavior").getter(getter(MsSmoothGroupSettings::eventStopBehaviorAsString))
            .setter(setter(Builder::eventStopBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStopBehavior").build()).build();

    private static final SdkField<Integer> FILECACHE_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FilecacheDuration").getter(getter(MsSmoothGroupSettings::filecacheDuration))
            .setter(setter(Builder::filecacheDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filecacheDuration").build()).build();

    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FragmentLength").getter(getter(MsSmoothGroupSettings::fragmentLength))
            .setter(setter(Builder::fragmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()).build();

    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputLossAction").getter(getter(MsSmoothGroupSettings::inputLossActionAsString))
            .setter(setter(Builder::inputLossAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()).build();

    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumRetries").getter(getter(MsSmoothGroupSettings::numRetries)).setter(setter(Builder::numRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRetries").build()).build();

    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RestartDelay").getter(getter(MsSmoothGroupSettings::restartDelay)).setter(setter(Builder::restartDelay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()).build();

    private static final SdkField<String> SEGMENTATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentationMode").getter(getter(MsSmoothGroupSettings::segmentationModeAsString))
            .setter(setter(Builder::segmentationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationMode").build()).build();

    private static final SdkField<Integer> SEND_DELAY_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SendDelayMs").getter(getter(MsSmoothGroupSettings::sendDelayMs)).setter(setter(Builder::sendDelayMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sendDelayMs").build()).build();

    private static final SdkField<String> SPARSE_TRACK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SparseTrackType").getter(getter(MsSmoothGroupSettings::sparseTrackTypeAsString))
            .setter(setter(Builder::sparseTrackType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparseTrackType").build()).build();

    private static final SdkField<String> STREAM_MANIFEST_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamManifestBehavior").getter(getter(MsSmoothGroupSettings::streamManifestBehaviorAsString))
            .setter(setter(Builder::streamManifestBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamManifestBehavior").build())
            .build();

    private static final SdkField<String> TIMESTAMP_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampOffset").getter(getter(MsSmoothGroupSettings::timestampOffset))
            .setter(setter(Builder::timestampOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampOffset").build()).build();

    private static final SdkField<String> TIMESTAMP_OFFSET_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampOffsetMode").getter(getter(MsSmoothGroupSettings::timestampOffsetModeAsString))
            .setter(setter(Builder::timestampOffsetMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampOffsetMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACQUISITION_POINT_ID_FIELD,
            AUDIO_ONLY_TIMECODE_CONTROL_FIELD, CERTIFICATE_MODE_FIELD, CONNECTION_RETRY_INTERVAL_FIELD, DESTINATION_FIELD,
            EVENT_ID_FIELD, EVENT_ID_MODE_FIELD, EVENT_STOP_BEHAVIOR_FIELD, FILECACHE_DURATION_FIELD, FRAGMENT_LENGTH_FIELD,
            INPUT_LOSS_ACTION_FIELD, NUM_RETRIES_FIELD, RESTART_DELAY_FIELD, SEGMENTATION_MODE_FIELD, SEND_DELAY_MS_FIELD,
            SPARSE_TRACK_TYPE_FIELD, STREAM_MANIFEST_BEHAVIOR_FIELD, TIMESTAMP_OFFSET_FIELD, TIMESTAMP_OFFSET_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String acquisitionPointId;

    private final String audioOnlyTimecodeControl;

    private final String certificateMode;

    private final Integer connectionRetryInterval;

    private final OutputLocationRef destination;

    private final String eventId;

    private final String eventIdMode;

    private final String eventStopBehavior;

    private final Integer filecacheDuration;

    private final Integer fragmentLength;

    private final String inputLossAction;

    private final Integer numRetries;

    private final Integer restartDelay;

    private final String segmentationMode;

    private final Integer sendDelayMs;

    private final String sparseTrackType;

    private final String streamManifestBehavior;

    private final String timestampOffset;

    private final String timestampOffsetMode;

    private MsSmoothGroupSettings(BuilderImpl builder) {
        this.acquisitionPointId = builder.acquisitionPointId;
        this.audioOnlyTimecodeControl = builder.audioOnlyTimecodeControl;
        this.certificateMode = builder.certificateMode;
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.destination = builder.destination;
        this.eventId = builder.eventId;
        this.eventIdMode = builder.eventIdMode;
        this.eventStopBehavior = builder.eventStopBehavior;
        this.filecacheDuration = builder.filecacheDuration;
        this.fragmentLength = builder.fragmentLength;
        this.inputLossAction = builder.inputLossAction;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
        this.segmentationMode = builder.segmentationMode;
        this.sendDelayMs = builder.sendDelayMs;
        this.sparseTrackType = builder.sparseTrackType;
        this.streamManifestBehavior = builder.streamManifestBehavior;
        this.timestampOffset = builder.timestampOffset;
        this.timestampOffsetMode = builder.timestampOffsetMode;
    }

    /**
     * The ID to include in each message in the sparse track. Ignored if sparseTrackType is NONE.
     * 
     * @return The ID to include in each message in the sparse track. Ignored if sparseTrackType is NONE.
     */
    public final String acquisitionPointId() {
        return acquisitionPointId;
    }

    /**
     * If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the current
     * timecode. This option does not write timecodes to the audio elementary stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioOnlyTimecodeControl} will return {@link SmoothGroupAudioOnlyTimecodeControl#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #audioOnlyTimecodeControlAsString}.
     * </p>
     * 
     * @return If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the
     *         current timecode. This option does not write timecodes to the audio elementary stream.
     * @see SmoothGroupAudioOnlyTimecodeControl
     */
    public final SmoothGroupAudioOnlyTimecodeControl audioOnlyTimecodeControl() {
        return SmoothGroupAudioOnlyTimecodeControl.fromValue(audioOnlyTimecodeControl);
    }

    /**
     * If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the current
     * timecode. This option does not write timecodes to the audio elementary stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioOnlyTimecodeControl} will return {@link SmoothGroupAudioOnlyTimecodeControl#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #audioOnlyTimecodeControlAsString}.
     * </p>
     * 
     * @return If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the
     *         current timecode. This option does not write timecodes to the audio elementary stream.
     * @see SmoothGroupAudioOnlyTimecodeControl
     */
    public final String audioOnlyTimecodeControlAsString() {
        return audioOnlyTimecodeControl;
    }

    /**
     * If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA). This
     * will cause https outputs to self-signed certificates to fail.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateMode}
     * will return {@link SmoothGroupCertificateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #certificateModeAsString}.
     * </p>
     * 
     * @return If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA).
     *         This will cause https outputs to self-signed certificates to fail.
     * @see SmoothGroupCertificateMode
     */
    public final SmoothGroupCertificateMode certificateMode() {
        return SmoothGroupCertificateMode.fromValue(certificateMode);
    }

    /**
     * If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA). This
     * will cause https outputs to self-signed certificates to fail.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateMode}
     * will return {@link SmoothGroupCertificateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #certificateModeAsString}.
     * </p>
     * 
     * @return If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA).
     *         This will cause https outputs to self-signed certificates to fail.
     * @see SmoothGroupCertificateMode
     */
    public final String certificateModeAsString() {
        return certificateMode;
    }

    /**
     * Number of seconds to wait before retrying connection to the IIS server if the connection is lost. Content will be
     * cached during this time and the cache will be be delivered to the IIS server once the connection is
     * re-established.
     * 
     * @return Number of seconds to wait before retrying connection to the IIS server if the connection is lost. Content
     *         will be cached during this time and the cache will be be delivered to the IIS server once the connection
     *         is re-established.
     */
    public final Integer connectionRetryInterval() {
        return connectionRetryInterval;
    }

    /**
     * Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS.
     * 
     * @return Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS.
     */
    public final OutputLocationRef destination() {
        return destination;
    }

    /**
     * MS Smooth event ID to be sent to the IIS server.
     *
     * Should only be specified if eventIdMode is set to useConfigured.
     * 
     * @return MS Smooth event ID to be sent to the IIS server.
     *
     *         Should only be specified if eventIdMode is set to useConfigured.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live Event is
     * used without changing the publishing point, clients might see cached video from the previous run.
     *
     * Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send an event ID
     * based on the current timestamp - "noEventId" - do not send an event ID to the IIS server.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventIdMode} will
     * return {@link SmoothGroupEventIdMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventIdModeAsString}.
     * </p>
     * 
     * @return Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live
     *         Event is used without changing the publishing point, clients might see cached video from the previous
     *         run.
     *
     *         Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send an
     *         event ID based on the current timestamp - "noEventId" - do not send an event ID to the IIS server.
     * @see SmoothGroupEventIdMode
     */
    public final SmoothGroupEventIdMode eventIdMode() {
        return SmoothGroupEventIdMode.fromValue(eventIdMode);
    }

    /**
     * Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live Event is
     * used without changing the publishing point, clients might see cached video from the previous run.
     *
     * Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send an event ID
     * based on the current timestamp - "noEventId" - do not send an event ID to the IIS server.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventIdMode} will
     * return {@link SmoothGroupEventIdMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventIdModeAsString}.
     * </p>
     * 
     * @return Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live
     *         Event is used without changing the publishing point, clients might see cached video from the previous
     *         run.
     *
     *         Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send an
     *         event ID based on the current timestamp - "noEventId" - do not send an event ID to the IIS server.
     * @see SmoothGroupEventIdMode
     */
    public final String eventIdModeAsString() {
        return eventIdMode;
    }

    /**
     * When set to sendEos, send EOS signal to IIS server when stopping the event
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStopBehavior}
     * will return {@link SmoothGroupEventStopBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventStopBehaviorAsString}.
     * </p>
     * 
     * @return When set to sendEos, send EOS signal to IIS server when stopping the event
     * @see SmoothGroupEventStopBehavior
     */
    public final SmoothGroupEventStopBehavior eventStopBehavior() {
        return SmoothGroupEventStopBehavior.fromValue(eventStopBehavior);
    }

    /**
     * When set to sendEos, send EOS signal to IIS server when stopping the event
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStopBehavior}
     * will return {@link SmoothGroupEventStopBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventStopBehaviorAsString}.
     * </p>
     * 
     * @return When set to sendEos, send EOS signal to IIS server when stopping the event
     * @see SmoothGroupEventStopBehavior
     */
    public final String eventStopBehaviorAsString() {
        return eventStopBehavior;
    }

    /**
     * Size in seconds of file cache for streaming outputs.
     * 
     * @return Size in seconds of file cache for streaming outputs.
     */
    public final Integer filecacheDuration() {
        return filecacheDuration;
    }

    /**
     * Length of mp4 fragments to generate (in seconds). Fragment length must be compatible with GOP size and framerate.
     * 
     * @return Length of mp4 fragments to generate (in seconds). Fragment length must be compatible with GOP size and
     *         framerate.
     */
    public final Integer fragmentLength() {
        return fragmentLength;
    }

    /**
     * Parameter that control output group behavior on input loss.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForMsSmoothOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Parameter that control output group behavior on input loss.
     * @see InputLossActionForMsSmoothOut
     */
    public final InputLossActionForMsSmoothOut inputLossAction() {
        return InputLossActionForMsSmoothOut.fromValue(inputLossAction);
    }

    /**
     * Parameter that control output group behavior on input loss.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForMsSmoothOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Parameter that control output group behavior on input loss.
     * @see InputLossActionForMsSmoothOut
     */
    public final String inputLossActionAsString() {
        return inputLossAction;
    }

    /**
     * Number of retry attempts.
     * 
     * @return Number of retry attempts.
     */
    public final Integer numRetries() {
        return numRetries;
    }

    /**
     * Number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on one
     * segment, or exceeding filecacheDuration.
     * 
     * @return Number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on
     *         one segment, or exceeding filecacheDuration.
     */
    public final Integer restartDelay() {
        return restartDelay;
    }

    /**
     * useInputSegmentation has been deprecated. The configured segment size is always used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentationMode}
     * will return {@link SmoothGroupSegmentationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #segmentationModeAsString}.
     * </p>
     * 
     * @return useInputSegmentation has been deprecated. The configured segment size is always used.
     * @see SmoothGroupSegmentationMode
     */
    public final SmoothGroupSegmentationMode segmentationMode() {
        return SmoothGroupSegmentationMode.fromValue(segmentationMode);
    }

    /**
     * useInputSegmentation has been deprecated. The configured segment size is always used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentationMode}
     * will return {@link SmoothGroupSegmentationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #segmentationModeAsString}.
     * </p>
     * 
     * @return useInputSegmentation has been deprecated. The configured segment size is always used.
     * @see SmoothGroupSegmentationMode
     */
    public final String segmentationModeAsString() {
        return segmentationMode;
    }

    /**
     * Number of milliseconds to delay the output from the second pipeline.
     * 
     * @return Number of milliseconds to delay the output from the second pipeline.
     */
    public final Integer sendDelayMs() {
        return sendDelayMs;
    }

    /**
     * Identifies the type of data to place in the sparse track: - SCTE35: Insert SCTE-35 messages from the source
     * content. With each message, insert an IDR frame to start a new segment. - SCTE35_WITHOUT_SEGMENTATION: Insert
     * SCTE-35 messages from the source content. With each message, insert an IDR frame but don't start a new segment. -
     * NONE: Don't generate a sparse track for any outputs in this output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sparseTrackType}
     * will return {@link SmoothGroupSparseTrackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sparseTrackTypeAsString}.
     * </p>
     * 
     * @return Identifies the type of data to place in the sparse track: - SCTE35: Insert SCTE-35 messages from the
     *         source content. With each message, insert an IDR frame to start a new segment. -
     *         SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages from the source content. With each message, insert
     *         an IDR frame but don't start a new segment. - NONE: Don't generate a sparse track for any outputs in this
     *         output group.
     * @see SmoothGroupSparseTrackType
     */
    public final SmoothGroupSparseTrackType sparseTrackType() {
        return SmoothGroupSparseTrackType.fromValue(sparseTrackType);
    }

    /**
     * Identifies the type of data to place in the sparse track: - SCTE35: Insert SCTE-35 messages from the source
     * content. With each message, insert an IDR frame to start a new segment. - SCTE35_WITHOUT_SEGMENTATION: Insert
     * SCTE-35 messages from the source content. With each message, insert an IDR frame but don't start a new segment. -
     * NONE: Don't generate a sparse track for any outputs in this output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sparseTrackType}
     * will return {@link SmoothGroupSparseTrackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sparseTrackTypeAsString}.
     * </p>
     * 
     * @return Identifies the type of data to place in the sparse track: - SCTE35: Insert SCTE-35 messages from the
     *         source content. With each message, insert an IDR frame to start a new segment. -
     *         SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages from the source content. With each message, insert
     *         an IDR frame but don't start a new segment. - NONE: Don't generate a sparse track for any outputs in this
     *         output group.
     * @see SmoothGroupSparseTrackType
     */
    public final String sparseTrackTypeAsString() {
        return sparseTrackType;
    }

    /**
     * When set to send, send stream manifest so publishing point doesn't start until all streams start.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamManifestBehavior} will return {@link SmoothGroupStreamManifestBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #streamManifestBehaviorAsString}.
     * </p>
     * 
     * @return When set to send, send stream manifest so publishing point doesn't start until all streams start.
     * @see SmoothGroupStreamManifestBehavior
     */
    public final SmoothGroupStreamManifestBehavior streamManifestBehavior() {
        return SmoothGroupStreamManifestBehavior.fromValue(streamManifestBehavior);
    }

    /**
     * When set to send, send stream manifest so publishing point doesn't start until all streams start.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamManifestBehavior} will return {@link SmoothGroupStreamManifestBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #streamManifestBehaviorAsString}.
     * </p>
     * 
     * @return When set to send, send stream manifest so publishing point doesn't start until all streams start.
     * @see SmoothGroupStreamManifestBehavior
     */
    public final String streamManifestBehaviorAsString() {
        return streamManifestBehavior;
    }

    /**
     * Timestamp offset for the event. Only used if timestampOffsetMode is set to useConfiguredOffset.
     * 
     * @return Timestamp offset for the event. Only used if timestampOffsetMode is set to useConfiguredOffset.
     */
    public final String timestampOffset() {
        return timestampOffset;
    }

    /**
     * Type of timestamp date offset to use. - useEventStartDate: Use the date the event was started as the offset -
     * useConfiguredOffset: Use an explicitly configured date as the offset
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timestampOffsetMode} will return {@link SmoothGroupTimestampOffsetMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #timestampOffsetModeAsString}.
     * </p>
     * 
     * @return Type of timestamp date offset to use. - useEventStartDate: Use the date the event was started as the
     *         offset - useConfiguredOffset: Use an explicitly configured date as the offset
     * @see SmoothGroupTimestampOffsetMode
     */
    public final SmoothGroupTimestampOffsetMode timestampOffsetMode() {
        return SmoothGroupTimestampOffsetMode.fromValue(timestampOffsetMode);
    }

    /**
     * Type of timestamp date offset to use. - useEventStartDate: Use the date the event was started as the offset -
     * useConfiguredOffset: Use an explicitly configured date as the offset
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timestampOffsetMode} will return {@link SmoothGroupTimestampOffsetMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #timestampOffsetModeAsString}.
     * </p>
     * 
     * @return Type of timestamp date offset to use. - useEventStartDate: Use the date the event was started as the
     *         offset - useConfiguredOffset: Use an explicitly configured date as the offset
     * @see SmoothGroupTimestampOffsetMode
     */
    public final String timestampOffsetModeAsString() {
        return timestampOffsetMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acquisitionPointId());
        hashCode = 31 * hashCode + Objects.hashCode(audioOnlyTimecodeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventIdModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventStopBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(restartDelay());
        hashCode = 31 * hashCode + Objects.hashCode(segmentationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sendDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(sparseTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamManifestBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestampOffset());
        hashCode = 31 * hashCode + Objects.hashCode(timestampOffsetModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MsSmoothGroupSettings)) {
            return false;
        }
        MsSmoothGroupSettings other = (MsSmoothGroupSettings) obj;
        return Objects.equals(acquisitionPointId(), other.acquisitionPointId())
                && Objects.equals(audioOnlyTimecodeControlAsString(), other.audioOnlyTimecodeControlAsString())
                && Objects.equals(certificateModeAsString(), other.certificateModeAsString())
                && Objects.equals(connectionRetryInterval(), other.connectionRetryInterval())
                && Objects.equals(destination(), other.destination()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(eventIdModeAsString(), other.eventIdModeAsString())
                && Objects.equals(eventStopBehaviorAsString(), other.eventStopBehaviorAsString())
                && Objects.equals(filecacheDuration(), other.filecacheDuration())
                && Objects.equals(fragmentLength(), other.fragmentLength())
                && Objects.equals(inputLossActionAsString(), other.inputLossActionAsString())
                && Objects.equals(numRetries(), other.numRetries()) && Objects.equals(restartDelay(), other.restartDelay())
                && Objects.equals(segmentationModeAsString(), other.segmentationModeAsString())
                && Objects.equals(sendDelayMs(), other.sendDelayMs())
                && Objects.equals(sparseTrackTypeAsString(), other.sparseTrackTypeAsString())
                && Objects.equals(streamManifestBehaviorAsString(), other.streamManifestBehaviorAsString())
                && Objects.equals(timestampOffset(), other.timestampOffset())
                && Objects.equals(timestampOffsetModeAsString(), other.timestampOffsetModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MsSmoothGroupSettings").add("AcquisitionPointId", acquisitionPointId())
                .add("AudioOnlyTimecodeControl", audioOnlyTimecodeControlAsString())
                .add("CertificateMode", certificateModeAsString()).add("ConnectionRetryInterval", connectionRetryInterval())
                .add("Destination", destination()).add("EventId", eventId()).add("EventIdMode", eventIdModeAsString())
                .add("EventStopBehavior", eventStopBehaviorAsString()).add("FilecacheDuration", filecacheDuration())
                .add("FragmentLength", fragmentLength()).add("InputLossAction", inputLossActionAsString())
                .add("NumRetries", numRetries()).add("RestartDelay", restartDelay())
                .add("SegmentationMode", segmentationModeAsString()).add("SendDelayMs", sendDelayMs())
                .add("SparseTrackType", sparseTrackTypeAsString())
                .add("StreamManifestBehavior", streamManifestBehaviorAsString()).add("TimestampOffset", timestampOffset())
                .add("TimestampOffsetMode", timestampOffsetModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcquisitionPointId":
            return Optional.ofNullable(clazz.cast(acquisitionPointId()));
        case "AudioOnlyTimecodeControl":
            return Optional.ofNullable(clazz.cast(audioOnlyTimecodeControlAsString()));
        case "CertificateMode":
            return Optional.ofNullable(clazz.cast(certificateModeAsString()));
        case "ConnectionRetryInterval":
            return Optional.ofNullable(clazz.cast(connectionRetryInterval()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "EventIdMode":
            return Optional.ofNullable(clazz.cast(eventIdModeAsString()));
        case "EventStopBehavior":
            return Optional.ofNullable(clazz.cast(eventStopBehaviorAsString()));
        case "FilecacheDuration":
            return Optional.ofNullable(clazz.cast(filecacheDuration()));
        case "FragmentLength":
            return Optional.ofNullable(clazz.cast(fragmentLength()));
        case "InputLossAction":
            return Optional.ofNullable(clazz.cast(inputLossActionAsString()));
        case "NumRetries":
            return Optional.ofNullable(clazz.cast(numRetries()));
        case "RestartDelay":
            return Optional.ofNullable(clazz.cast(restartDelay()));
        case "SegmentationMode":
            return Optional.ofNullable(clazz.cast(segmentationModeAsString()));
        case "SendDelayMs":
            return Optional.ofNullable(clazz.cast(sendDelayMs()));
        case "SparseTrackType":
            return Optional.ofNullable(clazz.cast(sparseTrackTypeAsString()));
        case "StreamManifestBehavior":
            return Optional.ofNullable(clazz.cast(streamManifestBehaviorAsString()));
        case "TimestampOffset":
            return Optional.ofNullable(clazz.cast(timestampOffset()));
        case "TimestampOffsetMode":
            return Optional.ofNullable(clazz.cast(timestampOffsetModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MsSmoothGroupSettings, T> g) {
        return obj -> g.apply((MsSmoothGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MsSmoothGroupSettings> {
        /**
         * The ID to include in each message in the sparse track. Ignored if sparseTrackType is NONE.
         * 
         * @param acquisitionPointId
         *        The ID to include in each message in the sparse track. Ignored if sparseTrackType is NONE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acquisitionPointId(String acquisitionPointId);

        /**
         * If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the
         * current timecode. This option does not write timecodes to the audio elementary stream.
         * 
         * @param audioOnlyTimecodeControl
         *        If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to
         *        the current timecode. This option does not write timecodes to the audio elementary stream.
         * @see SmoothGroupAudioOnlyTimecodeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupAudioOnlyTimecodeControl
         */
        Builder audioOnlyTimecodeControl(String audioOnlyTimecodeControl);

        /**
         * If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the
         * current timecode. This option does not write timecodes to the audio elementary stream.
         * 
         * @param audioOnlyTimecodeControl
         *        If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to
         *        the current timecode. This option does not write timecodes to the audio elementary stream.
         * @see SmoothGroupAudioOnlyTimecodeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupAudioOnlyTimecodeControl
         */
        Builder audioOnlyTimecodeControl(SmoothGroupAudioOnlyTimecodeControl audioOnlyTimecodeControl);

        /**
         * If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA).
         * This will cause https outputs to self-signed certificates to fail.
         * 
         * @param certificateMode
         *        If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority
         *        (CA). This will cause https outputs to self-signed certificates to fail.
         * @see SmoothGroupCertificateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupCertificateMode
         */
        Builder certificateMode(String certificateMode);

        /**
         * If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA).
         * This will cause https outputs to self-signed certificates to fail.
         * 
         * @param certificateMode
         *        If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority
         *        (CA). This will cause https outputs to self-signed certificates to fail.
         * @see SmoothGroupCertificateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupCertificateMode
         */
        Builder certificateMode(SmoothGroupCertificateMode certificateMode);

        /**
         * Number of seconds to wait before retrying connection to the IIS server if the connection is lost. Content
         * will be cached during this time and the cache will be be delivered to the IIS server once the connection is
         * re-established.
         * 
         * @param connectionRetryInterval
         *        Number of seconds to wait before retrying connection to the IIS server if the connection is lost.
         *        Content will be cached during this time and the cache will be be delivered to the IIS server once the
         *        connection is re-established.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionRetryInterval(Integer connectionRetryInterval);

        /**
         * Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS.
         * 
         * @param destination
         *        Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(OutputLocationRef destination);

        /**
         * Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS. This is a
         * convenience that creates an instance of the {@link OutputLocationRef.Builder} avoiding the need to create one
         * manually via {@link OutputLocationRef#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocationRef.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(OutputLocationRef)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link OutputLocationRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(OutputLocationRef)
         */
        default Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return destination(OutputLocationRef.builder().applyMutation(destination).build());
        }

        /**
         * MS Smooth event ID to be sent to the IIS server.
         *
         * Should only be specified if eventIdMode is set to useConfigured.
         * 
         * @param eventId
         *        MS Smooth event ID to be sent to the IIS server.
         *
         *        Should only be specified if eventIdMode is set to useConfigured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live
         * Event is used without changing the publishing point, clients might see cached video from the previous run.
         *
         * Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send an event
         * ID based on the current timestamp - "noEventId" - do not send an event ID to the IIS server.
         * 
         * @param eventIdMode
         *        Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same
         *        Live Event is used without changing the publishing point, clients might see cached video from the
         *        previous run.
         *
         *        Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send an
         *        event ID based on the current timestamp - "noEventId" - do not send an event ID to the IIS server.
         * @see SmoothGroupEventIdMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupEventIdMode
         */
        Builder eventIdMode(String eventIdMode);

        /**
         * Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live
         * Event is used without changing the publishing point, clients might see cached video from the previous run.
         *
         * Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send an event
         * ID based on the current timestamp - "noEventId" - do not send an event ID to the IIS server.
         * 
         * @param eventIdMode
         *        Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same
         *        Live Event is used without changing the publishing point, clients might see cached video from the
         *        previous run.
         *
         *        Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send an
         *        event ID based on the current timestamp - "noEventId" - do not send an event ID to the IIS server.
         * @see SmoothGroupEventIdMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupEventIdMode
         */
        Builder eventIdMode(SmoothGroupEventIdMode eventIdMode);

        /**
         * When set to sendEos, send EOS signal to IIS server when stopping the event
         * 
         * @param eventStopBehavior
         *        When set to sendEos, send EOS signal to IIS server when stopping the event
         * @see SmoothGroupEventStopBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupEventStopBehavior
         */
        Builder eventStopBehavior(String eventStopBehavior);

        /**
         * When set to sendEos, send EOS signal to IIS server when stopping the event
         * 
         * @param eventStopBehavior
         *        When set to sendEos, send EOS signal to IIS server when stopping the event
         * @see SmoothGroupEventStopBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupEventStopBehavior
         */
        Builder eventStopBehavior(SmoothGroupEventStopBehavior eventStopBehavior);

        /**
         * Size in seconds of file cache for streaming outputs.
         * 
         * @param filecacheDuration
         *        Size in seconds of file cache for streaming outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filecacheDuration(Integer filecacheDuration);

        /**
         * Length of mp4 fragments to generate (in seconds). Fragment length must be compatible with GOP size and
         * framerate.
         * 
         * @param fragmentLength
         *        Length of mp4 fragments to generate (in seconds). Fragment length must be compatible with GOP size and
         *        framerate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentLength(Integer fragmentLength);

        /**
         * Parameter that control output group behavior on input loss.
         * 
         * @param inputLossAction
         *        Parameter that control output group behavior on input loss.
         * @see InputLossActionForMsSmoothOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForMsSmoothOut
         */
        Builder inputLossAction(String inputLossAction);

        /**
         * Parameter that control output group behavior on input loss.
         * 
         * @param inputLossAction
         *        Parameter that control output group behavior on input loss.
         * @see InputLossActionForMsSmoothOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForMsSmoothOut
         */
        Builder inputLossAction(InputLossActionForMsSmoothOut inputLossAction);

        /**
         * Number of retry attempts.
         * 
         * @param numRetries
         *        Number of retry attempts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numRetries(Integer numRetries);

        /**
         * Number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on one
         * segment, or exceeding filecacheDuration.
         * 
         * @param restartDelay
         *        Number of seconds before initiating a restart due to output failure, due to exhausting the numRetries
         *        on one segment, or exceeding filecacheDuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restartDelay(Integer restartDelay);

        /**
         * useInputSegmentation has been deprecated. The configured segment size is always used.
         * 
         * @param segmentationMode
         *        useInputSegmentation has been deprecated. The configured segment size is always used.
         * @see SmoothGroupSegmentationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupSegmentationMode
         */
        Builder segmentationMode(String segmentationMode);

        /**
         * useInputSegmentation has been deprecated. The configured segment size is always used.
         * 
         * @param segmentationMode
         *        useInputSegmentation has been deprecated. The configured segment size is always used.
         * @see SmoothGroupSegmentationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupSegmentationMode
         */
        Builder segmentationMode(SmoothGroupSegmentationMode segmentationMode);

        /**
         * Number of milliseconds to delay the output from the second pipeline.
         * 
         * @param sendDelayMs
         *        Number of milliseconds to delay the output from the second pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendDelayMs(Integer sendDelayMs);

        /**
         * Identifies the type of data to place in the sparse track: - SCTE35: Insert SCTE-35 messages from the source
         * content. With each message, insert an IDR frame to start a new segment. - SCTE35_WITHOUT_SEGMENTATION: Insert
         * SCTE-35 messages from the source content. With each message, insert an IDR frame but don't start a new
         * segment. - NONE: Don't generate a sparse track for any outputs in this output group.
         * 
         * @param sparseTrackType
         *        Identifies the type of data to place in the sparse track: - SCTE35: Insert SCTE-35 messages from the
         *        source content. With each message, insert an IDR frame to start a new segment. -
         *        SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages from the source content. With each message,
         *        insert an IDR frame but don't start a new segment. - NONE: Don't generate a sparse track for any
         *        outputs in this output group.
         * @see SmoothGroupSparseTrackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupSparseTrackType
         */
        Builder sparseTrackType(String sparseTrackType);

        /**
         * Identifies the type of data to place in the sparse track: - SCTE35: Insert SCTE-35 messages from the source
         * content. With each message, insert an IDR frame to start a new segment. - SCTE35_WITHOUT_SEGMENTATION: Insert
         * SCTE-35 messages from the source content. With each message, insert an IDR frame but don't start a new
         * segment. - NONE: Don't generate a sparse track for any outputs in this output group.
         * 
         * @param sparseTrackType
         *        Identifies the type of data to place in the sparse track: - SCTE35: Insert SCTE-35 messages from the
         *        source content. With each message, insert an IDR frame to start a new segment. -
         *        SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages from the source content. With each message,
         *        insert an IDR frame but don't start a new segment. - NONE: Don't generate a sparse track for any
         *        outputs in this output group.
         * @see SmoothGroupSparseTrackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupSparseTrackType
         */
        Builder sparseTrackType(SmoothGroupSparseTrackType sparseTrackType);

        /**
         * When set to send, send stream manifest so publishing point doesn't start until all streams start.
         * 
         * @param streamManifestBehavior
         *        When set to send, send stream manifest so publishing point doesn't start until all streams start.
         * @see SmoothGroupStreamManifestBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupStreamManifestBehavior
         */
        Builder streamManifestBehavior(String streamManifestBehavior);

        /**
         * When set to send, send stream manifest so publishing point doesn't start until all streams start.
         * 
         * @param streamManifestBehavior
         *        When set to send, send stream manifest so publishing point doesn't start until all streams start.
         * @see SmoothGroupStreamManifestBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupStreamManifestBehavior
         */
        Builder streamManifestBehavior(SmoothGroupStreamManifestBehavior streamManifestBehavior);

        /**
         * Timestamp offset for the event. Only used if timestampOffsetMode is set to useConfiguredOffset.
         * 
         * @param timestampOffset
         *        Timestamp offset for the event. Only used if timestampOffsetMode is set to useConfiguredOffset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampOffset(String timestampOffset);

        /**
         * Type of timestamp date offset to use. - useEventStartDate: Use the date the event was started as the offset -
         * useConfiguredOffset: Use an explicitly configured date as the offset
         * 
         * @param timestampOffsetMode
         *        Type of timestamp date offset to use. - useEventStartDate: Use the date the event was started as the
         *        offset - useConfiguredOffset: Use an explicitly configured date as the offset
         * @see SmoothGroupTimestampOffsetMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupTimestampOffsetMode
         */
        Builder timestampOffsetMode(String timestampOffsetMode);

        /**
         * Type of timestamp date offset to use. - useEventStartDate: Use the date the event was started as the offset -
         * useConfiguredOffset: Use an explicitly configured date as the offset
         * 
         * @param timestampOffsetMode
         *        Type of timestamp date offset to use. - useEventStartDate: Use the date the event was started as the
         *        offset - useConfiguredOffset: Use an explicitly configured date as the offset
         * @see SmoothGroupTimestampOffsetMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmoothGroupTimestampOffsetMode
         */
        Builder timestampOffsetMode(SmoothGroupTimestampOffsetMode timestampOffsetMode);
    }

    static final class BuilderImpl implements Builder {
        private String acquisitionPointId;

        private String audioOnlyTimecodeControl;

        private String certificateMode;

        private Integer connectionRetryInterval;

        private OutputLocationRef destination;

        private String eventId;

        private String eventIdMode;

        private String eventStopBehavior;

        private Integer filecacheDuration;

        private Integer fragmentLength;

        private String inputLossAction;

        private Integer numRetries;

        private Integer restartDelay;

        private String segmentationMode;

        private Integer sendDelayMs;

        private String sparseTrackType;

        private String streamManifestBehavior;

        private String timestampOffset;

        private String timestampOffsetMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MsSmoothGroupSettings model) {
            acquisitionPointId(model.acquisitionPointId);
            audioOnlyTimecodeControl(model.audioOnlyTimecodeControl);
            certificateMode(model.certificateMode);
            connectionRetryInterval(model.connectionRetryInterval);
            destination(model.destination);
            eventId(model.eventId);
            eventIdMode(model.eventIdMode);
            eventStopBehavior(model.eventStopBehavior);
            filecacheDuration(model.filecacheDuration);
            fragmentLength(model.fragmentLength);
            inputLossAction(model.inputLossAction);
            numRetries(model.numRetries);
            restartDelay(model.restartDelay);
            segmentationMode(model.segmentationMode);
            sendDelayMs(model.sendDelayMs);
            sparseTrackType(model.sparseTrackType);
            streamManifestBehavior(model.streamManifestBehavior);
            timestampOffset(model.timestampOffset);
            timestampOffsetMode(model.timestampOffsetMode);
        }

        public final String getAcquisitionPointId() {
            return acquisitionPointId;
        }

        @Override
        public final Builder acquisitionPointId(String acquisitionPointId) {
            this.acquisitionPointId = acquisitionPointId;
            return this;
        }

        public final void setAcquisitionPointId(String acquisitionPointId) {
            this.acquisitionPointId = acquisitionPointId;
        }

        public final String getAudioOnlyTimecodeControl() {
            return audioOnlyTimecodeControl;
        }

        @Override
        public final Builder audioOnlyTimecodeControl(String audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl = audioOnlyTimecodeControl;
            return this;
        }

        @Override
        public final Builder audioOnlyTimecodeControl(SmoothGroupAudioOnlyTimecodeControl audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl(audioOnlyTimecodeControl == null ? null : audioOnlyTimecodeControl.toString());
            return this;
        }

        public final void setAudioOnlyTimecodeControl(String audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl = audioOnlyTimecodeControl;
        }

        public final String getCertificateMode() {
            return certificateMode;
        }

        @Override
        public final Builder certificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
            return this;
        }

        @Override
        public final Builder certificateMode(SmoothGroupCertificateMode certificateMode) {
            this.certificateMode(certificateMode == null ? null : certificateMode.toString());
            return this;
        }

        public final void setCertificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
        }

        public final Integer getConnectionRetryInterval() {
            return connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public final OutputLocationRef.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventIdMode() {
            return eventIdMode;
        }

        @Override
        public final Builder eventIdMode(String eventIdMode) {
            this.eventIdMode = eventIdMode;
            return this;
        }

        @Override
        public final Builder eventIdMode(SmoothGroupEventIdMode eventIdMode) {
            this.eventIdMode(eventIdMode == null ? null : eventIdMode.toString());
            return this;
        }

        public final void setEventIdMode(String eventIdMode) {
            this.eventIdMode = eventIdMode;
        }

        public final String getEventStopBehavior() {
            return eventStopBehavior;
        }

        @Override
        public final Builder eventStopBehavior(String eventStopBehavior) {
            this.eventStopBehavior = eventStopBehavior;
            return this;
        }

        @Override
        public final Builder eventStopBehavior(SmoothGroupEventStopBehavior eventStopBehavior) {
            this.eventStopBehavior(eventStopBehavior == null ? null : eventStopBehavior.toString());
            return this;
        }

        public final void setEventStopBehavior(String eventStopBehavior) {
            this.eventStopBehavior = eventStopBehavior;
        }

        public final Integer getFilecacheDuration() {
            return filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        public final Integer getFragmentLength() {
            return fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getInputLossAction() {
            return inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForMsSmoothOut inputLossAction) {
            this.inputLossAction(inputLossAction == null ? null : inputLossAction.toString());
            return this;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        public final Integer getNumRetries() {
            return numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        public final Integer getRestartDelay() {
            return restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        public final String getSegmentationMode() {
            return segmentationMode;
        }

        @Override
        public final Builder segmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
            return this;
        }

        @Override
        public final Builder segmentationMode(SmoothGroupSegmentationMode segmentationMode) {
            this.segmentationMode(segmentationMode == null ? null : segmentationMode.toString());
            return this;
        }

        public final void setSegmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
        }

        public final Integer getSendDelayMs() {
            return sendDelayMs;
        }

        @Override
        public final Builder sendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
            return this;
        }

        public final void setSendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
        }

        public final String getSparseTrackType() {
            return sparseTrackType;
        }

        @Override
        public final Builder sparseTrackType(String sparseTrackType) {
            this.sparseTrackType = sparseTrackType;
            return this;
        }

        @Override
        public final Builder sparseTrackType(SmoothGroupSparseTrackType sparseTrackType) {
            this.sparseTrackType(sparseTrackType == null ? null : sparseTrackType.toString());
            return this;
        }

        public final void setSparseTrackType(String sparseTrackType) {
            this.sparseTrackType = sparseTrackType;
        }

        public final String getStreamManifestBehavior() {
            return streamManifestBehavior;
        }

        @Override
        public final Builder streamManifestBehavior(String streamManifestBehavior) {
            this.streamManifestBehavior = streamManifestBehavior;
            return this;
        }

        @Override
        public final Builder streamManifestBehavior(SmoothGroupStreamManifestBehavior streamManifestBehavior) {
            this.streamManifestBehavior(streamManifestBehavior == null ? null : streamManifestBehavior.toString());
            return this;
        }

        public final void setStreamManifestBehavior(String streamManifestBehavior) {
            this.streamManifestBehavior = streamManifestBehavior;
        }

        public final String getTimestampOffset() {
            return timestampOffset;
        }

        @Override
        public final Builder timestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
            return this;
        }

        public final void setTimestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
        }

        public final String getTimestampOffsetMode() {
            return timestampOffsetMode;
        }

        @Override
        public final Builder timestampOffsetMode(String timestampOffsetMode) {
            this.timestampOffsetMode = timestampOffsetMode;
            return this;
        }

        @Override
        public final Builder timestampOffsetMode(SmoothGroupTimestampOffsetMode timestampOffsetMode) {
            this.timestampOffsetMode(timestampOffsetMode == null ? null : timestampOffsetMode.toString());
            return this;
        }

        public final void setTimestampOffsetMode(String timestampOffsetMode) {
            this.timestampOffsetMode = timestampOffsetMode;
        }

        @Override
        public MsSmoothGroupSettings build() {
            return new MsSmoothGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
