/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The video configuration for each program in a multiplex.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexVideoSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexVideoSettings.Builder, MultiplexVideoSettings> {
    private static final SdkField<Integer> CONSTANT_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConstantBitrate").getter(getter(MultiplexVideoSettings::constantBitrate))
            .setter(setter(Builder::constantBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantBitrate").build()).build();

    private static final SdkField<MultiplexStatmuxVideoSettings> STATMUX_SETTINGS_FIELD = SdkField
            .<MultiplexStatmuxVideoSettings> builder(MarshallingType.SDK_POJO).memberName("StatmuxSettings")
            .getter(getter(MultiplexVideoSettings::statmuxSettings)).setter(setter(Builder::statmuxSettings))
            .constructor(MultiplexStatmuxVideoSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statmuxSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_BITRATE_FIELD,
            STATMUX_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer constantBitrate;

    private final MultiplexStatmuxVideoSettings statmuxSettings;

    private MultiplexVideoSettings(BuilderImpl builder) {
        this.constantBitrate = builder.constantBitrate;
        this.statmuxSettings = builder.statmuxSettings;
    }

    /**
     * The constant bitrate configuration for the video encode. When this field is defined, StatmuxSettings must be
     * undefined.
     * 
     * @return The constant bitrate configuration for the video encode. When this field is defined, StatmuxSettings must
     *         be undefined.
     */
    public final Integer constantBitrate() {
        return constantBitrate;
    }

    /**
     * Statmux rate control settings. When this field is defined, ConstantBitrate must be undefined.
     * 
     * @return Statmux rate control settings. When this field is defined, ConstantBitrate must be undefined.
     */
    public final MultiplexStatmuxVideoSettings statmuxSettings() {
        return statmuxSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(statmuxSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexVideoSettings)) {
            return false;
        }
        MultiplexVideoSettings other = (MultiplexVideoSettings) obj;
        return Objects.equals(constantBitrate(), other.constantBitrate())
                && Objects.equals(statmuxSettings(), other.statmuxSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexVideoSettings").add("ConstantBitrate", constantBitrate())
                .add("StatmuxSettings", statmuxSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantBitrate":
            return Optional.ofNullable(clazz.cast(constantBitrate()));
        case "StatmuxSettings":
            return Optional.ofNullable(clazz.cast(statmuxSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexVideoSettings, T> g) {
        return obj -> g.apply((MultiplexVideoSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexVideoSettings> {
        /**
         * The constant bitrate configuration for the video encode. When this field is defined, StatmuxSettings must be
         * undefined.
         * 
         * @param constantBitrate
         *        The constant bitrate configuration for the video encode. When this field is defined, StatmuxSettings
         *        must be undefined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constantBitrate(Integer constantBitrate);

        /**
         * Statmux rate control settings. When this field is defined, ConstantBitrate must be undefined.
         * 
         * @param statmuxSettings
         *        Statmux rate control settings. When this field is defined, ConstantBitrate must be undefined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statmuxSettings(MultiplexStatmuxVideoSettings statmuxSettings);

        /**
         * Statmux rate control settings. When this field is defined, ConstantBitrate must be undefined. This is a
         * convenience that creates an instance of the {@link MultiplexStatmuxVideoSettings.Builder} avoiding the need
         * to create one manually via {@link MultiplexStatmuxVideoSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexStatmuxVideoSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #statmuxSettings(MultiplexStatmuxVideoSettings)}.
         * 
         * @param statmuxSettings
         *        a consumer that will call methods on {@link MultiplexStatmuxVideoSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statmuxSettings(MultiplexStatmuxVideoSettings)
         */
        default Builder statmuxSettings(Consumer<MultiplexStatmuxVideoSettings.Builder> statmuxSettings) {
            return statmuxSettings(MultiplexStatmuxVideoSettings.builder().applyMutation(statmuxSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer constantBitrate;

        private MultiplexStatmuxVideoSettings statmuxSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexVideoSettings model) {
            constantBitrate(model.constantBitrate);
            statmuxSettings(model.statmuxSettings);
        }

        public final Integer getConstantBitrate() {
            return constantBitrate;
        }

        @Override
        public final Builder constantBitrate(Integer constantBitrate) {
            this.constantBitrate = constantBitrate;
            return this;
        }

        public final void setConstantBitrate(Integer constantBitrate) {
            this.constantBitrate = constantBitrate;
        }

        public final MultiplexStatmuxVideoSettings.Builder getStatmuxSettings() {
            return statmuxSettings != null ? statmuxSettings.toBuilder() : null;
        }

        @Override
        public final Builder statmuxSettings(MultiplexStatmuxVideoSettings statmuxSettings) {
            this.statmuxSettings = statmuxSettings;
            return this;
        }

        public final void setStatmuxSettings(MultiplexStatmuxVideoSettings.BuilderImpl statmuxSettings) {
            this.statmuxSettings = statmuxSettings != null ? statmuxSettings.build() : null;
        }

        @Override
        public MultiplexVideoSettings build() {
            return new MultiplexVideoSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
