/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Corresponds to SCTE-35 segmentation_event_cancel_indicator. SEGMENTATION_EVENT_NOT_CANCELED corresponds to 0 in the
 * SCTE-35 specification and indicates that this is an insertion request. SEGMENTATION_EVENT_CANCELED corresponds to 1
 * in the SCTE-35 specification and indicates that this is a cancelation request, in which case complete this field and
 * the existing event ID to cancel.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Scte35SegmentationCancelIndicator {
    SEGMENTATION_EVENT_NOT_CANCELED("SEGMENTATION_EVENT_NOT_CANCELED"),

    SEGMENTATION_EVENT_CANCELED("SEGMENTATION_EVENT_CANCELED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Scte35SegmentationCancelIndicator(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Scte35SegmentationCancelIndicator corresponding to the value
     */
    public static Scte35SegmentationCancelIndicator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Scte35SegmentationCancelIndicator.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Scte35SegmentationCancelIndicator}s
     */
    public static Set<Scte35SegmentationCancelIndicator> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
