/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Udp Container Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class UdpContainerSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<UdpContainerSettings.Builder, UdpContainerSettings> {
    private static final SdkField<M2tsSettings> M2_TS_SETTINGS_FIELD = SdkField.<M2tsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("M2tsSettings").getter(getter(UdpContainerSettings::m2tsSettings)).setter(setter(Builder::m2tsSettings))
            .constructor(M2tsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2tsSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(M2_TS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final M2tsSettings m2tsSettings;

    private UdpContainerSettings(BuilderImpl builder) {
        this.m2tsSettings = builder.m2tsSettings;
    }

    /**
     * Returns the value of the M2tsSettings property for this object.
     * 
     * @return The value of the M2tsSettings property for this object.
     */
    public final M2tsSettings m2tsSettings() {
        return m2tsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(m2tsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UdpContainerSettings)) {
            return false;
        }
        UdpContainerSettings other = (UdpContainerSettings) obj;
        return Objects.equals(m2tsSettings(), other.m2tsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UdpContainerSettings").add("M2tsSettings", m2tsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "M2tsSettings":
            return Optional.ofNullable(clazz.cast(m2tsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UdpContainerSettings, T> g) {
        return obj -> g.apply((UdpContainerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UdpContainerSettings> {
        /**
         * Sets the value of the M2tsSettings property for this object.
         *
         * @param m2tsSettings
         *        The new value for the M2tsSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2tsSettings(M2tsSettings m2tsSettings);

        /**
         * Sets the value of the M2tsSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link M2tsSettings.Builder} avoiding the need to
         * create one manually via {@link M2tsSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link M2tsSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #m2tsSettings(M2tsSettings)}.
         * 
         * @param m2tsSettings
         *        a consumer that will call methods on {@link M2tsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2tsSettings(M2tsSettings)
         */
        default Builder m2tsSettings(Consumer<M2tsSettings.Builder> m2tsSettings) {
            return m2tsSettings(M2tsSettings.builder().applyMutation(m2tsSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private M2tsSettings m2tsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UdpContainerSettings model) {
            m2tsSettings(model.m2tsSettings);
        }

        public final M2tsSettings.Builder getM2tsSettings() {
            return m2tsSettings != null ? m2tsSettings.toBuilder() : null;
        }

        @Override
        public final Builder m2tsSettings(M2tsSettings m2tsSettings) {
            this.m2tsSettings = m2tsSettings;
            return this;
        }

        public final void setM2tsSettings(M2tsSettings.BuilderImpl m2tsSettings) {
            this.m2tsSettings = m2tsSettings != null ? m2tsSettings.build() : null;
        }

        @Override
        public UdpContainerSettings build() {
            return new UdpContainerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
