/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Video Selector Color Space Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoSelectorColorSpaceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoSelectorColorSpaceSettings.Builder, VideoSelectorColorSpaceSettings> {
    private static final SdkField<Hdr10Settings> HDR10_SETTINGS_FIELD = SdkField
            .<Hdr10Settings> builder(MarshallingType.SDK_POJO).memberName("Hdr10Settings")
            .getter(getter(VideoSelectorColorSpaceSettings::hdr10Settings)).setter(setter(Builder::hdr10Settings))
            .constructor(Hdr10Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdr10Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HDR10_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Hdr10Settings hdr10Settings;

    private VideoSelectorColorSpaceSettings(BuilderImpl builder) {
        this.hdr10Settings = builder.hdr10Settings;
    }

    /**
     * Returns the value of the Hdr10Settings property for this object.
     * 
     * @return The value of the Hdr10Settings property for this object.
     */
    public final Hdr10Settings hdr10Settings() {
        return hdr10Settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hdr10Settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelectorColorSpaceSettings)) {
            return false;
        }
        VideoSelectorColorSpaceSettings other = (VideoSelectorColorSpaceSettings) obj;
        return Objects.equals(hdr10Settings(), other.hdr10Settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoSelectorColorSpaceSettings").add("Hdr10Settings", hdr10Settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hdr10Settings":
            return Optional.ofNullable(clazz.cast(hdr10Settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoSelectorColorSpaceSettings, T> g) {
        return obj -> g.apply((VideoSelectorColorSpaceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoSelectorColorSpaceSettings> {
        /**
         * Sets the value of the Hdr10Settings property for this object.
         *
         * @param hdr10Settings
         *        The new value for the Hdr10Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hdr10Settings(Hdr10Settings hdr10Settings);

        /**
         * Sets the value of the Hdr10Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Hdr10Settings.Builder} avoiding the need to
         * create one manually via {@link Hdr10Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Hdr10Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #hdr10Settings(Hdr10Settings)}.
         * 
         * @param hdr10Settings
         *        a consumer that will call methods on {@link Hdr10Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hdr10Settings(Hdr10Settings)
         */
        default Builder hdr10Settings(Consumer<Hdr10Settings.Builder> hdr10Settings) {
            return hdr10Settings(Hdr10Settings.builder().applyMutation(hdr10Settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Hdr10Settings hdr10Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelectorColorSpaceSettings model) {
            hdr10Settings(model.hdr10Settings);
        }

        public final Hdr10Settings.Builder getHdr10Settings() {
            return hdr10Settings != null ? hdr10Settings.toBuilder() : null;
        }

        @Override
        public final Builder hdr10Settings(Hdr10Settings hdr10Settings) {
            this.hdr10Settings = hdr10Settings;
            return this;
        }

        public final void setHdr10Settings(Hdr10Settings.BuilderImpl hdr10Settings) {
            this.hdr10Settings = hdr10Settings != null ? hdr10Settings.build() : null;
        }

        @Override
        public VideoSelectorColorSpaceSettings build() {
            return new VideoSelectorColorSpaceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
