/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfInputWhitelistRuleCopier {
    static List<InputWhitelistRule> copy(Collection<? extends InputWhitelistRule> __listOfInputWhitelistRuleParam) {
        List<InputWhitelistRule> list;
        if (__listOfInputWhitelistRuleParam == null || __listOfInputWhitelistRuleParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InputWhitelistRule> modifiableList = new ArrayList<>();
            __listOfInputWhitelistRuleParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InputWhitelistRule> copyFromBuilder(
            Collection<? extends InputWhitelistRule.Builder> __listOfInputWhitelistRuleParam) {
        List<InputWhitelistRule> list;
        if (__listOfInputWhitelistRuleParam == null || __listOfInputWhitelistRuleParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InputWhitelistRule> modifiableList = new ArrayList<>();
            __listOfInputWhitelistRuleParam.forEach(entry -> {
                InputWhitelistRule member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InputWhitelistRule.Builder> copyToBuilder(Collection<? extends InputWhitelistRule> __listOfInputWhitelistRuleParam) {
        List<InputWhitelistRule.Builder> list;
        if (__listOfInputWhitelistRuleParam == null || __listOfInputWhitelistRuleParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InputWhitelistRule.Builder> modifiableList = new ArrayList<>();
            __listOfInputWhitelistRuleParam.forEach(entry -> {
                InputWhitelistRule.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
