/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Watermark Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioWatermarkSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioWatermarkSettings.Builder, AudioWatermarkSettings> {
    private static final SdkField<NielsenWatermarksSettings> NIELSEN_WATERMARKS_SETTINGS_FIELD = SdkField
            .<NielsenWatermarksSettings> builder(MarshallingType.SDK_POJO).memberName("NielsenWatermarksSettings")
            .getter(getter(AudioWatermarkSettings::nielsenWatermarksSettings)).setter(setter(Builder::nielsenWatermarksSettings))
            .constructor(NielsenWatermarksSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenWatermarksSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NIELSEN_WATERMARKS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final NielsenWatermarksSettings nielsenWatermarksSettings;

    private AudioWatermarkSettings(BuilderImpl builder) {
        this.nielsenWatermarksSettings = builder.nielsenWatermarksSettings;
    }

    /**
     * Settings to configure Nielsen Watermarks in the audio encode
     * 
     * @return Settings to configure Nielsen Watermarks in the audio encode
     */
    public final NielsenWatermarksSettings nielsenWatermarksSettings() {
        return nielsenWatermarksSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nielsenWatermarksSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioWatermarkSettings)) {
            return false;
        }
        AudioWatermarkSettings other = (AudioWatermarkSettings) obj;
        return Objects.equals(nielsenWatermarksSettings(), other.nielsenWatermarksSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioWatermarkSettings").add("NielsenWatermarksSettings", nielsenWatermarksSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NielsenWatermarksSettings":
            return Optional.ofNullable(clazz.cast(nielsenWatermarksSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioWatermarkSettings, T> g) {
        return obj -> g.apply((AudioWatermarkSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioWatermarkSettings> {
        /**
         * Settings to configure Nielsen Watermarks in the audio encode
         * 
         * @param nielsenWatermarksSettings
         *        Settings to configure Nielsen Watermarks in the audio encode
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nielsenWatermarksSettings(NielsenWatermarksSettings nielsenWatermarksSettings);

        /**
         * Settings to configure Nielsen Watermarks in the audio encode This is a convenience that creates an instance
         * of the {@link NielsenWatermarksSettings.Builder} avoiding the need to create one manually via
         * {@link NielsenWatermarksSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link NielsenWatermarksSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #nielsenWatermarksSettings(NielsenWatermarksSettings)}.
         * 
         * @param nielsenWatermarksSettings
         *        a consumer that will call methods on {@link NielsenWatermarksSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nielsenWatermarksSettings(NielsenWatermarksSettings)
         */
        default Builder nielsenWatermarksSettings(Consumer<NielsenWatermarksSettings.Builder> nielsenWatermarksSettings) {
            return nielsenWatermarksSettings(NielsenWatermarksSettings.builder().applyMutation(nielsenWatermarksSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NielsenWatermarksSettings nielsenWatermarksSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioWatermarkSettings model) {
            nielsenWatermarksSettings(model.nielsenWatermarksSettings);
        }

        public final NielsenWatermarksSettings.Builder getNielsenWatermarksSettings() {
            return nielsenWatermarksSettings != null ? nielsenWatermarksSettings.toBuilder() : null;
        }

        public final void setNielsenWatermarksSettings(NielsenWatermarksSettings.BuilderImpl nielsenWatermarksSettings) {
            this.nielsenWatermarksSettings = nielsenWatermarksSettings != null ? nielsenWatermarksSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder nielsenWatermarksSettings(NielsenWatermarksSettings nielsenWatermarksSettings) {
            this.nielsenWatermarksSettings = nielsenWatermarksSettings;
            return this;
        }

        @Override
        public AudioWatermarkSettings build() {
            return new AudioWatermarkSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
