/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A list of schedule actions to create (in a request) or that have been created (in a response).
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchScheduleActionCreateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchScheduleActionCreateRequest.Builder, BatchScheduleActionCreateRequest> {
    private static final SdkField<List<ScheduleAction>> SCHEDULE_ACTIONS_FIELD = SdkField
            .<List<ScheduleAction>> builder(MarshallingType.LIST)
            .memberName("ScheduleActions")
            .getter(getter(BatchScheduleActionCreateRequest::scheduleActions))
            .setter(setter(Builder::scheduleActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduleAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduleAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ScheduleAction> scheduleActions;

    private BatchScheduleActionCreateRequest(BuilderImpl builder) {
        this.scheduleActions = builder.scheduleActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduleActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduleActions() {
        return scheduleActions != null && !(scheduleActions instanceof SdkAutoConstructList);
    }

    /**
     * A list of schedule actions to create.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduleActions} method.
     * </p>
     * 
     * @return A list of schedule actions to create.
     */
    public final List<ScheduleAction> scheduleActions() {
        return scheduleActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduleActions() ? scheduleActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchScheduleActionCreateRequest)) {
            return false;
        }
        BatchScheduleActionCreateRequest other = (BatchScheduleActionCreateRequest) obj;
        return hasScheduleActions() == other.hasScheduleActions() && Objects.equals(scheduleActions(), other.scheduleActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchScheduleActionCreateRequest")
                .add("ScheduleActions", hasScheduleActions() ? scheduleActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleActions":
            return Optional.ofNullable(clazz.cast(scheduleActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchScheduleActionCreateRequest, T> g) {
        return obj -> g.apply((BatchScheduleActionCreateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchScheduleActionCreateRequest> {
        /**
         * A list of schedule actions to create.
         * 
         * @param scheduleActions
         *        A list of schedule actions to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActions(Collection<ScheduleAction> scheduleActions);

        /**
         * A list of schedule actions to create.
         * 
         * @param scheduleActions
         *        A list of schedule actions to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActions(ScheduleAction... scheduleActions);

        /**
         * A list of schedule actions to create. This is a convenience that creates an instance of the {@link List
         * <ScheduleAction>.Builder} avoiding the need to create one manually via {@link List<ScheduleAction>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<ScheduleAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleActions(List<ScheduleAction>)}.
         * 
         * @param scheduleActions
         *        a consumer that will call methods on {@link List<ScheduleAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleActions(List<ScheduleAction>)
         */
        Builder scheduleActions(Consumer<ScheduleAction.Builder>... scheduleActions);
    }

    static final class BuilderImpl implements Builder {
        private List<ScheduleAction> scheduleActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchScheduleActionCreateRequest model) {
            scheduleActions(model.scheduleActions);
        }

        public final List<ScheduleAction.Builder> getScheduleActions() {
            List<ScheduleAction.Builder> result = ___listOfScheduleActionCopier.copyToBuilder(this.scheduleActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduleActions(Collection<ScheduleAction.BuilderImpl> scheduleActions) {
            this.scheduleActions = ___listOfScheduleActionCopier.copyFromBuilder(scheduleActions);
        }

        @Override
        @Transient
        public final Builder scheduleActions(Collection<ScheduleAction> scheduleActions) {
            this.scheduleActions = ___listOfScheduleActionCopier.copy(scheduleActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scheduleActions(ScheduleAction... scheduleActions) {
            scheduleActions(Arrays.asList(scheduleActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scheduleActions(Consumer<ScheduleAction.Builder>... scheduleActions) {
            scheduleActions(Stream.of(scheduleActions).map(c -> ScheduleAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchScheduleActionCreateRequest build() {
            return new BatchScheduleActionCreateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
