/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for BatchStopResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStopResponse extends MediaLiveResponse implements
        ToCopyableBuilder<BatchStopResponse.Builder, BatchStopResponse> {
    private static final SdkField<List<BatchFailedResultModel>> FAILED_FIELD = SdkField
            .<List<BatchFailedResultModel>> builder(MarshallingType.LIST)
            .memberName("Failed")
            .getter(getter(BatchStopResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchFailedResultModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchFailedResultModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchSuccessfulResultModel>> SUCCESSFUL_FIELD = SdkField
            .<List<BatchSuccessfulResultModel>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(BatchStopResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchSuccessfulResultModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchSuccessfulResultModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_FIELD, SUCCESSFUL_FIELD));

    private final List<BatchFailedResultModel> failed;

    private final List<BatchSuccessfulResultModel> successful;

    private BatchStopResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
        this.successful = builder.successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failed property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * List of failed operations
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailed} method.
     * </p>
     * 
     * @return List of failed operations
     */
    public final List<BatchFailedResultModel> failed() {
        return failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * List of successful operations
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return List of successful operations
     */
    public final List<BatchSuccessfulResultModel> successful() {
        return successful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopResponse)) {
            return false;
        }
        BatchStopResponse other = (BatchStopResponse) obj;
        return hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed())
                && hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStopResponse").add("Failed", hasFailed() ? failed() : null)
                .add("Successful", hasSuccessful() ? successful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStopResponse, T> g) {
        return obj -> g.apply((BatchStopResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchStopResponse> {
        /**
         * List of failed operations
         * 
         * @param failed
         *        List of failed operations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchFailedResultModel> failed);

        /**
         * List of failed operations
         * 
         * @param failed
         *        List of failed operations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchFailedResultModel... failed);

        /**
         * List of failed operations This is a convenience that creates an instance of the {@link List
         * <BatchFailedResultModel>.Builder} avoiding the need to create one manually via {@link List
         * <BatchFailedResultModel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchFailedResultModel>.Builder#build()} is called
         * immediately and its result is passed to {@link #failed(List<BatchFailedResultModel>)}.
         * 
         * @param failed
         *        a consumer that will call methods on {@link List<BatchFailedResultModel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(List<BatchFailedResultModel>)
         */
        Builder failed(Consumer<BatchFailedResultModel.Builder>... failed);

        /**
         * List of successful operations
         * 
         * @param successful
         *        List of successful operations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<BatchSuccessfulResultModel> successful);

        /**
         * List of successful operations
         * 
         * @param successful
         *        List of successful operations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(BatchSuccessfulResultModel... successful);

        /**
         * List of successful operations This is a convenience that creates an instance of the {@link List
         * <BatchSuccessfulResultModel>.Builder} avoiding the need to create one manually via {@link List
         * <BatchSuccessfulResultModel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchSuccessfulResultModel>.Builder#build()} is called
         * immediately and its result is passed to {@link #successful(List<BatchSuccessfulResultModel>)}.
         * 
         * @param successful
         *        a consumer that will call methods on {@link List<BatchSuccessfulResultModel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(List<BatchSuccessfulResultModel>)
         */
        Builder successful(Consumer<BatchSuccessfulResultModel.Builder>... successful);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<BatchFailedResultModel> failed = DefaultSdkAutoConstructList.getInstance();

        private List<BatchSuccessfulResultModel> successful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopResponse model) {
            super(model);
            failed(model.failed);
            successful(model.successful);
        }

        public final List<BatchFailedResultModel.Builder> getFailed() {
            List<BatchFailedResultModel.Builder> result = ___listOfBatchFailedResultModelCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchFailedResultModel.BuilderImpl> failed) {
            this.failed = ___listOfBatchFailedResultModelCopier.copyFromBuilder(failed);
        }

        @Override
        @Transient
        public final Builder failed(Collection<BatchFailedResultModel> failed) {
            this.failed = ___listOfBatchFailedResultModelCopier.copy(failed);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failed(BatchFailedResultModel... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failed(Consumer<BatchFailedResultModel.Builder>... failed) {
            failed(Stream.of(failed).map(c -> BatchFailedResultModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchSuccessfulResultModel.Builder> getSuccessful() {
            List<BatchSuccessfulResultModel.Builder> result = ___listOfBatchSuccessfulResultModelCopier
                    .copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<BatchSuccessfulResultModel.BuilderImpl> successful) {
            this.successful = ___listOfBatchSuccessfulResultModelCopier.copyFromBuilder(successful);
        }

        @Override
        @Transient
        public final Builder successful(Collection<BatchSuccessfulResultModel> successful) {
            this.successful = ___listOfBatchSuccessfulResultModelCopier.copy(successful);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successful(BatchSuccessfulResultModel... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successful(Consumer<BatchSuccessfulResultModel.Builder>... successful) {
            successful(Stream.of(successful).map(c -> BatchSuccessfulResultModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchStopResponse build() {
            return new BatchStopResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
