/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Caption Description
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionDescription.Builder, CaptionDescription> {
    private static final SdkField<String> CAPTION_SELECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptionSelectorName").getter(getter(CaptionDescription::captionSelectorName))
            .setter(setter(Builder::captionSelectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectorName").build())
            .build();

    private static final SdkField<CaptionDestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<CaptionDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DestinationSettings")
            .getter(getter(CaptionDescription::destinationSettings)).setter(setter(Builder::destinationSettings))
            .constructor(CaptionDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CaptionDescription::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<String> LANGUAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageDescription").getter(getter(CaptionDescription::languageDescription))
            .setter(setter(Builder::languageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageDescription").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CaptionDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTION_SELECTOR_NAME_FIELD,
            DESTINATION_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_DESCRIPTION_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String captionSelectorName;

    private final CaptionDestinationSettings destinationSettings;

    private final String languageCode;

    private final String languageDescription;

    private final String name;

    private CaptionDescription(BuilderImpl builder) {
        this.captionSelectorName = builder.captionSelectorName;
        this.destinationSettings = builder.destinationSettings;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
        this.name = builder.name;
    }

    /**
     * Specifies which input caption selector to use as a caption source when generating output captions. This field
     * should match a captionSelector name.
     * 
     * @return Specifies which input caption selector to use as a caption source when generating output captions. This
     *         field should match a captionSelector name.
     */
    public final String captionSelectorName() {
        return captionSelectorName;
    }

    /**
     * Additional settings for captions destination that depend on the destination type.
     * 
     * @return Additional settings for captions destination that depend on the destination type.
     */
    public final CaptionDestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
     * 
     * @return ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * Human readable information to indicate captions available for players (eg. English, or Spanish).
     * 
     * @return Human readable information to indicate captions available for players (eg. English, or Spanish).
     */
    public final String languageDescription() {
        return languageDescription;
    }

    /**
     * Name of the caption description. Used to associate a caption description with an output. Names must be unique
     * within an event.
     * 
     * @return Name of the caption description. Used to associate a caption description with an output. Names must be
     *         unique within an event.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captionSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(languageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDescription)) {
            return false;
        }
        CaptionDescription other = (CaptionDescription) obj;
        return Objects.equals(captionSelectorName(), other.captionSelectorName())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(languageDescription(), other.languageDescription()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionDescription").add("CaptionSelectorName", captionSelectorName())
                .add("DestinationSettings", destinationSettings()).add("LanguageCode", languageCode())
                .add("LanguageDescription", languageDescription()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptionSelectorName":
            return Optional.ofNullable(clazz.cast(captionSelectorName()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "LanguageDescription":
            return Optional.ofNullable(clazz.cast(languageDescription()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionDescription, T> g) {
        return obj -> g.apply((CaptionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionDescription> {
        /**
         * Specifies which input caption selector to use as a caption source when generating output captions. This field
         * should match a captionSelector name.
         * 
         * @param captionSelectorName
         *        Specifies which input caption selector to use as a caption source when generating output captions.
         *        This field should match a captionSelector name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionSelectorName(String captionSelectorName);

        /**
         * Additional settings for captions destination that depend on the destination type.
         * 
         * @param destinationSettings
         *        Additional settings for captions destination that depend on the destination type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(CaptionDestinationSettings destinationSettings);

        /**
         * Additional settings for captions destination that depend on the destination type. This is a convenience that
         * creates an instance of the {@link CaptionDestinationSettings.Builder} avoiding the need to create one
         * manually via {@link CaptionDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CaptionDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationSettings(CaptionDestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link CaptionDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(CaptionDestinationSettings)
         */
        default Builder destinationSettings(Consumer<CaptionDestinationSettings.Builder> destinationSettings) {
            return destinationSettings(CaptionDestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
         * 
         * @param languageCode
         *        ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * Human readable information to indicate captions available for players (eg. English, or Spanish).
         * 
         * @param languageDescription
         *        Human readable information to indicate captions available for players (eg. English, or Spanish).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageDescription(String languageDescription);

        /**
         * Name of the caption description. Used to associate a caption description with an output. Names must be unique
         * within an event.
         * 
         * @param name
         *        Name of the caption description. Used to associate a caption description with an output. Names must be
         *        unique within an event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String captionSelectorName;

        private CaptionDestinationSettings destinationSettings;

        private String languageCode;

        private String languageDescription;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDescription model) {
            captionSelectorName(model.captionSelectorName);
            destinationSettings(model.destinationSettings);
            languageCode(model.languageCode);
            languageDescription(model.languageDescription);
            name(model.name);
        }

        public final String getCaptionSelectorName() {
            return captionSelectorName;
        }

        public final void setCaptionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
        }

        @Override
        @Transient
        public final Builder captionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
            return this;
        }

        public final CaptionDestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(CaptionDestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationSettings(CaptionDestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getLanguageDescription() {
            return languageDescription;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        @Override
        @Transient
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public CaptionDescription build() {
            return new CaptionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
