/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Maps a caption channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2), with an optional
 * description.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionLanguageMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionLanguageMapping.Builder, CaptionLanguageMapping> {
    private static final SdkField<Integer> CAPTION_CHANNEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CaptionChannel").getter(getter(CaptionLanguageMapping::captionChannel))
            .setter(setter(Builder::captionChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionChannel").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CaptionLanguageMapping::languageCode))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<String> LANGUAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageDescription").getter(getter(CaptionLanguageMapping::languageDescription))
            .setter(setter(Builder::languageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTION_CHANNEL_FIELD,
            LANGUAGE_CODE_FIELD, LANGUAGE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer captionChannel;

    private final String languageCode;

    private final String languageDescription;

    private CaptionLanguageMapping(BuilderImpl builder) {
        this.captionChannel = builder.captionChannel;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
    }

    /**
     * The closed caption channel being described by this CaptionLanguageMapping. Each channel mapping must have a
     * unique channel number (maximum of 4)
     * 
     * @return The closed caption channel being described by this CaptionLanguageMapping. Each channel mapping must have
     *         a unique channel number (maximum of 4)
     */
    public final Integer captionChannel() {
        return captionChannel;
    }

    /**
     * Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)
     * 
     * @return Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * Textual description of language
     * 
     * @return Textual description of language
     */
    public final String languageDescription() {
        return languageDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captionChannel());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(languageDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionLanguageMapping)) {
            return false;
        }
        CaptionLanguageMapping other = (CaptionLanguageMapping) obj;
        return Objects.equals(captionChannel(), other.captionChannel()) && Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(languageDescription(), other.languageDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionLanguageMapping").add("CaptionChannel", captionChannel())
                .add("LanguageCode", languageCode()).add("LanguageDescription", languageDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptionChannel":
            return Optional.ofNullable(clazz.cast(captionChannel()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "LanguageDescription":
            return Optional.ofNullable(clazz.cast(languageDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionLanguageMapping, T> g) {
        return obj -> g.apply((CaptionLanguageMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionLanguageMapping> {
        /**
         * The closed caption channel being described by this CaptionLanguageMapping. Each channel mapping must have a
         * unique channel number (maximum of 4)
         * 
         * @param captionChannel
         *        The closed caption channel being described by this CaptionLanguageMapping. Each channel mapping must
         *        have a unique channel number (maximum of 4)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionChannel(Integer captionChannel);

        /**
         * Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)
         * 
         * @param languageCode
         *        Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * Textual description of language
         * 
         * @param languageDescription
         *        Textual description of language
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageDescription(String languageDescription);
    }

    static final class BuilderImpl implements Builder {
        private Integer captionChannel;

        private String languageCode;

        private String languageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionLanguageMapping model) {
            captionChannel(model.captionChannel);
            languageCode(model.languageCode);
            languageDescription(model.languageDescription);
        }

        public final Integer getCaptionChannel() {
            return captionChannel;
        }

        public final void setCaptionChannel(Integer captionChannel) {
            this.captionChannel = captionChannel;
        }

        @Override
        @Transient
        public final Builder captionChannel(Integer captionChannel) {
            this.captionChannel = captionChannel;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getLanguageDescription() {
            return languageDescription;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        @Override
        @Transient
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        @Override
        public CaptionLanguageMapping build() {
            return new CaptionLanguageMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
