/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for CdiInputSpecification
 */
@Generated("software.amazon.awssdk:codegen")
public final class CdiInputSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<CdiInputSpecification.Builder, CdiInputSpecification> {
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resolution").getter(getter(CdiInputSpecification::resolutionAsString))
            .setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLUTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resolution;

    private CdiInputSpecification(BuilderImpl builder) {
        this.resolution = builder.resolution;
    }

    /**
     * Maximum CDI input resolution
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link CdiInputResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolutionAsString}.
     * </p>
     * 
     * @return Maximum CDI input resolution
     * @see CdiInputResolution
     */
    public final CdiInputResolution resolution() {
        return CdiInputResolution.fromValue(resolution);
    }

    /**
     * Maximum CDI input resolution
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link CdiInputResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolutionAsString}.
     * </p>
     * 
     * @return Maximum CDI input resolution
     * @see CdiInputResolution
     */
    public final String resolutionAsString() {
        return resolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resolutionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdiInputSpecification)) {
            return false;
        }
        CdiInputSpecification other = (CdiInputSpecification) obj;
        return Objects.equals(resolutionAsString(), other.resolutionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CdiInputSpecification").add("Resolution", resolutionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resolution":
            return Optional.ofNullable(clazz.cast(resolutionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CdiInputSpecification, T> g) {
        return obj -> g.apply((CdiInputSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CdiInputSpecification> {
        /**
         * Maximum CDI input resolution
         * 
         * @param resolution
         *        Maximum CDI input resolution
         * @see CdiInputResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CdiInputResolution
         */
        Builder resolution(String resolution);

        /**
         * Maximum CDI input resolution
         * 
         * @param resolution
         *        Maximum CDI input resolution
         * @see CdiInputResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CdiInputResolution
         */
        Builder resolution(CdiInputResolution resolution);
    }

    static final class BuilderImpl implements Builder {
        private String resolution;

        private BuilderImpl() {
        }

        private BuilderImpl(CdiInputSpecification model) {
            resolution(model.resolution);
        }

        public final String getResolution() {
            return resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        @Transient
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        @Transient
        public final Builder resolution(CdiInputResolution resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        @Override
        public CdiInputSpecification build() {
            return new CdiInputSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
