/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeOfferingResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOfferingResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DescribeOfferingResponse.Builder, DescribeOfferingResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeOfferingResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(DescribeOfferingResponse::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(DescribeOfferingResponse::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurationUnits").getter(getter(DescribeOfferingResponse::durationUnitsAsString))
            .setter(setter(Builder::durationUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FixedPrice").getter(getter(DescribeOfferingResponse::fixedPrice)).setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedPrice").build()).build();

    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingDescription").getter(getter(DescribeOfferingResponse::offeringDescription))
            .setter(setter(Builder::offeringDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build())
            .build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingId").getter(getter(DescribeOfferingResponse::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingType").getter(getter(DescribeOfferingResponse::offeringTypeAsString))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(DescribeOfferingResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<ReservationResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ReservationResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("ResourceSpecification")
            .getter(getter(DescribeOfferingResponse::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ReservationResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UsagePrice").getter(getter(DescribeOfferingResponse::usagePrice)).setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usagePrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CURRENCY_CODE_FIELD, DURATION_FIELD, DURATION_UNITS_FIELD, FIXED_PRICE_FIELD, OFFERING_DESCRIPTION_FIELD,
            OFFERING_ID_FIELD, OFFERING_TYPE_FIELD, REGION_FIELD, RESOURCE_SPECIFICATION_FIELD, USAGE_PRICE_FIELD));

    private final String arn;

    private final String currencyCode;

    private final Integer duration;

    private final String durationUnits;

    private final Double fixedPrice;

    private final String offeringDescription;

    private final String offeringId;

    private final String offeringType;

    private final String region;

    private final ReservationResourceSpecification resourceSpecification;

    private final Double usagePrice;

    private DescribeOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.fixedPrice = builder.fixedPrice;
        this.offeringDescription = builder.offeringDescription;
        this.offeringId = builder.offeringId;
        this.offeringType = builder.offeringType;
        this.region = builder.region;
        this.resourceSpecification = builder.resourceSpecification;
        this.usagePrice = builder.usagePrice;
    }

    /**
     * Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
     * 
     * @return Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
     */
    public final String arn() {
        return arn;
    }

    /**
     * Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
     * 
     * @return Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * Lease duration, e.g. '12'
     * 
     * @return Lease duration, e.g. '12'
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * Units for duration, e.g. 'MONTHS'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnits}
     * will return {@link OfferingDurationUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #durationUnitsAsString}.
     * </p>
     * 
     * @return Units for duration, e.g. 'MONTHS'
     * @see OfferingDurationUnits
     */
    public final OfferingDurationUnits durationUnits() {
        return OfferingDurationUnits.fromValue(durationUnits);
    }

    /**
     * Units for duration, e.g. 'MONTHS'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnits}
     * will return {@link OfferingDurationUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #durationUnitsAsString}.
     * </p>
     * 
     * @return Units for duration, e.g. 'MONTHS'
     * @see OfferingDurationUnits
     */
    public final String durationUnitsAsString() {
        return durationUnits;
    }

    /**
     * One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
     * 
     * @return One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
     */
    public final Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
     * 
     * @return Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
     */
    public final String offeringDescription() {
        return offeringDescription;
    }

    /**
     * Unique offering ID, e.g. '87654321'
     * 
     * @return Unique offering ID, e.g. '87654321'
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * Offering type, e.g. 'NO_UPFRONT'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return Offering type, e.g. 'NO_UPFRONT'
     * @see OfferingType
     */
    public final OfferingType offeringType() {
        return OfferingType.fromValue(offeringType);
    }

    /**
     * Offering type, e.g. 'NO_UPFRONT'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return Offering type, e.g. 'NO_UPFRONT'
     * @see OfferingType
     */
    public final String offeringTypeAsString() {
        return offeringType;
    }

    /**
     * AWS region, e.g. 'us-west-2'
     * 
     * @return AWS region, e.g. 'us-west-2'
     */
    public final String region() {
        return region;
    }

    /**
     * Resource configuration details
     * 
     * @return Resource configuration details
     */
    public final ReservationResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * Recurring usage charge for each reserved resource, e.g. '157.0'
     * 
     * @return Recurring usage charge for each reserved resource, e.g. '157.0'
     */
    public final Double usagePrice() {
        return usagePrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOfferingResponse)) {
            return false;
        }
        DescribeOfferingResponse other = (DescribeOfferingResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(duration(), other.duration())
                && Objects.equals(durationUnitsAsString(), other.durationUnitsAsString())
                && Objects.equals(fixedPrice(), other.fixedPrice())
                && Objects.equals(offeringDescription(), other.offeringDescription())
                && Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(offeringTypeAsString(), other.offeringTypeAsString())
                && Objects.equals(region(), other.region())
                && Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(usagePrice(), other.usagePrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOfferingResponse").add("Arn", arn()).add("CurrencyCode", currencyCode())
                .add("Duration", duration()).add("DurationUnits", durationUnitsAsString()).add("FixedPrice", fixedPrice())
                .add("OfferingDescription", offeringDescription()).add("OfferingId", offeringId())
                .add("OfferingType", offeringTypeAsString()).add("Region", region())
                .add("ResourceSpecification", resourceSpecification()).add("UsagePrice", usagePrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "DurationUnits":
            return Optional.ofNullable(clazz.cast(durationUnitsAsString()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "OfferingDescription":
            return Optional.ofNullable(clazz.cast(offeringDescription()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringTypeAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ResourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOfferingResponse, T> g) {
        return obj -> g.apply((DescribeOfferingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeOfferingResponse> {
        /**
         * Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
         * 
         * @param arn
         *        Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
         * 
         * @param currencyCode
         *        Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * Lease duration, e.g. '12'
         * 
         * @param duration
         *        Lease duration, e.g. '12'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * Units for duration, e.g. 'MONTHS'
         * 
         * @param durationUnits
         *        Units for duration, e.g. 'MONTHS'
         * @see OfferingDurationUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingDurationUnits
         */
        Builder durationUnits(String durationUnits);

        /**
         * Units for duration, e.g. 'MONTHS'
         * 
         * @param durationUnits
         *        Units for duration, e.g. 'MONTHS'
         * @see OfferingDurationUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingDurationUnits
         */
        Builder durationUnits(OfferingDurationUnits durationUnits);

        /**
         * One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
         * 
         * @param fixedPrice
         *        One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
         * 
         * @param offeringDescription
         *        Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringDescription(String offeringDescription);

        /**
         * Unique offering ID, e.g. '87654321'
         * 
         * @param offeringId
         *        Unique offering ID, e.g. '87654321'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * Offering type, e.g. 'NO_UPFRONT'
         * 
         * @param offeringType
         *        Offering type, e.g. 'NO_UPFRONT'
         * @see OfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder offeringType(String offeringType);

        /**
         * Offering type, e.g. 'NO_UPFRONT'
         * 
         * @param offeringType
         *        Offering type, e.g. 'NO_UPFRONT'
         * @see OfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingType
         */
        Builder offeringType(OfferingType offeringType);

        /**
         * AWS region, e.g. 'us-west-2'
         * 
         * @param region
         *        AWS region, e.g. 'us-west-2'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * Resource configuration details
         * 
         * @param resourceSpecification
         *        Resource configuration details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ReservationResourceSpecification resourceSpecification);

        /**
         * Resource configuration details This is a convenience that creates an instance of the
         * {@link ReservationResourceSpecification.Builder} avoiding the need to create one manually via
         * {@link ReservationResourceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSpecification(ReservationResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ReservationResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ReservationResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ReservationResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ReservationResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * Recurring usage charge for each reserved resource, e.g. '157.0'
         * 
         * @param usagePrice
         *        Recurring usage charge for each reserved resource, e.g. '157.0'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Double usagePrice);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private String currencyCode;

        private Integer duration;

        private String durationUnits;

        private Double fixedPrice;

        private String offeringDescription;

        private String offeringId;

        private String offeringType;

        private String region;

        private ReservationResourceSpecification resourceSpecification;

        private Double usagePrice;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOfferingResponse model) {
            super(model);
            arn(model.arn);
            currencyCode(model.currencyCode);
            duration(model.duration);
            durationUnits(model.durationUnits);
            fixedPrice(model.fixedPrice);
            offeringDescription(model.offeringDescription);
            offeringId(model.offeringId);
            offeringType(model.offeringType);
            region(model.region);
            resourceSpecification(model.resourceSpecification);
            usagePrice(model.usagePrice);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getDurationUnits() {
            return durationUnits;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        @Override
        @Transient
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        @Transient
        public final Builder durationUnits(OfferingDurationUnits durationUnits) {
            this.durationUnits(durationUnits == null ? null : durationUnits.toString());
            return this;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        @Transient
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final String getOfferingDescription() {
            return offeringDescription;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        @Override
        @Transient
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        @Transient
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        @Transient
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        @Transient
        public final Builder offeringType(OfferingType offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final ReservationResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ReservationResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceSpecification(ReservationResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final Double getUsagePrice() {
            return usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        @Transient
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        @Override
        public DescribeOfferingResponse build() {
            return new DescribeOfferingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
