/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * DVB Service Description Table (SDT)
 */
@Generated("software.amazon.awssdk:codegen")
public final class DvbSdtSettings implements SdkPojo, Serializable, ToCopyableBuilder<DvbSdtSettings.Builder, DvbSdtSettings> {
    private static final SdkField<String> OUTPUT_SDT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputSdt").getter(getter(DvbSdtSettings::outputSdtAsString)).setter(setter(Builder::outputSdt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSdt").build()).build();

    private static final SdkField<Integer> REP_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RepInterval").getter(getter(DvbSdtSettings::repInterval)).setter(setter(Builder::repInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repInterval").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(DvbSdtSettings::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SERVICE_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceProviderName").getter(getter(DvbSdtSettings::serviceProviderName))
            .setter(setter(Builder::serviceProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceProviderName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SDT_FIELD,
            REP_INTERVAL_FIELD, SERVICE_NAME_FIELD, SERVICE_PROVIDER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputSdt;

    private final Integer repInterval;

    private final String serviceName;

    private final String serviceProviderName;

    private DvbSdtSettings(BuilderImpl builder) {
        this.outputSdt = builder.outputSdt;
        this.repInterval = builder.repInterval;
        this.serviceName = builder.serviceName;
        this.serviceProviderName = builder.serviceProviderName;
    }

    /**
     * Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT information from
     * input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output
     * stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. The
     * sdtManual setting means user will enter the SDT information. The sdtNone setting means output stream will not
     * contain SDT information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSdt} will
     * return {@link DvbSdtOutputSdt#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputSdtAsString}.
     * </p>
     * 
     * @return Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT
     *         information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information
     *         from input stream to output stream if SDT information is present in the input, otherwise it will fall
     *         back on the user-defined values. The sdtManual setting means user will enter the SDT information. The
     *         sdtNone setting means output stream will not contain SDT information.
     * @see DvbSdtOutputSdt
     */
    public final DvbSdtOutputSdt outputSdt() {
        return DvbSdtOutputSdt.fromValue(outputSdt);
    }

    /**
     * Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT information from
     * input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output
     * stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. The
     * sdtManual setting means user will enter the SDT information. The sdtNone setting means output stream will not
     * contain SDT information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSdt} will
     * return {@link DvbSdtOutputSdt#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputSdtAsString}.
     * </p>
     * 
     * @return Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT
     *         information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information
     *         from input stream to output stream if SDT information is present in the input, otherwise it will fall
     *         back on the user-defined values. The sdtManual setting means user will enter the SDT information. The
     *         sdtNone setting means output stream will not contain SDT information.
     * @see DvbSdtOutputSdt
     */
    public final String outputSdtAsString() {
        return outputSdt;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream.
     */
    public final Integer repInterval() {
        return repInterval;
    }

    /**
     * The service name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256
     * characters.
     * 
     * @return The service name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256
     *         characters.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * The service provider name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256
     * characters.
     * 
     * @return The service provider name placed in the serviceDescriptor in the Service Description Table. Maximum
     *         length is 256 characters.
     */
    public final String serviceProviderName() {
        return serviceProviderName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputSdtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repInterval());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProviderName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSdtSettings)) {
            return false;
        }
        DvbSdtSettings other = (DvbSdtSettings) obj;
        return Objects.equals(outputSdtAsString(), other.outputSdtAsString())
                && Objects.equals(repInterval(), other.repInterval()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(serviceProviderName(), other.serviceProviderName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DvbSdtSettings").add("OutputSdt", outputSdtAsString()).add("RepInterval", repInterval())
                .add("ServiceName", serviceName()).add("ServiceProviderName", serviceProviderName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputSdt":
            return Optional.ofNullable(clazz.cast(outputSdtAsString()));
        case "RepInterval":
            return Optional.ofNullable(clazz.cast(repInterval()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceProviderName":
            return Optional.ofNullable(clazz.cast(serviceProviderName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DvbSdtSettings, T> g) {
        return obj -> g.apply((DvbSdtSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DvbSdtSettings> {
        /**
         * Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT information
         * from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream
         * to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined
         * values. The sdtManual setting means user will enter the SDT information. The sdtNone setting means output
         * stream will not contain SDT information.
         * 
         * @param outputSdt
         *        Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT
         *        information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information
         *        from input stream to output stream if SDT information is present in the input, otherwise it will fall
         *        back on the user-defined values. The sdtManual setting means user will enter the SDT information. The
         *        sdtNone setting means output stream will not contain SDT information.
         * @see DvbSdtOutputSdt
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSdtOutputSdt
         */
        Builder outputSdt(String outputSdt);

        /**
         * Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT information
         * from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream
         * to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined
         * values. The sdtManual setting means user will enter the SDT information. The sdtNone setting means output
         * stream will not contain SDT information.
         * 
         * @param outputSdt
         *        Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT
         *        information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information
         *        from input stream to output stream if SDT information is present in the input, otherwise it will fall
         *        back on the user-defined values. The sdtManual setting means user will enter the SDT information. The
         *        sdtNone setting means output stream will not contain SDT information.
         * @see DvbSdtOutputSdt
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSdtOutputSdt
         */
        Builder outputSdt(DvbSdtOutputSdt outputSdt);

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         * 
         * @param repInterval
         *        The number of milliseconds between instances of this table in the output transport stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repInterval(Integer repInterval);

        /**
         * The service name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256
         * characters.
         * 
         * @param serviceName
         *        The service name placed in the serviceDescriptor in the Service Description Table. Maximum length is
         *        256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * The service provider name placed in the serviceDescriptor in the Service Description Table. Maximum length is
         * 256 characters.
         * 
         * @param serviceProviderName
         *        The service provider name placed in the serviceDescriptor in the Service Description Table. Maximum
         *        length is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProviderName(String serviceProviderName);
    }

    static final class BuilderImpl implements Builder {
        private String outputSdt;

        private Integer repInterval;

        private String serviceName;

        private String serviceProviderName;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSdtSettings model) {
            outputSdt(model.outputSdt);
            repInterval(model.repInterval);
            serviceName(model.serviceName);
            serviceProviderName(model.serviceProviderName);
        }

        public final String getOutputSdt() {
            return outputSdt;
        }

        public final void setOutputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
        }

        @Override
        @Transient
        public final Builder outputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
            return this;
        }

        @Override
        @Transient
        public final Builder outputSdt(DvbSdtOutputSdt outputSdt) {
            this.outputSdt(outputSdt == null ? null : outputSdt.toString());
            return this;
        }

        public final Integer getRepInterval() {
            return repInterval;
        }

        public final void setRepInterval(Integer repInterval) {
            this.repInterval = repInterval;
        }

        @Override
        @Transient
        public final Builder repInterval(Integer repInterval) {
            this.repInterval = repInterval;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceProviderName() {
            return serviceProviderName;
        }

        public final void setServiceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
        }

        @Override
        @Transient
        public final Builder serviceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
            return this;
        }

        @Override
        public DvbSdtSettings build() {
            return new DvbSdtSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
