/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * DVB Time and Date Table (SDT)
 */
@Generated("software.amazon.awssdk:codegen")
public final class DvbTdtSettings implements SdkPojo, Serializable, ToCopyableBuilder<DvbTdtSettings.Builder, DvbTdtSettings> {
    private static final SdkField<Integer> REP_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RepInterval").getter(getter(DvbTdtSettings::repInterval)).setter(setter(Builder::repInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repInterval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REP_INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer repInterval;

    private DvbTdtSettings(BuilderImpl builder) {
        this.repInterval = builder.repInterval;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream.
     */
    public final Integer repInterval() {
        return repInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbTdtSettings)) {
            return false;
        }
        DvbTdtSettings other = (DvbTdtSettings) obj;
        return Objects.equals(repInterval(), other.repInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DvbTdtSettings").add("RepInterval", repInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepInterval":
            return Optional.ofNullable(clazz.cast(repInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DvbTdtSettings, T> g) {
        return obj -> g.apply((DvbTdtSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DvbTdtSettings> {
        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         * 
         * @param repInterval
         *        The number of milliseconds between instances of this table in the output transport stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repInterval(Integer repInterval);
    }

    static final class BuilderImpl implements Builder {
        private Integer repInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbTdtSettings model) {
            repInterval(model.repInterval);
        }

        public final Integer getRepInterval() {
            return repInterval;
        }

        public final void setRepInterval(Integer repInterval) {
            this.repInterval = repInterval;
        }

        @Override
        @Transient
        public final Builder repInterval(Integer repInterval) {
            this.repInterval = repInterval;
            return this;
        }

        @Override
        public DvbTdtSettings build() {
            return new DvbTdtSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
