/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Eac3 Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Eac3Settings implements SdkPojo, Serializable, ToCopyableBuilder<Eac3Settings.Builder, Eac3Settings> {
    private static final SdkField<String> ATTENUATION_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttenuationControl").getter(getter(Eac3Settings::attenuationControlAsString))
            .setter(setter(Builder::attenuationControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attenuationControl").build())
            .build();

    private static final SdkField<Double> BITRATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Bitrate")
            .getter(getter(Eac3Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BitstreamMode").getter(getter(Eac3Settings::bitstreamModeAsString))
            .setter(setter(Builder::bitstreamMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodingMode").getter(getter(Eac3Settings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<String> DC_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DcFilter").getter(getter(Eac3Settings::dcFilterAsString)).setter(setter(Builder::dcFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dcFilter").build()).build();

    private static final SdkField<Integer> DIALNORM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Dialnorm").getter(getter(Eac3Settings::dialnorm)).setter(setter(Builder::dialnorm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialnorm").build()).build();

    private static final SdkField<String> DRC_LINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DrcLine").getter(getter(Eac3Settings::drcLineAsString)).setter(setter(Builder::drcLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcLine").build()).build();

    private static final SdkField<String> DRC_RF_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DrcRf")
            .getter(getter(Eac3Settings::drcRfAsString)).setter(setter(Builder::drcRf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcRf").build()).build();

    private static final SdkField<String> LFE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LfeControl").getter(getter(Eac3Settings::lfeControlAsString)).setter(setter(Builder::lfeControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lfeControl").build()).build();

    private static final SdkField<String> LFE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LfeFilter").getter(getter(Eac3Settings::lfeFilterAsString)).setter(setter(Builder::lfeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lfeFilter").build()).build();

    private static final SdkField<Double> LO_RO_CENTER_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LoRoCenterMixLevel").getter(getter(Eac3Settings::loRoCenterMixLevel))
            .setter(setter(Builder::loRoCenterMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoCenterMixLevel").build())
            .build();

    private static final SdkField<Double> LO_RO_SURROUND_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LoRoSurroundMixLevel").getter(getter(Eac3Settings::loRoSurroundMixLevel))
            .setter(setter(Builder::loRoSurroundMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoSurroundMixLevel").build())
            .build();

    private static final SdkField<Double> LT_RT_CENTER_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LtRtCenterMixLevel").getter(getter(Eac3Settings::ltRtCenterMixLevel))
            .setter(setter(Builder::ltRtCenterMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtCenterMixLevel").build())
            .build();

    private static final SdkField<Double> LT_RT_SURROUND_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LtRtSurroundMixLevel").getter(getter(Eac3Settings::ltRtSurroundMixLevel))
            .setter(setter(Builder::ltRtSurroundMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtSurroundMixLevel").build())
            .build();

    private static final SdkField<String> METADATA_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataControl").getter(getter(Eac3Settings::metadataControlAsString))
            .setter(setter(Builder::metadataControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataControl").build()).build();

    private static final SdkField<String> PASSTHROUGH_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PassthroughControl").getter(getter(Eac3Settings::passthroughControlAsString))
            .setter(setter(Builder::passthroughControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passthroughControl").build())
            .build();

    private static final SdkField<String> PHASE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhaseControl").getter(getter(Eac3Settings::phaseControlAsString)).setter(setter(Builder::phaseControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phaseControl").build()).build();

    private static final SdkField<String> STEREO_DOWNMIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StereoDownmix").getter(getter(Eac3Settings::stereoDownmixAsString))
            .setter(setter(Builder::stereoDownmix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stereoDownmix").build()).build();

    private static final SdkField<String> SURROUND_EX_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SurroundExMode").getter(getter(Eac3Settings::surroundExModeAsString))
            .setter(setter(Builder::surroundExMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundExMode").build()).build();

    private static final SdkField<String> SURROUND_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SurroundMode").getter(getter(Eac3Settings::surroundModeAsString)).setter(setter(Builder::surroundMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENUATION_CONTROL_FIELD,
            BITRATE_FIELD, BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DC_FILTER_FIELD, DIALNORM_FIELD, DRC_LINE_FIELD,
            DRC_RF_FIELD, LFE_CONTROL_FIELD, LFE_FILTER_FIELD, LO_RO_CENTER_MIX_LEVEL_FIELD, LO_RO_SURROUND_MIX_LEVEL_FIELD,
            LT_RT_CENTER_MIX_LEVEL_FIELD, LT_RT_SURROUND_MIX_LEVEL_FIELD, METADATA_CONTROL_FIELD, PASSTHROUGH_CONTROL_FIELD,
            PHASE_CONTROL_FIELD, STEREO_DOWNMIX_FIELD, SURROUND_EX_MODE_FIELD, SURROUND_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attenuationControl;

    private final Double bitrate;

    private final String bitstreamMode;

    private final String codingMode;

    private final String dcFilter;

    private final Integer dialnorm;

    private final String drcLine;

    private final String drcRf;

    private final String lfeControl;

    private final String lfeFilter;

    private final Double loRoCenterMixLevel;

    private final Double loRoSurroundMixLevel;

    private final Double ltRtCenterMixLevel;

    private final Double ltRtSurroundMixLevel;

    private final String metadataControl;

    private final String passthroughControl;

    private final String phaseControl;

    private final String stereoDownmix;

    private final String surroundExMode;

    private final String surroundMode;

    private Eac3Settings(BuilderImpl builder) {
        this.attenuationControl = builder.attenuationControl;
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dcFilter = builder.dcFilter;
        this.dialnorm = builder.dialnorm;
        this.drcLine = builder.drcLine;
        this.drcRf = builder.drcRf;
        this.lfeControl = builder.lfeControl;
        this.lfeFilter = builder.lfeFilter;
        this.loRoCenterMixLevel = builder.loRoCenterMixLevel;
        this.loRoSurroundMixLevel = builder.loRoSurroundMixLevel;
        this.ltRtCenterMixLevel = builder.ltRtCenterMixLevel;
        this.ltRtSurroundMixLevel = builder.ltRtSurroundMixLevel;
        this.metadataControl = builder.metadataControl;
        this.passthroughControl = builder.passthroughControl;
        this.phaseControl = builder.phaseControl;
        this.stereoDownmix = builder.stereoDownmix;
        this.surroundExMode = builder.surroundExMode;
        this.surroundMode = builder.surroundMode;
    }

    /**
     * When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attenuationControl} will return {@link Eac3AttenuationControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attenuationControlAsString}.
     * </p>
     * 
     * @return When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding
     *         mode.
     * @see Eac3AttenuationControl
     */
    public final Eac3AttenuationControl attenuationControl() {
        return Eac3AttenuationControl.fromValue(attenuationControl);
    }

    /**
     * When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attenuationControl} will return {@link Eac3AttenuationControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attenuationControlAsString}.
     * </p>
     * 
     * @return When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding
     *         mode.
     * @see Eac3AttenuationControl
     */
    public final String attenuationControlAsString() {
        return attenuationControl;
    }

    /**
     * Average bitrate in bits/second. Valid bitrates depend on the coding mode.
     * 
     * @return Average bitrate in bits/second. Valid bitrates depend on the coding mode.
     */
    public final Double bitrate() {
        return bitrate;
    }

    /**
     * Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for background
     * on these values.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Eac3BitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for
     *         background on these values.
     * @see Eac3BitstreamMode
     */
    public final Eac3BitstreamMode bitstreamMode() {
        return Eac3BitstreamMode.fromValue(bitstreamMode);
    }

    /**
     * Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for background
     * on these values.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Eac3BitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for
     *         background on these values.
     * @see Eac3BitstreamMode
     */
    public final String bitstreamModeAsString() {
        return bitstreamMode;
    }

    /**
     * Dolby Digital Plus coding mode. Determines number of channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Eac3CodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Dolby Digital Plus coding mode. Determines number of channels.
     * @see Eac3CodingMode
     */
    public final Eac3CodingMode codingMode() {
        return Eac3CodingMode.fromValue(codingMode);
    }

    /**
     * Dolby Digital Plus coding mode. Determines number of channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Eac3CodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Dolby Digital Plus coding mode. Determines number of channels.
     * @see Eac3CodingMode
     */
    public final String codingModeAsString() {
        return codingMode;
    }

    /**
     * When set to enabled, activates a DC highpass filter for all input channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dcFilter} will
     * return {@link Eac3DcFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dcFilterAsString}.
     * </p>
     * 
     * @return When set to enabled, activates a DC highpass filter for all input channels.
     * @see Eac3DcFilter
     */
    public final Eac3DcFilter dcFilter() {
        return Eac3DcFilter.fromValue(dcFilter);
    }

    /**
     * When set to enabled, activates a DC highpass filter for all input channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dcFilter} will
     * return {@link Eac3DcFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dcFilterAsString}.
     * </p>
     * 
     * @return When set to enabled, activates a DC highpass filter for all input channels.
     * @see Eac3DcFilter
     */
    public final String dcFilterAsString() {
        return dcFilter;
    }

    /**
     * Sets the dialnorm for the output. If blank and input audio is Dolby Digital Plus, dialnorm will be passed
     * through.
     * 
     * @return Sets the dialnorm for the output. If blank and input audio is Dolby Digital Plus, dialnorm will be passed
     *         through.
     */
    public final Integer dialnorm() {
        return dialnorm;
    }

    /**
     * Sets the Dolby dynamic range compression profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drcLine} will
     * return {@link Eac3DrcLine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drcLineAsString}.
     * </p>
     * 
     * @return Sets the Dolby dynamic range compression profile.
     * @see Eac3DrcLine
     */
    public final Eac3DrcLine drcLine() {
        return Eac3DrcLine.fromValue(drcLine);
    }

    /**
     * Sets the Dolby dynamic range compression profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drcLine} will
     * return {@link Eac3DrcLine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drcLineAsString}.
     * </p>
     * 
     * @return Sets the Dolby dynamic range compression profile.
     * @see Eac3DrcLine
     */
    public final String drcLineAsString() {
        return drcLine;
    }

    /**
     * Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do not
     * exceed specified levels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drcRf} will return
     * {@link Eac3DrcRf#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drcRfAsString}.
     * </p>
     * 
     * @return Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks
     *         do not exceed specified levels.
     * @see Eac3DrcRf
     */
    public final Eac3DrcRf drcRf() {
        return Eac3DrcRf.fromValue(drcRf);
    }

    /**
     * Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do not
     * exceed specified levels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #drcRf} will return
     * {@link Eac3DrcRf#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #drcRfAsString}.
     * </p>
     * 
     * @return Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks
     *         do not exceed specified levels.
     * @see Eac3DrcRf
     */
    public final String drcRfAsString() {
        return drcRf;
    }

    /**
     * When encoding 3/2 audio, setting to lfe enables the LFE channel
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lfeControl} will
     * return {@link Eac3LfeControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lfeControlAsString}.
     * </p>
     * 
     * @return When encoding 3/2 audio, setting to lfe enables the LFE channel
     * @see Eac3LfeControl
     */
    public final Eac3LfeControl lfeControl() {
        return Eac3LfeControl.fromValue(lfeControl);
    }

    /**
     * When encoding 3/2 audio, setting to lfe enables the LFE channel
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lfeControl} will
     * return {@link Eac3LfeControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lfeControlAsString}.
     * </p>
     * 
     * @return When encoding 3/2 audio, setting to lfe enables the LFE channel
     * @see Eac3LfeControl
     */
    public final String lfeControlAsString() {
        return lfeControl;
    }

    /**
     * When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with
     * codingMode32 coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lfeFilter} will
     * return {@link Eac3LfeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lfeFilterAsString}.
     * </p>
     * 
     * @return When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with
     *         codingMode32 coding mode.
     * @see Eac3LfeFilter
     */
    public final Eac3LfeFilter lfeFilter() {
        return Eac3LfeFilter.fromValue(lfeFilter);
    }

    /**
     * When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with
     * codingMode32 coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lfeFilter} will
     * return {@link Eac3LfeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lfeFilterAsString}.
     * </p>
     * 
     * @return When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with
     *         codingMode32 coding mode.
     * @see Eac3LfeFilter
     */
    public final String lfeFilterAsString() {
        return lfeFilter;
    }

    /**
     * Left only/Right only center mix level. Only used for 3/2 coding mode.
     * 
     * @return Left only/Right only center mix level. Only used for 3/2 coding mode.
     */
    public final Double loRoCenterMixLevel() {
        return loRoCenterMixLevel;
    }

    /**
     * Left only/Right only surround mix level. Only used for 3/2 coding mode.
     * 
     * @return Left only/Right only surround mix level. Only used for 3/2 coding mode.
     */
    public final Double loRoSurroundMixLevel() {
        return loRoSurroundMixLevel;
    }

    /**
     * Left total/Right total center mix level. Only used for 3/2 coding mode.
     * 
     * @return Left total/Right total center mix level. Only used for 3/2 coding mode.
     */
    public final Double ltRtCenterMixLevel() {
        return ltRtCenterMixLevel;
    }

    /**
     * Left total/Right total surround mix level. Only used for 3/2 coding mode.
     * 
     * @return Left total/Right total surround mix level. Only used for 3/2 coding mode.
     */
    public final Double ltRtSurroundMixLevel() {
        return ltRtSurroundMixLevel;
    }

    /**
     * When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this
     * audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataControl}
     * will return {@link Eac3MetadataControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metadataControlAsString}.
     * </p>
     * 
     * @return When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
     *         supplied this audio data. If audio was not supplied from one of these streams, then the static metadata
     *         settings will be used.
     * @see Eac3MetadataControl
     */
    public final Eac3MetadataControl metadataControl() {
        return Eac3MetadataControl.fromValue(metadataControl);
    }

    /**
     * When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this
     * audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataControl}
     * will return {@link Eac3MetadataControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metadataControlAsString}.
     * </p>
     * 
     * @return When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
     *         supplied this audio data. If audio was not supplied from one of these streams, then the static metadata
     *         settings will be used.
     * @see Eac3MetadataControl
     */
    public final String metadataControlAsString() {
        return metadataControl;
    }

    /**
     * When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This detection is
     * dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a
     * consistent DD+ output as the system alternates between passthrough and encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #passthroughControl} will return {@link Eac3PassthroughControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #passthroughControlAsString}.
     * </p>
     * 
     * @return When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This
     *         detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+
     *         content will have a consistent DD+ output as the system alternates between passthrough and encoding.
     * @see Eac3PassthroughControl
     */
    public final Eac3PassthroughControl passthroughControl() {
        return Eac3PassthroughControl.fromValue(passthroughControl);
    }

    /**
     * When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This detection is
     * dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a
     * consistent DD+ output as the system alternates between passthrough and encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #passthroughControl} will return {@link Eac3PassthroughControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #passthroughControlAsString}.
     * </p>
     * 
     * @return When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This
     *         detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+
     *         content will have a consistent DD+ output as the system alternates between passthrough and encoding.
     * @see Eac3PassthroughControl
     */
    public final String passthroughControlAsString() {
        return passthroughControl;
    }

    /**
     * When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for 3/2 coding
     * mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phaseControl} will
     * return {@link Eac3PhaseControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #phaseControlAsString}.
     * </p>
     * 
     * @return When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for 3/2
     *         coding mode.
     * @see Eac3PhaseControl
     */
    public final Eac3PhaseControl phaseControl() {
        return Eac3PhaseControl.fromValue(phaseControl);
    }

    /**
     * When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for 3/2 coding
     * mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phaseControl} will
     * return {@link Eac3PhaseControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #phaseControlAsString}.
     * </p>
     * 
     * @return When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for 3/2
     *         coding mode.
     * @see Eac3PhaseControl
     */
    public final String phaseControlAsString() {
        return phaseControl;
    }

    /**
     * Stereo downmix preference. Only used for 3/2 coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stereoDownmix}
     * will return {@link Eac3StereoDownmix#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stereoDownmixAsString}.
     * </p>
     * 
     * @return Stereo downmix preference. Only used for 3/2 coding mode.
     * @see Eac3StereoDownmix
     */
    public final Eac3StereoDownmix stereoDownmix() {
        return Eac3StereoDownmix.fromValue(stereoDownmix);
    }

    /**
     * Stereo downmix preference. Only used for 3/2 coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stereoDownmix}
     * will return {@link Eac3StereoDownmix#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stereoDownmixAsString}.
     * </p>
     * 
     * @return Stereo downmix preference. Only used for 3/2 coding mode.
     * @see Eac3StereoDownmix
     */
    public final String stereoDownmixAsString() {
        return stereoDownmix;
    }

    /**
     * When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and
     * right surround channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #surroundExMode}
     * will return {@link Eac3SurroundExMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #surroundExModeAsString}.
     * </p>
     * 
     * @return When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the
     *         left and right surround channels.
     * @see Eac3SurroundExMode
     */
    public final Eac3SurroundExMode surroundExMode() {
        return Eac3SurroundExMode.fromValue(surroundExMode);
    }

    /**
     * When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and
     * right surround channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #surroundExMode}
     * will return {@link Eac3SurroundExMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #surroundExModeAsString}.
     * </p>
     * 
     * @return When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the
     *         left and right surround channels.
     * @see Eac3SurroundExMode
     */
    public final String surroundExModeAsString() {
        return surroundExMode;
    }

    /**
     * When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #surroundMode} will
     * return {@link Eac3SurroundMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #surroundModeAsString}.
     * </p>
     * 
     * @return When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
     * @see Eac3SurroundMode
     */
    public final Eac3SurroundMode surroundMode() {
        return Eac3SurroundMode.fromValue(surroundMode);
    }

    /**
     * When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #surroundMode} will
     * return {@link Eac3SurroundMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #surroundModeAsString}.
     * </p>
     * 
     * @return When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
     * @see Eac3SurroundMode
     */
    public final String surroundModeAsString() {
        return surroundMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attenuationControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dcFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(drcLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(drcRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lfeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lfeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loRoCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(loRoSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(ltRtCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(ltRtSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(metadataControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(passthroughControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phaseControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stereoDownmixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(surroundExModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(surroundModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eac3Settings)) {
            return false;
        }
        Eac3Settings other = (Eac3Settings) obj;
        return Objects.equals(attenuationControlAsString(), other.attenuationControlAsString())
                && Objects.equals(bitrate(), other.bitrate())
                && Objects.equals(bitstreamModeAsString(), other.bitstreamModeAsString())
                && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(dcFilterAsString(), other.dcFilterAsString()) && Objects.equals(dialnorm(), other.dialnorm())
                && Objects.equals(drcLineAsString(), other.drcLineAsString())
                && Objects.equals(drcRfAsString(), other.drcRfAsString())
                && Objects.equals(lfeControlAsString(), other.lfeControlAsString())
                && Objects.equals(lfeFilterAsString(), other.lfeFilterAsString())
                && Objects.equals(loRoCenterMixLevel(), other.loRoCenterMixLevel())
                && Objects.equals(loRoSurroundMixLevel(), other.loRoSurroundMixLevel())
                && Objects.equals(ltRtCenterMixLevel(), other.ltRtCenterMixLevel())
                && Objects.equals(ltRtSurroundMixLevel(), other.ltRtSurroundMixLevel())
                && Objects.equals(metadataControlAsString(), other.metadataControlAsString())
                && Objects.equals(passthroughControlAsString(), other.passthroughControlAsString())
                && Objects.equals(phaseControlAsString(), other.phaseControlAsString())
                && Objects.equals(stereoDownmixAsString(), other.stereoDownmixAsString())
                && Objects.equals(surroundExModeAsString(), other.surroundExModeAsString())
                && Objects.equals(surroundModeAsString(), other.surroundModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Eac3Settings").add("AttenuationControl", attenuationControlAsString()).add("Bitrate", bitrate())
                .add("BitstreamMode", bitstreamModeAsString()).add("CodingMode", codingModeAsString())
                .add("DcFilter", dcFilterAsString()).add("Dialnorm", dialnorm()).add("DrcLine", drcLineAsString())
                .add("DrcRf", drcRfAsString()).add("LfeControl", lfeControlAsString()).add("LfeFilter", lfeFilterAsString())
                .add("LoRoCenterMixLevel", loRoCenterMixLevel()).add("LoRoSurroundMixLevel", loRoSurroundMixLevel())
                .add("LtRtCenterMixLevel", ltRtCenterMixLevel()).add("LtRtSurroundMixLevel", ltRtSurroundMixLevel())
                .add("MetadataControl", metadataControlAsString()).add("PassthroughControl", passthroughControlAsString())
                .add("PhaseControl", phaseControlAsString()).add("StereoDownmix", stereoDownmixAsString())
                .add("SurroundExMode", surroundExModeAsString()).add("SurroundMode", surroundModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttenuationControl":
            return Optional.ofNullable(clazz.cast(attenuationControlAsString()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "BitstreamMode":
            return Optional.ofNullable(clazz.cast(bitstreamModeAsString()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "DcFilter":
            return Optional.ofNullable(clazz.cast(dcFilterAsString()));
        case "Dialnorm":
            return Optional.ofNullable(clazz.cast(dialnorm()));
        case "DrcLine":
            return Optional.ofNullable(clazz.cast(drcLineAsString()));
        case "DrcRf":
            return Optional.ofNullable(clazz.cast(drcRfAsString()));
        case "LfeControl":
            return Optional.ofNullable(clazz.cast(lfeControlAsString()));
        case "LfeFilter":
            return Optional.ofNullable(clazz.cast(lfeFilterAsString()));
        case "LoRoCenterMixLevel":
            return Optional.ofNullable(clazz.cast(loRoCenterMixLevel()));
        case "LoRoSurroundMixLevel":
            return Optional.ofNullable(clazz.cast(loRoSurroundMixLevel()));
        case "LtRtCenterMixLevel":
            return Optional.ofNullable(clazz.cast(ltRtCenterMixLevel()));
        case "LtRtSurroundMixLevel":
            return Optional.ofNullable(clazz.cast(ltRtSurroundMixLevel()));
        case "MetadataControl":
            return Optional.ofNullable(clazz.cast(metadataControlAsString()));
        case "PassthroughControl":
            return Optional.ofNullable(clazz.cast(passthroughControlAsString()));
        case "PhaseControl":
            return Optional.ofNullable(clazz.cast(phaseControlAsString()));
        case "StereoDownmix":
            return Optional.ofNullable(clazz.cast(stereoDownmixAsString()));
        case "SurroundExMode":
            return Optional.ofNullable(clazz.cast(surroundExModeAsString()));
        case "SurroundMode":
            return Optional.ofNullable(clazz.cast(surroundModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Eac3Settings, T> g) {
        return obj -> g.apply((Eac3Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Eac3Settings> {
        /**
         * When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.
         * 
         * @param attenuationControl
         *        When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2
         *        coding mode.
         * @see Eac3AttenuationControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AttenuationControl
         */
        Builder attenuationControl(String attenuationControl);

        /**
         * When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.
         * 
         * @param attenuationControl
         *        When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2
         *        coding mode.
         * @see Eac3AttenuationControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AttenuationControl
         */
        Builder attenuationControl(Eac3AttenuationControl attenuationControl);

        /**
         * Average bitrate in bits/second. Valid bitrates depend on the coding mode.
         * 
         * @param bitrate
         *        Average bitrate in bits/second. Valid bitrates depend on the coding mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Double bitrate);

        /**
         * Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for
         * background on these values.
         * 
         * @param bitstreamMode
         *        Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for
         *        background on these values.
         * @see Eac3BitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3BitstreamMode
         */
        Builder bitstreamMode(String bitstreamMode);

        /**
         * Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for
         * background on these values.
         * 
         * @param bitstreamMode
         *        Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for
         *        background on these values.
         * @see Eac3BitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3BitstreamMode
         */
        Builder bitstreamMode(Eac3BitstreamMode bitstreamMode);

        /**
         * Dolby Digital Plus coding mode. Determines number of channels.
         * 
         * @param codingMode
         *        Dolby Digital Plus coding mode. Determines number of channels.
         * @see Eac3CodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3CodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * Dolby Digital Plus coding mode. Determines number of channels.
         * 
         * @param codingMode
         *        Dolby Digital Plus coding mode. Determines number of channels.
         * @see Eac3CodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3CodingMode
         */
        Builder codingMode(Eac3CodingMode codingMode);

        /**
         * When set to enabled, activates a DC highpass filter for all input channels.
         * 
         * @param dcFilter
         *        When set to enabled, activates a DC highpass filter for all input channels.
         * @see Eac3DcFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3DcFilter
         */
        Builder dcFilter(String dcFilter);

        /**
         * When set to enabled, activates a DC highpass filter for all input channels.
         * 
         * @param dcFilter
         *        When set to enabled, activates a DC highpass filter for all input channels.
         * @see Eac3DcFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3DcFilter
         */
        Builder dcFilter(Eac3DcFilter dcFilter);

        /**
         * Sets the dialnorm for the output. If blank and input audio is Dolby Digital Plus, dialnorm will be passed
         * through.
         * 
         * @param dialnorm
         *        Sets the dialnorm for the output. If blank and input audio is Dolby Digital Plus, dialnorm will be
         *        passed through.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialnorm(Integer dialnorm);

        /**
         * Sets the Dolby dynamic range compression profile.
         * 
         * @param drcLine
         *        Sets the Dolby dynamic range compression profile.
         * @see Eac3DrcLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3DrcLine
         */
        Builder drcLine(String drcLine);

        /**
         * Sets the Dolby dynamic range compression profile.
         * 
         * @param drcLine
         *        Sets the Dolby dynamic range compression profile.
         * @see Eac3DrcLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3DrcLine
         */
        Builder drcLine(Eac3DrcLine drcLine);

        /**
         * Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do
         * not exceed specified levels.
         * 
         * @param drcRf
         *        Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal
         *        peaks do not exceed specified levels.
         * @see Eac3DrcRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3DrcRf
         */
        Builder drcRf(String drcRf);

        /**
         * Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do
         * not exceed specified levels.
         * 
         * @param drcRf
         *        Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal
         *        peaks do not exceed specified levels.
         * @see Eac3DrcRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3DrcRf
         */
        Builder drcRf(Eac3DrcRf drcRf);

        /**
         * When encoding 3/2 audio, setting to lfe enables the LFE channel
         * 
         * @param lfeControl
         *        When encoding 3/2 audio, setting to lfe enables the LFE channel
         * @see Eac3LfeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3LfeControl
         */
        Builder lfeControl(String lfeControl);

        /**
         * When encoding 3/2 audio, setting to lfe enables the LFE channel
         * 
         * @param lfeControl
         *        When encoding 3/2 audio, setting to lfe enables the LFE channel
         * @see Eac3LfeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3LfeControl
         */
        Builder lfeControl(Eac3LfeControl lfeControl);

        /**
         * When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with
         * codingMode32 coding mode.
         * 
         * @param lfeFilter
         *        When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid
         *        with codingMode32 coding mode.
         * @see Eac3LfeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3LfeFilter
         */
        Builder lfeFilter(String lfeFilter);

        /**
         * When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with
         * codingMode32 coding mode.
         * 
         * @param lfeFilter
         *        When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid
         *        with codingMode32 coding mode.
         * @see Eac3LfeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3LfeFilter
         */
        Builder lfeFilter(Eac3LfeFilter lfeFilter);

        /**
         * Left only/Right only center mix level. Only used for 3/2 coding mode.
         * 
         * @param loRoCenterMixLevel
         *        Left only/Right only center mix level. Only used for 3/2 coding mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRoCenterMixLevel(Double loRoCenterMixLevel);

        /**
         * Left only/Right only surround mix level. Only used for 3/2 coding mode.
         * 
         * @param loRoSurroundMixLevel
         *        Left only/Right only surround mix level. Only used for 3/2 coding mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel);

        /**
         * Left total/Right total center mix level. Only used for 3/2 coding mode.
         * 
         * @param ltRtCenterMixLevel
         *        Left total/Right total center mix level. Only used for 3/2 coding mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel);

        /**
         * Left total/Right total surround mix level. Only used for 3/2 coding mode.
         * 
         * @param ltRtSurroundMixLevel
         *        Left total/Right total surround mix level. Only used for 3/2 coding mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel);

        /**
         * When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied
         * this audio data. If audio was not supplied from one of these streams, then the static metadata settings will
         * be used.
         * 
         * @param metadataControl
         *        When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
         *        supplied this audio data. If audio was not supplied from one of these streams, then the static
         *        metadata settings will be used.
         * @see Eac3MetadataControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3MetadataControl
         */
        Builder metadataControl(String metadataControl);

        /**
         * When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied
         * this audio data. If audio was not supplied from one of these streams, then the static metadata settings will
         * be used.
         * 
         * @param metadataControl
         *        When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
         *        supplied this audio data. If audio was not supplied from one of these streams, then the static
         *        metadata settings will be used.
         * @see Eac3MetadataControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3MetadataControl
         */
        Builder metadataControl(Eac3MetadataControl metadataControl);

        /**
         * When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This
         * detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content
         * will have a consistent DD+ output as the system alternates between passthrough and encoding.
         * 
         * @param passthroughControl
         *        When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This
         *        detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+
         *        content will have a consistent DD+ output as the system alternates between passthrough and encoding.
         * @see Eac3PassthroughControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3PassthroughControl
         */
        Builder passthroughControl(String passthroughControl);

        /**
         * When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This
         * detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content
         * will have a consistent DD+ output as the system alternates between passthrough and encoding.
         * 
         * @param passthroughControl
         *        When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This
         *        detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+
         *        content will have a consistent DD+ output as the system alternates between passthrough and encoding.
         * @see Eac3PassthroughControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3PassthroughControl
         */
        Builder passthroughControl(Eac3PassthroughControl passthroughControl);

        /**
         * When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for 3/2
         * coding mode.
         * 
         * @param phaseControl
         *        When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for
         *        3/2 coding mode.
         * @see Eac3PhaseControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3PhaseControl
         */
        Builder phaseControl(String phaseControl);

        /**
         * When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for 3/2
         * coding mode.
         * 
         * @param phaseControl
         *        When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for
         *        3/2 coding mode.
         * @see Eac3PhaseControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3PhaseControl
         */
        Builder phaseControl(Eac3PhaseControl phaseControl);

        /**
         * Stereo downmix preference. Only used for 3/2 coding mode.
         * 
         * @param stereoDownmix
         *        Stereo downmix preference. Only used for 3/2 coding mode.
         * @see Eac3StereoDownmix
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3StereoDownmix
         */
        Builder stereoDownmix(String stereoDownmix);

        /**
         * Stereo downmix preference. Only used for 3/2 coding mode.
         * 
         * @param stereoDownmix
         *        Stereo downmix preference. Only used for 3/2 coding mode.
         * @see Eac3StereoDownmix
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3StereoDownmix
         */
        Builder stereoDownmix(Eac3StereoDownmix stereoDownmix);

        /**
         * When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left
         * and right surround channels.
         * 
         * @param surroundExMode
         *        When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the
         *        left and right surround channels.
         * @see Eac3SurroundExMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3SurroundExMode
         */
        Builder surroundExMode(String surroundExMode);

        /**
         * When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left
         * and right surround channels.
         * 
         * @param surroundExMode
         *        When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the
         *        left and right surround channels.
         * @see Eac3SurroundExMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3SurroundExMode
         */
        Builder surroundExMode(Eac3SurroundExMode surroundExMode);

        /**
         * When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
         * 
         * @param surroundMode
         *        When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
         * @see Eac3SurroundMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3SurroundMode
         */
        Builder surroundMode(String surroundMode);

        /**
         * When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
         * 
         * @param surroundMode
         *        When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.
         * @see Eac3SurroundMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3SurroundMode
         */
        Builder surroundMode(Eac3SurroundMode surroundMode);
    }

    static final class BuilderImpl implements Builder {
        private String attenuationControl;

        private Double bitrate;

        private String bitstreamMode;

        private String codingMode;

        private String dcFilter;

        private Integer dialnorm;

        private String drcLine;

        private String drcRf;

        private String lfeControl;

        private String lfeFilter;

        private Double loRoCenterMixLevel;

        private Double loRoSurroundMixLevel;

        private Double ltRtCenterMixLevel;

        private Double ltRtSurroundMixLevel;

        private String metadataControl;

        private String passthroughControl;

        private String phaseControl;

        private String stereoDownmix;

        private String surroundExMode;

        private String surroundMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Eac3Settings model) {
            attenuationControl(model.attenuationControl);
            bitrate(model.bitrate);
            bitstreamMode(model.bitstreamMode);
            codingMode(model.codingMode);
            dcFilter(model.dcFilter);
            dialnorm(model.dialnorm);
            drcLine(model.drcLine);
            drcRf(model.drcRf);
            lfeControl(model.lfeControl);
            lfeFilter(model.lfeFilter);
            loRoCenterMixLevel(model.loRoCenterMixLevel);
            loRoSurroundMixLevel(model.loRoSurroundMixLevel);
            ltRtCenterMixLevel(model.ltRtCenterMixLevel);
            ltRtSurroundMixLevel(model.ltRtSurroundMixLevel);
            metadataControl(model.metadataControl);
            passthroughControl(model.passthroughControl);
            phaseControl(model.phaseControl);
            stereoDownmix(model.stereoDownmix);
            surroundExMode(model.surroundExMode);
            surroundMode(model.surroundMode);
        }

        public final String getAttenuationControl() {
            return attenuationControl;
        }

        public final void setAttenuationControl(String attenuationControl) {
            this.attenuationControl = attenuationControl;
        }

        @Override
        @Transient
        public final Builder attenuationControl(String attenuationControl) {
            this.attenuationControl = attenuationControl;
            return this;
        }

        @Override
        @Transient
        public final Builder attenuationControl(Eac3AttenuationControl attenuationControl) {
            this.attenuationControl(attenuationControl == null ? null : attenuationControl.toString());
            return this;
        }

        public final Double getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        @Transient
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getBitstreamMode() {
            return bitstreamMode;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        @Override
        @Transient
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        @Transient
        public final Builder bitstreamMode(Eac3BitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        @Transient
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder codingMode(Eac3CodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final String getDcFilter() {
            return dcFilter;
        }

        public final void setDcFilter(String dcFilter) {
            this.dcFilter = dcFilter;
        }

        @Override
        @Transient
        public final Builder dcFilter(String dcFilter) {
            this.dcFilter = dcFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder dcFilter(Eac3DcFilter dcFilter) {
            this.dcFilter(dcFilter == null ? null : dcFilter.toString());
            return this;
        }

        public final Integer getDialnorm() {
            return dialnorm;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        @Override
        @Transient
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final String getDrcLine() {
            return drcLine;
        }

        public final void setDrcLine(String drcLine) {
            this.drcLine = drcLine;
        }

        @Override
        @Transient
        public final Builder drcLine(String drcLine) {
            this.drcLine = drcLine;
            return this;
        }

        @Override
        @Transient
        public final Builder drcLine(Eac3DrcLine drcLine) {
            this.drcLine(drcLine == null ? null : drcLine.toString());
            return this;
        }

        public final String getDrcRf() {
            return drcRf;
        }

        public final void setDrcRf(String drcRf) {
            this.drcRf = drcRf;
        }

        @Override
        @Transient
        public final Builder drcRf(String drcRf) {
            this.drcRf = drcRf;
            return this;
        }

        @Override
        @Transient
        public final Builder drcRf(Eac3DrcRf drcRf) {
            this.drcRf(drcRf == null ? null : drcRf.toString());
            return this;
        }

        public final String getLfeControl() {
            return lfeControl;
        }

        public final void setLfeControl(String lfeControl) {
            this.lfeControl = lfeControl;
        }

        @Override
        @Transient
        public final Builder lfeControl(String lfeControl) {
            this.lfeControl = lfeControl;
            return this;
        }

        @Override
        @Transient
        public final Builder lfeControl(Eac3LfeControl lfeControl) {
            this.lfeControl(lfeControl == null ? null : lfeControl.toString());
            return this;
        }

        public final String getLfeFilter() {
            return lfeFilter;
        }

        public final void setLfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
        }

        @Override
        @Transient
        public final Builder lfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder lfeFilter(Eac3LfeFilter lfeFilter) {
            this.lfeFilter(lfeFilter == null ? null : lfeFilter.toString());
            return this;
        }

        public final Double getLoRoCenterMixLevel() {
            return loRoCenterMixLevel;
        }

        public final void setLoRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
        }

        @Override
        @Transient
        public final Builder loRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
            return this;
        }

        public final Double getLoRoSurroundMixLevel() {
            return loRoSurroundMixLevel;
        }

        public final void setLoRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
        }

        @Override
        @Transient
        public final Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
            return this;
        }

        public final Double getLtRtCenterMixLevel() {
            return ltRtCenterMixLevel;
        }

        public final void setLtRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
        }

        @Override
        @Transient
        public final Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
            return this;
        }

        public final Double getLtRtSurroundMixLevel() {
            return ltRtSurroundMixLevel;
        }

        public final void setLtRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
        }

        @Override
        @Transient
        public final Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
            return this;
        }

        public final String getMetadataControl() {
            return metadataControl;
        }

        public final void setMetadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
        }

        @Override
        @Transient
        public final Builder metadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
            return this;
        }

        @Override
        @Transient
        public final Builder metadataControl(Eac3MetadataControl metadataControl) {
            this.metadataControl(metadataControl == null ? null : metadataControl.toString());
            return this;
        }

        public final String getPassthroughControl() {
            return passthroughControl;
        }

        public final void setPassthroughControl(String passthroughControl) {
            this.passthroughControl = passthroughControl;
        }

        @Override
        @Transient
        public final Builder passthroughControl(String passthroughControl) {
            this.passthroughControl = passthroughControl;
            return this;
        }

        @Override
        @Transient
        public final Builder passthroughControl(Eac3PassthroughControl passthroughControl) {
            this.passthroughControl(passthroughControl == null ? null : passthroughControl.toString());
            return this;
        }

        public final String getPhaseControl() {
            return phaseControl;
        }

        public final void setPhaseControl(String phaseControl) {
            this.phaseControl = phaseControl;
        }

        @Override
        @Transient
        public final Builder phaseControl(String phaseControl) {
            this.phaseControl = phaseControl;
            return this;
        }

        @Override
        @Transient
        public final Builder phaseControl(Eac3PhaseControl phaseControl) {
            this.phaseControl(phaseControl == null ? null : phaseControl.toString());
            return this;
        }

        public final String getStereoDownmix() {
            return stereoDownmix;
        }

        public final void setStereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
        }

        @Override
        @Transient
        public final Builder stereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
            return this;
        }

        @Override
        @Transient
        public final Builder stereoDownmix(Eac3StereoDownmix stereoDownmix) {
            this.stereoDownmix(stereoDownmix == null ? null : stereoDownmix.toString());
            return this;
        }

        public final String getSurroundExMode() {
            return surroundExMode;
        }

        public final void setSurroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
        }

        @Override
        @Transient
        public final Builder surroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
            return this;
        }

        @Override
        @Transient
        public final Builder surroundExMode(Eac3SurroundExMode surroundExMode) {
            this.surroundExMode(surroundExMode == null ? null : surroundExMode.toString());
            return this;
        }

        public final String getSurroundMode() {
            return surroundMode;
        }

        public final void setSurroundMode(String surroundMode) {
            this.surroundMode = surroundMode;
        }

        @Override
        @Transient
        public final Builder surroundMode(String surroundMode) {
            this.surroundMode = surroundMode;
            return this;
        }

        @Override
        @Transient
        public final Builder surroundMode(Eac3SurroundMode surroundMode) {
            this.surroundMode(surroundMode == null ? null : surroundMode.toString());
            return this;
        }

        @Override
        public Eac3Settings build() {
            return new Eac3Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
