/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * H264 Color Space Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class H264ColorSpaceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<H264ColorSpaceSettings.Builder, H264ColorSpaceSettings> {
    private static final SdkField<ColorSpacePassthroughSettings> COLOR_SPACE_PASSTHROUGH_SETTINGS_FIELD = SdkField
            .<ColorSpacePassthroughSettings> builder(MarshallingType.SDK_POJO)
            .memberName("ColorSpacePassthroughSettings")
            .getter(getter(H264ColorSpaceSettings::colorSpacePassthroughSettings))
            .setter(setter(Builder::colorSpacePassthroughSettings))
            .constructor(ColorSpacePassthroughSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpacePassthroughSettings")
                    .build()).build();

    private static final SdkField<Rec601Settings> REC601_SETTINGS_FIELD = SdkField
            .<Rec601Settings> builder(MarshallingType.SDK_POJO).memberName("Rec601Settings")
            .getter(getter(H264ColorSpaceSettings::rec601Settings)).setter(setter(Builder::rec601Settings))
            .constructor(Rec601Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rec601Settings").build()).build();

    private static final SdkField<Rec709Settings> REC709_SETTINGS_FIELD = SdkField
            .<Rec709Settings> builder(MarshallingType.SDK_POJO).memberName("Rec709Settings")
            .getter(getter(H264ColorSpaceSettings::rec709Settings)).setter(setter(Builder::rec709Settings))
            .constructor(Rec709Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rec709Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLOR_SPACE_PASSTHROUGH_SETTINGS_FIELD, REC601_SETTINGS_FIELD, REC709_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ColorSpacePassthroughSettings colorSpacePassthroughSettings;

    private final Rec601Settings rec601Settings;

    private final Rec709Settings rec709Settings;

    private H264ColorSpaceSettings(BuilderImpl builder) {
        this.colorSpacePassthroughSettings = builder.colorSpacePassthroughSettings;
        this.rec601Settings = builder.rec601Settings;
        this.rec709Settings = builder.rec709Settings;
    }

    /**
     * Returns the value of the ColorSpacePassthroughSettings property for this object.
     * 
     * @return The value of the ColorSpacePassthroughSettings property for this object.
     */
    public final ColorSpacePassthroughSettings colorSpacePassthroughSettings() {
        return colorSpacePassthroughSettings;
    }

    /**
     * Returns the value of the Rec601Settings property for this object.
     * 
     * @return The value of the Rec601Settings property for this object.
     */
    public final Rec601Settings rec601Settings() {
        return rec601Settings;
    }

    /**
     * Returns the value of the Rec709Settings property for this object.
     * 
     * @return The value of the Rec709Settings property for this object.
     */
    public final Rec709Settings rec709Settings() {
        return rec709Settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(colorSpacePassthroughSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rec601Settings());
        hashCode = 31 * hashCode + Objects.hashCode(rec709Settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264ColorSpaceSettings)) {
            return false;
        }
        H264ColorSpaceSettings other = (H264ColorSpaceSettings) obj;
        return Objects.equals(colorSpacePassthroughSettings(), other.colorSpacePassthroughSettings())
                && Objects.equals(rec601Settings(), other.rec601Settings())
                && Objects.equals(rec709Settings(), other.rec709Settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("H264ColorSpaceSettings").add("ColorSpacePassthroughSettings", colorSpacePassthroughSettings())
                .add("Rec601Settings", rec601Settings()).add("Rec709Settings", rec709Settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColorSpacePassthroughSettings":
            return Optional.ofNullable(clazz.cast(colorSpacePassthroughSettings()));
        case "Rec601Settings":
            return Optional.ofNullable(clazz.cast(rec601Settings()));
        case "Rec709Settings":
            return Optional.ofNullable(clazz.cast(rec709Settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264ColorSpaceSettings, T> g) {
        return obj -> g.apply((H264ColorSpaceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H264ColorSpaceSettings> {
        /**
         * Sets the value of the ColorSpacePassthroughSettings property for this object.
         *
         * @param colorSpacePassthroughSettings
         *        The new value for the ColorSpacePassthroughSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettings colorSpacePassthroughSettings);

        /**
         * Sets the value of the ColorSpacePassthroughSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link ColorSpacePassthroughSettings.Builder} avoiding
         * the need to create one manually via {@link ColorSpacePassthroughSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ColorSpacePassthroughSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #colorSpacePassthroughSettings(ColorSpacePassthroughSettings)}
         * .
         * 
         * @param colorSpacePassthroughSettings
         *        a consumer that will call methods on {@link ColorSpacePassthroughSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorSpacePassthroughSettings(ColorSpacePassthroughSettings)
         */
        default Builder colorSpacePassthroughSettings(
                Consumer<ColorSpacePassthroughSettings.Builder> colorSpacePassthroughSettings) {
            return colorSpacePassthroughSettings(ColorSpacePassthroughSettings.builder()
                    .applyMutation(colorSpacePassthroughSettings).build());
        }

        /**
         * Sets the value of the Rec601Settings property for this object.
         *
         * @param rec601Settings
         *        The new value for the Rec601Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rec601Settings(Rec601Settings rec601Settings);

        /**
         * Sets the value of the Rec601Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Rec601Settings.Builder} avoiding the need to
         * create one manually via {@link Rec601Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Rec601Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #rec601Settings(Rec601Settings)}.
         * 
         * @param rec601Settings
         *        a consumer that will call methods on {@link Rec601Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rec601Settings(Rec601Settings)
         */
        default Builder rec601Settings(Consumer<Rec601Settings.Builder> rec601Settings) {
            return rec601Settings(Rec601Settings.builder().applyMutation(rec601Settings).build());
        }

        /**
         * Sets the value of the Rec709Settings property for this object.
         *
         * @param rec709Settings
         *        The new value for the Rec709Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rec709Settings(Rec709Settings rec709Settings);

        /**
         * Sets the value of the Rec709Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Rec709Settings.Builder} avoiding the need to
         * create one manually via {@link Rec709Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Rec709Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #rec709Settings(Rec709Settings)}.
         * 
         * @param rec709Settings
         *        a consumer that will call methods on {@link Rec709Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rec709Settings(Rec709Settings)
         */
        default Builder rec709Settings(Consumer<Rec709Settings.Builder> rec709Settings) {
            return rec709Settings(Rec709Settings.builder().applyMutation(rec709Settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColorSpacePassthroughSettings colorSpacePassthroughSettings;

        private Rec601Settings rec601Settings;

        private Rec709Settings rec709Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(H264ColorSpaceSettings model) {
            colorSpacePassthroughSettings(model.colorSpacePassthroughSettings);
            rec601Settings(model.rec601Settings);
            rec709Settings(model.rec709Settings);
        }

        public final ColorSpacePassthroughSettings.Builder getColorSpacePassthroughSettings() {
            return colorSpacePassthroughSettings != null ? colorSpacePassthroughSettings.toBuilder() : null;
        }

        public final void setColorSpacePassthroughSettings(ColorSpacePassthroughSettings.BuilderImpl colorSpacePassthroughSettings) {
            this.colorSpacePassthroughSettings = colorSpacePassthroughSettings != null ? colorSpacePassthroughSettings.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettings colorSpacePassthroughSettings) {
            this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
            return this;
        }

        public final Rec601Settings.Builder getRec601Settings() {
            return rec601Settings != null ? rec601Settings.toBuilder() : null;
        }

        public final void setRec601Settings(Rec601Settings.BuilderImpl rec601Settings) {
            this.rec601Settings = rec601Settings != null ? rec601Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder rec601Settings(Rec601Settings rec601Settings) {
            this.rec601Settings = rec601Settings;
            return this;
        }

        public final Rec709Settings.Builder getRec709Settings() {
            return rec709Settings != null ? rec709Settings.toBuilder() : null;
        }

        public final void setRec709Settings(Rec709Settings.BuilderImpl rec709Settings) {
            this.rec709Settings = rec709Settings != null ? rec709Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder rec709Settings(Rec709Settings rec709Settings) {
            this.rec709Settings = rec709Settings;
            return this;
        }

        @Override
        public H264ColorSpaceSettings build() {
            return new H264ColorSpaceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
