/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configurable settings for the input device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceConfigurableSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceConfigurableSettings.Builder, InputDeviceConfigurableSettings> {
    private static final SdkField<String> CONFIGURED_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfiguredInput").getter(getter(InputDeviceConfigurableSettings::configuredInputAsString))
            .setter(setter(Builder::configuredInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredInput").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(InputDeviceConfigurableSettings::maxBitrate))
            .setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_INPUT_FIELD,
            MAX_BITRATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configuredInput;

    private final Integer maxBitrate;

    private InputDeviceConfigurableSettings(BuilderImpl builder) {
        this.configuredInput = builder.configuredInput;
        this.maxBitrate = builder.maxBitrate;
    }

    /**
     * The input source that you want to use. If the device has a source connected to only one of its input ports, or if
     * you don't care which source the device sends, specify Auto. If the device has sources connected to both its input
     * ports, and you want to use a specific source, specify the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configuredInput}
     * will return {@link InputDeviceConfiguredInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configuredInputAsString}.
     * </p>
     * 
     * @return The input source that you want to use. If the device has a source connected to only one of its input
     *         ports, or if you don't care which source the device sends, specify Auto. If the device has sources
     *         connected to both its input ports, and you want to use a specific source, specify the source.
     * @see InputDeviceConfiguredInput
     */
    public final InputDeviceConfiguredInput configuredInput() {
        return InputDeviceConfiguredInput.fromValue(configuredInput);
    }

    /**
     * The input source that you want to use. If the device has a source connected to only one of its input ports, or if
     * you don't care which source the device sends, specify Auto. If the device has sources connected to both its input
     * ports, and you want to use a specific source, specify the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configuredInput}
     * will return {@link InputDeviceConfiguredInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configuredInputAsString}.
     * </p>
     * 
     * @return The input source that you want to use. If the device has a source connected to only one of its input
     *         ports, or if you don't care which source the device sends, specify Auto. If the device has sources
     *         connected to both its input ports, and you want to use a specific source, specify the source.
     * @see InputDeviceConfiguredInput
     */
    public final String configuredInputAsString() {
        return configuredInput;
    }

    /**
     * The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
     * 
     * @return The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuredInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceConfigurableSettings)) {
            return false;
        }
        InputDeviceConfigurableSettings other = (InputDeviceConfigurableSettings) obj;
        return Objects.equals(configuredInputAsString(), other.configuredInputAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceConfigurableSettings").add("ConfiguredInput", configuredInputAsString())
                .add("MaxBitrate", maxBitrate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfiguredInput":
            return Optional.ofNullable(clazz.cast(configuredInputAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceConfigurableSettings, T> g) {
        return obj -> g.apply((InputDeviceConfigurableSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceConfigurableSettings> {
        /**
         * The input source that you want to use. If the device has a source connected to only one of its input ports,
         * or if you don't care which source the device sends, specify Auto. If the device has sources connected to both
         * its input ports, and you want to use a specific source, specify the source.
         * 
         * @param configuredInput
         *        The input source that you want to use. If the device has a source connected to only one of its input
         *        ports, or if you don't care which source the device sends, specify Auto. If the device has sources
         *        connected to both its input ports, and you want to use a specific source, specify the source.
         * @see InputDeviceConfiguredInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfiguredInput
         */
        Builder configuredInput(String configuredInput);

        /**
         * The input source that you want to use. If the device has a source connected to only one of its input ports,
         * or if you don't care which source the device sends, specify Auto. If the device has sources connected to both
         * its input ports, and you want to use a specific source, specify the source.
         * 
         * @param configuredInput
         *        The input source that you want to use. If the device has a source connected to only one of its input
         *        ports, or if you don't care which source the device sends, specify Auto. If the device has sources
         *        connected to both its input ports, and you want to use a specific source, specify the source.
         * @see InputDeviceConfiguredInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfiguredInput
         */
        Builder configuredInput(InputDeviceConfiguredInput configuredInput);

        /**
         * The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
         * 
         * @param maxBitrate
         *        The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);
    }

    static final class BuilderImpl implements Builder {
        private String configuredInput;

        private Integer maxBitrate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceConfigurableSettings model) {
            configuredInput(model.configuredInput);
            maxBitrate(model.maxBitrate);
        }

        public final String getConfiguredInput() {
            return configuredInput;
        }

        public final void setConfiguredInput(String configuredInput) {
            this.configuredInput = configuredInput;
        }

        @Override
        @Transient
        public final Builder configuredInput(String configuredInput) {
            this.configuredInput = configuredInput;
            return this;
        }

        @Override
        @Transient
        public final Builder configuredInput(InputDeviceConfiguredInput configuredInput) {
            this.configuredInput(configuredInput == null ? null : configuredInput.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        @Transient
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        @Override
        public InputDeviceConfigurableSettings build() {
            return new InputDeviceConfigurableSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
