/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Input Loss Behavior
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputLossBehavior implements SdkPojo, Serializable,
        ToCopyableBuilder<InputLossBehavior.Builder, InputLossBehavior> {
    private static final SdkField<Integer> BLACK_FRAME_MSEC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlackFrameMsec").getter(getter(InputLossBehavior::blackFrameMsec))
            .setter(setter(Builder::blackFrameMsec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackFrameMsec").build()).build();

    private static final SdkField<String> INPUT_LOSS_IMAGE_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputLossImageColor").getter(getter(InputLossBehavior::inputLossImageColor))
            .setter(setter(Builder::inputLossImageColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossImageColor").build())
            .build();

    private static final SdkField<InputLocation> INPUT_LOSS_IMAGE_SLATE_FIELD = SdkField
            .<InputLocation> builder(MarshallingType.SDK_POJO).memberName("InputLossImageSlate")
            .getter(getter(InputLossBehavior::inputLossImageSlate)).setter(setter(Builder::inputLossImageSlate))
            .constructor(InputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossImageSlate").build())
            .build();

    private static final SdkField<String> INPUT_LOSS_IMAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputLossImageType").getter(getter(InputLossBehavior::inputLossImageTypeAsString))
            .setter(setter(Builder::inputLossImageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossImageType").build())
            .build();

    private static final SdkField<Integer> REPEAT_FRAME_MSEC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RepeatFrameMsec").getter(getter(InputLossBehavior::repeatFrameMsec))
            .setter(setter(Builder::repeatFrameMsec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repeatFrameMsec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACK_FRAME_MSEC_FIELD,
            INPUT_LOSS_IMAGE_COLOR_FIELD, INPUT_LOSS_IMAGE_SLATE_FIELD, INPUT_LOSS_IMAGE_TYPE_FIELD, REPEAT_FRAME_MSEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer blackFrameMsec;

    private final String inputLossImageColor;

    private final InputLocation inputLossImageSlate;

    private final String inputLossImageType;

    private final Integer repeatFrameMsec;

    private InputLossBehavior(BuilderImpl builder) {
        this.blackFrameMsec = builder.blackFrameMsec;
        this.inputLossImageColor = builder.inputLossImageColor;
        this.inputLossImageSlate = builder.inputLossImageSlate;
        this.inputLossImageType = builder.inputLossImageType;
        this.repeatFrameMsec = builder.repeatFrameMsec;
    }

    /**
     * Documentation update needed
     * 
     * @return Documentation update needed
     */
    public final Integer blackFrameMsec() {
        return blackFrameMsec;
    }

    /**
     * When input loss image type is "color" this field specifies the color to use. Value: 6 hex characters representing
     * the values of RGB.
     * 
     * @return When input loss image type is "color" this field specifies the color to use. Value: 6 hex characters
     *         representing the values of RGB.
     */
    public final String inputLossImageColor() {
        return inputLossImageColor;
    }

    /**
     * When input loss image type is "slate" these fields specify the parameters for accessing the slate.
     * 
     * @return When input loss image type is "slate" these fields specify the parameters for accessing the slate.
     */
    public final InputLocation inputLossImageSlate() {
        return inputLossImageSlate;
    }

    /**
     * Indicates whether to substitute a solid color or a slate into the output after input loss exceeds blackFrameMsec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputLossImageType} will return {@link InputLossImageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #inputLossImageTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to substitute a solid color or a slate into the output after input loss exceeds
     *         blackFrameMsec.
     * @see InputLossImageType
     */
    public final InputLossImageType inputLossImageType() {
        return InputLossImageType.fromValue(inputLossImageType);
    }

    /**
     * Indicates whether to substitute a solid color or a slate into the output after input loss exceeds blackFrameMsec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputLossImageType} will return {@link InputLossImageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #inputLossImageTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to substitute a solid color or a slate into the output after input loss exceeds
     *         blackFrameMsec.
     * @see InputLossImageType
     */
    public final String inputLossImageTypeAsString() {
        return inputLossImageType;
    }

    /**
     * Documentation update needed
     * 
     * @return Documentation update needed
     */
    public final Integer repeatFrameMsec() {
        return repeatFrameMsec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blackFrameMsec());
        hashCode = 31 * hashCode + Objects.hashCode(inputLossImageColor());
        hashCode = 31 * hashCode + Objects.hashCode(inputLossImageSlate());
        hashCode = 31 * hashCode + Objects.hashCode(inputLossImageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repeatFrameMsec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLossBehavior)) {
            return false;
        }
        InputLossBehavior other = (InputLossBehavior) obj;
        return Objects.equals(blackFrameMsec(), other.blackFrameMsec())
                && Objects.equals(inputLossImageColor(), other.inputLossImageColor())
                && Objects.equals(inputLossImageSlate(), other.inputLossImageSlate())
                && Objects.equals(inputLossImageTypeAsString(), other.inputLossImageTypeAsString())
                && Objects.equals(repeatFrameMsec(), other.repeatFrameMsec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputLossBehavior").add("BlackFrameMsec", blackFrameMsec())
                .add("InputLossImageColor", inputLossImageColor()).add("InputLossImageSlate", inputLossImageSlate())
                .add("InputLossImageType", inputLossImageTypeAsString()).add("RepeatFrameMsec", repeatFrameMsec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlackFrameMsec":
            return Optional.ofNullable(clazz.cast(blackFrameMsec()));
        case "InputLossImageColor":
            return Optional.ofNullable(clazz.cast(inputLossImageColor()));
        case "InputLossImageSlate":
            return Optional.ofNullable(clazz.cast(inputLossImageSlate()));
        case "InputLossImageType":
            return Optional.ofNullable(clazz.cast(inputLossImageTypeAsString()));
        case "RepeatFrameMsec":
            return Optional.ofNullable(clazz.cast(repeatFrameMsec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputLossBehavior, T> g) {
        return obj -> g.apply((InputLossBehavior) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputLossBehavior> {
        /**
         * Documentation update needed
         * 
         * @param blackFrameMsec
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blackFrameMsec(Integer blackFrameMsec);

        /**
         * When input loss image type is "color" this field specifies the color to use. Value: 6 hex characters
         * representing the values of RGB.
         * 
         * @param inputLossImageColor
         *        When input loss image type is "color" this field specifies the color to use. Value: 6 hex characters
         *        representing the values of RGB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLossImageColor(String inputLossImageColor);

        /**
         * When input loss image type is "slate" these fields specify the parameters for accessing the slate.
         * 
         * @param inputLossImageSlate
         *        When input loss image type is "slate" these fields specify the parameters for accessing the slate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLossImageSlate(InputLocation inputLossImageSlate);

        /**
         * When input loss image type is "slate" these fields specify the parameters for accessing the slate. This is a
         * convenience that creates an instance of the {@link InputLocation.Builder} avoiding the need to create one
         * manually via {@link InputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #inputLossImageSlate(InputLocation)}.
         * 
         * @param inputLossImageSlate
         *        a consumer that will call methods on {@link InputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLossImageSlate(InputLocation)
         */
        default Builder inputLossImageSlate(Consumer<InputLocation.Builder> inputLossImageSlate) {
            return inputLossImageSlate(InputLocation.builder().applyMutation(inputLossImageSlate).build());
        }

        /**
         * Indicates whether to substitute a solid color or a slate into the output after input loss exceeds
         * blackFrameMsec.
         * 
         * @param inputLossImageType
         *        Indicates whether to substitute a solid color or a slate into the output after input loss exceeds
         *        blackFrameMsec.
         * @see InputLossImageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossImageType
         */
        Builder inputLossImageType(String inputLossImageType);

        /**
         * Indicates whether to substitute a solid color or a slate into the output after input loss exceeds
         * blackFrameMsec.
         * 
         * @param inputLossImageType
         *        Indicates whether to substitute a solid color or a slate into the output after input loss exceeds
         *        blackFrameMsec.
         * @see InputLossImageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossImageType
         */
        Builder inputLossImageType(InputLossImageType inputLossImageType);

        /**
         * Documentation update needed
         * 
         * @param repeatFrameMsec
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repeatFrameMsec(Integer repeatFrameMsec);
    }

    static final class BuilderImpl implements Builder {
        private Integer blackFrameMsec;

        private String inputLossImageColor;

        private InputLocation inputLossImageSlate;

        private String inputLossImageType;

        private Integer repeatFrameMsec;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLossBehavior model) {
            blackFrameMsec(model.blackFrameMsec);
            inputLossImageColor(model.inputLossImageColor);
            inputLossImageSlate(model.inputLossImageSlate);
            inputLossImageType(model.inputLossImageType);
            repeatFrameMsec(model.repeatFrameMsec);
        }

        public final Integer getBlackFrameMsec() {
            return blackFrameMsec;
        }

        public final void setBlackFrameMsec(Integer blackFrameMsec) {
            this.blackFrameMsec = blackFrameMsec;
        }

        @Override
        @Transient
        public final Builder blackFrameMsec(Integer blackFrameMsec) {
            this.blackFrameMsec = blackFrameMsec;
            return this;
        }

        public final String getInputLossImageColor() {
            return inputLossImageColor;
        }

        public final void setInputLossImageColor(String inputLossImageColor) {
            this.inputLossImageColor = inputLossImageColor;
        }

        @Override
        @Transient
        public final Builder inputLossImageColor(String inputLossImageColor) {
            this.inputLossImageColor = inputLossImageColor;
            return this;
        }

        public final InputLocation.Builder getInputLossImageSlate() {
            return inputLossImageSlate != null ? inputLossImageSlate.toBuilder() : null;
        }

        public final void setInputLossImageSlate(InputLocation.BuilderImpl inputLossImageSlate) {
            this.inputLossImageSlate = inputLossImageSlate != null ? inputLossImageSlate.build() : null;
        }

        @Override
        @Transient
        public final Builder inputLossImageSlate(InputLocation inputLossImageSlate) {
            this.inputLossImageSlate = inputLossImageSlate;
            return this;
        }

        public final String getInputLossImageType() {
            return inputLossImageType;
        }

        public final void setInputLossImageType(String inputLossImageType) {
            this.inputLossImageType = inputLossImageType;
        }

        @Override
        @Transient
        public final Builder inputLossImageType(String inputLossImageType) {
            this.inputLossImageType = inputLossImageType;
            return this;
        }

        @Override
        @Transient
        public final Builder inputLossImageType(InputLossImageType inputLossImageType) {
            this.inputLossImageType(inputLossImageType == null ? null : inputLossImageType.toString());
            return this;
        }

        public final Integer getRepeatFrameMsec() {
            return repeatFrameMsec;
        }

        public final void setRepeatFrameMsec(Integer repeatFrameMsec) {
            this.repeatFrameMsec = repeatFrameMsec;
        }

        @Override
        @Transient
        public final Builder repeatFrameMsec(Integer repeatFrameMsec) {
            this.repeatFrameMsec = repeatFrameMsec;
            return this;
        }

        @Override
        public InputLossBehavior build() {
            return new InputLossBehavior(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
