/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * MediaLive will perform a failover if content is not detected in this input for the specified period.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputLossFailoverSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputLossFailoverSettings.Builder, InputLossFailoverSettings> {
    private static final SdkField<Integer> INPUT_LOSS_THRESHOLD_MSEC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InputLossThresholdMsec").getter(getter(InputLossFailoverSettings::inputLossThresholdMsec))
            .setter(setter(Builder::inputLossThresholdMsec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossThresholdMsec").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INPUT_LOSS_THRESHOLD_MSEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer inputLossThresholdMsec;

    private InputLossFailoverSettings(BuilderImpl builder) {
        this.inputLossThresholdMsec = builder.inputLossThresholdMsec;
    }

    /**
     * The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.
     * 
     * @return The amount of time (in milliseconds) that no input is detected. After that time, an input failover will
     *         occur.
     */
    public final Integer inputLossThresholdMsec() {
        return inputLossThresholdMsec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputLossThresholdMsec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLossFailoverSettings)) {
            return false;
        }
        InputLossFailoverSettings other = (InputLossFailoverSettings) obj;
        return Objects.equals(inputLossThresholdMsec(), other.inputLossThresholdMsec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputLossFailoverSettings").add("InputLossThresholdMsec", inputLossThresholdMsec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputLossThresholdMsec":
            return Optional.ofNullable(clazz.cast(inputLossThresholdMsec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputLossFailoverSettings, T> g) {
        return obj -> g.apply((InputLossFailoverSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputLossFailoverSettings> {
        /**
         * The amount of time (in milliseconds) that no input is detected. After that time, an input failover will
         * occur.
         * 
         * @param inputLossThresholdMsec
         *        The amount of time (in milliseconds) that no input is detected. After that time, an input failover
         *        will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLossThresholdMsec(Integer inputLossThresholdMsec);
    }

    static final class BuilderImpl implements Builder {
        private Integer inputLossThresholdMsec;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLossFailoverSettings model) {
            inputLossThresholdMsec(model.inputLossThresholdMsec);
        }

        public final Integer getInputLossThresholdMsec() {
            return inputLossThresholdMsec;
        }

        public final void setInputLossThresholdMsec(Integer inputLossThresholdMsec) {
            this.inputLossThresholdMsec = inputLossThresholdMsec;
        }

        @Override
        @Transient
        public final Builder inputLossThresholdMsec(Integer inputLossThresholdMsec) {
            this.inputLossThresholdMsec = inputLossThresholdMsec;
            return this;
        }

        @Override
        public InputLossFailoverSettings build() {
            return new InputLossFailoverSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
