/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListInputSecurityGroupsResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInputSecurityGroupsResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListInputSecurityGroupsResponse.Builder, ListInputSecurityGroupsResponse> {
    private static final SdkField<List<InputSecurityGroup>> INPUT_SECURITY_GROUPS_FIELD = SdkField
            .<List<InputSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("InputSecurityGroups")
            .getter(getter(ListInputSecurityGroupsResponse::inputSecurityGroups))
            .setter(setter(Builder::inputSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInputSecurityGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SECURITY_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InputSecurityGroup> inputSecurityGroups;

    private final String nextToken;

    private ListInputSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputSecurityGroups() {
        return inputSecurityGroups != null && !(inputSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * List of input security groups
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputSecurityGroups} method.
     * </p>
     * 
     * @return List of input security groups
     */
    public final List<InputSecurityGroup> inputSecurityGroups() {
        return inputSecurityGroups;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInputSecurityGroups() ? inputSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputSecurityGroupsResponse)) {
            return false;
        }
        ListInputSecurityGroupsResponse other = (ListInputSecurityGroupsResponse) obj;
        return hasInputSecurityGroups() == other.hasInputSecurityGroups()
                && Objects.equals(inputSecurityGroups(), other.inputSecurityGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInputSecurityGroupsResponse")
                .add("InputSecurityGroups", hasInputSecurityGroups() ? inputSecurityGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputSecurityGroups":
            return Optional.ofNullable(clazz.cast(inputSecurityGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInputSecurityGroupsResponse, T> g) {
        return obj -> g.apply((ListInputSecurityGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInputSecurityGroupsResponse> {
        /**
         * List of input security groups
         * 
         * @param inputSecurityGroups
         *        List of input security groups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroups(Collection<InputSecurityGroup> inputSecurityGroups);

        /**
         * List of input security groups
         * 
         * @param inputSecurityGroups
         *        List of input security groups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroups(InputSecurityGroup... inputSecurityGroups);

        /**
         * List of input security groups This is a convenience that creates an instance of the {@link List
         * <InputSecurityGroup>.Builder} avoiding the need to create one manually via {@link List
         * <InputSecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputSecurityGroup>.Builder#build()} is called immediately
         * and its result is passed to {@link #inputSecurityGroups(List<InputSecurityGroup>)}.
         * 
         * @param inputSecurityGroups
         *        a consumer that will call methods on {@link List<InputSecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSecurityGroups(List<InputSecurityGroup>)
         */
        Builder inputSecurityGroups(Consumer<InputSecurityGroup.Builder>... inputSecurityGroups);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<InputSecurityGroup> inputSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputSecurityGroupsResponse model) {
            super(model);
            inputSecurityGroups(model.inputSecurityGroups);
            nextToken(model.nextToken);
        }

        public final List<InputSecurityGroup.Builder> getInputSecurityGroups() {
            List<InputSecurityGroup.Builder> result = ___listOfInputSecurityGroupCopier.copyToBuilder(this.inputSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSecurityGroups(Collection<InputSecurityGroup.BuilderImpl> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOfInputSecurityGroupCopier.copyFromBuilder(inputSecurityGroups);
        }

        @Override
        @Transient
        public final Builder inputSecurityGroups(Collection<InputSecurityGroup> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOfInputSecurityGroupCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputSecurityGroups(InputSecurityGroup... inputSecurityGroups) {
            inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputSecurityGroups(Consumer<InputSecurityGroup.Builder>... inputSecurityGroups) {
            inputSecurityGroups(Stream.of(inputSecurityGroups).map(c -> InputSecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInputSecurityGroupsResponse build() {
            return new ListInputSecurityGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
