/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings information for the .m3u8 container
 */
@Generated("software.amazon.awssdk:codegen")
public final class M3u8Settings implements SdkPojo, Serializable, ToCopyableBuilder<M3u8Settings.Builder, M3u8Settings> {
    private static final SdkField<Integer> AUDIO_FRAMES_PER_PES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AudioFramesPerPes").getter(getter(M3u8Settings::audioFramesPerPes))
            .setter(setter(Builder::audioFramesPerPes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioFramesPerPes").build()).build();

    private static final SdkField<String> AUDIO_PIDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioPids").getter(getter(M3u8Settings::audioPids)).setter(setter(Builder::audioPids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioPids").build()).build();

    private static final SdkField<String> ECM_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EcmPid")
            .getter(getter(M3u8Settings::ecmPid)).setter(setter(Builder::ecmPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecmPid").build()).build();

    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NielsenId3Behavior").getter(getter(M3u8Settings::nielsenId3BehaviorAsString))
            .setter(setter(Builder::nielsenId3Behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build())
            .build();

    private static final SdkField<Integer> PAT_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PatInterval").getter(getter(M3u8Settings::patInterval)).setter(setter(Builder::patInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patInterval").build()).build();

    private static final SdkField<String> PCR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PcrControl").getter(getter(M3u8Settings::pcrControlAsString)).setter(setter(Builder::pcrControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrControl").build()).build();

    private static final SdkField<Integer> PCR_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PcrPeriod").getter(getter(M3u8Settings::pcrPeriod)).setter(setter(Builder::pcrPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPeriod").build()).build();

    private static final SdkField<String> PCR_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PcrPid")
            .getter(getter(M3u8Settings::pcrPid)).setter(setter(Builder::pcrPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPid").build()).build();

    private static final SdkField<Integer> PMT_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PmtInterval").getter(getter(M3u8Settings::pmtInterval)).setter(setter(Builder::pmtInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtInterval").build()).build();

    private static final SdkField<String> PMT_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PmtPid")
            .getter(getter(M3u8Settings::pmtPid)).setter(setter(Builder::pmtPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtPid").build()).build();

    private static final SdkField<Integer> PROGRAM_NUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramNum").getter(getter(M3u8Settings::programNum)).setter(setter(Builder::programNum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNum").build()).build();

    private static final SdkField<String> SCTE35_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Behavior").getter(getter(M3u8Settings::scte35BehaviorAsString))
            .setter(setter(Builder::scte35Behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Behavior").build()).build();

    private static final SdkField<String> SCTE35_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Pid").getter(getter(M3u8Settings::scte35Pid)).setter(setter(Builder::scte35Pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Pid").build()).build();

    private static final SdkField<String> TIMED_METADATA_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimedMetadataBehavior").getter(getter(M3u8Settings::timedMetadataBehaviorAsString))
            .setter(setter(Builder::timedMetadataBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataBehavior").build())
            .build();

    private static final SdkField<String> TIMED_METADATA_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimedMetadataPid").getter(getter(M3u8Settings::timedMetadataPid))
            .setter(setter(Builder::timedMetadataPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataPid").build()).build();

    private static final SdkField<Integer> TRANSPORT_STREAM_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TransportStreamId").getter(getter(M3u8Settings::transportStreamId))
            .setter(setter(Builder::transportStreamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamId").build()).build();

    private static final SdkField<String> VIDEO_PID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VideoPid").getter(getter(M3u8Settings::videoPid)).setter(setter(Builder::videoPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoPid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FRAMES_PER_PES_FIELD,
            AUDIO_PIDS_FIELD, ECM_PID_FIELD, NIELSEN_ID3_BEHAVIOR_FIELD, PAT_INTERVAL_FIELD, PCR_CONTROL_FIELD, PCR_PERIOD_FIELD,
            PCR_PID_FIELD, PMT_INTERVAL_FIELD, PMT_PID_FIELD, PROGRAM_NUM_FIELD, SCTE35_BEHAVIOR_FIELD, SCTE35_PID_FIELD,
            TIMED_METADATA_BEHAVIOR_FIELD, TIMED_METADATA_PID_FIELD, TRANSPORT_STREAM_ID_FIELD, VIDEO_PID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer audioFramesPerPes;

    private final String audioPids;

    private final String ecmPid;

    private final String nielsenId3Behavior;

    private final Integer patInterval;

    private final String pcrControl;

    private final Integer pcrPeriod;

    private final String pcrPid;

    private final Integer pmtInterval;

    private final String pmtPid;

    private final Integer programNum;

    private final String scte35Behavior;

    private final String scte35Pid;

    private final String timedMetadataBehavior;

    private final String timedMetadataPid;

    private final Integer transportStreamId;

    private final String videoPid;

    private M3u8Settings(BuilderImpl builder) {
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioPids = builder.audioPids;
        this.ecmPid = builder.ecmPid;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.patInterval = builder.patInterval;
        this.pcrControl = builder.pcrControl;
        this.pcrPeriod = builder.pcrPeriod;
        this.pcrPid = builder.pcrPid;
        this.pmtInterval = builder.pmtInterval;
        this.pmtPid = builder.pmtPid;
        this.programNum = builder.programNum;
        this.scte35Behavior = builder.scte35Behavior;
        this.scte35Pid = builder.scte35Pid;
        this.timedMetadataBehavior = builder.timedMetadataBehavior;
        this.timedMetadataPid = builder.timedMetadataPid;
        this.transportStreamId = builder.transportStreamId;
        this.videoPid = builder.videoPid;
    }

    /**
     * The number of audio frames to insert for each PES packet.
     * 
     * @return The number of audio frames to insert for each PES packet.
     */
    public final Integer audioFramesPerPes() {
        return audioFramesPerPes;
    }

    /**
     * Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted,
     * and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.
     * 
     * @return Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are
     *         accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or
     *         hexadecimal values.
     */
    public final String audioPids() {
        return audioPids;
    }

    /**
     * This parameter is unused and deprecated.
     * 
     * @return This parameter is unused and deprecated.
     */
    public final String ecmPid() {
        return ecmPid;
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link M3u8NielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see M3u8NielsenId3Behavior
     */
    public final M3u8NielsenId3Behavior nielsenId3Behavior() {
        return M3u8NielsenId3Behavior.fromValue(nielsenId3Behavior);
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link M3u8NielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see M3u8NielsenId3Behavior
     */
    public final String nielsenId3BehaviorAsString() {
        return nielsenId3Behavior;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream. A value of \"0\"
     * writes out the PMT once per segment file.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream. A value of
     *         \"0\" writes out the PMT once per segment file.
     */
    public final Integer patInterval() {
        return patInterval;
    }

    /**
     * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream
     * (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary
     * stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pcrControl} will
     * return {@link M3u8PcrControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pcrControlAsString}.
     * </p>
     * 
     * @return When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
     *         Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
     *         video or audio elementary stream.
     * @see M3u8PcrControl
     */
    public final M3u8PcrControl pcrControl() {
        return M3u8PcrControl.fromValue(pcrControl);
    }

    /**
     * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream
     * (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary
     * stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pcrControl} will
     * return {@link M3u8PcrControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pcrControlAsString}.
     * </p>
     * 
     * @return When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
     *         Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
     *         video or audio elementary stream.
     * @see M3u8PcrControl
     */
    public final String pcrControlAsString() {
        return pcrControl;
    }

    /**
     * Maximum time in milliseconds between Program Clock References (PCRs) inserted into the transport stream.
     * 
     * @return Maximum time in milliseconds between Program Clock References (PCRs) inserted into the transport stream.
     */
    public final Integer pcrPeriod() {
        return pcrPeriod;
    }

    /**
     * Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the
     * encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.
     * 
     * @return Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is
     *         given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or
     *         hexadecimal value.
     */
    public final String pcrPid() {
        return pcrPid;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream. A value of \"0\"
     * writes out the PMT once per segment file.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream. A value of
     *         \"0\" writes out the PMT once per segment file.
     */
    public final Integer pmtInterval() {
        return pmtInterval;
    }

    /**
     * Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or
     * hexadecimal value.
     * 
     * @return Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a
     *         decimal or hexadecimal value.
     */
    public final String pmtPid() {
        return pmtPid;
    }

    /**
     * The value of the program number field in the Program Map Table.
     * 
     * @return The value of the program number field in the Program Map Table.
     */
    public final Integer programNum() {
        return programNum;
    }

    /**
     * If set to passthrough, passes any SCTE-35 signals from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Behavior}
     * will return {@link M3u8Scte35Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scte35BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any SCTE-35 signals from the input source to this output.
     * @see M3u8Scte35Behavior
     */
    public final M3u8Scte35Behavior scte35Behavior() {
        return M3u8Scte35Behavior.fromValue(scte35Behavior);
    }

    /**
     * If set to passthrough, passes any SCTE-35 signals from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Behavior}
     * will return {@link M3u8Scte35Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scte35BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any SCTE-35 signals from the input source to this output.
     * @see M3u8Scte35Behavior
     */
    public final String scte35BehaviorAsString() {
        return scte35Behavior;
    }

    /**
     * Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal
     * value.
     * 
     * @return Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or
     *         hexadecimal value.
     */
    public final String scte35Pid() {
        return scte35Pid;
    }

    /**
     * When set to passthrough, timed metadata is passed through from input to output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataBehavior} will return {@link M3u8TimedMetadataBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #timedMetadataBehaviorAsString}.
     * </p>
     * 
     * @return When set to passthrough, timed metadata is passed through from input to output.
     * @see M3u8TimedMetadataBehavior
     */
    public final M3u8TimedMetadataBehavior timedMetadataBehavior() {
        return M3u8TimedMetadataBehavior.fromValue(timedMetadataBehavior);
    }

    /**
     * When set to passthrough, timed metadata is passed through from input to output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataBehavior} will return {@link M3u8TimedMetadataBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #timedMetadataBehaviorAsString}.
     * </p>
     * 
     * @return When set to passthrough, timed metadata is passed through from input to output.
     * @see M3u8TimedMetadataBehavior
     */
    public final String timedMetadataBehaviorAsString() {
        return timedMetadataBehavior;
    }

    /**
     * Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or
     * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     * 
     * @return Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal
     *         or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
     */
    public final String timedMetadataPid() {
        return timedMetadataPid;
    }

    /**
     * The value of the transport stream ID field in the Program Map Table.
     * 
     * @return The value of the transport stream ID field in the Program Map Table.
     */
    public final Integer transportStreamId() {
        return transportStreamId;
    }

    /**
     * Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or
     * hexadecimal value.
     * 
     * @return Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a
     *         decimal or hexadecimal value.
     */
    public final String videoPid() {
        return videoPid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(audioPids());
        hashCode = 31 * hashCode + Objects.hashCode(ecmPid());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(patInterval());
        hashCode = 31 * hashCode + Objects.hashCode(pcrControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pcrPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(pmtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(programNum());
        hashCode = 31 * hashCode + Objects.hashCode(scte35BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(videoPid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M3u8Settings)) {
            return false;
        }
        M3u8Settings other = (M3u8Settings) obj;
        return Objects.equals(audioFramesPerPes(), other.audioFramesPerPes()) && Objects.equals(audioPids(), other.audioPids())
                && Objects.equals(ecmPid(), other.ecmPid())
                && Objects.equals(nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString())
                && Objects.equals(patInterval(), other.patInterval())
                && Objects.equals(pcrControlAsString(), other.pcrControlAsString())
                && Objects.equals(pcrPeriod(), other.pcrPeriod()) && Objects.equals(pcrPid(), other.pcrPid())
                && Objects.equals(pmtInterval(), other.pmtInterval()) && Objects.equals(pmtPid(), other.pmtPid())
                && Objects.equals(programNum(), other.programNum())
                && Objects.equals(scte35BehaviorAsString(), other.scte35BehaviorAsString())
                && Objects.equals(scte35Pid(), other.scte35Pid())
                && Objects.equals(timedMetadataBehaviorAsString(), other.timedMetadataBehaviorAsString())
                && Objects.equals(timedMetadataPid(), other.timedMetadataPid())
                && Objects.equals(transportStreamId(), other.transportStreamId()) && Objects.equals(videoPid(), other.videoPid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M3u8Settings").add("AudioFramesPerPes", audioFramesPerPes()).add("AudioPids", audioPids())
                .add("EcmPid", ecmPid()).add("NielsenId3Behavior", nielsenId3BehaviorAsString())
                .add("PatInterval", patInterval()).add("PcrControl", pcrControlAsString()).add("PcrPeriod", pcrPeriod())
                .add("PcrPid", pcrPid()).add("PmtInterval", pmtInterval()).add("PmtPid", pmtPid())
                .add("ProgramNum", programNum()).add("Scte35Behavior", scte35BehaviorAsString()).add("Scte35Pid", scte35Pid())
                .add("TimedMetadataBehavior", timedMetadataBehaviorAsString()).add("TimedMetadataPid", timedMetadataPid())
                .add("TransportStreamId", transportStreamId()).add("VideoPid", videoPid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioFramesPerPes":
            return Optional.ofNullable(clazz.cast(audioFramesPerPes()));
        case "AudioPids":
            return Optional.ofNullable(clazz.cast(audioPids()));
        case "EcmPid":
            return Optional.ofNullable(clazz.cast(ecmPid()));
        case "NielsenId3Behavior":
            return Optional.ofNullable(clazz.cast(nielsenId3BehaviorAsString()));
        case "PatInterval":
            return Optional.ofNullable(clazz.cast(patInterval()));
        case "PcrControl":
            return Optional.ofNullable(clazz.cast(pcrControlAsString()));
        case "PcrPeriod":
            return Optional.ofNullable(clazz.cast(pcrPeriod()));
        case "PcrPid":
            return Optional.ofNullable(clazz.cast(pcrPid()));
        case "PmtInterval":
            return Optional.ofNullable(clazz.cast(pmtInterval()));
        case "PmtPid":
            return Optional.ofNullable(clazz.cast(pmtPid()));
        case "ProgramNum":
            return Optional.ofNullable(clazz.cast(programNum()));
        case "Scte35Behavior":
            return Optional.ofNullable(clazz.cast(scte35BehaviorAsString()));
        case "Scte35Pid":
            return Optional.ofNullable(clazz.cast(scte35Pid()));
        case "TimedMetadataBehavior":
            return Optional.ofNullable(clazz.cast(timedMetadataBehaviorAsString()));
        case "TimedMetadataPid":
            return Optional.ofNullable(clazz.cast(timedMetadataPid()));
        case "TransportStreamId":
            return Optional.ofNullable(clazz.cast(transportStreamId()));
        case "VideoPid":
            return Optional.ofNullable(clazz.cast(videoPid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M3u8Settings, T> g) {
        return obj -> g.apply((M3u8Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M3u8Settings> {
        /**
         * The number of audio frames to insert for each PES packet.
         * 
         * @param audioFramesPerPes
         *        The number of audio frames to insert for each PES packet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioFramesPerPes(Integer audioFramesPerPes);

        /**
         * Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are
         * accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal
         * values.
         * 
         * @param audioPids
         *        Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are
         *        accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or
         *        hexadecimal values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioPids(String audioPids);

        /**
         * This parameter is unused and deprecated.
         * 
         * @param ecmPid
         *        This parameter is unused and deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecmPid(String ecmPid);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see M3u8NielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M3u8NielsenId3Behavior
         */
        Builder nielsenId3Behavior(String nielsenId3Behavior);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see M3u8NielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M3u8NielsenId3Behavior
         */
        Builder nielsenId3Behavior(M3u8NielsenId3Behavior nielsenId3Behavior);

        /**
         * The number of milliseconds between instances of this table in the output transport stream. A value of \"0\"
         * writes out the PMT once per segment file.
         * 
         * @param patInterval
         *        The number of milliseconds between instances of this table in the output transport stream. A value of
         *        \"0\" writes out the PMT once per segment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patInterval(Integer patInterval);

        /**
         * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary
         * Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio
         * elementary stream.
         * 
         * @param pcrControl
         *        When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
         *        Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
         *        video or audio elementary stream.
         * @see M3u8PcrControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M3u8PcrControl
         */
        Builder pcrControl(String pcrControl);

        /**
         * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary
         * Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio
         * elementary stream.
         * 
         * @param pcrControl
         *        When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
         *        Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
         *        video or audio elementary stream.
         * @see M3u8PcrControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M3u8PcrControl
         */
        Builder pcrControl(M3u8PcrControl pcrControl);

        /**
         * Maximum time in milliseconds between Program Clock References (PCRs) inserted into the transport stream.
         * 
         * @param pcrPeriod
         *        Maximum time in milliseconds between Program Clock References (PCRs) inserted into the transport
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcrPeriod(Integer pcrPeriod);

        /**
         * Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given,
         * the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.
         * 
         * @param pcrPid
         *        Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is
         *        given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or
         *        hexadecimal value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcrPid(String pcrPid);

        /**
         * The number of milliseconds between instances of this table in the output transport stream. A value of \"0\"
         * writes out the PMT once per segment file.
         * 
         * @param pmtInterval
         *        The number of milliseconds between instances of this table in the output transport stream. A value of
         *        \"0\" writes out the PMT once per segment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pmtInterval(Integer pmtInterval);

        /**
         * Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal
         * or hexadecimal value.
         * 
         * @param pmtPid
         *        Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a
         *        decimal or hexadecimal value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pmtPid(String pmtPid);

        /**
         * The value of the program number field in the Program Map Table.
         * 
         * @param programNum
         *        The value of the program number field in the Program Map Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programNum(Integer programNum);

        /**
         * If set to passthrough, passes any SCTE-35 signals from the input source to this output.
         * 
         * @param scte35Behavior
         *        If set to passthrough, passes any SCTE-35 signals from the input source to this output.
         * @see M3u8Scte35Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M3u8Scte35Behavior
         */
        Builder scte35Behavior(String scte35Behavior);

        /**
         * If set to passthrough, passes any SCTE-35 signals from the input source to this output.
         * 
         * @param scte35Behavior
         *        If set to passthrough, passes any SCTE-35 signals from the input source to this output.
         * @see M3u8Scte35Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M3u8Scte35Behavior
         */
        Builder scte35Behavior(M3u8Scte35Behavior scte35Behavior);

        /**
         * Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or
         * hexadecimal value.
         * 
         * @param scte35Pid
         *        Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or
         *        hexadecimal value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35Pid(String scte35Pid);

        /**
         * When set to passthrough, timed metadata is passed through from input to output.
         * 
         * @param timedMetadataBehavior
         *        When set to passthrough, timed metadata is passed through from input to output.
         * @see M3u8TimedMetadataBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M3u8TimedMetadataBehavior
         */
        Builder timedMetadataBehavior(String timedMetadataBehavior);

        /**
         * When set to passthrough, timed metadata is passed through from input to output.
         * 
         * @param timedMetadataBehavior
         *        When set to passthrough, timed metadata is passed through from input to output.
         * @see M3u8TimedMetadataBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M3u8TimedMetadataBehavior
         */
        Builder timedMetadataBehavior(M3u8TimedMetadataBehavior timedMetadataBehavior);

        /**
         * Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or
         * hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * 
         * @param timedMetadataPid
         *        Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a
         *        decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataPid(String timedMetadataPid);

        /**
         * The value of the transport stream ID field in the Program Map Table.
         * 
         * @param transportStreamId
         *        The value of the transport stream ID field in the Program Map Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportStreamId(Integer transportStreamId);

        /**
         * Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal
         * or hexadecimal value.
         * 
         * @param videoPid
         *        Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a
         *        decimal or hexadecimal value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoPid(String videoPid);
    }

    static final class BuilderImpl implements Builder {
        private Integer audioFramesPerPes;

        private String audioPids;

        private String ecmPid;

        private String nielsenId3Behavior;

        private Integer patInterval;

        private String pcrControl;

        private Integer pcrPeriod;

        private String pcrPid;

        private Integer pmtInterval;

        private String pmtPid;

        private Integer programNum;

        private String scte35Behavior;

        private String scte35Pid;

        private String timedMetadataBehavior;

        private String timedMetadataPid;

        private Integer transportStreamId;

        private String videoPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M3u8Settings model) {
            audioFramesPerPes(model.audioFramesPerPes);
            audioPids(model.audioPids);
            ecmPid(model.ecmPid);
            nielsenId3Behavior(model.nielsenId3Behavior);
            patInterval(model.patInterval);
            pcrControl(model.pcrControl);
            pcrPeriod(model.pcrPeriod);
            pcrPid(model.pcrPid);
            pmtInterval(model.pmtInterval);
            pmtPid(model.pmtPid);
            programNum(model.programNum);
            scte35Behavior(model.scte35Behavior);
            scte35Pid(model.scte35Pid);
            timedMetadataBehavior(model.timedMetadataBehavior);
            timedMetadataPid(model.timedMetadataPid);
            transportStreamId(model.transportStreamId);
            videoPid(model.videoPid);
        }

        public final Integer getAudioFramesPerPes() {
            return audioFramesPerPes;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        @Override
        @Transient
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final String getAudioPids() {
            return audioPids;
        }

        public final void setAudioPids(String audioPids) {
            this.audioPids = audioPids;
        }

        @Override
        @Transient
        public final Builder audioPids(String audioPids) {
            this.audioPids = audioPids;
            return this;
        }

        public final String getEcmPid() {
            return ecmPid;
        }

        public final void setEcmPid(String ecmPid) {
            this.ecmPid = ecmPid;
        }

        @Override
        @Transient
        public final Builder ecmPid(String ecmPid) {
            this.ecmPid = ecmPid;
            return this;
        }

        public final String getNielsenId3Behavior() {
            return nielsenId3Behavior;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        @Override
        @Transient
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        @Transient
        public final Builder nielsenId3Behavior(M3u8NielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final Integer getPatInterval() {
            return patInterval;
        }

        public final void setPatInterval(Integer patInterval) {
            this.patInterval = patInterval;
        }

        @Override
        @Transient
        public final Builder patInterval(Integer patInterval) {
            this.patInterval = patInterval;
            return this;
        }

        public final String getPcrControl() {
            return pcrControl;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        @Override
        @Transient
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        @Transient
        public final Builder pcrControl(M3u8PcrControl pcrControl) {
            this.pcrControl(pcrControl == null ? null : pcrControl.toString());
            return this;
        }

        public final Integer getPcrPeriod() {
            return pcrPeriod;
        }

        public final void setPcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
        }

        @Override
        @Transient
        public final Builder pcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
            return this;
        }

        public final String getPcrPid() {
            return pcrPid;
        }

        public final void setPcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
        }

        @Override
        @Transient
        public final Builder pcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final Integer getPmtInterval() {
            return pmtInterval;
        }

        public final void setPmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
        }

        @Override
        @Transient
        public final Builder pmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
            return this;
        }

        public final String getPmtPid() {
            return pmtPid;
        }

        public final void setPmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
        }

        @Override
        @Transient
        public final Builder pmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final Integer getProgramNum() {
            return programNum;
        }

        public final void setProgramNum(Integer programNum) {
            this.programNum = programNum;
        }

        @Override
        @Transient
        public final Builder programNum(Integer programNum) {
            this.programNum = programNum;
            return this;
        }

        public final String getScte35Behavior() {
            return scte35Behavior;
        }

        public final void setScte35Behavior(String scte35Behavior) {
            this.scte35Behavior = scte35Behavior;
        }

        @Override
        @Transient
        public final Builder scte35Behavior(String scte35Behavior) {
            this.scte35Behavior = scte35Behavior;
            return this;
        }

        @Override
        @Transient
        public final Builder scte35Behavior(M3u8Scte35Behavior scte35Behavior) {
            this.scte35Behavior(scte35Behavior == null ? null : scte35Behavior.toString());
            return this;
        }

        public final String getScte35Pid() {
            return scte35Pid;
        }

        public final void setScte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        @Override
        @Transient
        public final Builder scte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final String getTimedMetadataBehavior() {
            return timedMetadataBehavior;
        }

        public final void setTimedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
        }

        @Override
        @Transient
        public final Builder timedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder timedMetadataBehavior(M3u8TimedMetadataBehavior timedMetadataBehavior) {
            this.timedMetadataBehavior(timedMetadataBehavior == null ? null : timedMetadataBehavior.toString());
            return this;
        }

        public final String getTimedMetadataPid() {
            return timedMetadataPid;
        }

        public final void setTimedMetadataPid(String timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
        }

        @Override
        @Transient
        public final Builder timedMetadataPid(String timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
            return this;
        }

        public final Integer getTransportStreamId() {
            return transportStreamId;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        @Override
        @Transient
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final String getVideoPid() {
            return videoPid;
        }

        public final void setVideoPid(String videoPid) {
            this.videoPid = videoPid;
        }

        @Override
        @Transient
        public final Builder videoPid(String videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        @Override
        public M3u8Settings build() {
            return new M3u8Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
