/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Media Package Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaPackageGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaPackageGroupSettings.Builder, MediaPackageGroupSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField
            .<OutputLocationRef> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(MediaPackageGroupSettings::destination)).setter(setter(Builder::destination))
            .constructor(OutputLocationRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final OutputLocationRef destination;

    private MediaPackageGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
    }

    /**
     * MediaPackage channel destination.
     * 
     * @return MediaPackage channel destination.
     */
    public final OutputLocationRef destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPackageGroupSettings)) {
            return false;
        }
        MediaPackageGroupSettings other = (MediaPackageGroupSettings) obj;
        return Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaPackageGroupSettings").add("Destination", destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaPackageGroupSettings, T> g) {
        return obj -> g.apply((MediaPackageGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaPackageGroupSettings> {
        /**
         * MediaPackage channel destination.
         * 
         * @param destination
         *        MediaPackage channel destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(OutputLocationRef destination);

        /**
         * MediaPackage channel destination. This is a convenience that creates an instance of the
         * {@link OutputLocationRef.Builder} avoiding the need to create one manually via
         * {@link OutputLocationRef#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocationRef.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(OutputLocationRef)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link OutputLocationRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(OutputLocationRef)
         */
        default Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return destination(OutputLocationRef.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OutputLocationRef destination;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPackageGroupSettings model) {
            destination(model.destination);
        }

        public final OutputLocationRef.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        @Transient
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public MediaPackageGroupSettings build() {
            return new MediaPackageGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
