/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Ms Smooth Output Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MsSmoothOutputSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MsSmoothOutputSettings.Builder, MsSmoothOutputSettings> {
    private static final SdkField<String> H265_PACKAGING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("H265PackagingType").getter(getter(MsSmoothOutputSettings::h265PackagingTypeAsString))
            .setter(setter(Builder::h265PackagingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265PackagingType").build()).build();

    private static final SdkField<String> NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameModifier").getter(getter(MsSmoothOutputSettings::nameModifier))
            .setter(setter(Builder::nameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameModifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(H265_PACKAGING_TYPE_FIELD,
            NAME_MODIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String h265PackagingType;

    private final String nameModifier;

    private MsSmoothOutputSettings(BuilderImpl builder) {
        this.h265PackagingType = builder.h265PackagingType;
        this.nameModifier = builder.nameModifier;
    }

    /**
     * Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments should
     * be packaged as HEV1 or HVC1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #h265PackagingType}
     * will return {@link MsSmoothH265PackagingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #h265PackagingTypeAsString}.
     * </p>
     * 
     * @return Only applicable when this output is referencing an H.265 video description. Specifies whether MP4
     *         segments should be packaged as HEV1 or HVC1.
     * @see MsSmoothH265PackagingType
     */
    public final MsSmoothH265PackagingType h265PackagingType() {
        return MsSmoothH265PackagingType.fromValue(h265PackagingType);
    }

    /**
     * Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments should
     * be packaged as HEV1 or HVC1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #h265PackagingType}
     * will return {@link MsSmoothH265PackagingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #h265PackagingTypeAsString}.
     * </p>
     * 
     * @return Only applicable when this output is referencing an H.265 video description. Specifies whether MP4
     *         segments should be packaged as HEV1 or HVC1.
     * @see MsSmoothH265PackagingType
     */
    public final String h265PackagingTypeAsString() {
        return h265PackagingType;
    }

    /**
     * String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
     * 
     * @return String concatenated to the end of the destination filename. Required for multiple outputs of the same
     *         type.
     */
    public final String nameModifier() {
        return nameModifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(h265PackagingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameModifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MsSmoothOutputSettings)) {
            return false;
        }
        MsSmoothOutputSettings other = (MsSmoothOutputSettings) obj;
        return Objects.equals(h265PackagingTypeAsString(), other.h265PackagingTypeAsString())
                && Objects.equals(nameModifier(), other.nameModifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MsSmoothOutputSettings").add("H265PackagingType", h265PackagingTypeAsString())
                .add("NameModifier", nameModifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "H265PackagingType":
            return Optional.ofNullable(clazz.cast(h265PackagingTypeAsString()));
        case "NameModifier":
            return Optional.ofNullable(clazz.cast(nameModifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MsSmoothOutputSettings, T> g) {
        return obj -> g.apply((MsSmoothOutputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MsSmoothOutputSettings> {
        /**
         * Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments
         * should be packaged as HEV1 or HVC1.
         * 
         * @param h265PackagingType
         *        Only applicable when this output is referencing an H.265 video description. Specifies whether MP4
         *        segments should be packaged as HEV1 or HVC1.
         * @see MsSmoothH265PackagingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MsSmoothH265PackagingType
         */
        Builder h265PackagingType(String h265PackagingType);

        /**
         * Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments
         * should be packaged as HEV1 or HVC1.
         * 
         * @param h265PackagingType
         *        Only applicable when this output is referencing an H.265 video description. Specifies whether MP4
         *        segments should be packaged as HEV1 or HVC1.
         * @see MsSmoothH265PackagingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MsSmoothH265PackagingType
         */
        Builder h265PackagingType(MsSmoothH265PackagingType h265PackagingType);

        /**
         * String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
         * 
         * @param nameModifier
         *        String concatenated to the end of the destination filename. Required for multiple outputs of the same
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameModifier(String nameModifier);
    }

    static final class BuilderImpl implements Builder {
        private String h265PackagingType;

        private String nameModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(MsSmoothOutputSettings model) {
            h265PackagingType(model.h265PackagingType);
            nameModifier(model.nameModifier);
        }

        public final String getH265PackagingType() {
            return h265PackagingType;
        }

        public final void setH265PackagingType(String h265PackagingType) {
            this.h265PackagingType = h265PackagingType;
        }

        @Override
        @Transient
        public final Builder h265PackagingType(String h265PackagingType) {
            this.h265PackagingType = h265PackagingType;
            return this;
        }

        @Override
        @Transient
        public final Builder h265PackagingType(MsSmoothH265PackagingType h265PackagingType) {
            this.h265PackagingType(h265PackagingType == null ? null : h265PackagingType.toString());
            return this;
        }

        public final String getNameModifier() {
            return nameModifier;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        @Override
        @Transient
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        @Override
        public MsSmoothOutputSettings build() {
            return new MsSmoothOutputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
