/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Statmux rate control settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexStatmuxVideoSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexStatmuxVideoSettings.Builder, MultiplexStatmuxVideoSettings> {
    private static final SdkField<Integer> MAXIMUM_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBitrate").getter(getter(MultiplexStatmuxVideoSettings::maximumBitrate))
            .setter(setter(Builder::maximumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()).build();

    private static final SdkField<Integer> MINIMUM_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumBitrate").getter(getter(MultiplexStatmuxVideoSettings::minimumBitrate))
            .setter(setter(Builder::minimumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumBitrate").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(MultiplexStatmuxVideoSettings::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BITRATE_FIELD,
            MINIMUM_BITRATE_FIELD, PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumBitrate;

    private final Integer minimumBitrate;

    private final Integer priority;

    private MultiplexStatmuxVideoSettings(BuilderImpl builder) {
        this.maximumBitrate = builder.maximumBitrate;
        this.minimumBitrate = builder.minimumBitrate;
        this.priority = builder.priority;
    }

    /**
     * Maximum statmux bitrate.
     * 
     * @return Maximum statmux bitrate.
     */
    public final Integer maximumBitrate() {
        return maximumBitrate;
    }

    /**
     * Minimum statmux bitrate.
     * 
     * @return Minimum statmux bitrate.
     */
    public final Integer minimumBitrate() {
        return minimumBitrate;
    }

    /**
     * The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the QVBR
     * capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over others. Channels
     * that have a higher priority will\nget higher video quality at the expense of the video quality of\nother channels
     * in the multiplex with lower priority.
     * 
     * @return The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the QVBR
     *         capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over others.
     *         Channels that have a higher priority will\nget higher video quality at the expense of the video quality
     *         of\nother channels in the multiplex with lower priority.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(minimumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexStatmuxVideoSettings)) {
            return false;
        }
        MultiplexStatmuxVideoSettings other = (MultiplexStatmuxVideoSettings) obj;
        return Objects.equals(maximumBitrate(), other.maximumBitrate())
                && Objects.equals(minimumBitrate(), other.minimumBitrate()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexStatmuxVideoSettings").add("MaximumBitrate", maximumBitrate())
                .add("MinimumBitrate", minimumBitrate()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumBitrate":
            return Optional.ofNullable(clazz.cast(maximumBitrate()));
        case "MinimumBitrate":
            return Optional.ofNullable(clazz.cast(minimumBitrate()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexStatmuxVideoSettings, T> g) {
        return obj -> g.apply((MultiplexStatmuxVideoSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexStatmuxVideoSettings> {
        /**
         * Maximum statmux bitrate.
         * 
         * @param maximumBitrate
         *        Maximum statmux bitrate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBitrate(Integer maximumBitrate);

        /**
         * Minimum statmux bitrate.
         * 
         * @param minimumBitrate
         *        Minimum statmux bitrate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumBitrate(Integer minimumBitrate);

        /**
         * The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the QVBR
         * capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over others.
         * Channels that have a higher priority will\nget higher video quality at the expense of the video quality
         * of\nother channels in the multiplex with lower priority.
         * 
         * @param priority
         *        The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the
         *        QVBR capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over
         *        others. Channels that have a higher priority will\nget higher video quality at the expense of the
         *        video quality of\nother channels in the multiplex with lower priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumBitrate;

        private Integer minimumBitrate;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexStatmuxVideoSettings model) {
            maximumBitrate(model.maximumBitrate);
            minimumBitrate(model.minimumBitrate);
            priority(model.priority);
        }

        public final Integer getMaximumBitrate() {
            return maximumBitrate;
        }

        public final void setMaximumBitrate(Integer maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        @Transient
        public final Builder maximumBitrate(Integer maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final Integer getMinimumBitrate() {
            return minimumBitrate;
        }

        public final void setMinimumBitrate(Integer minimumBitrate) {
            this.minimumBitrate = minimumBitrate;
        }

        @Override
        @Transient
        public final Builder minimumBitrate(Integer minimumBitrate) {
            this.minimumBitrate = minimumBitrate;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public MultiplexStatmuxVideoSettings build() {
            return new MultiplexStatmuxVideoSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
