/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Nielsen Configuration
 */
@Generated("software.amazon.awssdk:codegen")
public final class NielsenConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NielsenConfiguration.Builder, NielsenConfiguration> {
    private static final SdkField<String> DISTRIBUTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistributorId").getter(getter(NielsenConfiguration::distributorId))
            .setter(setter(Builder::distributorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributorId").build()).build();

    private static final SdkField<String> NIELSEN_PCM_TO_ID3_TAGGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NielsenPcmToId3Tagging").getter(getter(NielsenConfiguration::nielsenPcmToId3TaggingAsString))
            .setter(setter(Builder::nielsenPcmToId3Tagging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenPcmToId3Tagging").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTOR_ID_FIELD,
            NIELSEN_PCM_TO_ID3_TAGGING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String distributorId;

    private final String nielsenPcmToId3Tagging;

    private NielsenConfiguration(BuilderImpl builder) {
        this.distributorId = builder.distributorId;
        this.nielsenPcmToId3Tagging = builder.nielsenPcmToId3Tagging;
    }

    /**
     * Enter the Distributor ID assigned to your organization by Nielsen.
     * 
     * @return Enter the Distributor ID assigned to your organization by Nielsen.
     */
    public final String distributorId() {
        return distributorId;
    }

    /**
     * Enables Nielsen PCM to ID3 tagging
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenPcmToId3Tagging} will return {@link NielsenPcmToId3TaggingState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #nielsenPcmToId3TaggingAsString}.
     * </p>
     * 
     * @return Enables Nielsen PCM to ID3 tagging
     * @see NielsenPcmToId3TaggingState
     */
    public final NielsenPcmToId3TaggingState nielsenPcmToId3Tagging() {
        return NielsenPcmToId3TaggingState.fromValue(nielsenPcmToId3Tagging);
    }

    /**
     * Enables Nielsen PCM to ID3 tagging
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenPcmToId3Tagging} will return {@link NielsenPcmToId3TaggingState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #nielsenPcmToId3TaggingAsString}.
     * </p>
     * 
     * @return Enables Nielsen PCM to ID3 tagging
     * @see NielsenPcmToId3TaggingState
     */
    public final String nielsenPcmToId3TaggingAsString() {
        return nielsenPcmToId3Tagging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distributorId());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenPcmToId3TaggingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NielsenConfiguration)) {
            return false;
        }
        NielsenConfiguration other = (NielsenConfiguration) obj;
        return Objects.equals(distributorId(), other.distributorId())
                && Objects.equals(nielsenPcmToId3TaggingAsString(), other.nielsenPcmToId3TaggingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NielsenConfiguration").add("DistributorId", distributorId())
                .add("NielsenPcmToId3Tagging", nielsenPcmToId3TaggingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributorId":
            return Optional.ofNullable(clazz.cast(distributorId()));
        case "NielsenPcmToId3Tagging":
            return Optional.ofNullable(clazz.cast(nielsenPcmToId3TaggingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NielsenConfiguration, T> g) {
        return obj -> g.apply((NielsenConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NielsenConfiguration> {
        /**
         * Enter the Distributor ID assigned to your organization by Nielsen.
         * 
         * @param distributorId
         *        Enter the Distributor ID assigned to your organization by Nielsen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributorId(String distributorId);

        /**
         * Enables Nielsen PCM to ID3 tagging
         * 
         * @param nielsenPcmToId3Tagging
         *        Enables Nielsen PCM to ID3 tagging
         * @see NielsenPcmToId3TaggingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenPcmToId3TaggingState
         */
        Builder nielsenPcmToId3Tagging(String nielsenPcmToId3Tagging);

        /**
         * Enables Nielsen PCM to ID3 tagging
         * 
         * @param nielsenPcmToId3Tagging
         *        Enables Nielsen PCM to ID3 tagging
         * @see NielsenPcmToId3TaggingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenPcmToId3TaggingState
         */
        Builder nielsenPcmToId3Tagging(NielsenPcmToId3TaggingState nielsenPcmToId3Tagging);
    }

    static final class BuilderImpl implements Builder {
        private String distributorId;

        private String nielsenPcmToId3Tagging;

        private BuilderImpl() {
        }

        private BuilderImpl(NielsenConfiguration model) {
            distributorId(model.distributorId);
            nielsenPcmToId3Tagging(model.nielsenPcmToId3Tagging);
        }

        public final String getDistributorId() {
            return distributorId;
        }

        public final void setDistributorId(String distributorId) {
            this.distributorId = distributorId;
        }

        @Override
        @Transient
        public final Builder distributorId(String distributorId) {
            this.distributorId = distributorId;
            return this;
        }

        public final String getNielsenPcmToId3Tagging() {
            return nielsenPcmToId3Tagging;
        }

        public final void setNielsenPcmToId3Tagging(String nielsenPcmToId3Tagging) {
            this.nielsenPcmToId3Tagging = nielsenPcmToId3Tagging;
        }

        @Override
        @Transient
        public final Builder nielsenPcmToId3Tagging(String nielsenPcmToId3Tagging) {
            this.nielsenPcmToId3Tagging = nielsenPcmToId3Tagging;
            return this;
        }

        @Override
        @Transient
        public final Builder nielsenPcmToId3Tagging(NielsenPcmToId3TaggingState nielsenPcmToId3Tagging) {
            this.nielsenPcmToId3Tagging(nielsenPcmToId3Tagging == null ? null : nielsenPcmToId3Tagging.toString());
            return this;
        }

        @Override
        public NielsenConfiguration build() {
            return new NielsenConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
