/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Nielsen Watermarks Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class NielsenWatermarksSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<NielsenWatermarksSettings.Builder, NielsenWatermarksSettings> {
    private static final SdkField<NielsenCBET> NIELSEN_CBET_SETTINGS_FIELD = SdkField
            .<NielsenCBET> builder(MarshallingType.SDK_POJO).memberName("NielsenCbetSettings")
            .getter(getter(NielsenWatermarksSettings::nielsenCbetSettings)).setter(setter(Builder::nielsenCbetSettings))
            .constructor(NielsenCBET::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenCbetSettings").build())
            .build();

    private static final SdkField<String> NIELSEN_DISTRIBUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NielsenDistributionType").getter(getter(NielsenWatermarksSettings::nielsenDistributionTypeAsString))
            .setter(setter(Builder::nielsenDistributionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenDistributionType").build())
            .build();

    private static final SdkField<NielsenNaesIiNw> NIELSEN_NAES_II_NW_SETTINGS_FIELD = SdkField
            .<NielsenNaesIiNw> builder(MarshallingType.SDK_POJO).memberName("NielsenNaesIiNwSettings")
            .getter(getter(NielsenWatermarksSettings::nielsenNaesIiNwSettings)).setter(setter(Builder::nielsenNaesIiNwSettings))
            .constructor(NielsenNaesIiNw::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenNaesIiNwSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NIELSEN_CBET_SETTINGS_FIELD,
            NIELSEN_DISTRIBUTION_TYPE_FIELD, NIELSEN_NAES_II_NW_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final NielsenCBET nielsenCbetSettings;

    private final String nielsenDistributionType;

    private final NielsenNaesIiNw nielsenNaesIiNwSettings;

    private NielsenWatermarksSettings(BuilderImpl builder) {
        this.nielsenCbetSettings = builder.nielsenCbetSettings;
        this.nielsenDistributionType = builder.nielsenDistributionType;
        this.nielsenNaesIiNwSettings = builder.nielsenNaesIiNwSettings;
    }

    /**
     * Complete these fields only if you want to insert watermarks of type Nielsen CBET
     * 
     * @return Complete these fields only if you want to insert watermarks of type Nielsen CBET
     */
    public final NielsenCBET nielsenCbetSettings() {
        return nielsenCbetSettings;
    }

    /**
     * Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT - FINAL_DISTRIBUTOR
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenDistributionType} will return {@link NielsenWatermarksDistributionTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #nielsenDistributionTypeAsString}.
     * </p>
     * 
     * @return Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT -
     *         FINAL_DISTRIBUTOR
     * @see NielsenWatermarksDistributionTypes
     */
    public final NielsenWatermarksDistributionTypes nielsenDistributionType() {
        return NielsenWatermarksDistributionTypes.fromValue(nielsenDistributionType);
    }

    /**
     * Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT - FINAL_DISTRIBUTOR
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenDistributionType} will return {@link NielsenWatermarksDistributionTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #nielsenDistributionTypeAsString}.
     * </p>
     * 
     * @return Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT -
     *         FINAL_DISTRIBUTOR
     * @see NielsenWatermarksDistributionTypes
     */
    public final String nielsenDistributionTypeAsString() {
        return nielsenDistributionType;
    }

    /**
     * Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen NAES VI
     * (NW).
     * 
     * @return Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen NAES
     *         VI (NW).
     */
    public final NielsenNaesIiNw nielsenNaesIiNwSettings() {
        return nielsenNaesIiNwSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nielsenCbetSettings());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenDistributionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenNaesIiNwSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NielsenWatermarksSettings)) {
            return false;
        }
        NielsenWatermarksSettings other = (NielsenWatermarksSettings) obj;
        return Objects.equals(nielsenCbetSettings(), other.nielsenCbetSettings())
                && Objects.equals(nielsenDistributionTypeAsString(), other.nielsenDistributionTypeAsString())
                && Objects.equals(nielsenNaesIiNwSettings(), other.nielsenNaesIiNwSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NielsenWatermarksSettings").add("NielsenCbetSettings", nielsenCbetSettings())
                .add("NielsenDistributionType", nielsenDistributionTypeAsString())
                .add("NielsenNaesIiNwSettings", nielsenNaesIiNwSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NielsenCbetSettings":
            return Optional.ofNullable(clazz.cast(nielsenCbetSettings()));
        case "NielsenDistributionType":
            return Optional.ofNullable(clazz.cast(nielsenDistributionTypeAsString()));
        case "NielsenNaesIiNwSettings":
            return Optional.ofNullable(clazz.cast(nielsenNaesIiNwSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NielsenWatermarksSettings, T> g) {
        return obj -> g.apply((NielsenWatermarksSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NielsenWatermarksSettings> {
        /**
         * Complete these fields only if you want to insert watermarks of type Nielsen CBET
         * 
         * @param nielsenCbetSettings
         *        Complete these fields only if you want to insert watermarks of type Nielsen CBET
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nielsenCbetSettings(NielsenCBET nielsenCbetSettings);

        /**
         * Complete these fields only if you want to insert watermarks of type Nielsen CBET This is a convenience that
         * creates an instance of the {@link NielsenCBET.Builder} avoiding the need to create one manually via
         * {@link NielsenCBET#builder()}.
         *
         * When the {@link Consumer} completes, {@link NielsenCBET.Builder#build()} is called immediately and its result
         * is passed to {@link #nielsenCbetSettings(NielsenCBET)}.
         * 
         * @param nielsenCbetSettings
         *        a consumer that will call methods on {@link NielsenCBET.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nielsenCbetSettings(NielsenCBET)
         */
        default Builder nielsenCbetSettings(Consumer<NielsenCBET.Builder> nielsenCbetSettings) {
            return nielsenCbetSettings(NielsenCBET.builder().applyMutation(nielsenCbetSettings).build());
        }

        /**
         * Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT -
         * FINAL_DISTRIBUTOR
         * 
         * @param nielsenDistributionType
         *        Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT -
         *        FINAL_DISTRIBUTOR
         * @see NielsenWatermarksDistributionTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenWatermarksDistributionTypes
         */
        Builder nielsenDistributionType(String nielsenDistributionType);

        /**
         * Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT -
         * FINAL_DISTRIBUTOR
         * 
         * @param nielsenDistributionType
         *        Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT -
         *        FINAL_DISTRIBUTOR
         * @see NielsenWatermarksDistributionTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenWatermarksDistributionTypes
         */
        Builder nielsenDistributionType(NielsenWatermarksDistributionTypes nielsenDistributionType);

        /**
         * Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen NAES VI
         * (NW).
         * 
         * @param nielsenNaesIiNwSettings
         *        Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen
         *        NAES VI (NW).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nielsenNaesIiNwSettings(NielsenNaesIiNw nielsenNaesIiNwSettings);

        /**
         * Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen NAES VI
         * (NW). This is a convenience that creates an instance of the {@link NielsenNaesIiNw.Builder} avoiding the need
         * to create one manually via {@link NielsenNaesIiNw#builder()}.
         *
         * When the {@link Consumer} completes, {@link NielsenNaesIiNw.Builder#build()} is called immediately and its
         * result is passed to {@link #nielsenNaesIiNwSettings(NielsenNaesIiNw)}.
         * 
         * @param nielsenNaesIiNwSettings
         *        a consumer that will call methods on {@link NielsenNaesIiNw.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nielsenNaesIiNwSettings(NielsenNaesIiNw)
         */
        default Builder nielsenNaesIiNwSettings(Consumer<NielsenNaesIiNw.Builder> nielsenNaesIiNwSettings) {
            return nielsenNaesIiNwSettings(NielsenNaesIiNw.builder().applyMutation(nielsenNaesIiNwSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NielsenCBET nielsenCbetSettings;

        private String nielsenDistributionType;

        private NielsenNaesIiNw nielsenNaesIiNwSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(NielsenWatermarksSettings model) {
            nielsenCbetSettings(model.nielsenCbetSettings);
            nielsenDistributionType(model.nielsenDistributionType);
            nielsenNaesIiNwSettings(model.nielsenNaesIiNwSettings);
        }

        public final NielsenCBET.Builder getNielsenCbetSettings() {
            return nielsenCbetSettings != null ? nielsenCbetSettings.toBuilder() : null;
        }

        public final void setNielsenCbetSettings(NielsenCBET.BuilderImpl nielsenCbetSettings) {
            this.nielsenCbetSettings = nielsenCbetSettings != null ? nielsenCbetSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder nielsenCbetSettings(NielsenCBET nielsenCbetSettings) {
            this.nielsenCbetSettings = nielsenCbetSettings;
            return this;
        }

        public final String getNielsenDistributionType() {
            return nielsenDistributionType;
        }

        public final void setNielsenDistributionType(String nielsenDistributionType) {
            this.nielsenDistributionType = nielsenDistributionType;
        }

        @Override
        @Transient
        public final Builder nielsenDistributionType(String nielsenDistributionType) {
            this.nielsenDistributionType = nielsenDistributionType;
            return this;
        }

        @Override
        @Transient
        public final Builder nielsenDistributionType(NielsenWatermarksDistributionTypes nielsenDistributionType) {
            this.nielsenDistributionType(nielsenDistributionType == null ? null : nielsenDistributionType.toString());
            return this;
        }

        public final NielsenNaesIiNw.Builder getNielsenNaesIiNwSettings() {
            return nielsenNaesIiNwSettings != null ? nielsenNaesIiNwSettings.toBuilder() : null;
        }

        public final void setNielsenNaesIiNwSettings(NielsenNaesIiNw.BuilderImpl nielsenNaesIiNwSettings) {
            this.nielsenNaesIiNwSettings = nielsenNaesIiNwSettings != null ? nielsenNaesIiNwSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder nielsenNaesIiNwSettings(NielsenNaesIiNw nielsenNaesIiNwSettings) {
            this.nielsenNaesIiNwSettings = nielsenNaesIiNwSettings;
            return this;
        }

        @Override
        public NielsenWatermarksSettings build() {
            return new NielsenWatermarksSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
