/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Output groups for this Live Event. Output groups contain information about where streams should be distributed.
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputGroup implements SdkPojo, Serializable, ToCopyableBuilder<OutputGroup.Builder, OutputGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OutputGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<OutputGroupSettings> OUTPUT_GROUP_SETTINGS_FIELD = SdkField
            .<OutputGroupSettings> builder(MarshallingType.SDK_POJO).memberName("OutputGroupSettings")
            .getter(getter(OutputGroup::outputGroupSettings)).setter(setter(Builder::outputGroupSettings))
            .constructor(OutputGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroupSettings").build())
            .build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(OutputGroup::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            OUTPUT_GROUP_SETTINGS_FIELD, OUTPUTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final OutputGroupSettings outputGroupSettings;

    private final List<Output> outputs;

    private OutputGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.outputGroupSettings = builder.outputGroupSettings;
        this.outputs = builder.outputs;
    }

    /**
     * Custom output group name optionally defined by the user. Only letters, numbers, and the underscore character
     * allowed; only 32 characters allowed.
     * 
     * @return Custom output group name optionally defined by the user. Only letters, numbers, and the underscore
     *         character allowed; only 32 characters allowed.
     */
    public final String name() {
        return name;
    }

    /**
     * Settings associated with the output group.
     * 
     * @return Settings associated with the output group.
     */
    public final OutputGroupSettings outputGroupSettings() {
        return outputGroupSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Outputs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The value of the Outputs property for this object.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroup)) {
            return false;
        }
        OutputGroup other = (OutputGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(outputGroupSettings(), other.outputGroupSettings())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputGroup").add("Name", name()).add("OutputGroupSettings", outputGroupSettings())
                .add("Outputs", hasOutputs() ? outputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OutputGroupSettings":
            return Optional.ofNullable(clazz.cast(outputGroupSettings()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputGroup, T> g) {
        return obj -> g.apply((OutputGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputGroup> {
        /**
         * Custom output group name optionally defined by the user. Only letters, numbers, and the underscore character
         * allowed; only 32 characters allowed.
         * 
         * @param name
         *        Custom output group name optionally defined by the user. Only letters, numbers, and the underscore
         *        character allowed; only 32 characters allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Settings associated with the output group.
         * 
         * @param outputGroupSettings
         *        Settings associated with the output group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroupSettings(OutputGroupSettings outputGroupSettings);

        /**
         * Settings associated with the output group. This is a convenience that creates an instance of the
         * {@link OutputGroupSettings.Builder} avoiding the need to create one manually via
         * {@link OutputGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputGroupSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #outputGroupSettings(OutputGroupSettings)}.
         * 
         * @param outputGroupSettings
         *        a consumer that will call methods on {@link OutputGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputGroupSettings(OutputGroupSettings)
         */
        default Builder outputGroupSettings(Consumer<OutputGroupSettings.Builder> outputGroupSettings) {
            return outputGroupSettings(OutputGroupSettings.builder().applyMutation(outputGroupSettings).build());
        }

        /**
         * Sets the value of the Outputs property for this object.
         *
         * @param outputs
         *        The new value for the Outputs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * Sets the value of the Outputs property for this object.
         *
         * @param outputs
         *        The new value for the Outputs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * Sets the value of the Outputs property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Output>.Builder} avoiding the need to
         * create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private OutputGroupSettings outputGroupSettings;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroup model) {
            name(model.name);
            outputGroupSettings(model.outputGroupSettings);
            outputs(model.outputs);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final OutputGroupSettings.Builder getOutputGroupSettings() {
            return outputGroupSettings != null ? outputGroupSettings.toBuilder() : null;
        }

        public final void setOutputGroupSettings(OutputGroupSettings.BuilderImpl outputGroupSettings) {
            this.outputGroupSettings = outputGroupSettings != null ? outputGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder outputGroupSettings(OutputGroupSettings outputGroupSettings) {
            this.outputGroupSettings = outputGroupSettings;
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = ___listOfOutputCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ___listOfOutputCopier.copyFromBuilder(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ___listOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OutputGroup build() {
            return new OutputGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
