/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Runtime details of a pipeline when a channel is running.
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineDetail implements SdkPojo, Serializable, ToCopyableBuilder<PipelineDetail.Builder, PipelineDetail> {
    private static final SdkField<String> ACTIVE_INPUT_ATTACHMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveInputAttachmentName").getter(getter(PipelineDetail::activeInputAttachmentName))
            .setter(setter(Builder::activeInputAttachmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeInputAttachmentName").build())
            .build();

    private static final SdkField<String> ACTIVE_INPUT_SWITCH_ACTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ActiveInputSwitchActionName")
            .getter(getter(PipelineDetail::activeInputSwitchActionName))
            .setter(setter(Builder::activeInputSwitchActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeInputSwitchActionName")
                    .build()).build();

    private static final SdkField<String> ACTIVE_MOTION_GRAPHICS_ACTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ActiveMotionGraphicsActionName")
            .getter(getter(PipelineDetail::activeMotionGraphicsActionName))
            .setter(setter(Builder::activeMotionGraphicsActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeMotionGraphicsActionName")
                    .build()).build();

    private static final SdkField<String> ACTIVE_MOTION_GRAPHICS_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveMotionGraphicsUri").getter(getter(PipelineDetail::activeMotionGraphicsUri))
            .setter(setter(Builder::activeMotionGraphicsUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeMotionGraphicsUri").build())
            .build();

    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineId").getter(getter(PipelineDetail::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVE_INPUT_ATTACHMENT_NAME_FIELD, ACTIVE_INPUT_SWITCH_ACTION_NAME_FIELD, ACTIVE_MOTION_GRAPHICS_ACTION_NAME_FIELD,
            ACTIVE_MOTION_GRAPHICS_URI_FIELD, PIPELINE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activeInputAttachmentName;

    private final String activeInputSwitchActionName;

    private final String activeMotionGraphicsActionName;

    private final String activeMotionGraphicsUri;

    private final String pipelineId;

    private PipelineDetail(BuilderImpl builder) {
        this.activeInputAttachmentName = builder.activeInputAttachmentName;
        this.activeInputSwitchActionName = builder.activeInputSwitchActionName;
        this.activeMotionGraphicsActionName = builder.activeMotionGraphicsActionName;
        this.activeMotionGraphicsUri = builder.activeMotionGraphicsUri;
        this.pipelineId = builder.pipelineId;
    }

    /**
     * The name of the active input attachment currently being ingested by this pipeline.
     * 
     * @return The name of the active input attachment currently being ingested by this pipeline.
     */
    public final String activeInputAttachmentName() {
        return activeInputAttachmentName;
    }

    /**
     * The name of the input switch schedule action that occurred most recently and that resulted in the switch to the
     * current input attachment for this pipeline.
     * 
     * @return The name of the input switch schedule action that occurred most recently and that resulted in the switch
     *         to the current input attachment for this pipeline.
     */
    public final String activeInputSwitchActionName() {
        return activeInputSwitchActionName;
    }

    /**
     * The name of the motion graphics activate action that occurred most recently and that resulted in the current
     * graphics URI for this pipeline.
     * 
     * @return The name of the motion graphics activate action that occurred most recently and that resulted in the
     *         current graphics URI for this pipeline.
     */
    public final String activeMotionGraphicsActionName() {
        return activeMotionGraphicsActionName;
    }

    /**
     * The current URI being used for HTML5 motion graphics for this pipeline.
     * 
     * @return The current URI being used for HTML5 motion graphics for this pipeline.
     */
    public final String activeMotionGraphicsUri() {
        return activeMotionGraphicsUri;
    }

    /**
     * Pipeline ID
     * 
     * @return Pipeline ID
     */
    public final String pipelineId() {
        return pipelineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeInputAttachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(activeInputSwitchActionName());
        hashCode = 31 * hashCode + Objects.hashCode(activeMotionGraphicsActionName());
        hashCode = 31 * hashCode + Objects.hashCode(activeMotionGraphicsUri());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDetail)) {
            return false;
        }
        PipelineDetail other = (PipelineDetail) obj;
        return Objects.equals(activeInputAttachmentName(), other.activeInputAttachmentName())
                && Objects.equals(activeInputSwitchActionName(), other.activeInputSwitchActionName())
                && Objects.equals(activeMotionGraphicsActionName(), other.activeMotionGraphicsActionName())
                && Objects.equals(activeMotionGraphicsUri(), other.activeMotionGraphicsUri())
                && Objects.equals(pipelineId(), other.pipelineId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineDetail").add("ActiveInputAttachmentName", activeInputAttachmentName())
                .add("ActiveInputSwitchActionName", activeInputSwitchActionName())
                .add("ActiveMotionGraphicsActionName", activeMotionGraphicsActionName())
                .add("ActiveMotionGraphicsUri", activeMotionGraphicsUri()).add("PipelineId", pipelineId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveInputAttachmentName":
            return Optional.ofNullable(clazz.cast(activeInputAttachmentName()));
        case "ActiveInputSwitchActionName":
            return Optional.ofNullable(clazz.cast(activeInputSwitchActionName()));
        case "ActiveMotionGraphicsActionName":
            return Optional.ofNullable(clazz.cast(activeMotionGraphicsActionName()));
        case "ActiveMotionGraphicsUri":
            return Optional.ofNullable(clazz.cast(activeMotionGraphicsUri()));
        case "PipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineDetail, T> g) {
        return obj -> g.apply((PipelineDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineDetail> {
        /**
         * The name of the active input attachment currently being ingested by this pipeline.
         * 
         * @param activeInputAttachmentName
         *        The name of the active input attachment currently being ingested by this pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInputAttachmentName(String activeInputAttachmentName);

        /**
         * The name of the input switch schedule action that occurred most recently and that resulted in the switch to
         * the current input attachment for this pipeline.
         * 
         * @param activeInputSwitchActionName
         *        The name of the input switch schedule action that occurred most recently and that resulted in the
         *        switch to the current input attachment for this pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInputSwitchActionName(String activeInputSwitchActionName);

        /**
         * The name of the motion graphics activate action that occurred most recently and that resulted in the current
         * graphics URI for this pipeline.
         * 
         * @param activeMotionGraphicsActionName
         *        The name of the motion graphics activate action that occurred most recently and that resulted in the
         *        current graphics URI for this pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeMotionGraphicsActionName(String activeMotionGraphicsActionName);

        /**
         * The current URI being used for HTML5 motion graphics for this pipeline.
         * 
         * @param activeMotionGraphicsUri
         *        The current URI being used for HTML5 motion graphics for this pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeMotionGraphicsUri(String activeMotionGraphicsUri);

        /**
         * Pipeline ID
         * 
         * @param pipelineId
         *        Pipeline ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);
    }

    static final class BuilderImpl implements Builder {
        private String activeInputAttachmentName;

        private String activeInputSwitchActionName;

        private String activeMotionGraphicsActionName;

        private String activeMotionGraphicsUri;

        private String pipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDetail model) {
            activeInputAttachmentName(model.activeInputAttachmentName);
            activeInputSwitchActionName(model.activeInputSwitchActionName);
            activeMotionGraphicsActionName(model.activeMotionGraphicsActionName);
            activeMotionGraphicsUri(model.activeMotionGraphicsUri);
            pipelineId(model.pipelineId);
        }

        public final String getActiveInputAttachmentName() {
            return activeInputAttachmentName;
        }

        public final void setActiveInputAttachmentName(String activeInputAttachmentName) {
            this.activeInputAttachmentName = activeInputAttachmentName;
        }

        @Override
        @Transient
        public final Builder activeInputAttachmentName(String activeInputAttachmentName) {
            this.activeInputAttachmentName = activeInputAttachmentName;
            return this;
        }

        public final String getActiveInputSwitchActionName() {
            return activeInputSwitchActionName;
        }

        public final void setActiveInputSwitchActionName(String activeInputSwitchActionName) {
            this.activeInputSwitchActionName = activeInputSwitchActionName;
        }

        @Override
        @Transient
        public final Builder activeInputSwitchActionName(String activeInputSwitchActionName) {
            this.activeInputSwitchActionName = activeInputSwitchActionName;
            return this;
        }

        public final String getActiveMotionGraphicsActionName() {
            return activeMotionGraphicsActionName;
        }

        public final void setActiveMotionGraphicsActionName(String activeMotionGraphicsActionName) {
            this.activeMotionGraphicsActionName = activeMotionGraphicsActionName;
        }

        @Override
        @Transient
        public final Builder activeMotionGraphicsActionName(String activeMotionGraphicsActionName) {
            this.activeMotionGraphicsActionName = activeMotionGraphicsActionName;
            return this;
        }

        public final String getActiveMotionGraphicsUri() {
            return activeMotionGraphicsUri;
        }

        public final void setActiveMotionGraphicsUri(String activeMotionGraphicsUri) {
            this.activeMotionGraphicsUri = activeMotionGraphicsUri;
        }

        @Override
        @Transient
        public final Builder activeMotionGraphicsUri(String activeMotionGraphicsUri) {
            this.activeMotionGraphicsUri = activeMotionGraphicsUri;
            return this;
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        @Transient
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        @Override
        public PipelineDetail build() {
            return new PipelineDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
