/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Rtmp Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class RtmpGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RtmpGroupSettings.Builder, RtmpGroupSettings> {
    private static final SdkField<List<String>> AD_MARKERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdMarkers")
            .getter(getter(RtmpGroupSettings::adMarkersAsStrings))
            .setter(setter(Builder::adMarkersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTHENTICATION_SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationScheme").getter(getter(RtmpGroupSettings::authenticationSchemeAsString))
            .setter(setter(Builder::authenticationScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationScheme").build())
            .build();

    private static final SdkField<String> CACHE_FULL_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheFullBehavior").getter(getter(RtmpGroupSettings::cacheFullBehaviorAsString))
            .setter(setter(Builder::cacheFullBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheFullBehavior").build()).build();

    private static final SdkField<Integer> CACHE_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CacheLength").getter(getter(RtmpGroupSettings::cacheLength)).setter(setter(Builder::cacheLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheLength").build()).build();

    private static final SdkField<String> CAPTION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptionData").getter(getter(RtmpGroupSettings::captionDataAsString))
            .setter(setter(Builder::captionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionData").build()).build();

    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputLossAction").getter(getter(RtmpGroupSettings::inputLossActionAsString))
            .setter(setter(Builder::inputLossAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()).build();

    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RestartDelay").getter(getter(RtmpGroupSettings::restartDelay)).setter(setter(Builder::restartDelay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD,
            AUTHENTICATION_SCHEME_FIELD, CACHE_FULL_BEHAVIOR_FIELD, CACHE_LENGTH_FIELD, CAPTION_DATA_FIELD,
            INPUT_LOSS_ACTION_FIELD, RESTART_DELAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> adMarkers;

    private final String authenticationScheme;

    private final String cacheFullBehavior;

    private final Integer cacheLength;

    private final String captionData;

    private final String inputLossAction;

    private final Integer restartDelay;

    private RtmpGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.authenticationScheme = builder.authenticationScheme;
        this.cacheFullBehavior = builder.cacheFullBehavior;
        this.cacheLength = builder.cacheLength;
        this.captionData = builder.captionData;
        this.inputLossAction = builder.inputLossAction;
        this.restartDelay = builder.restartDelay;
    }

    /**
     * Choose the ad marker type for this output group. MediaLive will create a message based on the content of each
     * SCTE-35 message, format it for that marker type, and insert it in the datastream.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdMarkers} method.
     * </p>
     * 
     * @return Choose the ad marker type for this output group. MediaLive will create a message based on the content of
     *         each SCTE-35 message, format it for that marker type, and insert it in the datastream.
     */
    public final List<RtmpAdMarkers> adMarkers() {
        return ___listOfRtmpAdMarkersCopier.copyStringToEnum(adMarkers);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdMarkers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdMarkers() {
        return adMarkers != null && !(adMarkers instanceof SdkAutoConstructList);
    }

    /**
     * Choose the ad marker type for this output group. MediaLive will create a message based on the content of each
     * SCTE-35 message, format it for that marker type, and insert it in the datastream.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdMarkers} method.
     * </p>
     * 
     * @return Choose the ad marker type for this output group. MediaLive will create a message based on the content of
     *         each SCTE-35 message, format it for that marker type, and insert it in the datastream.
     */
    public final List<String> adMarkersAsStrings() {
        return adMarkers;
    }

    /**
     * Authentication scheme to use when connecting with CDN
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationScheme} will return {@link AuthenticationScheme#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationSchemeAsString}.
     * </p>
     * 
     * @return Authentication scheme to use when connecting with CDN
     * @see AuthenticationScheme
     */
    public final AuthenticationScheme authenticationScheme() {
        return AuthenticationScheme.fromValue(authenticationScheme);
    }

    /**
     * Authentication scheme to use when connecting with CDN
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationScheme} will return {@link AuthenticationScheme#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationSchemeAsString}.
     * </p>
     * 
     * @return Authentication scheme to use when connecting with CDN
     * @see AuthenticationScheme
     */
    public final String authenticationSchemeAsString() {
        return authenticationScheme;
    }

    /**
     * Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and does not
     * accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration specified by
     * cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the RTMP output will
     * force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If set to waitForServer, the
     * RTMP output will wait up to 5 minutes to allow the origin server to begin accepting data again.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheFullBehavior}
     * will return {@link RtmpCacheFullBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #cacheFullBehaviorAsString}.
     * </p>
     * 
     * @return Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and
     *         does not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration
     *         specified by cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the
     *         RTMP output will force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If
     *         set to waitForServer, the RTMP output will wait up to 5 minutes to allow the origin server to begin
     *         accepting data again.
     * @see RtmpCacheFullBehavior
     */
    public final RtmpCacheFullBehavior cacheFullBehavior() {
        return RtmpCacheFullBehavior.fromValue(cacheFullBehavior);
    }

    /**
     * Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and does not
     * accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration specified by
     * cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the RTMP output will
     * force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If set to waitForServer, the
     * RTMP output will wait up to 5 minutes to allow the origin server to begin accepting data again.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheFullBehavior}
     * will return {@link RtmpCacheFullBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #cacheFullBehaviorAsString}.
     * </p>
     * 
     * @return Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and
     *         does not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration
     *         specified by cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the
     *         RTMP output will force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If
     *         set to waitForServer, the RTMP output will wait up to 5 minutes to allow the origin server to begin
     *         accepting data again.
     * @see RtmpCacheFullBehavior
     */
    public final String cacheFullBehaviorAsString() {
        return cacheFullBehavior;
    }

    /**
     * Cache length, in seconds, is used to calculate buffer size.
     * 
     * @return Cache length, in seconds, is used to calculate buffer size.
     */
    public final Integer cacheLength() {
        return cacheLength;
    }

    /**
     * Controls the types of data that passes to onCaptionInfo outputs. If set to 'all' then 608 and 708 carried DTVCC
     * data will be passed. If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608 data from both
     * fields will be passed. If set to 'field1608' then only the data carried in 608 from field 1 video will be passed.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #captionData} will
     * return {@link RtmpCaptionData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #captionDataAsString}.
     * </p>
     * 
     * @return Controls the types of data that passes to onCaptionInfo outputs. If set to 'all' then 608 and 708 carried
     *         DTVCC data will be passed. If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608
     *         data from both fields will be passed. If set to 'field1608' then only the data carried in 608 from field
     *         1 video will be passed.
     * @see RtmpCaptionData
     */
    public final RtmpCaptionData captionData() {
        return RtmpCaptionData.fromValue(captionData);
    }

    /**
     * Controls the types of data that passes to onCaptionInfo outputs. If set to 'all' then 608 and 708 carried DTVCC
     * data will be passed. If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608 data from both
     * fields will be passed. If set to 'field1608' then only the data carried in 608 from field 1 video will be passed.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #captionData} will
     * return {@link RtmpCaptionData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #captionDataAsString}.
     * </p>
     * 
     * @return Controls the types of data that passes to onCaptionInfo outputs. If set to 'all' then 608 and 708 carried
     *         DTVCC data will be passed. If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608
     *         data from both fields will be passed. If set to 'field1608' then only the data carried in 608 from field
     *         1 video will be passed.
     * @see RtmpCaptionData
     */
    public final String captionDataAsString() {
        return captionData;
    }

    /**
     * Controls the behavior of this RTMP group if input becomes unavailable.
     *
     * - emitOutput: Emit a slate until input returns. - pauseOutput: Stop transmitting data until input returns. This
     * does not close the underlying RTMP connection.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForRtmpOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Controls the behavior of this RTMP group if input becomes unavailable.
     *
     *         - emitOutput: Emit a slate until input returns. - pauseOutput: Stop transmitting data until input
     *         returns. This does not close the underlying RTMP connection.
     * @see InputLossActionForRtmpOut
     */
    public final InputLossActionForRtmpOut inputLossAction() {
        return InputLossActionForRtmpOut.fromValue(inputLossAction);
    }

    /**
     * Controls the behavior of this RTMP group if input becomes unavailable.
     *
     * - emitOutput: Emit a slate until input returns. - pauseOutput: Stop transmitting data until input returns. This
     * does not close the underlying RTMP connection.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForRtmpOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Controls the behavior of this RTMP group if input becomes unavailable.
     *
     *         - emitOutput: Emit a slate until input returns. - pauseOutput: Stop transmitting data until input
     *         returns. This does not close the underlying RTMP connection.
     * @see InputLossActionForRtmpOut
     */
    public final String inputLossActionAsString() {
        return inputLossAction;
    }

    /**
     * If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never
     * restart.
     * 
     * @return If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means
     *         never restart.
     */
    public final Integer restartDelay() {
        return restartDelay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdMarkers() ? adMarkersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cacheFullBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cacheLength());
        hashCode = 31 * hashCode + Objects.hashCode(captionDataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(restartDelay());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RtmpGroupSettings)) {
            return false;
        }
        RtmpGroupSettings other = (RtmpGroupSettings) obj;
        return hasAdMarkers() == other.hasAdMarkers() && Objects.equals(adMarkersAsStrings(), other.adMarkersAsStrings())
                && Objects.equals(authenticationSchemeAsString(), other.authenticationSchemeAsString())
                && Objects.equals(cacheFullBehaviorAsString(), other.cacheFullBehaviorAsString())
                && Objects.equals(cacheLength(), other.cacheLength())
                && Objects.equals(captionDataAsString(), other.captionDataAsString())
                && Objects.equals(inputLossActionAsString(), other.inputLossActionAsString())
                && Objects.equals(restartDelay(), other.restartDelay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RtmpGroupSettings").add("AdMarkers", hasAdMarkers() ? adMarkersAsStrings() : null)
                .add("AuthenticationScheme", authenticationSchemeAsString())
                .add("CacheFullBehavior", cacheFullBehaviorAsString()).add("CacheLength", cacheLength())
                .add("CaptionData", captionDataAsString()).add("InputLossAction", inputLossActionAsString())
                .add("RestartDelay", restartDelay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkers":
            return Optional.ofNullable(clazz.cast(adMarkersAsStrings()));
        case "AuthenticationScheme":
            return Optional.ofNullable(clazz.cast(authenticationSchemeAsString()));
        case "CacheFullBehavior":
            return Optional.ofNullable(clazz.cast(cacheFullBehaviorAsString()));
        case "CacheLength":
            return Optional.ofNullable(clazz.cast(cacheLength()));
        case "CaptionData":
            return Optional.ofNullable(clazz.cast(captionDataAsString()));
        case "InputLossAction":
            return Optional.ofNullable(clazz.cast(inputLossActionAsString()));
        case "RestartDelay":
            return Optional.ofNullable(clazz.cast(restartDelay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RtmpGroupSettings, T> g) {
        return obj -> g.apply((RtmpGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RtmpGroupSettings> {
        /**
         * Choose the ad marker type for this output group. MediaLive will create a message based on the content of each
         * SCTE-35 message, format it for that marker type, and insert it in the datastream.
         * 
         * @param adMarkers
         *        Choose the ad marker type for this output group. MediaLive will create a message based on the content
         *        of each SCTE-35 message, format it for that marker type, and insert it in the datastream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkersWithStrings(Collection<String> adMarkers);

        /**
         * Choose the ad marker type for this output group. MediaLive will create a message based on the content of each
         * SCTE-35 message, format it for that marker type, and insert it in the datastream.
         * 
         * @param adMarkers
         *        Choose the ad marker type for this output group. MediaLive will create a message based on the content
         *        of each SCTE-35 message, format it for that marker type, and insert it in the datastream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkersWithStrings(String... adMarkers);

        /**
         * Choose the ad marker type for this output group. MediaLive will create a message based on the content of each
         * SCTE-35 message, format it for that marker type, and insert it in the datastream.
         * 
         * @param adMarkers
         *        Choose the ad marker type for this output group. MediaLive will create a message based on the content
         *        of each SCTE-35 message, format it for that marker type, and insert it in the datastream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkers(Collection<RtmpAdMarkers> adMarkers);

        /**
         * Choose the ad marker type for this output group. MediaLive will create a message based on the content of each
         * SCTE-35 message, format it for that marker type, and insert it in the datastream.
         * 
         * @param adMarkers
         *        Choose the ad marker type for this output group. MediaLive will create a message based on the content
         *        of each SCTE-35 message, format it for that marker type, and insert it in the datastream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkers(RtmpAdMarkers... adMarkers);

        /**
         * Authentication scheme to use when connecting with CDN
         * 
         * @param authenticationScheme
         *        Authentication scheme to use when connecting with CDN
         * @see AuthenticationScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationScheme
         */
        Builder authenticationScheme(String authenticationScheme);

        /**
         * Authentication scheme to use when connecting with CDN
         * 
         * @param authenticationScheme
         *        Authentication scheme to use when connecting with CDN
         * @see AuthenticationScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationScheme
         */
        Builder authenticationScheme(AuthenticationScheme authenticationScheme);

        /**
         * Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and does
         * not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration specified
         * by cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the RTMP output
         * will force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If set to
         * waitForServer, the RTMP output will wait up to 5 minutes to allow the origin server to begin accepting data
         * again.
         * 
         * @param cacheFullBehavior
         *        Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and
         *        does not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the
         *        duration specified by cacheLength the cache will stop accepting new content. If set to
         *        disconnectImmediately, the RTMP output will force a disconnect. Clear the media cache, and reconnect
         *        after restartDelay seconds. If set to waitForServer, the RTMP output will wait up to 5 minutes to
         *        allow the origin server to begin accepting data again.
         * @see RtmpCacheFullBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RtmpCacheFullBehavior
         */
        Builder cacheFullBehavior(String cacheFullBehavior);

        /**
         * Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and does
         * not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration specified
         * by cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the RTMP output
         * will force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If set to
         * waitForServer, the RTMP output will wait up to 5 minutes to allow the origin server to begin accepting data
         * again.
         * 
         * @param cacheFullBehavior
         *        Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and
         *        does not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the
         *        duration specified by cacheLength the cache will stop accepting new content. If set to
         *        disconnectImmediately, the RTMP output will force a disconnect. Clear the media cache, and reconnect
         *        after restartDelay seconds. If set to waitForServer, the RTMP output will wait up to 5 minutes to
         *        allow the origin server to begin accepting data again.
         * @see RtmpCacheFullBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RtmpCacheFullBehavior
         */
        Builder cacheFullBehavior(RtmpCacheFullBehavior cacheFullBehavior);

        /**
         * Cache length, in seconds, is used to calculate buffer size.
         * 
         * @param cacheLength
         *        Cache length, in seconds, is used to calculate buffer size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheLength(Integer cacheLength);

        /**
         * Controls the types of data that passes to onCaptionInfo outputs. If set to 'all' then 608 and 708 carried
         * DTVCC data will be passed. If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608 data
         * from both fields will be passed. If set to 'field1608' then only the data carried in 608 from field 1 video
         * will be passed.
         * 
         * @param captionData
         *        Controls the types of data that passes to onCaptionInfo outputs. If set to 'all' then 608 and 708
         *        carried DTVCC data will be passed. If set to 'field1AndField2608' then DTVCC data will be stripped
         *        out, but 608 data from both fields will be passed. If set to 'field1608' then only the data carried in
         *        608 from field 1 video will be passed.
         * @see RtmpCaptionData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RtmpCaptionData
         */
        Builder captionData(String captionData);

        /**
         * Controls the types of data that passes to onCaptionInfo outputs. If set to 'all' then 608 and 708 carried
         * DTVCC data will be passed. If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608 data
         * from both fields will be passed. If set to 'field1608' then only the data carried in 608 from field 1 video
         * will be passed.
         * 
         * @param captionData
         *        Controls the types of data that passes to onCaptionInfo outputs. If set to 'all' then 608 and 708
         *        carried DTVCC data will be passed. If set to 'field1AndField2608' then DTVCC data will be stripped
         *        out, but 608 data from both fields will be passed. If set to 'field1608' then only the data carried in
         *        608 from field 1 video will be passed.
         * @see RtmpCaptionData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RtmpCaptionData
         */
        Builder captionData(RtmpCaptionData captionData);

        /**
         * Controls the behavior of this RTMP group if input becomes unavailable.
         *
         * - emitOutput: Emit a slate until input returns. - pauseOutput: Stop transmitting data until input returns.
         * This does not close the underlying RTMP connection.
         * 
         * @param inputLossAction
         *        Controls the behavior of this RTMP group if input becomes unavailable.
         *
         *        - emitOutput: Emit a slate until input returns. - pauseOutput: Stop transmitting data until input
         *        returns. This does not close the underlying RTMP connection.
         * @see InputLossActionForRtmpOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForRtmpOut
         */
        Builder inputLossAction(String inputLossAction);

        /**
         * Controls the behavior of this RTMP group if input becomes unavailable.
         *
         * - emitOutput: Emit a slate until input returns. - pauseOutput: Stop transmitting data until input returns.
         * This does not close the underlying RTMP connection.
         * 
         * @param inputLossAction
         *        Controls the behavior of this RTMP group if input becomes unavailable.
         *
         *        - emitOutput: Emit a slate until input returns. - pauseOutput: Stop transmitting data until input
         *        returns. This does not close the underlying RTMP connection.
         * @see InputLossActionForRtmpOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForRtmpOut
         */
        Builder inputLossAction(InputLossActionForRtmpOut inputLossAction);

        /**
         * If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never
         * restart.
         * 
         * @param restartDelay
         *        If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0
         *        means never restart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restartDelay(Integer restartDelay);
    }

    static final class BuilderImpl implements Builder {
        private List<String> adMarkers = DefaultSdkAutoConstructList.getInstance();

        private String authenticationScheme;

        private String cacheFullBehavior;

        private Integer cacheLength;

        private String captionData;

        private String inputLossAction;

        private Integer restartDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(RtmpGroupSettings model) {
            adMarkersWithStrings(model.adMarkers);
            authenticationScheme(model.authenticationScheme);
            cacheFullBehavior(model.cacheFullBehavior);
            cacheLength(model.cacheLength);
            captionData(model.captionData);
            inputLossAction(model.inputLossAction);
            restartDelay(model.restartDelay);
        }

        public final Collection<String> getAdMarkers() {
            if (adMarkers instanceof SdkAutoConstructList) {
                return null;
            }
            return adMarkers;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ___listOfRtmpAdMarkersCopier.copy(adMarkers);
        }

        @Override
        @Transient
        public final Builder adMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfRtmpAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adMarkersWithStrings(String... adMarkers) {
            adMarkersWithStrings(Arrays.asList(adMarkers));
            return this;
        }

        @Override
        @Transient
        public final Builder adMarkers(Collection<RtmpAdMarkers> adMarkers) {
            this.adMarkers = ___listOfRtmpAdMarkersCopier.copyEnumToString(adMarkers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adMarkers(RtmpAdMarkers... adMarkers) {
            adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final String getAuthenticationScheme() {
            return authenticationScheme;
        }

        public final void setAuthenticationScheme(String authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
        }

        @Override
        @Transient
        public final Builder authenticationScheme(String authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        @Override
        @Transient
        public final Builder authenticationScheme(AuthenticationScheme authenticationScheme) {
            this.authenticationScheme(authenticationScheme == null ? null : authenticationScheme.toString());
            return this;
        }

        public final String getCacheFullBehavior() {
            return cacheFullBehavior;
        }

        public final void setCacheFullBehavior(String cacheFullBehavior) {
            this.cacheFullBehavior = cacheFullBehavior;
        }

        @Override
        @Transient
        public final Builder cacheFullBehavior(String cacheFullBehavior) {
            this.cacheFullBehavior = cacheFullBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder cacheFullBehavior(RtmpCacheFullBehavior cacheFullBehavior) {
            this.cacheFullBehavior(cacheFullBehavior == null ? null : cacheFullBehavior.toString());
            return this;
        }

        public final Integer getCacheLength() {
            return cacheLength;
        }

        public final void setCacheLength(Integer cacheLength) {
            this.cacheLength = cacheLength;
        }

        @Override
        @Transient
        public final Builder cacheLength(Integer cacheLength) {
            this.cacheLength = cacheLength;
            return this;
        }

        public final String getCaptionData() {
            return captionData;
        }

        public final void setCaptionData(String captionData) {
            this.captionData = captionData;
        }

        @Override
        @Transient
        public final Builder captionData(String captionData) {
            this.captionData = captionData;
            return this;
        }

        @Override
        @Transient
        public final Builder captionData(RtmpCaptionData captionData) {
            this.captionData(captionData == null ? null : captionData.toString());
            return this;
        }

        public final String getInputLossAction() {
            return inputLossAction;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        @Override
        @Transient
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        @Transient
        public final Builder inputLossAction(InputLossActionForRtmpOut inputLossAction) {
            this.inputLossAction(inputLossAction == null ? null : inputLossAction.toString());
            return this;
        }

        public final Integer getRestartDelay() {
            return restartDelay;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        @Override
        @Transient
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        @Override
        public RtmpGroupSettings build() {
            return new RtmpGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
