/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings to identify the end of the clip.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopTimecode implements SdkPojo, Serializable, ToCopyableBuilder<StopTimecode.Builder, StopTimecode> {
    private static final SdkField<String> LAST_FRAME_CLIPPING_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastFrameClippingBehavior").getter(getter(StopTimecode::lastFrameClippingBehaviorAsString))
            .setter(setter(Builder::lastFrameClippingBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastFrameClippingBehavior").build())
            .build();

    private static final SdkField<String> TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timecode").getter(getter(StopTimecode::timecode)).setter(setter(Builder::timecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAST_FRAME_CLIPPING_BEHAVIOR_FIELD, TIMECODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lastFrameClippingBehavior;

    private final String timecode;

    private StopTimecode(BuilderImpl builder) {
        this.lastFrameClippingBehavior = builder.lastFrameClippingBehavior;
        this.timecode = builder.timecode;
    }

    /**
     * If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the clip to
     * exclude (the default) or include the frame specified by the timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastFrameClippingBehavior} will return {@link LastFrameClippingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #lastFrameClippingBehaviorAsString}.
     * </p>
     * 
     * @return If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the
     *         clip to exclude (the default) or include the frame specified by the timecode.
     * @see LastFrameClippingBehavior
     */
    public final LastFrameClippingBehavior lastFrameClippingBehavior() {
        return LastFrameClippingBehavior.fromValue(lastFrameClippingBehavior);
    }

    /**
     * If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the clip to
     * exclude (the default) or include the frame specified by the timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastFrameClippingBehavior} will return {@link LastFrameClippingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #lastFrameClippingBehaviorAsString}.
     * </p>
     * 
     * @return If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the
     *         clip to exclude (the default) or include the frame specified by the timecode.
     * @see LastFrameClippingBehavior
     */
    public final String lastFrameClippingBehaviorAsString() {
        return lastFrameClippingBehavior;
    }

    /**
     * The timecode for the frame where you want to stop the clip. Optional; if not specified, the clip continues to the
     * end of the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.
     * 
     * @return The timecode for the frame where you want to stop the clip. Optional; if not specified, the clip
     *         continues to the end of the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.
     */
    public final String timecode() {
        return timecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastFrameClippingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopTimecode)) {
            return false;
        }
        StopTimecode other = (StopTimecode) obj;
        return Objects.equals(lastFrameClippingBehaviorAsString(), other.lastFrameClippingBehaviorAsString())
                && Objects.equals(timecode(), other.timecode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopTimecode").add("LastFrameClippingBehavior", lastFrameClippingBehaviorAsString())
                .add("Timecode", timecode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastFrameClippingBehavior":
            return Optional.ofNullable(clazz.cast(lastFrameClippingBehaviorAsString()));
        case "Timecode":
            return Optional.ofNullable(clazz.cast(timecode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopTimecode, T> g) {
        return obj -> g.apply((StopTimecode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StopTimecode> {
        /**
         * If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the clip
         * to exclude (the default) or include the frame specified by the timecode.
         * 
         * @param lastFrameClippingBehavior
         *        If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the
         *        clip to exclude (the default) or include the frame specified by the timecode.
         * @see LastFrameClippingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastFrameClippingBehavior
         */
        Builder lastFrameClippingBehavior(String lastFrameClippingBehavior);

        /**
         * If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the clip
         * to exclude (the default) or include the frame specified by the timecode.
         * 
         * @param lastFrameClippingBehavior
         *        If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the
         *        clip to exclude (the default) or include the frame specified by the timecode.
         * @see LastFrameClippingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastFrameClippingBehavior
         */
        Builder lastFrameClippingBehavior(LastFrameClippingBehavior lastFrameClippingBehavior);

        /**
         * The timecode for the frame where you want to stop the clip. Optional; if not specified, the clip continues to
         * the end of the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.
         * 
         * @param timecode
         *        The timecode for the frame where you want to stop the clip. Optional; if not specified, the clip
         *        continues to the end of the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecode(String timecode);
    }

    static final class BuilderImpl implements Builder {
        private String lastFrameClippingBehavior;

        private String timecode;

        private BuilderImpl() {
        }

        private BuilderImpl(StopTimecode model) {
            lastFrameClippingBehavior(model.lastFrameClippingBehavior);
            timecode(model.timecode);
        }

        public final String getLastFrameClippingBehavior() {
            return lastFrameClippingBehavior;
        }

        public final void setLastFrameClippingBehavior(String lastFrameClippingBehavior) {
            this.lastFrameClippingBehavior = lastFrameClippingBehavior;
        }

        @Override
        @Transient
        public final Builder lastFrameClippingBehavior(String lastFrameClippingBehavior) {
            this.lastFrameClippingBehavior = lastFrameClippingBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder lastFrameClippingBehavior(LastFrameClippingBehavior lastFrameClippingBehavior) {
            this.lastFrameClippingBehavior(lastFrameClippingBehavior == null ? null : lastFrameClippingBehavior.toString());
            return this;
        }

        public final String getTimecode() {
            return timecode;
        }

        public final void setTimecode(String timecode) {
            this.timecode = timecode;
        }

        @Override
        @Transient
        public final Builder timecode(String timecode) {
            this.timecode = timecode;
            return this;
        }

        @Override
        public StopTimecode build() {
            return new StopTimecode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
