/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to transfer an input device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransferInputDeviceRequest extends MediaLiveRequest implements
        ToCopyableBuilder<TransferInputDeviceRequest.Builder, TransferInputDeviceRequest> {
    private static final SdkField<String> INPUT_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputDeviceId").getter(getter(TransferInputDeviceRequest::inputDeviceId))
            .setter(setter(Builder::inputDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputDeviceId").build()).build();

    private static final SdkField<String> TARGET_CUSTOMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCustomerId").getter(getter(TransferInputDeviceRequest::targetCustomerId))
            .setter(setter(Builder::targetCustomerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCustomerId").build()).build();

    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetRegion").getter(getter(TransferInputDeviceRequest::targetRegion))
            .setter(setter(Builder::targetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()).build();

    private static final SdkField<String> TRANSFER_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransferMessage").getter(getter(TransferInputDeviceRequest::transferMessage))
            .setter(setter(Builder::transferMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DEVICE_ID_FIELD,
            TARGET_CUSTOMER_ID_FIELD, TARGET_REGION_FIELD, TRANSFER_MESSAGE_FIELD));

    private final String inputDeviceId;

    private final String targetCustomerId;

    private final String targetRegion;

    private final String transferMessage;

    private TransferInputDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.inputDeviceId = builder.inputDeviceId;
        this.targetCustomerId = builder.targetCustomerId;
        this.targetRegion = builder.targetRegion;
        this.transferMessage = builder.transferMessage;
    }

    /**
     * The unique ID of this input device. For example, hd-123456789abcdef.
     * 
     * @return The unique ID of this input device. For example, hd-123456789abcdef.
     */
    public final String inputDeviceId() {
        return inputDeviceId;
    }

    /**
     * The AWS account ID (12 digits) for the recipient of the device transfer.
     * 
     * @return The AWS account ID (12 digits) for the recipient of the device transfer.
     */
    public final String targetCustomerId() {
        return targetCustomerId;
    }

    /**
     * The target AWS region to transfer the device.
     * 
     * @return The target AWS region to transfer the device.
     */
    public final String targetRegion() {
        return targetRegion;
    }

    /**
     * An optional message for the recipient. Maximum 280 characters.
     * 
     * @return An optional message for the recipient. Maximum 280 characters.
     */
    public final String transferMessage() {
        return transferMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(targetCustomerId());
        hashCode = 31 * hashCode + Objects.hashCode(targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(transferMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferInputDeviceRequest)) {
            return false;
        }
        TransferInputDeviceRequest other = (TransferInputDeviceRequest) obj;
        return Objects.equals(inputDeviceId(), other.inputDeviceId())
                && Objects.equals(targetCustomerId(), other.targetCustomerId())
                && Objects.equals(targetRegion(), other.targetRegion())
                && Objects.equals(transferMessage(), other.transferMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransferInputDeviceRequest").add("InputDeviceId", inputDeviceId())
                .add("TargetCustomerId", targetCustomerId()).add("TargetRegion", targetRegion())
                .add("TransferMessage", transferMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputDeviceId":
            return Optional.ofNullable(clazz.cast(inputDeviceId()));
        case "TargetCustomerId":
            return Optional.ofNullable(clazz.cast(targetCustomerId()));
        case "TargetRegion":
            return Optional.ofNullable(clazz.cast(targetRegion()));
        case "TransferMessage":
            return Optional.ofNullable(clazz.cast(transferMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransferInputDeviceRequest, T> g) {
        return obj -> g.apply((TransferInputDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, TransferInputDeviceRequest> {
        /**
         * The unique ID of this input device. For example, hd-123456789abcdef.
         * 
         * @param inputDeviceId
         *        The unique ID of this input device. For example, hd-123456789abcdef.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDeviceId(String inputDeviceId);

        /**
         * The AWS account ID (12 digits) for the recipient of the device transfer.
         * 
         * @param targetCustomerId
         *        The AWS account ID (12 digits) for the recipient of the device transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCustomerId(String targetCustomerId);

        /**
         * The target AWS region to transfer the device.
         * 
         * @param targetRegion
         *        The target AWS region to transfer the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegion(String targetRegion);

        /**
         * An optional message for the recipient. Maximum 280 characters.
         * 
         * @param transferMessage
         *        An optional message for the recipient. Maximum 280 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferMessage(String transferMessage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String inputDeviceId;

        private String targetCustomerId;

        private String targetRegion;

        private String transferMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferInputDeviceRequest model) {
            super(model);
            inputDeviceId(model.inputDeviceId);
            targetCustomerId(model.targetCustomerId);
            targetRegion(model.targetRegion);
            transferMessage(model.transferMessage);
        }

        public final String getInputDeviceId() {
            return inputDeviceId;
        }

        public final void setInputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
        }

        @Override
        @Transient
        public final Builder inputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
            return this;
        }

        public final String getTargetCustomerId() {
            return targetCustomerId;
        }

        public final void setTargetCustomerId(String targetCustomerId) {
            this.targetCustomerId = targetCustomerId;
        }

        @Override
        @Transient
        public final Builder targetCustomerId(String targetCustomerId) {
            this.targetCustomerId = targetCustomerId;
            return this;
        }

        public final String getTargetRegion() {
            return targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        @Transient
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final String getTransferMessage() {
            return transferMessage;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        @Override
        @Transient
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TransferInputDeviceRequest build() {
            return new TransferInputDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
