/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Udp Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class UdpGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<UdpGroupSettings.Builder, UdpGroupSettings> {
    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputLossAction").getter(getter(UdpGroupSettings::inputLossActionAsString))
            .setter(setter(Builder::inputLossAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()).build();

    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimedMetadataId3Frame").getter(getter(UdpGroupSettings::timedMetadataId3FrameAsString))
            .setter(setter(Builder::timedMetadataId3Frame))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build())
            .build();

    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimedMetadataId3Period").getter(getter(UdpGroupSettings::timedMetadataId3Period))
            .setter(setter(Builder::timedMetadataId3Period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_LOSS_ACTION_FIELD,
            TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputLossAction;

    private final String timedMetadataId3Frame;

    private final Integer timedMetadataId3Period;

    private UdpGroupSettings(BuilderImpl builder) {
        this.inputLossAction = builder.inputLossAction;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
    }

    /**
     * Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When dropTs
     * is selected the entire transport stream will stop being emitted. When dropProgram is selected the program can be
     * dropped from the transport stream (and replaced with null packets to meet the TS bitrate requirement). Or, when
     * emitProgram is chosen the transport stream will continue to be produced normally with repeat frames, black
     * frames, or slate frames substituted for the absent input video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForUdpOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When
     *         dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the
     *         program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate
     *         requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally
     *         with repeat frames, black frames, or slate frames substituted for the absent input video.
     * @see InputLossActionForUdpOut
     */
    public final InputLossActionForUdpOut inputLossAction() {
        return InputLossActionForUdpOut.fromValue(inputLossAction);
    }

    /**
     * Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When dropTs
     * is selected the entire transport stream will stop being emitted. When dropProgram is selected the program can be
     * dropped from the transport stream (and replaced with null packets to meet the TS bitrate requirement). Or, when
     * emitProgram is chosen the transport stream will continue to be produced normally with repeat frames, black
     * frames, or slate frames substituted for the absent input video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForUdpOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When
     *         dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the
     *         program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate
     *         requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally
     *         with repeat frames, black frames, or slate frames substituted for the absent input video.
     * @see InputLossActionForUdpOut
     */
    public final String inputLossActionAsString() {
        return inputLossAction;
    }

    /**
     * Indicates ID3 frame that has the timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataId3Frame} will return {@link UdpTimedMetadataId3Frame#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timedMetadataId3FrameAsString}.
     * </p>
     * 
     * @return Indicates ID3 frame that has the timecode.
     * @see UdpTimedMetadataId3Frame
     */
    public final UdpTimedMetadataId3Frame timedMetadataId3Frame() {
        return UdpTimedMetadataId3Frame.fromValue(timedMetadataId3Frame);
    }

    /**
     * Indicates ID3 frame that has the timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataId3Frame} will return {@link UdpTimedMetadataId3Frame#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timedMetadataId3FrameAsString}.
     * </p>
     * 
     * @return Indicates ID3 frame that has the timecode.
     * @see UdpTimedMetadataId3Frame
     */
    public final String timedMetadataId3FrameAsString() {
        return timedMetadataId3Frame;
    }

    /**
     * Timed Metadata interval in seconds.
     * 
     * @return Timed Metadata interval in seconds.
     */
    public final Integer timedMetadataId3Period() {
        return timedMetadataId3Period;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataId3Period());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UdpGroupSettings)) {
            return false;
        }
        UdpGroupSettings other = (UdpGroupSettings) obj;
        return Objects.equals(inputLossActionAsString(), other.inputLossActionAsString())
                && Objects.equals(timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString())
                && Objects.equals(timedMetadataId3Period(), other.timedMetadataId3Period());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UdpGroupSettings").add("InputLossAction", inputLossActionAsString())
                .add("TimedMetadataId3Frame", timedMetadataId3FrameAsString())
                .add("TimedMetadataId3Period", timedMetadataId3Period()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputLossAction":
            return Optional.ofNullable(clazz.cast(inputLossActionAsString()));
        case "TimedMetadataId3Frame":
            return Optional.ofNullable(clazz.cast(timedMetadataId3FrameAsString()));
        case "TimedMetadataId3Period":
            return Optional.ofNullable(clazz.cast(timedMetadataId3Period()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UdpGroupSettings, T> g) {
        return obj -> g.apply((UdpGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UdpGroupSettings> {
        /**
         * Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When
         * dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the
         * program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate
         * requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally with
         * repeat frames, black frames, or slate frames substituted for the absent input video.
         * 
         * @param inputLossAction
         *        Specifies behavior of last resort when input video is lost, and no more backup inputs are available.
         *        When dropTs is selected the entire transport stream will stop being emitted. When dropProgram is
         *        selected the program can be dropped from the transport stream (and replaced with null packets to meet
         *        the TS bitrate requirement). Or, when emitProgram is chosen the transport stream will continue to be
         *        produced normally with repeat frames, black frames, or slate frames substituted for the absent input
         *        video.
         * @see InputLossActionForUdpOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForUdpOut
         */
        Builder inputLossAction(String inputLossAction);

        /**
         * Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When
         * dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the
         * program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate
         * requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally with
         * repeat frames, black frames, or slate frames substituted for the absent input video.
         * 
         * @param inputLossAction
         *        Specifies behavior of last resort when input video is lost, and no more backup inputs are available.
         *        When dropTs is selected the entire transport stream will stop being emitted. When dropProgram is
         *        selected the program can be dropped from the transport stream (and replaced with null packets to meet
         *        the TS bitrate requirement). Or, when emitProgram is chosen the transport stream will continue to be
         *        produced normally with repeat frames, black frames, or slate frames substituted for the absent input
         *        video.
         * @see InputLossActionForUdpOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForUdpOut
         */
        Builder inputLossAction(InputLossActionForUdpOut inputLossAction);

        /**
         * Indicates ID3 frame that has the timecode.
         * 
         * @param timedMetadataId3Frame
         *        Indicates ID3 frame that has the timecode.
         * @see UdpTimedMetadataId3Frame
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UdpTimedMetadataId3Frame
         */
        Builder timedMetadataId3Frame(String timedMetadataId3Frame);

        /**
         * Indicates ID3 frame that has the timecode.
         * 
         * @param timedMetadataId3Frame
         *        Indicates ID3 frame that has the timecode.
         * @see UdpTimedMetadataId3Frame
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UdpTimedMetadataId3Frame
         */
        Builder timedMetadataId3Frame(UdpTimedMetadataId3Frame timedMetadataId3Frame);

        /**
         * Timed Metadata interval in seconds.
         * 
         * @param timedMetadataId3Period
         *        Timed Metadata interval in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataId3Period(Integer timedMetadataId3Period);
    }

    static final class BuilderImpl implements Builder {
        private String inputLossAction;

        private String timedMetadataId3Frame;

        private Integer timedMetadataId3Period;

        private BuilderImpl() {
        }

        private BuilderImpl(UdpGroupSettings model) {
            inputLossAction(model.inputLossAction);
            timedMetadataId3Frame(model.timedMetadataId3Frame);
            timedMetadataId3Period(model.timedMetadataId3Period);
        }

        public final String getInputLossAction() {
            return inputLossAction;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        @Override
        @Transient
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        @Transient
        public final Builder inputLossAction(InputLossActionForUdpOut inputLossAction) {
            this.inputLossAction(inputLossAction == null ? null : inputLossAction.toString());
            return this;
        }

        public final String getTimedMetadataId3Frame() {
            return timedMetadataId3Frame;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        @Override
        @Transient
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        @Transient
        public final Builder timedMetadataId3Frame(UdpTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame == null ? null : timedMetadataId3Frame.toString());
            return this;
        }

        public final Integer getTimedMetadataId3Period() {
            return timedMetadataId3Period;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        @Override
        @Transient
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        @Override
        public UdpGroupSettings build() {
            return new UdpGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
