/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The request to update some combination of the Input Security Group name and the IPv4 CIDRs the Input Security Group
 * should allow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInputSecurityGroupRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateInputSecurityGroupRequest.Builder, UpdateInputSecurityGroupRequest> {
    private static final SdkField<String> INPUT_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputSecurityGroupId").getter(getter(UpdateInputSecurityGroupRequest::inputSecurityGroupId))
            .setter(setter(Builder::inputSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputSecurityGroupId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(UpdateInputSecurityGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<InputWhitelistRuleCidr>> WHITELIST_RULES_FIELD = SdkField
            .<List<InputWhitelistRuleCidr>> builder(MarshallingType.LIST)
            .memberName("WhitelistRules")
            .getter(getter(UpdateInputSecurityGroupRequest::whitelistRules))
            .setter(setter(Builder::whitelistRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputWhitelistRuleCidr> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputWhitelistRuleCidr::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SECURITY_GROUP_ID_FIELD,
            TAGS_FIELD, WHITELIST_RULES_FIELD));

    private final String inputSecurityGroupId;

    private final Map<String, String> tags;

    private final List<InputWhitelistRuleCidr> whitelistRules;

    private UpdateInputSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.inputSecurityGroupId = builder.inputSecurityGroupId;
        this.tags = builder.tags;
        this.whitelistRules = builder.whitelistRules;
    }

    /**
     * The id of the Input Security Group to update.
     * 
     * @return The id of the Input Security Group to update.
     */
    public final String inputSecurityGroupId() {
        return inputSecurityGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the WhitelistRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWhitelistRules() {
        return whitelistRules != null && !(whitelistRules instanceof SdkAutoConstructList);
    }

    /**
     * List of IPv4 CIDR addresses to whitelist
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWhitelistRules} method.
     * </p>
     * 
     * @return List of IPv4 CIDR addresses to whitelist
     */
    public final List<InputWhitelistRuleCidr> whitelistRules() {
        return whitelistRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWhitelistRules() ? whitelistRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputSecurityGroupRequest)) {
            return false;
        }
        UpdateInputSecurityGroupRequest other = (UpdateInputSecurityGroupRequest) obj;
        return Objects.equals(inputSecurityGroupId(), other.inputSecurityGroupId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasWhitelistRules() == other.hasWhitelistRules()
                && Objects.equals(whitelistRules(), other.whitelistRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInputSecurityGroupRequest").add("InputSecurityGroupId", inputSecurityGroupId())
                .add("Tags", hasTags() ? tags() : null).add("WhitelistRules", hasWhitelistRules() ? whitelistRules() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputSecurityGroupId":
            return Optional.ofNullable(clazz.cast(inputSecurityGroupId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WhitelistRules":
            return Optional.ofNullable(clazz.cast(whitelistRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputSecurityGroupRequest, T> g) {
        return obj -> g.apply((UpdateInputSecurityGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateInputSecurityGroupRequest> {
        /**
         * The id of the Input Security Group to update.
         * 
         * @param inputSecurityGroupId
         *        The id of the Input Security Group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroupId(String inputSecurityGroupId);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * List of IPv4 CIDR addresses to whitelist
         * 
         * @param whitelistRules
         *        List of IPv4 CIDR addresses to whitelist
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistRules(Collection<InputWhitelistRuleCidr> whitelistRules);

        /**
         * List of IPv4 CIDR addresses to whitelist
         * 
         * @param whitelistRules
         *        List of IPv4 CIDR addresses to whitelist
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistRules(InputWhitelistRuleCidr... whitelistRules);

        /**
         * List of IPv4 CIDR addresses to whitelist This is a convenience that creates an instance of the {@link List
         * <InputWhitelistRuleCidr>.Builder} avoiding the need to create one manually via {@link List
         * <InputWhitelistRuleCidr>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputWhitelistRuleCidr>.Builder#build()} is called
         * immediately and its result is passed to {@link #whitelistRules(List<InputWhitelistRuleCidr>)}.
         * 
         * @param whitelistRules
         *        a consumer that will call methods on {@link List<InputWhitelistRuleCidr>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #whitelistRules(List<InputWhitelistRuleCidr>)
         */
        Builder whitelistRules(Consumer<InputWhitelistRuleCidr.Builder>... whitelistRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String inputSecurityGroupId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<InputWhitelistRuleCidr> whitelistRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputSecurityGroupRequest model) {
            super(model);
            inputSecurityGroupId(model.inputSecurityGroupId);
            tags(model.tags);
            whitelistRules(model.whitelistRules);
        }

        public final String getInputSecurityGroupId() {
            return inputSecurityGroupId;
        }

        public final void setInputSecurityGroupId(String inputSecurityGroupId) {
            this.inputSecurityGroupId = inputSecurityGroupId;
        }

        @Override
        @Transient
        public final Builder inputSecurityGroupId(String inputSecurityGroupId) {
            this.inputSecurityGroupId = inputSecurityGroupId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final List<InputWhitelistRuleCidr.Builder> getWhitelistRules() {
            List<InputWhitelistRuleCidr.Builder> result = ___listOfInputWhitelistRuleCidrCopier
                    .copyToBuilder(this.whitelistRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWhitelistRules(Collection<InputWhitelistRuleCidr.BuilderImpl> whitelistRules) {
            this.whitelistRules = ___listOfInputWhitelistRuleCidrCopier.copyFromBuilder(whitelistRules);
        }

        @Override
        @Transient
        public final Builder whitelistRules(Collection<InputWhitelistRuleCidr> whitelistRules) {
            this.whitelistRules = ___listOfInputWhitelistRuleCidrCopier.copy(whitelistRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder whitelistRules(InputWhitelistRuleCidr... whitelistRules) {
            whitelistRules(Arrays.asList(whitelistRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder whitelistRules(Consumer<InputWhitelistRuleCidr.Builder>... whitelistRules) {
            whitelistRules(Stream.of(whitelistRules).map(c -> InputWhitelistRuleCidr.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputSecurityGroupRequest build() {
            return new UpdateInputSecurityGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
