/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for UpdateMultiplexResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMultiplexResponse extends MediaLiveResponse implements
        ToCopyableBuilder<UpdateMultiplexResponse.Builder, UpdateMultiplexResponse> {
    private static final SdkField<Multiplex> MULTIPLEX_FIELD = SdkField.<Multiplex> builder(MarshallingType.SDK_POJO)
            .memberName("Multiplex").getter(getter(UpdateMultiplexResponse::multiplex)).setter(setter(Builder::multiplex))
            .constructor(Multiplex::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_FIELD));

    private final Multiplex multiplex;

    private UpdateMultiplexResponse(BuilderImpl builder) {
        super(builder);
        this.multiplex = builder.multiplex;
    }

    /**
     * The updated multiplex.
     * 
     * @return The updated multiplex.
     */
    public final Multiplex multiplex() {
        return multiplex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiplex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiplexResponse)) {
            return false;
        }
        UpdateMultiplexResponse other = (UpdateMultiplexResponse) obj;
        return Objects.equals(multiplex(), other.multiplex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMultiplexResponse").add("Multiplex", multiplex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Multiplex":
            return Optional.ofNullable(clazz.cast(multiplex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiplexResponse, T> g) {
        return obj -> g.apply((UpdateMultiplexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMultiplexResponse> {
        /**
         * The updated multiplex.
         * 
         * @param multiplex
         *        The updated multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplex(Multiplex multiplex);

        /**
         * The updated multiplex. This is a convenience that creates an instance of the {@link Multiplex.Builder}
         * avoiding the need to create one manually via {@link Multiplex#builder()}.
         *
         * When the {@link Consumer} completes, {@link Multiplex.Builder#build()} is called immediately and its result
         * is passed to {@link #multiplex(Multiplex)}.
         * 
         * @param multiplex
         *        a consumer that will call methods on {@link Multiplex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplex(Multiplex)
         */
        default Builder multiplex(Consumer<Multiplex.Builder> multiplex) {
            return multiplex(Multiplex.builder().applyMutation(multiplex).build());
        }
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private Multiplex multiplex;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiplexResponse model) {
            super(model);
            multiplex(model.multiplex);
        }

        public final Multiplex.Builder getMultiplex() {
            return multiplex != null ? multiplex.toBuilder() : null;
        }

        public final void setMultiplex(Multiplex.BuilderImpl multiplex) {
            this.multiplex = multiplex != null ? multiplex.build() : null;
        }

        @Override
        @Transient
        public final Builder multiplex(Multiplex multiplex) {
            this.multiplex = multiplex;
            return this;
        }

        @Override
        public UpdateMultiplexResponse build() {
            return new UpdateMultiplexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
