/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Video Selector Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoSelectorSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoSelectorSettings.Builder, VideoSelectorSettings> {
    private static final SdkField<VideoSelectorPid> VIDEO_SELECTOR_PID_FIELD = SdkField
            .<VideoSelectorPid> builder(MarshallingType.SDK_POJO).memberName("VideoSelectorPid")
            .getter(getter(VideoSelectorSettings::videoSelectorPid)).setter(setter(Builder::videoSelectorPid))
            .constructor(VideoSelectorPid::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSelectorPid").build()).build();

    private static final SdkField<VideoSelectorProgramId> VIDEO_SELECTOR_PROGRAM_ID_FIELD = SdkField
            .<VideoSelectorProgramId> builder(MarshallingType.SDK_POJO).memberName("VideoSelectorProgramId")
            .getter(getter(VideoSelectorSettings::videoSelectorProgramId)).setter(setter(Builder::videoSelectorProgramId))
            .constructor(VideoSelectorProgramId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSelectorProgramId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIDEO_SELECTOR_PID_FIELD,
            VIDEO_SELECTOR_PROGRAM_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final VideoSelectorPid videoSelectorPid;

    private final VideoSelectorProgramId videoSelectorProgramId;

    private VideoSelectorSettings(BuilderImpl builder) {
        this.videoSelectorPid = builder.videoSelectorPid;
        this.videoSelectorProgramId = builder.videoSelectorProgramId;
    }

    /**
     * Returns the value of the VideoSelectorPid property for this object.
     * 
     * @return The value of the VideoSelectorPid property for this object.
     */
    public final VideoSelectorPid videoSelectorPid() {
        return videoSelectorPid;
    }

    /**
     * Returns the value of the VideoSelectorProgramId property for this object.
     * 
     * @return The value of the VideoSelectorProgramId property for this object.
     */
    public final VideoSelectorProgramId videoSelectorProgramId() {
        return videoSelectorProgramId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(videoSelectorPid());
        hashCode = 31 * hashCode + Objects.hashCode(videoSelectorProgramId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelectorSettings)) {
            return false;
        }
        VideoSelectorSettings other = (VideoSelectorSettings) obj;
        return Objects.equals(videoSelectorPid(), other.videoSelectorPid())
                && Objects.equals(videoSelectorProgramId(), other.videoSelectorProgramId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoSelectorSettings").add("VideoSelectorPid", videoSelectorPid())
                .add("VideoSelectorProgramId", videoSelectorProgramId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VideoSelectorPid":
            return Optional.ofNullable(clazz.cast(videoSelectorPid()));
        case "VideoSelectorProgramId":
            return Optional.ofNullable(clazz.cast(videoSelectorProgramId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoSelectorSettings, T> g) {
        return obj -> g.apply((VideoSelectorSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoSelectorSettings> {
        /**
         * Sets the value of the VideoSelectorPid property for this object.
         *
         * @param videoSelectorPid
         *        The new value for the VideoSelectorPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoSelectorPid(VideoSelectorPid videoSelectorPid);

        /**
         * Sets the value of the VideoSelectorPid property for this object.
         *
         * This is a convenience that creates an instance of the {@link VideoSelectorPid.Builder} avoiding the need to
         * create one manually via {@link VideoSelectorPid#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoSelectorPid.Builder#build()} is called immediately and its
         * result is passed to {@link #videoSelectorPid(VideoSelectorPid)}.
         * 
         * @param videoSelectorPid
         *        a consumer that will call methods on {@link VideoSelectorPid.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoSelectorPid(VideoSelectorPid)
         */
        default Builder videoSelectorPid(Consumer<VideoSelectorPid.Builder> videoSelectorPid) {
            return videoSelectorPid(VideoSelectorPid.builder().applyMutation(videoSelectorPid).build());
        }

        /**
         * Sets the value of the VideoSelectorProgramId property for this object.
         *
         * @param videoSelectorProgramId
         *        The new value for the VideoSelectorProgramId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoSelectorProgramId(VideoSelectorProgramId videoSelectorProgramId);

        /**
         * Sets the value of the VideoSelectorProgramId property for this object.
         *
         * This is a convenience that creates an instance of the {@link VideoSelectorProgramId.Builder} avoiding the
         * need to create one manually via {@link VideoSelectorProgramId#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoSelectorProgramId.Builder#build()} is called immediately and
         * its result is passed to {@link #videoSelectorProgramId(VideoSelectorProgramId)}.
         * 
         * @param videoSelectorProgramId
         *        a consumer that will call methods on {@link VideoSelectorProgramId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoSelectorProgramId(VideoSelectorProgramId)
         */
        default Builder videoSelectorProgramId(Consumer<VideoSelectorProgramId.Builder> videoSelectorProgramId) {
            return videoSelectorProgramId(VideoSelectorProgramId.builder().applyMutation(videoSelectorProgramId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VideoSelectorPid videoSelectorPid;

        private VideoSelectorProgramId videoSelectorProgramId;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelectorSettings model) {
            videoSelectorPid(model.videoSelectorPid);
            videoSelectorProgramId(model.videoSelectorProgramId);
        }

        public final VideoSelectorPid.Builder getVideoSelectorPid() {
            return videoSelectorPid != null ? videoSelectorPid.toBuilder() : null;
        }

        public final void setVideoSelectorPid(VideoSelectorPid.BuilderImpl videoSelectorPid) {
            this.videoSelectorPid = videoSelectorPid != null ? videoSelectorPid.build() : null;
        }

        @Override
        @Transient
        public final Builder videoSelectorPid(VideoSelectorPid videoSelectorPid) {
            this.videoSelectorPid = videoSelectorPid;
            return this;
        }

        public final VideoSelectorProgramId.Builder getVideoSelectorProgramId() {
            return videoSelectorProgramId != null ? videoSelectorProgramId.toBuilder() : null;
        }

        public final void setVideoSelectorProgramId(VideoSelectorProgramId.BuilderImpl videoSelectorProgramId) {
            this.videoSelectorProgramId = videoSelectorProgramId != null ? videoSelectorProgramId.build() : null;
        }

        @Override
        @Transient
        public final Builder videoSelectorProgramId(VideoSelectorProgramId videoSelectorProgramId) {
            this.videoSelectorProgramId = videoSelectorProgramId;
            return this;
        }

        @Override
        public VideoSelectorSettings build() {
            return new VideoSelectorSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
