/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The properties for a private VPC Output When this property is specified, the output egress addresses will be created
 * in a user specified VPC
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcOutputSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcOutputSettings.Builder, VpcOutputSettings> {
    private static final SdkField<List<String>> PUBLIC_ADDRESS_ALLOCATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PublicAddressAllocationIds")
            .getter(getter(VpcOutputSettings::publicAddressAllocationIds))
            .setter(setter(Builder::publicAddressAllocationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAddressAllocationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(VpcOutputSettings::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(VpcOutputSettings::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PUBLIC_ADDRESS_ALLOCATION_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> publicAddressAllocationIds;

    private final List<String> securityGroupIds;

    private final List<String> subnetIds;

    private VpcOutputSettings(BuilderImpl builder) {
        this.publicAddressAllocationIds = builder.publicAddressAllocationIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicAddressAllocationIds property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPublicAddressAllocationIds() {
        return publicAddressAllocationIds != null && !(publicAddressAllocationIds instanceof SdkAutoConstructList);
    }

    /**
     * List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify one
     * for SINGLE_PIPELINE, two for STANDARD channels
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicAddressAllocationIds} method.
     * </p>
     * 
     * @return List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must
     *         specify one for SINGLE_PIPELINE, two for STANDARD channels
     */
    public final List<String> publicAddressAllocationIds() {
        return publicAddressAllocationIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are
     * specified then the VPC default security group will be used
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are
     *         specified then the VPC default security group will be used
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique
     * availability zones (AZ).
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique
     *         availability zones (AZ).
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicAddressAllocationIds() ? publicAddressAllocationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOutputSettings)) {
            return false;
        }
        VpcOutputSettings other = (VpcOutputSettings) obj;
        return hasPublicAddressAllocationIds() == other.hasPublicAddressAllocationIds()
                && Objects.equals(publicAddressAllocationIds(), other.publicAddressAllocationIds())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcOutputSettings")
                .add("PublicAddressAllocationIds", hasPublicAddressAllocationIds() ? publicAddressAllocationIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicAddressAllocationIds":
            return Optional.ofNullable(clazz.cast(publicAddressAllocationIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcOutputSettings, T> g) {
        return obj -> g.apply((VpcOutputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcOutputSettings> {
        /**
         * List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify
         * one for SINGLE_PIPELINE, two for STANDARD channels
         *
         * @param publicAddressAllocationIds
         *        List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must
         *        specify one for SINGLE_PIPELINE, two for STANDARD channels
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAddressAllocationIds(Collection<String> publicAddressAllocationIds);

        /**
         * List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must specify
         * one for SINGLE_PIPELINE, two for STANDARD channels
         *
         * @param publicAddressAllocationIds
         *        List of public address allocation ids to associate with ENIs that will be created in Output VPC. Must
         *        specify one for SINGLE_PIPELINE, two for STANDARD channels
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAddressAllocationIds(String... publicAddressAllocationIds);

        /**
         * A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are
         * specified then the VPC default security group will be used
         *
         * @param securityGroupIds
         *        A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none
         *        are specified then the VPC default security group will be used
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none are
         * specified then the VPC default security group will be used
         *
         * @param securityGroupIds
         *        A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces. If none
         *        are specified then the VPC default security group will be used
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique
         * availability zones (AZ).
         *
         * @param subnetIds
         *        A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two
         *        unique availability zones (AZ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two unique
         * availability zones (AZ).
         *
         * @param subnetIds
         *        A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must be mapped to two
         *        unique availability zones (AZ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> publicAddressAllocationIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOutputSettings model) {
            publicAddressAllocationIds(model.publicAddressAllocationIds);
            securityGroupIds(model.securityGroupIds);
            subnetIds(model.subnetIds);
        }

        public final Collection<String> getPublicAddressAllocationIds() {
            if (publicAddressAllocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return publicAddressAllocationIds;
        }

        public final void setPublicAddressAllocationIds(Collection<String> publicAddressAllocationIds) {
            this.publicAddressAllocationIds = ___listOf__stringCopier.copy(publicAddressAllocationIds);
        }

        @Override
        @Transient
        public final Builder publicAddressAllocationIds(Collection<String> publicAddressAllocationIds) {
            this.publicAddressAllocationIds = ___listOf__stringCopier.copy(publicAddressAllocationIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder publicAddressAllocationIds(String... publicAddressAllocationIds) {
            publicAddressAllocationIds(Arrays.asList(publicAddressAllocationIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOf__stringCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOf__stringCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
        }

        @Override
        @Transient
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        @Override
        public VpcOutputSettings build() {
            return new VpcOutputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
