/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Channel Mapping
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioChannelMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioChannelMapping.Builder, AudioChannelMapping> {
    private static final SdkField<List<InputChannelLevel>> INPUT_CHANNEL_LEVELS_FIELD = SdkField
            .<List<InputChannelLevel>> builder(MarshallingType.LIST)
            .memberName("InputChannelLevels")
            .getter(getter(AudioChannelMapping::inputChannelLevels))
            .setter(setter(Builder::inputChannelLevels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannelLevels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputChannelLevel> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputChannelLevel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> OUTPUT_CHANNEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OutputChannel").getter(getter(AudioChannelMapping::outputChannel))
            .setter(setter(Builder::outputChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputChannel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CHANNEL_LEVELS_FIELD,
            OUTPUT_CHANNEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InputChannelLevel> inputChannelLevels;

    private final Integer outputChannel;

    private AudioChannelMapping(BuilderImpl builder) {
        this.inputChannelLevels = builder.inputChannelLevels;
        this.outputChannel = builder.outputChannel;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputChannelLevels property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputChannelLevels() {
        return inputChannelLevels != null && !(inputChannelLevels instanceof SdkAutoConstructList);
    }

    /**
     * Indices and gain values for each input channel that should be remixed into this output channel.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputChannelLevels} method.
     * </p>
     * 
     * @return Indices and gain values for each input channel that should be remixed into this output channel.
     */
    public final List<InputChannelLevel> inputChannelLevels() {
        return inputChannelLevels;
    }

    /**
     * The index of the output channel being produced.
     * 
     * @return The index of the output channel being produced.
     */
    public final Integer outputChannel() {
        return outputChannel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInputChannelLevels() ? inputChannelLevels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputChannel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioChannelMapping)) {
            return false;
        }
        AudioChannelMapping other = (AudioChannelMapping) obj;
        return hasInputChannelLevels() == other.hasInputChannelLevels()
                && Objects.equals(inputChannelLevels(), other.inputChannelLevels())
                && Objects.equals(outputChannel(), other.outputChannel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioChannelMapping")
                .add("InputChannelLevels", hasInputChannelLevels() ? inputChannelLevels() : null)
                .add("OutputChannel", outputChannel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputChannelLevels":
            return Optional.ofNullable(clazz.cast(inputChannelLevels()));
        case "OutputChannel":
            return Optional.ofNullable(clazz.cast(outputChannel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioChannelMapping, T> g) {
        return obj -> g.apply((AudioChannelMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioChannelMapping> {
        /**
         * Indices and gain values for each input channel that should be remixed into this output channel.
         * 
         * @param inputChannelLevels
         *        Indices and gain values for each input channel that should be remixed into this output channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannelLevels(Collection<InputChannelLevel> inputChannelLevels);

        /**
         * Indices and gain values for each input channel that should be remixed into this output channel.
         * 
         * @param inputChannelLevels
         *        Indices and gain values for each input channel that should be remixed into this output channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannelLevels(InputChannelLevel... inputChannelLevels);

        /**
         * Indices and gain values for each input channel that should be remixed into this output channel. This is a
         * convenience method that creates an instance of the {@link List<InputChannelLevel>.Builder} avoiding the need
         * to create one manually via {@link List<InputChannelLevel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputChannelLevel>.Builder#build()} is called immediately
         * and its result is passed to {@link #inputChannelLevels(List<InputChannelLevel>)}.
         * 
         * @param inputChannelLevels
         *        a consumer that will call methods on {@link List<InputChannelLevel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputChannelLevels(List<InputChannelLevel>)
         */
        Builder inputChannelLevels(Consumer<InputChannelLevel.Builder>... inputChannelLevels);

        /**
         * The index of the output channel being produced.
         * 
         * @param outputChannel
         *        The index of the output channel being produced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputChannel(Integer outputChannel);
    }

    static final class BuilderImpl implements Builder {
        private List<InputChannelLevel> inputChannelLevels = DefaultSdkAutoConstructList.getInstance();

        private Integer outputChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioChannelMapping model) {
            inputChannelLevels(model.inputChannelLevels);
            outputChannel(model.outputChannel);
        }

        public final List<InputChannelLevel.Builder> getInputChannelLevels() {
            List<InputChannelLevel.Builder> result = ___listOfInputChannelLevelCopier.copyToBuilder(this.inputChannelLevels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputChannelLevels(Collection<InputChannelLevel.BuilderImpl> inputChannelLevels) {
            this.inputChannelLevels = ___listOfInputChannelLevelCopier.copyFromBuilder(inputChannelLevels);
        }

        @Override
        public final Builder inputChannelLevels(Collection<InputChannelLevel> inputChannelLevels) {
            this.inputChannelLevels = ___listOfInputChannelLevelCopier.copy(inputChannelLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannelLevels(InputChannelLevel... inputChannelLevels) {
            inputChannelLevels(Arrays.asList(inputChannelLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannelLevels(Consumer<InputChannelLevel.Builder>... inputChannelLevels) {
            inputChannelLevels(Stream.of(inputChannelLevels).map(c -> InputChannelLevel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getOutputChannel() {
            return outputChannel;
        }

        public final void setOutputChannel(Integer outputChannel) {
            this.outputChannel = outputChannel;
        }

        @Override
        public final Builder outputChannel(Integer outputChannel) {
            this.outputChannel = outputChannel;
            return this;
        }

        @Override
        public AudioChannelMapping build() {
            return new AudioChannelMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
