/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Encoder Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncoderSettings implements SdkPojo, Serializable, ToCopyableBuilder<EncoderSettings.Builder, EncoderSettings> {
    private static final SdkField<List<AudioDescription>> AUDIO_DESCRIPTIONS_FIELD = SdkField
            .<List<AudioDescription>> builder(MarshallingType.LIST)
            .memberName("AudioDescriptions")
            .getter(getter(EncoderSettings::audioDescriptions))
            .setter(setter(Builder::audioDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AvailBlanking> AVAIL_BLANKING_FIELD = SdkField
            .<AvailBlanking> builder(MarshallingType.SDK_POJO).memberName("AvailBlanking")
            .getter(getter(EncoderSettings::availBlanking)).setter(setter(Builder::availBlanking))
            .constructor(AvailBlanking::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availBlanking").build()).build();

    private static final SdkField<AvailConfiguration> AVAIL_CONFIGURATION_FIELD = SdkField
            .<AvailConfiguration> builder(MarshallingType.SDK_POJO).memberName("AvailConfiguration")
            .getter(getter(EncoderSettings::availConfiguration)).setter(setter(Builder::availConfiguration))
            .constructor(AvailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availConfiguration").build())
            .build();

    private static final SdkField<BlackoutSlate> BLACKOUT_SLATE_FIELD = SdkField
            .<BlackoutSlate> builder(MarshallingType.SDK_POJO).memberName("BlackoutSlate")
            .getter(getter(EncoderSettings::blackoutSlate)).setter(setter(Builder::blackoutSlate))
            .constructor(BlackoutSlate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackoutSlate").build()).build();

    private static final SdkField<List<CaptionDescription>> CAPTION_DESCRIPTIONS_FIELD = SdkField
            .<List<CaptionDescription>> builder(MarshallingType.LIST)
            .memberName("CaptionDescriptions")
            .getter(getter(EncoderSettings::captionDescriptions))
            .setter(setter(Builder::captionDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaptionDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaptionDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FeatureActivations> FEATURE_ACTIVATIONS_FIELD = SdkField
            .<FeatureActivations> builder(MarshallingType.SDK_POJO).memberName("FeatureActivations")
            .getter(getter(EncoderSettings::featureActivations)).setter(setter(Builder::featureActivations))
            .constructor(FeatureActivations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureActivations").build())
            .build();

    private static final SdkField<GlobalConfiguration> GLOBAL_CONFIGURATION_FIELD = SdkField
            .<GlobalConfiguration> builder(MarshallingType.SDK_POJO).memberName("GlobalConfiguration")
            .getter(getter(EncoderSettings::globalConfiguration)).setter(setter(Builder::globalConfiguration))
            .constructor(GlobalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalConfiguration").build())
            .build();

    private static final SdkField<MotionGraphicsConfiguration> MOTION_GRAPHICS_CONFIGURATION_FIELD = SdkField
            .<MotionGraphicsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("MotionGraphicsConfiguration")
            .getter(getter(EncoderSettings::motionGraphicsConfiguration))
            .setter(setter(Builder::motionGraphicsConfiguration))
            .constructor(MotionGraphicsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("motionGraphicsConfiguration")
                    .build()).build();

    private static final SdkField<NielsenConfiguration> NIELSEN_CONFIGURATION_FIELD = SdkField
            .<NielsenConfiguration> builder(MarshallingType.SDK_POJO).memberName("NielsenConfiguration")
            .getter(getter(EncoderSettings::nielsenConfiguration)).setter(setter(Builder::nielsenConfiguration))
            .constructor(NielsenConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenConfiguration").build())
            .build();

    private static final SdkField<List<OutputGroup>> OUTPUT_GROUPS_FIELD = SdkField
            .<List<OutputGroup>> builder(MarshallingType.LIST)
            .memberName("OutputGroups")
            .getter(getter(EncoderSettings::outputGroups))
            .setter(setter(Builder::outputGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimecodeConfig> TIMECODE_CONFIG_FIELD = SdkField
            .<TimecodeConfig> builder(MarshallingType.SDK_POJO).memberName("TimecodeConfig")
            .getter(getter(EncoderSettings::timecodeConfig)).setter(setter(Builder::timecodeConfig))
            .constructor(TimecodeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeConfig").build()).build();

    private static final SdkField<List<VideoDescription>> VIDEO_DESCRIPTIONS_FIELD = SdkField
            .<List<VideoDescription>> builder(MarshallingType.LIST)
            .memberName("VideoDescriptions")
            .getter(getter(EncoderSettings::videoDescriptions))
            .setter(setter(Builder::videoDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VideoDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(VideoDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTIONS_FIELD,
            AVAIL_BLANKING_FIELD, AVAIL_CONFIGURATION_FIELD, BLACKOUT_SLATE_FIELD, CAPTION_DESCRIPTIONS_FIELD,
            FEATURE_ACTIVATIONS_FIELD, GLOBAL_CONFIGURATION_FIELD, MOTION_GRAPHICS_CONFIGURATION_FIELD,
            NIELSEN_CONFIGURATION_FIELD, OUTPUT_GROUPS_FIELD, TIMECODE_CONFIG_FIELD, VIDEO_DESCRIPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AudioDescription> audioDescriptions;

    private final AvailBlanking availBlanking;

    private final AvailConfiguration availConfiguration;

    private final BlackoutSlate blackoutSlate;

    private final List<CaptionDescription> captionDescriptions;

    private final FeatureActivations featureActivations;

    private final GlobalConfiguration globalConfiguration;

    private final MotionGraphicsConfiguration motionGraphicsConfiguration;

    private final NielsenConfiguration nielsenConfiguration;

    private final List<OutputGroup> outputGroups;

    private final TimecodeConfig timecodeConfig;

    private final List<VideoDescription> videoDescriptions;

    private EncoderSettings(BuilderImpl builder) {
        this.audioDescriptions = builder.audioDescriptions;
        this.availBlanking = builder.availBlanking;
        this.availConfiguration = builder.availConfiguration;
        this.blackoutSlate = builder.blackoutSlate;
        this.captionDescriptions = builder.captionDescriptions;
        this.featureActivations = builder.featureActivations;
        this.globalConfiguration = builder.globalConfiguration;
        this.motionGraphicsConfiguration = builder.motionGraphicsConfiguration;
        this.nielsenConfiguration = builder.nielsenConfiguration;
        this.outputGroups = builder.outputGroups;
        this.timecodeConfig = builder.timecodeConfig;
        this.videoDescriptions = builder.videoDescriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudioDescriptions() {
        return audioDescriptions != null && !(audioDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AudioDescriptions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioDescriptions} method.
     * </p>
     * 
     * @return The value of the AudioDescriptions property for this object.
     */
    public final List<AudioDescription> audioDescriptions() {
        return audioDescriptions;
    }

    /**
     * Settings for ad avail blanking.
     * 
     * @return Settings for ad avail blanking.
     */
    public final AvailBlanking availBlanking() {
        return availBlanking;
    }

    /**
     * Event-wide configuration settings for ad avail insertion.
     * 
     * @return Event-wide configuration settings for ad avail insertion.
     */
    public final AvailConfiguration availConfiguration() {
        return availConfiguration;
    }

    /**
     * Settings for blackout slate.
     * 
     * @return Settings for blackout slate.
     */
    public final BlackoutSlate blackoutSlate() {
        return blackoutSlate;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaptionDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCaptionDescriptions() {
        return captionDescriptions != null && !(captionDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * Settings for caption decriptions
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaptionDescriptions} method.
     * </p>
     * 
     * @return Settings for caption decriptions
     */
    public final List<CaptionDescription> captionDescriptions() {
        return captionDescriptions;
    }

    /**
     * Feature Activations
     * 
     * @return Feature Activations
     */
    public final FeatureActivations featureActivations() {
        return featureActivations;
    }

    /**
     * Configuration settings that apply to the event as a whole.
     * 
     * @return Configuration settings that apply to the event as a whole.
     */
    public final GlobalConfiguration globalConfiguration() {
        return globalConfiguration;
    }

    /**
     * Settings for motion graphics.
     * 
     * @return Settings for motion graphics.
     */
    public final MotionGraphicsConfiguration motionGraphicsConfiguration() {
        return motionGraphicsConfiguration;
    }

    /**
     * Nielsen configuration settings.
     * 
     * @return Nielsen configuration settings.
     */
    public final NielsenConfiguration nielsenConfiguration() {
        return nielsenConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputGroups() {
        return outputGroups != null && !(outputGroups instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the OutputGroups property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputGroups} method.
     * </p>
     * 
     * @return The value of the OutputGroups property for this object.
     */
    public final List<OutputGroup> outputGroups() {
        return outputGroups;
    }

    /**
     * Contains settings used to acquire and adjust timecode information from inputs.
     * 
     * @return Contains settings used to acquire and adjust timecode information from inputs.
     */
    public final TimecodeConfig timecodeConfig() {
        return timecodeConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the VideoDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVideoDescriptions() {
        return videoDescriptions != null && !(videoDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the VideoDescriptions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVideoDescriptions} method.
     * </p>
     * 
     * @return The value of the VideoDescriptions property for this object.
     */
    public final List<VideoDescription> videoDescriptions() {
        return videoDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioDescriptions() ? audioDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availBlanking());
        hashCode = 31 * hashCode + Objects.hashCode(availConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(blackoutSlate());
        hashCode = 31 * hashCode + Objects.hashCode(hasCaptionDescriptions() ? captionDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(featureActivations());
        hashCode = 31 * hashCode + Objects.hashCode(globalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(motionGraphicsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputGroups() ? outputGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasVideoDescriptions() ? videoDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncoderSettings)) {
            return false;
        }
        EncoderSettings other = (EncoderSettings) obj;
        return hasAudioDescriptions() == other.hasAudioDescriptions()
                && Objects.equals(audioDescriptions(), other.audioDescriptions())
                && Objects.equals(availBlanking(), other.availBlanking())
                && Objects.equals(availConfiguration(), other.availConfiguration())
                && Objects.equals(blackoutSlate(), other.blackoutSlate())
                && hasCaptionDescriptions() == other.hasCaptionDescriptions()
                && Objects.equals(captionDescriptions(), other.captionDescriptions())
                && Objects.equals(featureActivations(), other.featureActivations())
                && Objects.equals(globalConfiguration(), other.globalConfiguration())
                && Objects.equals(motionGraphicsConfiguration(), other.motionGraphicsConfiguration())
                && Objects.equals(nielsenConfiguration(), other.nielsenConfiguration())
                && hasOutputGroups() == other.hasOutputGroups() && Objects.equals(outputGroups(), other.outputGroups())
                && Objects.equals(timecodeConfig(), other.timecodeConfig())
                && hasVideoDescriptions() == other.hasVideoDescriptions()
                && Objects.equals(videoDescriptions(), other.videoDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncoderSettings").add("AudioDescriptions", hasAudioDescriptions() ? audioDescriptions() : null)
                .add("AvailBlanking", availBlanking()).add("AvailConfiguration", availConfiguration())
                .add("BlackoutSlate", blackoutSlate())
                .add("CaptionDescriptions", hasCaptionDescriptions() ? captionDescriptions() : null)
                .add("FeatureActivations", featureActivations()).add("GlobalConfiguration", globalConfiguration())
                .add("MotionGraphicsConfiguration", motionGraphicsConfiguration())
                .add("NielsenConfiguration", nielsenConfiguration())
                .add("OutputGroups", hasOutputGroups() ? outputGroups() : null).add("TimecodeConfig", timecodeConfig())
                .add("VideoDescriptions", hasVideoDescriptions() ? videoDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDescriptions":
            return Optional.ofNullable(clazz.cast(audioDescriptions()));
        case "AvailBlanking":
            return Optional.ofNullable(clazz.cast(availBlanking()));
        case "AvailConfiguration":
            return Optional.ofNullable(clazz.cast(availConfiguration()));
        case "BlackoutSlate":
            return Optional.ofNullable(clazz.cast(blackoutSlate()));
        case "CaptionDescriptions":
            return Optional.ofNullable(clazz.cast(captionDescriptions()));
        case "FeatureActivations":
            return Optional.ofNullable(clazz.cast(featureActivations()));
        case "GlobalConfiguration":
            return Optional.ofNullable(clazz.cast(globalConfiguration()));
        case "MotionGraphicsConfiguration":
            return Optional.ofNullable(clazz.cast(motionGraphicsConfiguration()));
        case "NielsenConfiguration":
            return Optional.ofNullable(clazz.cast(nielsenConfiguration()));
        case "OutputGroups":
            return Optional.ofNullable(clazz.cast(outputGroups()));
        case "TimecodeConfig":
            return Optional.ofNullable(clazz.cast(timecodeConfig()));
        case "VideoDescriptions":
            return Optional.ofNullable(clazz.cast(videoDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncoderSettings, T> g) {
        return obj -> g.apply((EncoderSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncoderSettings> {
        /**
         * Sets the value of the AudioDescriptions property for this object.
         *
         * @param audioDescriptions
         *        The new value for the AudioDescriptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptions(Collection<AudioDescription> audioDescriptions);

        /**
         * Sets the value of the AudioDescriptions property for this object.
         *
         * @param audioDescriptions
         *        The new value for the AudioDescriptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptions(AudioDescription... audioDescriptions);

        /**
         * Sets the value of the AudioDescriptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<AudioDescription>.Builder} avoiding
         * the need to create one manually via {@link List<AudioDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AudioDescription>.Builder#build()} is called immediately and
         * its result is passed to {@link #audioDescriptions(List<AudioDescription>)}.
         * 
         * @param audioDescriptions
         *        a consumer that will call methods on {@link List<AudioDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioDescriptions(List<AudioDescription>)
         */
        Builder audioDescriptions(Consumer<AudioDescription.Builder>... audioDescriptions);

        /**
         * Settings for ad avail blanking.
         * 
         * @param availBlanking
         *        Settings for ad avail blanking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availBlanking(AvailBlanking availBlanking);

        /**
         * Settings for ad avail blanking. This is a convenience method that creates an instance of the
         * {@link AvailBlanking.Builder} avoiding the need to create one manually via {@link AvailBlanking#builder()}.
         *
         * When the {@link Consumer} completes, {@link AvailBlanking.Builder#build()} is called immediately and its
         * result is passed to {@link #availBlanking(AvailBlanking)}.
         * 
         * @param availBlanking
         *        a consumer that will call methods on {@link AvailBlanking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availBlanking(AvailBlanking)
         */
        default Builder availBlanking(Consumer<AvailBlanking.Builder> availBlanking) {
            return availBlanking(AvailBlanking.builder().applyMutation(availBlanking).build());
        }

        /**
         * Event-wide configuration settings for ad avail insertion.
         * 
         * @param availConfiguration
         *        Event-wide configuration settings for ad avail insertion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availConfiguration(AvailConfiguration availConfiguration);

        /**
         * Event-wide configuration settings for ad avail insertion. This is a convenience method that creates an
         * instance of the {@link AvailConfiguration.Builder} avoiding the need to create one manually via
         * {@link AvailConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AvailConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #availConfiguration(AvailConfiguration)}.
         * 
         * @param availConfiguration
         *        a consumer that will call methods on {@link AvailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availConfiguration(AvailConfiguration)
         */
        default Builder availConfiguration(Consumer<AvailConfiguration.Builder> availConfiguration) {
            return availConfiguration(AvailConfiguration.builder().applyMutation(availConfiguration).build());
        }

        /**
         * Settings for blackout slate.
         * 
         * @param blackoutSlate
         *        Settings for blackout slate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blackoutSlate(BlackoutSlate blackoutSlate);

        /**
         * Settings for blackout slate. This is a convenience method that creates an instance of the
         * {@link BlackoutSlate.Builder} avoiding the need to create one manually via {@link BlackoutSlate#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlackoutSlate.Builder#build()} is called immediately and its
         * result is passed to {@link #blackoutSlate(BlackoutSlate)}.
         * 
         * @param blackoutSlate
         *        a consumer that will call methods on {@link BlackoutSlate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blackoutSlate(BlackoutSlate)
         */
        default Builder blackoutSlate(Consumer<BlackoutSlate.Builder> blackoutSlate) {
            return blackoutSlate(BlackoutSlate.builder().applyMutation(blackoutSlate).build());
        }

        /**
         * Settings for caption decriptions
         * 
         * @param captionDescriptions
         *        Settings for caption decriptions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDescriptions(Collection<CaptionDescription> captionDescriptions);

        /**
         * Settings for caption decriptions
         * 
         * @param captionDescriptions
         *        Settings for caption decriptions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDescriptions(CaptionDescription... captionDescriptions);

        /**
         * Settings for caption decriptions This is a convenience method that creates an instance of the {@link List
         * <CaptionDescription>.Builder} avoiding the need to create one manually via {@link List
         * <CaptionDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CaptionDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #captionDescriptions(List<CaptionDescription>)}.
         * 
         * @param captionDescriptions
         *        a consumer that will call methods on {@link List<CaptionDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captionDescriptions(List<CaptionDescription>)
         */
        Builder captionDescriptions(Consumer<CaptionDescription.Builder>... captionDescriptions);

        /**
         * Feature Activations
         * 
         * @param featureActivations
         *        Feature Activations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureActivations(FeatureActivations featureActivations);

        /**
         * Feature Activations This is a convenience method that creates an instance of the
         * {@link FeatureActivations.Builder} avoiding the need to create one manually via
         * {@link FeatureActivations#builder()}.
         *
         * When the {@link Consumer} completes, {@link FeatureActivations.Builder#build()} is called immediately and its
         * result is passed to {@link #featureActivations(FeatureActivations)}.
         * 
         * @param featureActivations
         *        a consumer that will call methods on {@link FeatureActivations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureActivations(FeatureActivations)
         */
        default Builder featureActivations(Consumer<FeatureActivations.Builder> featureActivations) {
            return featureActivations(FeatureActivations.builder().applyMutation(featureActivations).build());
        }

        /**
         * Configuration settings that apply to the event as a whole.
         * 
         * @param globalConfiguration
         *        Configuration settings that apply to the event as a whole.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalConfiguration(GlobalConfiguration globalConfiguration);

        /**
         * Configuration settings that apply to the event as a whole. This is a convenience method that creates an
         * instance of the {@link GlobalConfiguration.Builder} avoiding the need to create one manually via
         * {@link GlobalConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link GlobalConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #globalConfiguration(GlobalConfiguration)}.
         * 
         * @param globalConfiguration
         *        a consumer that will call methods on {@link GlobalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalConfiguration(GlobalConfiguration)
         */
        default Builder globalConfiguration(Consumer<GlobalConfiguration.Builder> globalConfiguration) {
            return globalConfiguration(GlobalConfiguration.builder().applyMutation(globalConfiguration).build());
        }

        /**
         * Settings for motion graphics.
         * 
         * @param motionGraphicsConfiguration
         *        Settings for motion graphics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder motionGraphicsConfiguration(MotionGraphicsConfiguration motionGraphicsConfiguration);

        /**
         * Settings for motion graphics. This is a convenience method that creates an instance of the
         * {@link MotionGraphicsConfiguration.Builder} avoiding the need to create one manually via
         * {@link MotionGraphicsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MotionGraphicsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #motionGraphicsConfiguration(MotionGraphicsConfiguration)}.
         * 
         * @param motionGraphicsConfiguration
         *        a consumer that will call methods on {@link MotionGraphicsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #motionGraphicsConfiguration(MotionGraphicsConfiguration)
         */
        default Builder motionGraphicsConfiguration(Consumer<MotionGraphicsConfiguration.Builder> motionGraphicsConfiguration) {
            return motionGraphicsConfiguration(MotionGraphicsConfiguration.builder().applyMutation(motionGraphicsConfiguration)
                    .build());
        }

        /**
         * Nielsen configuration settings.
         * 
         * @param nielsenConfiguration
         *        Nielsen configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration);

        /**
         * Nielsen configuration settings. This is a convenience method that creates an instance of the
         * {@link NielsenConfiguration.Builder} avoiding the need to create one manually via
         * {@link NielsenConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NielsenConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #nielsenConfiguration(NielsenConfiguration)}.
         * 
         * @param nielsenConfiguration
         *        a consumer that will call methods on {@link NielsenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nielsenConfiguration(NielsenConfiguration)
         */
        default Builder nielsenConfiguration(Consumer<NielsenConfiguration.Builder> nielsenConfiguration) {
            return nielsenConfiguration(NielsenConfiguration.builder().applyMutation(nielsenConfiguration).build());
        }

        /**
         * Sets the value of the OutputGroups property for this object.
         *
         * @param outputGroups
         *        The new value for the OutputGroups property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroups(Collection<OutputGroup> outputGroups);

        /**
         * Sets the value of the OutputGroups property for this object.
         *
         * @param outputGroups
         *        The new value for the OutputGroups property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroups(OutputGroup... outputGroups);

        /**
         * Sets the value of the OutputGroups property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<OutputGroup>.Builder} avoiding the
         * need to create one manually via {@link List<OutputGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputGroups(List<OutputGroup>)}.
         * 
         * @param outputGroups
         *        a consumer that will call methods on {@link List<OutputGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputGroups(List<OutputGroup>)
         */
        Builder outputGroups(Consumer<OutputGroup.Builder>... outputGroups);

        /**
         * Contains settings used to acquire and adjust timecode information from inputs.
         * 
         * @param timecodeConfig
         *        Contains settings used to acquire and adjust timecode information from inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeConfig(TimecodeConfig timecodeConfig);

        /**
         * Contains settings used to acquire and adjust timecode information from inputs. This is a convenience method
         * that creates an instance of the {@link TimecodeConfig.Builder} avoiding the need to create one manually via
         * {@link TimecodeConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimecodeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timecodeConfig(TimecodeConfig)}.
         * 
         * @param timecodeConfig
         *        a consumer that will call methods on {@link TimecodeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeConfig(TimecodeConfig)
         */
        default Builder timecodeConfig(Consumer<TimecodeConfig.Builder> timecodeConfig) {
            return timecodeConfig(TimecodeConfig.builder().applyMutation(timecodeConfig).build());
        }

        /**
         * Sets the value of the VideoDescriptions property for this object.
         *
         * @param videoDescriptions
         *        The new value for the VideoDescriptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoDescriptions(Collection<VideoDescription> videoDescriptions);

        /**
         * Sets the value of the VideoDescriptions property for this object.
         *
         * @param videoDescriptions
         *        The new value for the VideoDescriptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoDescriptions(VideoDescription... videoDescriptions);

        /**
         * Sets the value of the VideoDescriptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<VideoDescription>.Builder} avoiding
         * the need to create one manually via {@link List<VideoDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VideoDescription>.Builder#build()} is called immediately and
         * its result is passed to {@link #videoDescriptions(List<VideoDescription>)}.
         * 
         * @param videoDescriptions
         *        a consumer that will call methods on {@link List<VideoDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoDescriptions(List<VideoDescription>)
         */
        Builder videoDescriptions(Consumer<VideoDescription.Builder>... videoDescriptions);
    }

    static final class BuilderImpl implements Builder {
        private List<AudioDescription> audioDescriptions = DefaultSdkAutoConstructList.getInstance();

        private AvailBlanking availBlanking;

        private AvailConfiguration availConfiguration;

        private BlackoutSlate blackoutSlate;

        private List<CaptionDescription> captionDescriptions = DefaultSdkAutoConstructList.getInstance();

        private FeatureActivations featureActivations;

        private GlobalConfiguration globalConfiguration;

        private MotionGraphicsConfiguration motionGraphicsConfiguration;

        private NielsenConfiguration nielsenConfiguration;

        private List<OutputGroup> outputGroups = DefaultSdkAutoConstructList.getInstance();

        private TimecodeConfig timecodeConfig;

        private List<VideoDescription> videoDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EncoderSettings model) {
            audioDescriptions(model.audioDescriptions);
            availBlanking(model.availBlanking);
            availConfiguration(model.availConfiguration);
            blackoutSlate(model.blackoutSlate);
            captionDescriptions(model.captionDescriptions);
            featureActivations(model.featureActivations);
            globalConfiguration(model.globalConfiguration);
            motionGraphicsConfiguration(model.motionGraphicsConfiguration);
            nielsenConfiguration(model.nielsenConfiguration);
            outputGroups(model.outputGroups);
            timecodeConfig(model.timecodeConfig);
            videoDescriptions(model.videoDescriptions);
        }

        public final List<AudioDescription.Builder> getAudioDescriptions() {
            List<AudioDescription.Builder> result = ___listOfAudioDescriptionCopier.copyToBuilder(this.audioDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioDescriptions(Collection<AudioDescription.BuilderImpl> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copyFromBuilder(audioDescriptions);
        }

        @Override
        public final Builder audioDescriptions(Collection<AudioDescription> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copy(audioDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(AudioDescription... audioDescriptions) {
            audioDescriptions(Arrays.asList(audioDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(Consumer<AudioDescription.Builder>... audioDescriptions) {
            audioDescriptions(Stream.of(audioDescriptions).map(c -> AudioDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AvailBlanking.Builder getAvailBlanking() {
            return availBlanking != null ? availBlanking.toBuilder() : null;
        }

        public final void setAvailBlanking(AvailBlanking.BuilderImpl availBlanking) {
            this.availBlanking = availBlanking != null ? availBlanking.build() : null;
        }

        @Override
        public final Builder availBlanking(AvailBlanking availBlanking) {
            this.availBlanking = availBlanking;
            return this;
        }

        public final AvailConfiguration.Builder getAvailConfiguration() {
            return availConfiguration != null ? availConfiguration.toBuilder() : null;
        }

        public final void setAvailConfiguration(AvailConfiguration.BuilderImpl availConfiguration) {
            this.availConfiguration = availConfiguration != null ? availConfiguration.build() : null;
        }

        @Override
        public final Builder availConfiguration(AvailConfiguration availConfiguration) {
            this.availConfiguration = availConfiguration;
            return this;
        }

        public final BlackoutSlate.Builder getBlackoutSlate() {
            return blackoutSlate != null ? blackoutSlate.toBuilder() : null;
        }

        public final void setBlackoutSlate(BlackoutSlate.BuilderImpl blackoutSlate) {
            this.blackoutSlate = blackoutSlate != null ? blackoutSlate.build() : null;
        }

        @Override
        public final Builder blackoutSlate(BlackoutSlate blackoutSlate) {
            this.blackoutSlate = blackoutSlate;
            return this;
        }

        public final List<CaptionDescription.Builder> getCaptionDescriptions() {
            List<CaptionDescription.Builder> result = ___listOfCaptionDescriptionCopier.copyToBuilder(this.captionDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaptionDescriptions(Collection<CaptionDescription.BuilderImpl> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionCopier.copyFromBuilder(captionDescriptions);
        }

        @Override
        public final Builder captionDescriptions(Collection<CaptionDescription> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionCopier.copy(captionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(CaptionDescription... captionDescriptions) {
            captionDescriptions(Arrays.asList(captionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(Consumer<CaptionDescription.Builder>... captionDescriptions) {
            captionDescriptions(Stream.of(captionDescriptions).map(c -> CaptionDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final FeatureActivations.Builder getFeatureActivations() {
            return featureActivations != null ? featureActivations.toBuilder() : null;
        }

        public final void setFeatureActivations(FeatureActivations.BuilderImpl featureActivations) {
            this.featureActivations = featureActivations != null ? featureActivations.build() : null;
        }

        @Override
        public final Builder featureActivations(FeatureActivations featureActivations) {
            this.featureActivations = featureActivations;
            return this;
        }

        public final GlobalConfiguration.Builder getGlobalConfiguration() {
            return globalConfiguration != null ? globalConfiguration.toBuilder() : null;
        }

        public final void setGlobalConfiguration(GlobalConfiguration.BuilderImpl globalConfiguration) {
            this.globalConfiguration = globalConfiguration != null ? globalConfiguration.build() : null;
        }

        @Override
        public final Builder globalConfiguration(GlobalConfiguration globalConfiguration) {
            this.globalConfiguration = globalConfiguration;
            return this;
        }

        public final MotionGraphicsConfiguration.Builder getMotionGraphicsConfiguration() {
            return motionGraphicsConfiguration != null ? motionGraphicsConfiguration.toBuilder() : null;
        }

        public final void setMotionGraphicsConfiguration(MotionGraphicsConfiguration.BuilderImpl motionGraphicsConfiguration) {
            this.motionGraphicsConfiguration = motionGraphicsConfiguration != null ? motionGraphicsConfiguration.build() : null;
        }

        @Override
        public final Builder motionGraphicsConfiguration(MotionGraphicsConfiguration motionGraphicsConfiguration) {
            this.motionGraphicsConfiguration = motionGraphicsConfiguration;
            return this;
        }

        public final NielsenConfiguration.Builder getNielsenConfiguration() {
            return nielsenConfiguration != null ? nielsenConfiguration.toBuilder() : null;
        }

        public final void setNielsenConfiguration(NielsenConfiguration.BuilderImpl nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration != null ? nielsenConfiguration.build() : null;
        }

        @Override
        public final Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration;
            return this;
        }

        public final List<OutputGroup.Builder> getOutputGroups() {
            List<OutputGroup.Builder> result = ___listOfOutputGroupCopier.copyToBuilder(this.outputGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputGroups(Collection<OutputGroup.BuilderImpl> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copyFromBuilder(outputGroups);
        }

        @Override
        public final Builder outputGroups(Collection<OutputGroup> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copy(outputGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(OutputGroup... outputGroups) {
            outputGroups(Arrays.asList(outputGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(Consumer<OutputGroup.Builder>... outputGroups) {
            outputGroups(Stream.of(outputGroups).map(c -> OutputGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TimecodeConfig.Builder getTimecodeConfig() {
            return timecodeConfig != null ? timecodeConfig.toBuilder() : null;
        }

        public final void setTimecodeConfig(TimecodeConfig.BuilderImpl timecodeConfig) {
            this.timecodeConfig = timecodeConfig != null ? timecodeConfig.build() : null;
        }

        @Override
        public final Builder timecodeConfig(TimecodeConfig timecodeConfig) {
            this.timecodeConfig = timecodeConfig;
            return this;
        }

        public final List<VideoDescription.Builder> getVideoDescriptions() {
            List<VideoDescription.Builder> result = ___listOfVideoDescriptionCopier.copyToBuilder(this.videoDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVideoDescriptions(Collection<VideoDescription.BuilderImpl> videoDescriptions) {
            this.videoDescriptions = ___listOfVideoDescriptionCopier.copyFromBuilder(videoDescriptions);
        }

        @Override
        public final Builder videoDescriptions(Collection<VideoDescription> videoDescriptions) {
            this.videoDescriptions = ___listOfVideoDescriptionCopier.copy(videoDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoDescriptions(VideoDescription... videoDescriptions) {
            videoDescriptions(Arrays.asList(videoDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoDescriptions(Consumer<VideoDescription.Builder>... videoDescriptions) {
            videoDescriptions(Stream.of(videoDescriptions).map(c -> VideoDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EncoderSettings build() {
            return new EncoderSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
