/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for one failover condition.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverConditionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FailoverConditionSettings.Builder, FailoverConditionSettings> {
    private static final SdkField<AudioSilenceFailoverSettings> AUDIO_SILENCE_SETTINGS_FIELD = SdkField
            .<AudioSilenceFailoverSettings> builder(MarshallingType.SDK_POJO).memberName("AudioSilenceSettings")
            .getter(getter(FailoverConditionSettings::audioSilenceSettings)).setter(setter(Builder::audioSilenceSettings))
            .constructor(AudioSilenceFailoverSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSilenceSettings").build())
            .build();

    private static final SdkField<InputLossFailoverSettings> INPUT_LOSS_SETTINGS_FIELD = SdkField
            .<InputLossFailoverSettings> builder(MarshallingType.SDK_POJO).memberName("InputLossSettings")
            .getter(getter(FailoverConditionSettings::inputLossSettings)).setter(setter(Builder::inputLossSettings))
            .constructor(InputLossFailoverSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossSettings").build()).build();

    private static final SdkField<VideoBlackFailoverSettings> VIDEO_BLACK_SETTINGS_FIELD = SdkField
            .<VideoBlackFailoverSettings> builder(MarshallingType.SDK_POJO).memberName("VideoBlackSettings")
            .getter(getter(FailoverConditionSettings::videoBlackSettings)).setter(setter(Builder::videoBlackSettings))
            .constructor(VideoBlackFailoverSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoBlackSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SILENCE_SETTINGS_FIELD,
            INPUT_LOSS_SETTINGS_FIELD, VIDEO_BLACK_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AudioSilenceFailoverSettings audioSilenceSettings;

    private final InputLossFailoverSettings inputLossSettings;

    private final VideoBlackFailoverSettings videoBlackSettings;

    private FailoverConditionSettings(BuilderImpl builder) {
        this.audioSilenceSettings = builder.audioSilenceSettings;
        this.inputLossSettings = builder.inputLossSettings;
        this.videoBlackSettings = builder.videoBlackSettings;
    }

    /**
     * MediaLive will perform a failover if the specified audio selector is silent for the specified period.
     * 
     * @return MediaLive will perform a failover if the specified audio selector is silent for the specified period.
     */
    public final AudioSilenceFailoverSettings audioSilenceSettings() {
        return audioSilenceSettings;
    }

    /**
     * MediaLive will perform a failover if content is not detected in this input for the specified period.
     * 
     * @return MediaLive will perform a failover if content is not detected in this input for the specified period.
     */
    public final InputLossFailoverSettings inputLossSettings() {
        return inputLossSettings;
    }

    /**
     * MediaLive will perform a failover if content is considered black for the specified period.
     * 
     * @return MediaLive will perform a failover if content is considered black for the specified period.
     */
    public final VideoBlackFailoverSettings videoBlackSettings() {
        return videoBlackSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioSilenceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(inputLossSettings());
        hashCode = 31 * hashCode + Objects.hashCode(videoBlackSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverConditionSettings)) {
            return false;
        }
        FailoverConditionSettings other = (FailoverConditionSettings) obj;
        return Objects.equals(audioSilenceSettings(), other.audioSilenceSettings())
                && Objects.equals(inputLossSettings(), other.inputLossSettings())
                && Objects.equals(videoBlackSettings(), other.videoBlackSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverConditionSettings").add("AudioSilenceSettings", audioSilenceSettings())
                .add("InputLossSettings", inputLossSettings()).add("VideoBlackSettings", videoBlackSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioSilenceSettings":
            return Optional.ofNullable(clazz.cast(audioSilenceSettings()));
        case "InputLossSettings":
            return Optional.ofNullable(clazz.cast(inputLossSettings()));
        case "VideoBlackSettings":
            return Optional.ofNullable(clazz.cast(videoBlackSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailoverConditionSettings, T> g) {
        return obj -> g.apply((FailoverConditionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailoverConditionSettings> {
        /**
         * MediaLive will perform a failover if the specified audio selector is silent for the specified period.
         * 
         * @param audioSilenceSettings
         *        MediaLive will perform a failover if the specified audio selector is silent for the specified period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSilenceSettings(AudioSilenceFailoverSettings audioSilenceSettings);

        /**
         * MediaLive will perform a failover if the specified audio selector is silent for the specified period. This is
         * a convenience method that creates an instance of the {@link AudioSilenceFailoverSettings.Builder} avoiding
         * the need to create one manually via {@link AudioSilenceFailoverSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioSilenceFailoverSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #audioSilenceSettings(AudioSilenceFailoverSettings)}.
         * 
         * @param audioSilenceSettings
         *        a consumer that will call methods on {@link AudioSilenceFailoverSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioSilenceSettings(AudioSilenceFailoverSettings)
         */
        default Builder audioSilenceSettings(Consumer<AudioSilenceFailoverSettings.Builder> audioSilenceSettings) {
            return audioSilenceSettings(AudioSilenceFailoverSettings.builder().applyMutation(audioSilenceSettings).build());
        }

        /**
         * MediaLive will perform a failover if content is not detected in this input for the specified period.
         * 
         * @param inputLossSettings
         *        MediaLive will perform a failover if content is not detected in this input for the specified period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLossSettings(InputLossFailoverSettings inputLossSettings);

        /**
         * MediaLive will perform a failover if content is not detected in this input for the specified period. This is
         * a convenience method that creates an instance of the {@link InputLossFailoverSettings.Builder} avoiding the
         * need to create one manually via {@link InputLossFailoverSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLossFailoverSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #inputLossSettings(InputLossFailoverSettings)}.
         * 
         * @param inputLossSettings
         *        a consumer that will call methods on {@link InputLossFailoverSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLossSettings(InputLossFailoverSettings)
         */
        default Builder inputLossSettings(Consumer<InputLossFailoverSettings.Builder> inputLossSettings) {
            return inputLossSettings(InputLossFailoverSettings.builder().applyMutation(inputLossSettings).build());
        }

        /**
         * MediaLive will perform a failover if content is considered black for the specified period.
         * 
         * @param videoBlackSettings
         *        MediaLive will perform a failover if content is considered black for the specified period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoBlackSettings(VideoBlackFailoverSettings videoBlackSettings);

        /**
         * MediaLive will perform a failover if content is considered black for the specified period. This is a
         * convenience method that creates an instance of the {@link VideoBlackFailoverSettings.Builder} avoiding the
         * need to create one manually via {@link VideoBlackFailoverSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoBlackFailoverSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #videoBlackSettings(VideoBlackFailoverSettings)}.
         * 
         * @param videoBlackSettings
         *        a consumer that will call methods on {@link VideoBlackFailoverSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoBlackSettings(VideoBlackFailoverSettings)
         */
        default Builder videoBlackSettings(Consumer<VideoBlackFailoverSettings.Builder> videoBlackSettings) {
            return videoBlackSettings(VideoBlackFailoverSettings.builder().applyMutation(videoBlackSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioSilenceFailoverSettings audioSilenceSettings;

        private InputLossFailoverSettings inputLossSettings;

        private VideoBlackFailoverSettings videoBlackSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverConditionSettings model) {
            audioSilenceSettings(model.audioSilenceSettings);
            inputLossSettings(model.inputLossSettings);
            videoBlackSettings(model.videoBlackSettings);
        }

        public final AudioSilenceFailoverSettings.Builder getAudioSilenceSettings() {
            return audioSilenceSettings != null ? audioSilenceSettings.toBuilder() : null;
        }

        public final void setAudioSilenceSettings(AudioSilenceFailoverSettings.BuilderImpl audioSilenceSettings) {
            this.audioSilenceSettings = audioSilenceSettings != null ? audioSilenceSettings.build() : null;
        }

        @Override
        public final Builder audioSilenceSettings(AudioSilenceFailoverSettings audioSilenceSettings) {
            this.audioSilenceSettings = audioSilenceSettings;
            return this;
        }

        public final InputLossFailoverSettings.Builder getInputLossSettings() {
            return inputLossSettings != null ? inputLossSettings.toBuilder() : null;
        }

        public final void setInputLossSettings(InputLossFailoverSettings.BuilderImpl inputLossSettings) {
            this.inputLossSettings = inputLossSettings != null ? inputLossSettings.build() : null;
        }

        @Override
        public final Builder inputLossSettings(InputLossFailoverSettings inputLossSettings) {
            this.inputLossSettings = inputLossSettings;
            return this;
        }

        public final VideoBlackFailoverSettings.Builder getVideoBlackSettings() {
            return videoBlackSettings != null ? videoBlackSettings.toBuilder() : null;
        }

        public final void setVideoBlackSettings(VideoBlackFailoverSettings.BuilderImpl videoBlackSettings) {
            this.videoBlackSettings = videoBlackSettings != null ? videoBlackSettings.build() : null;
        }

        @Override
        public final Builder videoBlackSettings(VideoBlackFailoverSettings videoBlackSettings) {
            this.videoBlackSettings = videoBlackSettings;
            return this;
        }

        @Override
        public FailoverConditionSettings build() {
            return new FailoverConditionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
