/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Frame Capture Cdn Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameCaptureCdnSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameCaptureCdnSettings.Builder, FrameCaptureCdnSettings> {
    private static final SdkField<FrameCaptureS3Settings> FRAME_CAPTURE_S3_SETTINGS_FIELD = SdkField
            .<FrameCaptureS3Settings> builder(MarshallingType.SDK_POJO).memberName("FrameCaptureS3Settings")
            .getter(getter(FrameCaptureCdnSettings::frameCaptureS3Settings)).setter(setter(Builder::frameCaptureS3Settings))
            .constructor(FrameCaptureS3Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureS3Settings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FRAME_CAPTURE_S3_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final FrameCaptureS3Settings frameCaptureS3Settings;

    private FrameCaptureCdnSettings(BuilderImpl builder) {
        this.frameCaptureS3Settings = builder.frameCaptureS3Settings;
    }

    /**
     * Returns the value of the FrameCaptureS3Settings property for this object.
     * 
     * @return The value of the FrameCaptureS3Settings property for this object.
     */
    public final FrameCaptureS3Settings frameCaptureS3Settings() {
        return frameCaptureS3Settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureS3Settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureCdnSettings)) {
            return false;
        }
        FrameCaptureCdnSettings other = (FrameCaptureCdnSettings) obj;
        return Objects.equals(frameCaptureS3Settings(), other.frameCaptureS3Settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrameCaptureCdnSettings").add("FrameCaptureS3Settings", frameCaptureS3Settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FrameCaptureS3Settings":
            return Optional.ofNullable(clazz.cast(frameCaptureS3Settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureCdnSettings, T> g) {
        return obj -> g.apply((FrameCaptureCdnSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameCaptureCdnSettings> {
        /**
         * Sets the value of the FrameCaptureS3Settings property for this object.
         *
         * @param frameCaptureS3Settings
         *        The new value for the FrameCaptureS3Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureS3Settings(FrameCaptureS3Settings frameCaptureS3Settings);

        /**
         * Sets the value of the FrameCaptureS3Settings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FrameCaptureS3Settings.Builder} avoiding
         * the need to create one manually via {@link FrameCaptureS3Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FrameCaptureS3Settings.Builder#build()} is called immediately and
         * its result is passed to {@link #frameCaptureS3Settings(FrameCaptureS3Settings)}.
         * 
         * @param frameCaptureS3Settings
         *        a consumer that will call methods on {@link FrameCaptureS3Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureS3Settings(FrameCaptureS3Settings)
         */
        default Builder frameCaptureS3Settings(Consumer<FrameCaptureS3Settings.Builder> frameCaptureS3Settings) {
            return frameCaptureS3Settings(FrameCaptureS3Settings.builder().applyMutation(frameCaptureS3Settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FrameCaptureS3Settings frameCaptureS3Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureCdnSettings model) {
            frameCaptureS3Settings(model.frameCaptureS3Settings);
        }

        public final FrameCaptureS3Settings.Builder getFrameCaptureS3Settings() {
            return frameCaptureS3Settings != null ? frameCaptureS3Settings.toBuilder() : null;
        }

        public final void setFrameCaptureS3Settings(FrameCaptureS3Settings.BuilderImpl frameCaptureS3Settings) {
            this.frameCaptureS3Settings = frameCaptureS3Settings != null ? frameCaptureS3Settings.build() : null;
        }

        @Override
        public final Builder frameCaptureS3Settings(FrameCaptureS3Settings frameCaptureS3Settings) {
            this.frameCaptureS3Settings = frameCaptureS3Settings;
            return this;
        }

        @Override
        public FrameCaptureCdnSettings build() {
            return new FrameCaptureCdnSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
