/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * H264 Filter Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class H264FilterSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<H264FilterSettings.Builder, H264FilterSettings> {
    private static final SdkField<TemporalFilterSettings> TEMPORAL_FILTER_SETTINGS_FIELD = SdkField
            .<TemporalFilterSettings> builder(MarshallingType.SDK_POJO).memberName("TemporalFilterSettings")
            .getter(getter(H264FilterSettings::temporalFilterSettings)).setter(setter(Builder::temporalFilterSettings))
            .constructor(TemporalFilterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalFilterSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TEMPORAL_FILTER_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TemporalFilterSettings temporalFilterSettings;

    private H264FilterSettings(BuilderImpl builder) {
        this.temporalFilterSettings = builder.temporalFilterSettings;
    }

    /**
     * Returns the value of the TemporalFilterSettings property for this object.
     * 
     * @return The value of the TemporalFilterSettings property for this object.
     */
    public final TemporalFilterSettings temporalFilterSettings() {
        return temporalFilterSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(temporalFilterSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264FilterSettings)) {
            return false;
        }
        H264FilterSettings other = (H264FilterSettings) obj;
        return Objects.equals(temporalFilterSettings(), other.temporalFilterSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("H264FilterSettings").add("TemporalFilterSettings", temporalFilterSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemporalFilterSettings":
            return Optional.ofNullable(clazz.cast(temporalFilterSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264FilterSettings, T> g) {
        return obj -> g.apply((H264FilterSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H264FilterSettings> {
        /**
         * Sets the value of the TemporalFilterSettings property for this object.
         *
         * @param temporalFilterSettings
         *        The new value for the TemporalFilterSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporalFilterSettings(TemporalFilterSettings temporalFilterSettings);

        /**
         * Sets the value of the TemporalFilterSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TemporalFilterSettings.Builder} avoiding
         * the need to create one manually via {@link TemporalFilterSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemporalFilterSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #temporalFilterSettings(TemporalFilterSettings)}.
         * 
         * @param temporalFilterSettings
         *        a consumer that will call methods on {@link TemporalFilterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #temporalFilterSettings(TemporalFilterSettings)
         */
        default Builder temporalFilterSettings(Consumer<TemporalFilterSettings.Builder> temporalFilterSettings) {
            return temporalFilterSettings(TemporalFilterSettings.builder().applyMutation(temporalFilterSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TemporalFilterSettings temporalFilterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(H264FilterSettings model) {
            temporalFilterSettings(model.temporalFilterSettings);
        }

        public final TemporalFilterSettings.Builder getTemporalFilterSettings() {
            return temporalFilterSettings != null ? temporalFilterSettings.toBuilder() : null;
        }

        public final void setTemporalFilterSettings(TemporalFilterSettings.BuilderImpl temporalFilterSettings) {
            this.temporalFilterSettings = temporalFilterSettings != null ? temporalFilterSettings.build() : null;
        }

        @Override
        public final Builder temporalFilterSettings(TemporalFilterSettings temporalFilterSettings) {
            this.temporalFilterSettings = temporalFilterSettings;
            return this;
        }

        @Override
        public H264FilterSettings build() {
            return new H264FilterSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
