/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListInputsResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInputsResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListInputsResponse.Builder, ListInputsResponse> {
    private static final SdkField<List<Input>> INPUTS_FIELD = SdkField
            .<List<Input>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(ListInputsResponse::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Input> builder(MarshallingType.SDK_POJO)
                                            .constructor(Input::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInputsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INPUTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Input> inputs;

    private final String nextToken;

    private ListInputsResponse(BuilderImpl builder) {
        super(builder);
        this.inputs = builder.inputs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Inputs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The value of the Inputs property for this object.
     */
    public final List<Input> inputs() {
        return inputs;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputsResponse)) {
            return false;
        }
        ListInputsResponse other = (ListInputsResponse) obj;
        return hasInputs() == other.hasInputs() && Objects.equals(inputs(), other.inputs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInputsResponse").add("Inputs", hasInputs() ? inputs() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInputsResponse, T> g) {
        return obj -> g.apply((ListInputsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInputsResponse> {
        /**
         * Sets the value of the Inputs property for this object.
         *
         * @param inputs
         *        The new value for the Inputs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<Input> inputs);

        /**
         * Sets the value of the Inputs property for this object.
         *
         * @param inputs
         *        The new value for the Inputs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Input... inputs);

        /**
         * Sets the value of the Inputs property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List<Input>.Builder} avoiding the need to
         * create one manually via {@link List<Input>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Input>.Builder#build()} is called immediately and its result
         * is passed to {@link #inputs(List<Input>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on {@link List<Input>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(List<Input>)
         */
        Builder inputs(Consumer<Input.Builder>... inputs);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<Input> inputs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputsResponse model) {
            super(model);
            inputs(model.inputs);
            nextToken(model.nextToken);
        }

        public final List<Input.Builder> getInputs() {
            List<Input.Builder> result = ___listOfInputCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = ___listOfInputCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = ___listOfInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<Input.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> Input.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInputsResponse build() {
            return new ListInputsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
